#include<stdio.h>
#include<ctype.h>
#include<string.h>

#include"..\h\apt_func.h"
#include"..\h\numstr.h"

void main(int argc,char **argv)
{
	unsigned lfn;
	unsigned char lname[17],rname[17];
	
	if(argc!=2)
	{
		apt_print_err(DOS_USAGE);
		printf("Usage: fclose lfn\n");
		printf("where lfn is the logical folder number returned by \n");
		printf("        fopen or fcreate.\n");
		apt_exit(DOS_USAGE);
	}
	
	if(toupper(argv[1][_a_strlen(argv[1])-1])=='H') lfn=(unsigned) _a_hex2num(argv[1]);
	 else lfn=(unsigned)_a_dec2num(argv[1]);

	if((apt_getname((char far *)lname)==NULL)||(apt_getrname((char far *)rname)==NULL))
	{
		apt_print_err(DIAG_NO_NAME);
		printf("Local/Remote not found.  Please first run SETNAME.EXE\n");
		apt_exit(DIAG_NO_NAME);
	}
	apt_status=NOSS_BUSY_TYPE;		/* set to busy */
	while((apt_status&0xf00)==NOSS_BUSY_TYPE)
	{
		if(apt_closefolder(lfn))
		{
			if((apt_status&0xf00)!=NOSS_BUSY_TYPE)
			{
				apt_exit_err(apt_status);
			}
		}
	}	
	apt_exit_err(0);
}
