@echo off
echo --------------------------------------------------------------------
echo (C) Copyright 1990-1992 by Autodesk, Inc.
echo Permission to use, copy, modify, and distribute this software and its
echo documentation for any purpose and without fee is hereby granted.   
echo THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
echo ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
echo MERCHANTABILITY ARE HEREBY DISCLAIMED.                                 
echo --------------------------------------------------------------------
rem        Sample batch file to create the R13 DOS ADS sample programs
rem           using MSVC++ 1.1 32-bit and Phar Lap 6
rem
rem This batch file demonstrates how to build the R13 DOS ADS sample programs.
rem You will need a copy of the Microsoft Visual C++ 32-bit version 1.1 and 
rem Phar Lap 6.x TNT SDK.  Be sure you use the updated DOSADS.LIB supplied along 
rem with this batch file (see the readme for more information).  Set VC below
rem to wherever you installed VC++.  Set PHARLAP to where you have installed
rem the Phar Lap TNT SDK.  Set DOSACAD to where you have installed AutoCAD.

set savpth=%path%
set VC=c:\msvcnt
set PHARLAP=g:\q\pharlap
set DOSACAD=g:\q
set PATH=%VC%\bin;%PHARLAP%\bin;%path%
set INCLUDE=%VC%\INCLUDE;%DOSACAD%\ads
set LIB=%PHARLAP%\lib;%VC%\lib;%DOSACAD%\ads

set copts=-c -omf -Ox -Zp1 -W3

if exist %VC%\bin\cl.exe goto L1
echo You must edit msvcsamp.bat and change the variable VC
goto done

:L1
if exist %PHARLAP%\bin\386link.exe goto L2
echo You must edit msvcsamp.bat and change the variable PHARLAP
goto done

:L2
if exist %DOSACAD%\ads\mvcads13.lnk goto L3
echo You must edit msvcsamp.bat and change the variable DOSACAD
goto done

:L3

if .%1 == . goto L4
@echo Compiling %1.c 
  cl %1.c -Fo%1.obj %copts% -DADS=1 -DPROTOTYPES=1
  386link %1.obj -sym -exe %1.exp -lib MVCADS13.LIB @mvcads13.lnk
goto done

:L4
@echo Compiling ads_perr.c
  cl ads_perr.c %copts% -DADS=1 -DPROTOTYPES=1
  386link ads_perr.obj -sym -exe ads_perr.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling appmngr.c
  cl appmngr.c %copts% -DADS=1 -DPROTOTYPES=1
  386link appmngr.obj -sym -exe appmngr.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling arbmat.c
  cl arbmat.c %copts% -DADS=1 -DPROTOTYPES=1
  386link arbmat.obj -sym -exe arbmat.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling colext.c
  cl colext.c %copts% -DADS=1 -DPROTOTYPES=1
  386link colext.obj -sym -exe colext.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling dlgtest.c
  cl dlgtest.c %copts% -DADS=1 -DPROTOTYPES=1
  386link dlgtest.obj -sym -exe dlgtest.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling dragger.c
  cl dragger.c %copts% -DADS=1 -DPROTOTYPES=1
  386link dragger.obj -sym -exe dragger.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling fact.c
  cl fact.c %copts% -DADS=1 -DPROTOTYPES=1
  386link fact.obj -sym -exe fact.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling gpalsym.c
  cl gpalsym.c %copts% -DADS=1 -DPROTOTYPES=1
  386link gpalsym.obj -sym -exe gpalsym.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling gravity.c
  cl gravity.c %copts% -DADS=1 -DPROTOTYPES=1
  386link gravity.obj -sym -exe gravity.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling grvecs.c
  cl grvecs.c %copts% -DADS=1 -DPROTOTYPES=1
  386link grvecs.obj -sym -exe grvecs.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling magnets.c
  cl magnets.c %copts% -DADS=1 -DPROTOTYPES=1
  386link magnets.obj -sym -exe magnets.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling mountain.c
  cl mountain.c %copts% -DADS=1 -DPROTOTYPES=1
  386link mountain.obj -sym -exe mountain.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling sld2ps.c
  cl sld2ps.c %copts% -DADS=1 -DPROTOTYPES=1
  386link sld2ps.obj -sym -exe sld2ps.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling sqr.c
  cl sqr.c %copts% -DADS=1 -DPROTOTYPES=1
  386link sqr.obj -sym -exe sqr.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling tadc.c
  cl tadc.c %copts% -DADS=1 -DPROTOTYPES=1
  386link tadc.obj -sym -exe tadc.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Compiling tower.c
  cl tower.c %copts% -DADS=1 -DPROTOTYPES=1
  386link tower.obj -sym -exe tower.exp -lib MVCADS13.LIB @mvcads13.lnk

@echo Building geomcal
  cl cal.c %copts% -DADS=1 -DPROTOTYPES=1
  cl calerr.c %copts% -DADS=1 -DPROTOTYPES=1
  cl calexpr.c %copts% -DADS=1 -DPROTOTYPES=1
  cl callex.c %copts% -DADS=1 -DPROTOTYPES=1
  cl calmngf.c %copts% -DADS=1 -DPROTOTYPES=1
  cl calstdf.c %copts% -DADS=1 -DPROTOTYPES=1
  cl calusrf.c %copts% -DADS=1 -DPROTOTYPES=1
  cl util.c %copts% -DADS=1 -DPROTOTYPES=1
  echo cal.obj calerr.obj calexpr.obj callex.obj >geomcal.lnk
  echo calmngf.obj calstdf.obj calusrf.obj util.obj >>geomcal.lnk
  386link @geomcal.lnk -sym -exe geomcal.exp -lib MVCADS13.LIB @mvcads13.lnk
  del geomcal.lnk

:done

set PATH=%savpth%
set VC=
set PHARLAP=
set DOSACAD=
set INCLUDE=
set LIB=
set copts=
set savpth=

@echo
@echo MSVCSAMP completed
@echo on
