@echo off
:: --------------------------------------------------------------------
:: (C) Copyright 1990-1994 by Autodesk, Inc.
:: Permission to use, copy, modify, and distribute this software and its
:: documentation for any purpose and without fee is hereby granted.   
:: THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
:: ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
:: MERCHANTABILITY ARE HEREBY DISCLAIMED.                                 
:: --------------------------------------------------------------------
::
:: HC3XDBG.BAT -- Used to Debug an AutoCAD R13 ADS application built with 
::                Metaware High-C 3.2x and Phar Lap 6.1
::
:: You will need to update the environment variable settings in this file
:: to match your machine.
::
:: The following SB386 switch is used:
::
::  -SYMFILE %1       Loads the symbol table from the ADS app
::
:: You should use -SWAPMON if you have a 2-monitor setup to avoid 
:: corrupting the AutoCAD graphics screen.  A dual monitor setup is not
:: necessary, but if it is not used minor graphics screen corruption may 
:: occur.
::
:: You may also want to use other SB386 switches with hc3xdbg.bat.  One 
:: useful switch is the -HOTKEY switch.  This switch allows you to switch 
:: control back to the debugger at any time by pressing the <CTRL> and 
:: <ALT> keys simultaneously.
::
:: Here's an example of setting a switch via the DOS command line:
::
::      hc3xdbg \acad\ads\tower -swapmon
::
:: The full pathname to the AutoCAD executable directory should be specified
:: after the "-dbgfname" on the "set tnt=" line and on the line which invokes
:: SB386.  This will guarantee that the correct ACAD.EXE gets loaded by SB386.
:: This batch file does this via the ACADPATH environment variable.
::
:: If you have a copy of Phar Lap's VMMDRV.EXP (the 386|VMM Virtual Memory
:: Manager module),  and you wish to use it to enable virtual memory,  you
:: can add the -vm switch to the "set tnt=" line like so:
::
::     set tnt=-dbgfname c:\acad13\acad.exe -vm c:\pharlap\bin\vmmdrv



:: if improper syntax for batch file go to usage message
if x%1 == x goto usage

:: location of root of Phar Lap directory tree
set PHARLAP=c:\pharlap6

if exist %PHARLAP%\bin\SB386.EXE goto L1
echo You must edit hc3xdbg.bat and change the variable PHARLAP 
goto exit 

:L1
:: location of root of AutoCAD directory tree
set ACADPATH=c:\acad13

if exist %ACADPATH%\ACAD.EXE goto L2
echo You must edit hc3xdbg.bat and change the variable ACADPATH 
goto exit 

:L2
:: location of ADS program source files
set SOURCEPATH=c:\adsfiles

:: save existing path to restore later
set OLDPATH=%PATH%

:: add acad and pharlap to path
set PATH=%ACADPATH%;%PHARLAP%\bin;%PATH%

:: search path for AutoCAD support files
set ACAD=%ACADPATH%\support;%ACADPATH%\fonts

:: triggers int 3 in AutoCAD
set EXPDEBUG=ADS

:: switches for Phar Lap DOS Extender
set tnt=-dbgfname %ACADPATH%\acad.exe

sb386 -sf %1.exp %2 %3 %4 %5 %6 %7 %8 %9 %ACADPATH%\acad.exe

:: restore DOS environment
set tnt=
set EXPDEBUG=
set ACAD=
set PATH=%OLDPATH%
set OLDPATH=
set SOURCEPATH=
set ACADPATH=
set PHARLAP=
goto exit

:usage
     echo Usage: hc3xdbg ads_filename [add'l SB386 switches]

:exit



