"Initialization code"
 !



!Process methods !
 
runTimeError: aString resume: resumeLevel
		"Private - An error has occurred in a runtime
         app, so write a walkback to a log file
         and display a message box."
		"@13.10.94 ch: check for currentProcessIsRecursive" 
		"@25.09.94 ch: show the parameters"
		"@17.09.94 ch: enhancement log the error message"
		"@15.09.94 : enhancement: add the time and day of the error"
	| f |
    f := File pathName: 'vRtError.log'.
    f setToEnd.
	f cr; 
		nextPutAll: '*** Runtime Error: ', 
			Date today printString, ' ', Time now printString; cr;
		nextPutAll: 'Error message: ', aString; cr.
	
    self walkbackOnExt: f maxLevels: 50.
    f close.
	Processor currentProcessIsRecursive ifFalse: [
	    Menu message: ('Runtime error: ', aString, ' See file VRtError.log.')]
	ifTrue: [
		3 timesRepeat: [DosLibrary beep: 500 for: 50]
		].!
  
walkbackOnExt: collector maxLevels: aNumber
		"Private - Display the stacked message sends for
         the receiver on the collector stream."
		"@26.09.94 ch: Creation" 
	| method aClass frameIndex stopSelector |
    stopSelector :=
        collector class == Debugger
            ifTrue: [nil]
            ifFalse: [#Doit].
    frameIndex := 0.
    [(frameIndex := frameIndex + 1) > aNumber
        or: [(self nextFrameAt: frameIndex) = 0]]
        whileFalse: [
            (self homeFrameOf: frameIndex) = frameIndex
                ifFalse: [collector nextPutAll: '[] in '].
            aClass := (self receiverAt: frameIndex) class.
            aClass name first isUpperCase
                ifTrue: [
                    collector nextPutAll: aClass name.
                    method := self methodAt: frameIndex.
                    method isNil
                        ifTrue: [
                            collector nextPutAll: '>>-unknown selector-']
                        ifFalse: [
                            method classField = aClass
                                ifFalse: [
                                    collector
                                        nextPut: $(;
                                        nextPutAll: method classField name;
                                        nextPut: $)].
                            collector
                                nextPutAll: '>>';
                                nextPutAll: method selector.
							1 to: method argumentCount do: [:i |
								collector cr; nextPutAll: '   arg ', i printString, ': ',
									(self argAt: frameIndex number: i) printString].
                            method selector = stopSelector
                                ifTrue: [^collector cr]].
                    collector cr]]! !



!Process class methods ! !



!Debugger methods !

walkbackFor: aProcess label: aString
		"Pop-up a walkback window with label equal
         to aString).  Display the stacked message
         sends for the receiver in the window."
		"@26.09.94 ch: use the walkbackForExt:label:" 
	| recursing tmpStream |
    process := aProcess.
    maxLevel := 10.
    recursing := RecursionInError.
    RecursionInError
        ifTrue: [
            Display white.
            logger := Display pen.
            logger place: 0 @ -1;
                cr; nextPutAll: 'Recursive walkback.'; cr;
                nextPutAll: 'error: ',aString; cr]
        ifFalse: [
            RecursionInError := true.
            self label: aString.
            logger := TextWindow
                walkBackWindowFor: self label: aString.
            logger isNil ifTrue: [
                "Unable to open a walkback window!!"
                RecursionInError := false.
                Process enableInterrupts: true.
                ^self].
            logger pane disableRedraw.
            logger menuWindow addMenu: self walkbackMenu].
    aProcess debugger: self.
    tmpStream := (String new: 100) asStream.
    aProcess walkbackOnExt: tmpStream maxLevels: maxLevel.
    logger nextPutAll: tmpStream contents.
    RecursionInError := false.
    Process enableInterrupts: true.
    recursing
        ifTrue: [
            DosLibrary sleep: 30000.
            ^Smalltalk exit]
        ifFalse:[logger pane selectBefore: 1 @ 1.
                    logger pane enableRedraw.
                    logger pane modified: false]! !



!Debugger class methods ! !
"Finalization code"
  !

 
Transcript cr; nextPutAll: 'General System Enhancements installed.'!
