/*********** Alpha C Program Include file (.H) ****************************/
/*                                                                        */
/*  The Alpha V2.1 include file defines symbolic constants used           */
/*  in the Alpha1.C etc. and .RC files.                                   */
/*                                                                        */
/*  Lionel de Lambert - 28 Jul 1994 - IBM, Hursley                        */
/*                                                                        */
/**************************************************************************/

#pragma linkage (main,optlink)
INT main( int argc, char *argv[] ); /* (VOID);                            */

extern VOID AbortAlpha(HWND hwndFrame,HWND hwndClient);

#define CLR_ORANGE    16
#define CLR_PURPLE    17
#define CLR_PALEGREEN 18
#define CLR_PALEBLUE  19
#define CLR_COLOUR1   20
#define Num_Colours   21


#define MSGBOXID    1001

#define ID_WINDOW   256

#define Max_record_size 256        /* also in ALpha3.asm                  */

#define ID_CHILD    257

#define IDHT_APPLICATION 258       /* Help table ID                       */

#define IDP_POINTER 260            /* pointer                             */

#define ID_BALLOON   258           /* Bitmap for Toolbar balloon          */
#define ID_HEADER   259            /* Bitmap header - Alpha               */
#define ID_SMLHD    280            /* Bitmap small header - Alpha         */
#define ID_NAME     279            /* Bitmap Lionel de Lambert            */
#define ID_SNOWHITE 281            /* Bitmap Snow White                   */
#define ID_BUTTON_B 282            /* Backout button                      */
#define ID_BUTTON_I 260            /* Bitmap for Include button           */
#define ID_BUTTON_NI 261           /* Bitmap for NOT Include button       */
#define ID_BUTTON_C 262            /* Bitmap for cascade button           */
#define ID_BUTTON_T 263            /* Bitmap for Tile  button             */
#define ID_BUTTON_CL 264           /* Clipboard button bitmap             */
#define ID_BUTTON_NO 265           /* Number button bitmap                */
#define ID_BUTTON_R 266            /* Repeat button bitmap                */
#define ID_BUTTON_S 267            /* Structure button bitmap             */
#define ID_BUTTON_TB 268           /* Tab button bitmap                   */
#define ID_BUTTON_NTB 272          /* Not Tab button bitmap               */
#define ID_BUTTON_D 269            /* Delete button bitmap                */
#define ID_BUTTON_X 270            /* XREF button bitmap                  */
#define ID_BUTTON_CM 271       /* Comment suppression bitmap  button bitmap */
#define ID_BUTTON_E 273            /* Edit button bitmap                  */
#define ID_BUTTON_M 274            /* Modify/save file  button bitmap     */
#define ID_BUTTON_CO 275           /* Compile button                      */
#define ID_BUTTON_ER 276           /* Erase records button                */
#define ID_BUTTON_P 277            /* Paste button                        */
#define ID_BUTTON_CT 278           /* Cut to Clipboard records button     */

#define ID_FILE     100

#define ID_ABOUT    200
#define ID_ABOUT_NM 206            /* Name                                */
#define ID_ABOUT_HD 207            /* Header Alpha                        */

#define ID_SAVEMSG_DLG 220         /* Save Dialog message                 */
#define ID_SAVEMSG_HD  221
#define ID_SAVEMSG_CAN 222
#define ID_SAVEMSG_CON 223
#define ID_SAVEMSG_FN  224         /* File name                           */

#define ID_COMMAND  300

#define ID_PRINT    750

#define ID_STRUCT   850

#define ID_SELECT   900

#define ID_CONFIGURE 1000

#define MID_TOOLBAR 1100           /* Menu Toolbar id                     */

 
#define ID_OPTIONS  400
#define ID_OPT_TAB  401
#define ID_OPT_STMT 402
#define ID_OPT_KEY  403
#define ID_OPT_INCL 404
#define ID_OPT_SCALE 405
#define ID_OPT_TOOL 406
#define ID_OPT_CONFT 407

#define ID_HELP     500 
#define ID_HELP_ABOUT 501
#define ID_HELP_HELP 502
#define ID_HELP_EXT 503

#define ID_FONT     600
 
#define ID_COLOUR   700

#define ID_WND      800
#define ID_WND_CAS  801
#define ID_WND_TIL  802
#define ID_WND_CLA  803
#define ID_WND_SEL  804
#define ID_WND_SEP  805
#define ID_WND_C1   806            /* Child name                          */
#define ID_WND_C2   807            /* Child name                          */
#define ID_WND_C3   808            /* Child name                          */
#define ID_WND_C4   809            /* Child name                          */
#define ID_WND_C5   810            /* Child name                          */
#define ID_WND_C6   811            /* Child name                          */
 
#define ID_EXITPROG 261

#define IDS_HELP    262


#define ID_FILE_DLG  101
#define ID_FILE_FLNM 102
#define ID_FILE_DRV  103
#define ID_FILE_FLE  105
#define ID_FILE_DIR  106
#define ID_FILE_ENT  109
#define ID_FILE_CAN  110
#define ID_FILE_OK   112
#define ID_FILE_PRF  114
#define ID_FILE_TRN  115

#define ID_COMMAND_DLG  301
#define ID_COMMAND_CMD  302
#define ID_COMMAND_LOC  303
#define ID_COMMAND_CAN  304
#define ID_COMMAND_NORM 309
#define ID_COMMAND_CASE 305
#define ID_COMMAND_COL1 306
#define ID_COMMAND_GOTO 307
#define ID_COMMAND_TXT  308
#define ID_COMMAND_REP  310        /* Replace/find button                 */
#define ID_COMMAND_REPTXT  311     /* Replace text  entry box             */
#define ID_COMMAND_REP_TXT 312

#define ID_FONT_DLG    601
#define ID_FONT_FACE   602
#define ID_FONT_POINT  603
#define ID_FONT_NORMAL 611
#define ID_FONT_BOLD   604
#define ID_FONT_ITALIC 605
#define ID_FONT_CHRW   606
#define ID_FONT_CHRH   607
#define ID_FONT_ENT    608
#define ID_FONT_CAN    609
#define ID_FONT_SAMP   610

#define ID_COLOUR_DLG  701   
#define ID_COLOUR_KEY  702   
#define ID_COLOUR_COL  703   
#define ID_COLOUR_ENT  704   
#define ID_COLOUR_CAN  705
#define ID_COLOUR_SR   706
#define ID_COLOUR_SG   707
#define ID_COLOUR_SB   708
#define ID_COLOUR_SBTN 712

#define ID_PRINT_DLG   840
#define ID_PRINT_LPT   841
#define ID_PRINT_PRN   842
#define ID_PRINT_CAN   843
#define ID_PRINT_STA   844
#define ID_PRINT_END   845

#define ID_STRUCT_DLG   851
#define ID_STRUCT_LBX   852
#define ID_STRUCT_PRN   853
#define ID_STRUCT_CAN   854
#define ID_STRUCT_ENT   855

#define ID_TOOL_DLG     870
#define ID_TOOL_D       871
#define ID_TOOL_S       872
#define ID_TOOL_NO      873
#define ID_TOOL_CLP     874
#define ID_TOOL_C       875
#define ID_TOOL_T       876
#define ID_TOOL_TAB     877
#define ID_TOOL_I       878
#define ID_TOOL_R       879
#define ID_TOOL_X       880
#define ID_TOOL_CM      881
#define ID_TOOL_E      882
#define ID_TOOL_M      883
#define ID_TOOL_CO     884
#define ID_TOOL_ER     885
#define ID_TOOL_P      886
#define ID_TOOL_CT     887
#define ID_TOOL_B      888            /* "Backout" button                */

#define ID_SEL_LST     901
#define ID_SEL_SEL     902
#define ID_SEL_CAN     903

#define ID_XREF_DLG     950
#define ID_XREF_LBX     951
#define ID_XREF_CAN     952
#define ID_XREF_ENT     953

/* #define no_tool_dialog 1        /* don't use  a standard dislog        */

#define Toolbar_Numb 18            /* Number of buttons available         */
#define Toolbarsize  16            /* the size of a buttton in the Tool  bar */

/* #ifdef  no_tool_dialog          /* skip defines for std. window toolbar*/
#define ID_CONFT_DLG     970       /* Configure Tool bar dialog           */
#define ID_CONFT_CNF     971       /* Configure Tool bar Configure button */
#define ID_CONFT_CAN     972       /* Configure Tool bar Cancel button    */
#define ID_CONFT_BTN     973       /* Configure Tool bar button list box  */
#define ID_CONFT_TOL     974       /* Configure Tool bar Tool bar list box */
#define ID_CONFT_ENT     975       /* Configure Tool bar size - entry box */
#define ID_CONFT_VRT     976       /* Configure Tool bar vertical Radio button*/
#define ID_CONFT_HRZ     977       /* Configure Tool bar Horizontal Radio button */
#define ID_CONFT_ADD     978       /* Configure Tool bar Add button       */
#define ID_CONFT_DEL     979       /* Configure Tool bar Delete button    */
#define ID_CONFT_MENU    980       /* Configure Tool bar in menu - radio button */
/* #endif                          /*                                     */

#define ID_NOTEBK_DLG  1100        /* Notebook definitions                */
#define ID_NOTEBK_CNT  1101        /* Notebook control                    */

#define ID_EDIT_D        1200      /* Edit Dialogue box                   */
#define ID_EDIT_M        1201      /* Edit Modify button                  */
#define ID_EDIT_C        1202      /* Edit Cancel button                  */
#define ID_EDIT_U        1203      /* Edit Undo Button                    */
#define ID_EDIT_E        1204      /* Edit Multiline entry                */
#define ID_EDIT_SCL      1205      /* Edit SCale text                     */
#define ID_EDIT_MOUSE    1206      /* Mouse coordinate button             */
#define ID_EDIT_CURSOR   1207      /* Cursor coordinate button            */

#define ID_SAVE_DLG      1250      /* Save file dialogue                  */
#define ID_SAVE_ENT      1251      /* Save file dialogue - Entry box      */
#define ID_SAVE_CAN      1252      /* Save file dialogue - Cancel button  */
#define ID_SAVE_SVE      1253      /* Save file dialogue - Save button    */


#define ID_COMP_DLG      1300      /* Compile  dialogue -                 */
#define ID_COMP_EXE      1301      /* Compile  dialogue - Execute button  */
#define ID_COMP_CAN      1302      /* Compile  dialogue - Cancel button   */
#define ID_COMP_CMD      1303      /* Compile  dialogue - Command entry   */
#define ID_COMP_FLE      1304      /* Compile  dialogue -  File entry     */
#define ID_COMP_RC       1305      /* Compile  dialogue -  return code    */
#define ID_COMP_MLE      1306      /* Compile  dialogue -  MLE - Output   */

#define ID_ABOUT_OK    204


#define Max_elm        1000        /* maximum No. elements in structure blk.*/
#define forward            0       /* direction for Find_term             */
#define backward           1       /* direction for Find_term             */
#define Str_max_nm      24         /* maximum name length for structure   */
#define Str_nm_entr        2       /* number of entries in name           */
#define Str_co_entr (Str_max_nm/4)+ Str_nm_entr  /* number of entries in structure continuation*/
#define Max_modify_rec 64          /* Maximum No. records in modify block */

struct Toolbar_data {
      LONG ID;
      LONG Button_ID;
      HWND Button;                 /* Button window handle                */
      HWND Bhwnd;                  /* button bit map handle               */
      char H_data[24];
     };

struct rec_elm {                   /* record element - see ALPHA3.ASM     */
                 char *rec;        /* address of record                   */
                 long length;      /* Length of record                    */
                 unsigned Modified :1; /* pointer to Modification entry   */
               };                  /* the length will be 12 bytes         */

#define records_prefix 12          /* length of prefix part of block      */
struct records {            /* record pointer block - see ALPHA3.ASM      */
                 struct records *next;  /* next record block              */
                 int    Max_elemt; /* Maximum No. elements in block       */
                 long   No_elm;    /* number of elements                  */
                 struct rec_elm record_elm[20000];
               };

struct Recd_elmt {                 /* Update record element               */
                  int length;      /* length of record                    */
                  char rec[Max_record_size]; /* new record                */
                 };

struct Modifyblk {                 /* Update record block                 */
                  struct Modifyblk *nxt; /* next modification block       */
                  int Max_rec;     /* maximum No. records in block        */
                  int No_rec;      /* Actual No. records in block         */
                  struct Recd_elmt entry[Max_modify_rec]; /* record entries */
                 };

struct Label_flgs {                /* flags for label entry etc.          */
                    unsigned flcn : 1; /* continuation entry              */
                    unsigned flse : 1; /* procedure entry                 */
                    unsigned flsc : 1; /* procedure call                  */
                    unsigned flsd : 1; /* label defined here              */

                  };

struct Label_state {               /* label statement number entry        */
                    short int stmtn;  /* statement number                 */
                    struct Label_flgs flag; /* entry flags                */
                   };

union label_nm {
             char name[Str_max_nm];    /* label name                      */
             struct Label_state stmt[Str_max_nm/4]; /* statement number & flags */
            };

struct Label_ent {                 /* label entry                         */
                 struct Label_con *cont; /* pointer to continuation       */
                 int nxfr;         /* next free index                     */
                 struct Label_flgs flag; /* entry flags                   */
                 short int naml;    /* name length                        */
                 union label_nm statemnt;
                 struct Label_state stmtc[Str_nm_entr]; /* statement number & flags */
                 };

struct Label_con {                 /* label continuation                  */
                 struct Label_con *cont; /* pointer to continuation       */
                 int nxfr;         /* next free index                     */
                 struct Label_flgs flag; /* entry flags                   */
                 short int naml;    /* name length                        */
                 struct Label_state stmt[Str_co_entr]; /* record statement # entries*/
                 };

struct Label_pt {                  /* label block                         */
                 struct Label_pt *nxt; /* next block or 0                 */
                 int Num;        /* number of label entries in this block */
                 struct Label_ent entr[Max_elm]; /* label entries         */
                };

struct child   {
                 HWND hwnd;        /* widow handle                        */
                 HWND Fhwnd;       /* frame handle                        */
                 HFILE Fhand;      /* file handle                         */
                 char *buffer;     /* pointer to file buffer              */
                 int lan;          /* language A37=1.ASM=2,etc.           */
                 long file_size;   /* number of characters in file        */
                 int rec_num;      /* current record number               */
                 int rec_last;     /* last rec. # used for Window         */
                 int Offset;       /* horizontal offset                   */
                 int tot_rec;      /* total number of records in file     */
                 int ySel_s;       /* Rec# start of Select area           */
                 int ySel_e;       /* Rec# end of Select area             */
                 int xSel_s;       /* Chr# start of select area           */
                 int xSel_e;       /* Chr# end of select area             */
                 int xMouse_l;     /* Last Mouse x coord.                 */
                 int yMouse_l;     /* Last Mouse y coord.                 */
                 int xEnd;         /* character end of Mouse button1 area */
                 int Hide_s;       /* Rec# start of hide area             */
                 int Hide_e;       /* Rec# end of hide area               */
                 int Pair_s;       /* start of BEGIN/END Pair area        */
                 int Pair_e;       /* end of Pair area                    */
                 int find_s_x;     /* x coord. of start of BEGIN pair     */
                 int menu_id;      /* window menu id of child if used     */
                 int find_s_y;     /* y coord. of start of BEGIN pair - offset*/
                 int Mark[10];     /* marker line numbers                 */
                 struct records *rec_array; /* pointer to records array   */
                 struct Label_pt *structure; /* pointer to structure entries*/
                 struct Modifyblk *Modblk; /* pointer to modification block */
                 unsigned Expand_child : 1;  /* set if expand window      */
                 unsigned Select : 1;  /* set if button1 drag area        */
                 unsigned Hide : 1;  /* set if hiding records             */
                 unsigned Pair : 1;  /* set if PAIRing records            */
                 unsigned erase_back :1; /* set if background to be erased */
                 unsigned Button1_down :1; /* Mouse button 1 down         */
                 unsigned Cmt_supr :1; /* Set if comment suppression      */
                 unsigned Save :1; /* Set if Save is required             */
                 unsigned Insert :1; /* Set if Insert mode - edit         */
               };

struct lex {                       /* language table entry                */
           int lan;                /* language 1=A37, 2=ASM, 3=PAS, 4=PLS */
           int len;                /* length of key word                  */
           long col;               /* colour                              */
           long backcol;           /* background colour                   */
           unsigned underline :1;  /* use underline font                  */
           char str[12];           /* key word                            */
           };


struct stat {
            unsigned tile :1;      /* =1 if tile was last window operation */
            };


struct OPR_Flg {                   /* operator table flags                */
                unsigned OPR_F_P :1; /* procedure                         */
                unsigned OPR_F_C :1; /* call                              */
                unsigned OPR_F_L :1; /* scan left                         */
                unsigned OPR_F_R :1; /* scan right                        */
                unsigned OPR_F_Co :1; /* label followed by colon          */
                unsigned OPR_F_2 :1; /* second parameteer                 */
               };

                                   /* operator table                      */
struct OPR {
            short int Lang;        /* Language or -1                      */
            struct OPR_Flg OFLAG;  /* Flags                               */
            short int Nm_len;      /* name length                         */
            char  Nm[12];          /* operator name                       */
           };

#define No_Cmd 3                   /* Number of commands                  */
#define Cmd_size 128               /* maximum length of commands          */

struct Command {                   /* Command array for compile           */
             char Cmd[No_Cmd][Cmd_size]; /* command strings               */
           };

struct Backout {                   /* Structure for backout records       */
             int recno;            /* record No. after which to insert    */
             char *recds;          /* pointer to records                  */
             int len;              /* Length of storage                   */
           };

#ifdef incextern
extern HAB hab;                    /* PM anchor block                     */
extern PSZ  pszErrMsg;
extern PSZ  ResultPointer;         /* pointer to environment string       */
extern HWND ToolbarHhwnd;          /* Toolbar help window                 */
extern HWND hwndToolM ;            /* Tool bar  handle in menu            */
extern HWND hwndMenuBar;           /* Menu bar window handle              */
extern HWND Notebook;              /* Notebook handles                    */
extern HWND NoteFrame;
extern HWND hwndClient;            /* Client area window handle           */
extern HWND hwndFrame;             /* Frame window handle                 */
extern HWND Ahwnd;                 /* latest active window handle         */
extern HWND hwndTool ;             /* Tool bar  handle                    */
extern HWND NoteFrame;
extern PFNWP pOldToolMProc ;       /* Menu Tool bar old procedure         */
extern PFNWP pOldMenuProc;         /* Old Menu bar procedure              */
extern PFNWP pfnwpOldCFrameProc;   /* Old child frame procedure           */
extern PFNWP pfnwpOldFrameProc;    /* Old main fram procedure             */
extern SWP swp_Tool ;              /* Tool bar position                   */
extern HPOINTER pointer;           /* pointer handle                      */
extern QMSG qmsg;                  /* Message queue for everyone          */
extern LONG Main_x;                /* set main window x coord.            */
extern LONG Main_y;                /* set main window y coord.            */
extern LONG Main_h;                /* set main window height              */
extern LONG Main_w;                /* main window width                   */
extern LONG Child_w;               /* Child window width                  */
extern LONG Child_h;               /* Child window height                 */    
extern LONG Child_x;               /* Child window x position             */ 
extern LONG Child_y;               /* Child window y position             */ 
extern LONG Child_i;               /* Child window increment position     */ 
extern USHORT ERR_INV_PARM;        /* invalid parameter passed            */
extern USHORT key;                 /* look for keywords                   */
extern USHORT tab;                 /* don't expand tabs                   */   
extern USHORT stmt_No;             /* don't display statement No.         */
extern USHORT Scale;               /* display grid lines                  */
extern USHORT Incl;                /* don't use Include files in Exp.     */
extern USHORT Tool_bar ;           /* Display tool bar                    */
extern USHORT Tool_init ;          /* Display tool bar initially          */
extern USHORT Tool_menu;           /* Display tool bar as menu to main win*/
extern USHORT comm;                /* command string to be analysed       */
/*extern USHORT case_sen;          /* case sensitive locate               */
extern USHORT Locate_Case;         /* Case sensitive locate               */
extern USHORT Locate_Col1;         /* Case sensitive locate in Column 1   */
extern USHORT Locate_Line;         /* Locate line number                  */
extern int comm_len;               /* length of command string            */
extern USHORT ERR_File;            /* can not allocate file               */
extern char Comment_start[12];     /* start of comment characters         */
extern char Comment_end[12];       /* end of comment characters           */
extern char comm_str[32];          /* command string                      */     
extern int High_len;               /* length of Highlight string          */
extern char High_str[32];          /* Highlight string                    */
extern int Locate_len;             /* length of Locate string             */    
extern char Locate_str[32];        /* Locate string                       */
extern int No_Children;            /* number of child windows             */    
extern struct child children[16];  /* array of child data                 */
extern FATTRS fat;
extern FONTMETRICS fm;
extern FIXED Chrh;                 /* character height                    */
extern FIXED Chrw;                 /* character width                     */    
extern FIXED Indent;               /* Record indent from Left of window   */
extern COLOR Text_colour;          /* text colour                         */
extern COLOR High_colour;          /* highlight  colour                   */    
extern COLOR Cmmt_colour;          /* comment colour                      */   
extern COLOR Locate_colour;        /* Locate colour                       */   
extern COLOR Back_colour;          /* background colour                   */ 
extern COLOR Branch_colour;        /* Branch colour                       */
extern COLOR Grid_colour;          /* Grid colour                         */
extern COLOR Select_colour;        /* Mouse drag area colour              */
extern COLOR Balloon_colour;       /* Tool bar help ballon background     */
extern COLOR Cmt_back_colour;      /* comment background  colour          */
extern COLOR Colour_tab[Num_Colours+1]; /* table of colours               */
extern int lex_size;               /* No. entries in lex array            */
extern int Tool_bar_sze;           /* size of Tool bar button             */
extern struct lex lex_array[32];   /* language array                      */
extern char File_type[64];         /* "A37,ASM,PAS,PLS,C,"                */
extern char Transfer_pgm[8];       /* trnsfer programme                   */
extern struct OPR Lan_key[64];     /* operator table                      */
extern char C_keys[64];            /* C precedent keys                    */
extern LONG alTable[Num_Colours];  /* assume 20 entries in Colour table   */
extern SIZEL Def_Char_Box;         /* Default Character Box               */
extern LONG Tile_vect[32];         /* x,y split of main window for tiling */
extern struct stat status;         /* programme status                    */
extern struct Backout Back_out;    /* Backout structure                   */ 

                                   /* Address of parse exit procedure     */
/* extern int (*Alpha_parse_exit) ( HWND hps, struct child pchild, char *ptr,
                 int l, char *ptr0,
                 int l0, int cmt_start, int cmt_end, int recno,
                 POINTL pAPTL[Max_record_size] );  /*                     */

extern PFN Alpha_parse_exit_ptr;

#endif

/* end of file - ALPHA.H                                                  */

