@echo off
rem /***********************************************************************/
rem /* This batch file is an example of how to backup a cc:Mail postoffice */
rem /***********************************************************************/ 

rem /* Shut down the post office with NPODOWN2 */ 
echo ** Running NPODOWN2 **
NPODOWN2 /N"po_name" /Ppswd /Dm:\ccdata /DISCONNECT /LOCKNOW /MINUTES/5 /BATCH
if errorlevel 3 goto NPERR
if errorlevel 2 goto ESC
if errorlevel 1 goto NPERR

rem /* Run ANALYZE2 on the post office */
echo ** Running ANALYZE2 **
ANALYZE2 /Dm:\ccdata /DIAGNOSTICS /BATCH  > backup.txt
if errorlevel 3 goto ANERR1
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR1

rem /* Run CCSAVE2 on the post office */
echo ** Running CCSAVE2 **
CCSAVE2 /Dm:\ccdata /TARGET/m:\ccdata\back /BATCH >> backup.txt
if errorlevel 3 goto SAVERR
if errorlevel 2 goto ESC
if errorlevel 1 goto SAVERR

rem /* Reopen the post office with NPODOWN2 */ 
echo ** Running NPODOWN2, reopening post office **
NPODOWN2 /N"po_name" /Ppswd /Dm:\ccdata /ENABLE /BATCH

echo ** Backup process successful **
goto END

:ANERR1
echo ** ANALYZE2 reported errors - process ended **
goto END

:NPERR
echo ** NPODOWN2 reported errors - process ended **
goto END

:SAVERR
echo ** CCSAVE2 reported errors - process ended **   
goto END

:ESC
echo ** Escape was pressed - process ended **

:END

