{
Copyright (c) 1988 BittWare Computing, ALL RIGHTS RESERVED
}
unit pps_init;
{$v-}
interface
uses
        menuvars,
        menucode,
        crt,
        pps_glob;

const
     MaxMasks       = 5;
     MaxPullDowns   = 5;

     ExeMenu        = 1;
     VarMenu        = 2;
     NumPtsMenu     = 3;
     FileMenu       = 4;
     ConfirmMenu    = 5;

var
     MaskID         :array[1..MaxMasks] of string[MenuMax];
     PullDowns      :array[1..MaxPullDowns] of MenuPtr;

     IOList         :MessagePtr;
     ColorList      :PickListPtr;
     MaskList       :PickListPtr;
     HdrList        :HdrPtr;

     HelpScreen     :HalfScreenPtr;
     HalfScreen1    :HalfScreenPtr;
     HalfScreen2    :HalfScreenPtr;
     QuarterScreen1 :QuarterScreenPtr;
     EighthScreen1  :EighthScreenPtr;
     EighthScreen2  :EighthScreenPtr;
     TextScreen     :ScreenPtr;

     VarVars        :InpStrPtr;
     FileVars       :InpStrPtr;
     NumPtVars      :InpStrPtr;

     OnOffList       :VarListPtr;
     VarTypeList     :VarListPtr;

procedure InitMenuVars;
procedure InitMenus;

implementation

{
procedure SaveMenus;
var
    indx         :integer;
    FileVar      :file of MenuPtrType;
    FileName     :FileString;
begin
    FileName := 'menuset.rec';
    Assign(FileVar,FileName);
    rewrite(FileVar);
    for indx := 1 to MaxPullDowns do
          write(filevar,MenuPtrType(PullDowns[indx]^));
    Close(FileVar);
end;

procedure RecallMenus;
var
    indx         :integer;
    FileVar      :file of MenuPtrType;
    FileName     :FileString;
begin
    FileName := 'menuset.rec';
    Assign(FileVar,FileName);
    reset(FileVar);
    for indx := 1 to MaxPullDowns do
          read(filevar,MenuPtrType(PullDowns[indx]^));
    Close(FileVar);
end;
}

procedure InitMenuVars;
var
     vp   :InpStrPtr;
     indx :integer;
     w    :byte;
begin
     vp := PullDowns[NumPtsMenu]^.VarPtr;
     w := PullDowns[NumPtsMenu]^.Width - PullDowns[NumPtsMenu]^.TxtLen - 2;
     For indx := 1 to 8 do begin
          vp^[indx].Str := '';
          vp^[indx].Typ := StringCode;
          vp^[indx].VarWidth := w;
     end;
     str(SpclNum,vp^[8].Str);
     NumPtVars^[8].typ := LongIntCode;

     vp := PullDowns[FileMenu]^.VarPtr;
     w := PullDowns[FileMenu]^.Width - PullDowns[FileMenu]^.TxtLen - 2;
     for indx := 1 to 5 do begin
             vp^[indx].Typ := StringCode;
             vp^[indx].VarWidth := w;
     end;
     vp^[1].Str := DirSearchPath;
     vp^[1].VarWidth := MaxPathLength;
     vp^[2].Str := DirSearchMask;
     vp^[3].Str := FlName;
     vp^[4].Str := ColorList^.str[FgColorSel+1];
     vp^[5].Str := ColorList^.str[BgColorSel+1];

     vp := PullDowns[VarMenu]^.VarPtr;
     w := PullDowns[VarMenu]^.Width - PullDowns[VarMenu]^.TxtLen - 2;
     for indx := 1 to 9 do begin
             vp^[indx].VarWidth := w;
     end;
     vp^[1].Str := MaskList^.str[MaskVar];
     vp^[1].Typ := StringCode;
     vp^[2].Str := StringVar;
     vp^[2].Typ := StringCode;
     vp^[3].str := Real2Str(RealVar1,w,2);
     vp^[3].Typ := RealCode;
     vp^[4].str := Real2Str(RealVar2,w,2);
     vp^[4].Typ := RealCode;
     str(IntVar,vp^[5].Str);
     vp^[5].Typ := IntCode;
     vp^[5].VarWidth := 6;
     str(LongIntVar,vp^[6].Str);
     vp^[6].Typ := LongIntCode;
     vp^[7].Str := OnOffList^.str[BoolVar];
     vp^[7].Typ := IntCode;
     str(MenuNum,vp^[8].Str);
     vp^[8].Typ := LongIntCode;
     vp^[9].Str := VarTypeList^.str[FrChgVar];
     vp^[9].Typ := IntCode;
end;

procedure InitMenus;
var
     indx, i2       :byte;
begin
     crt_mode := mem[$0040:$0049];
     if crt_mode = 7 then begin
          screen := ptr($b000,$0000);
          MenuBorderBg    := MonoLo;
          MenuBorderFg    := black;
          MenuSelFg       := black;
          MenuHiFg        := MonoHi;
          MenuLoFg        := MonoLo;
          MenuSelBg       := MonoLo;
          MenuNoSelFg     := MonoLo;
          MenuNoSelBg     := black;
          MenuVarBg       := black;
          MenuVarFg       := MonoHi;
          VarInpFg        := black;
          VarInpBg        := MonoLo;
          MainFg          := MonoHi;
          MainBg          := black;
          BottomFg        := black;
          BottomBg        := MonoLo;
          CursStart       := 12;
          CursEnd         := 13;
     end
     else begin
          screen := ptr($b800,$0000);
          MenuBorderBg    := magenta;
          MenuBorderFg    := yellow;
          MenuSelFg       := white;
          MenuHiFg        := white;
          MenuLoFg        := black;
          MenuSelBg       := red;
          MenuNoSelFg     := white;
          MenuNoSelBg     := cyan;
          MenuVarBg       := black;
          MenuVarFg       := yellow;
          VarInpFg        := yellow;
          VarInpBg        := blue;
          MainFg          := white;
          MainBg          := blue;
          BottomFg        := black;
          BottomBg        := lightgray;
          CursStart       := 7;
          CursEnd         := 8;
     end;

     for indx := 1 to MaxPullDowns do begin
          new(PullDowns[indx]);
          for i2 := 1 to MenuMax do
               PullDowns[indx]^.SelPattern[i2] := '*';
          PullDowns[indx]^.BorderBg := MenuBorderBg;
          PullDowns[indx]^.BorderFg := MenuBorderFg;
          PullDowns[indx]^.Fg       := MenuHiFg;
          PullDowns[indx]^.SelFg    := MenuSelFg;
          PullDowns[indx]^.SelBg    := MenuSelBg;
          PullDowns[indx]^.NoSelBg  := MenuNoSelBg;
          PullDowns[indx]^.NoSelFg  := MenuLoFg;
          PullDowns[indx]^.VarFg    := MenuVarFg;
          PullDowns[indx]^.VarBg    := MenuVarBg;
          PullDowns[indx]^.VarPtr   := nil;

     end;

     new(HdrList);
     New(OnOffList);
     New(VarTypeList);
     new(ColorList);
     new(HelpList);
     new(SkinnyIO);
     new(MaskList);
     new(ErrorList);
     new(IOList);

     New(VarVars);
     New(FileVars);
     New(NumPtVars);

     new(SkinnySave);
     new(HelpScreen);
     new(HalfScreen1);
     new(HalfScreen2);
     new(QuarterScreen1);
     new(EighthScreen1);
     new(EighthScreen2);
     new(TextScreen);

        HdrList^.str[1]   := 'Execute';
        HdrList^.str[2]   := 'File Select';
        HdrList^.str[3]   := 'Data Entry';
        HdrList^.str[4]   := 'Quit';
        HdrList^.max      := 4;
        HdrList^.sel      := 1;

        OnOffList^.str[1]   := 'On'; 
        OnOffList^.str[2]   := 'Off';
        OnOffList^.max      := 2;

        VarTypeList^.str[1]   := 'Real'; 
        VarTypeList^.str[2]   := 'Integer';
        VarTypeList^.str[3]   := 'String';
        VarTypeList^.max      := 3;

        MaskID[1] := '* * * * * *';
        MaskID[2] := '***********';
        MaskID[3] := ' * * * * * ';
        MaskID[4] := '*****      ';
        MaskID[5] := '     ******';
        MaskList^.str[1]  := 'Only Odd';
        MaskList^.str[2]  := 'Full Mask';
        MaskList^.str[3]  := 'Only Even';
        MaskList^.str[4]  := 'First Half';
        MaskList^.str[5]  := 'Last Half';
        MaskList^.max     := 5;
        MaskList^.maxX    := 4;
        MaskList^.sel     := 1;
        MaskList^.y       := 13;
        MaskList^.x       := 13;
        MaskList^.BorderBg := MenuBorderBg;
        MaskList^.BorderFg := MenuBorderFg;
        MaskList^.Fg       := MenuSelFg;
        MaskList^.SelBg    := MenuSelBg;
        MaskList^.NoSelBg  := MenuNoSelBg;
        MaskList^.NoSelFg  := MenuNoSelFg;
        MaskList^.title   := 'Set Menu Mask';
        MaskList^.ScreenBufPtr := HalfScreen1;

{If using save/restore menus, begin here}

        PullDowns[ExeMenu]^.str[1]   := 'User 1 ';
        PullDowns[ExeMenu]^.str[2]   := 'User 2 ';
        PullDowns[ExeMenu]^.str[3]   := 'Good Beep ';
        PullDowns[ExeMenu]^.str[4]   := 'Bad Beep ';
        PullDowns[ExeMenu]^.max      := 4;
        PullDowns[ExeMenu]^.sel      := 1;
        PullDowns[ExeMenu]^.x        := 1;
        PullDowns[ExeMenu]^.y        := 2;
        PullDowns[ExeMenu]^.TxtLen   := 14;
        PullDowns[ExeMenu]^.Width    := 14;
        PullDowns[ExeMenu]^.title    := '';

        PullDowns[VarMenu]^.str[1]   := 'Set Mask';
        PullDowns[VarMenu]^.str[2]   := 'String Var';
        PullDowns[VarMenu]^.str[3]   := 'Real Var #1';
        PullDowns[VarMenu]^.str[4]   := 'Real Var #2';
        PullDowns[VarMenu]^.str[5]   := 'Int Var';
        PullDowns[VarMenu]^.str[6]   := 'LongInt';
        PullDowns[VarMenu]^.str[7]   := 'Auto Mode';
        PullDowns[VarMenu]^.str[8]   := 'Pick Num';
        PullDowns[VarMenu]^.str[9]   := 'Switch Var';
        PullDowns[VarMenu]^.max      := 9;
        PullDowns[VarMenu]^.sel      := 1;
        PullDowns[VarMenu]^.x        := 1;
        PullDowns[VarMenu]^.y        := 2;
        PullDowns[VarMenu]^.TxtLen   := 14;
        PullDowns[VarMenu]^.Width    := 28;
        PullDowns[VarMenu]^.title    := 'Bullet-Proof Entry';
        PullDowns[VarMenu]^.SelPattern := MaskId[MaskVar];

        PullDowns[ConfirmMenu]^.str[1]   := 'Confirm ';
        PullDowns[ConfirmMenu]^.str[2]   := 'Cancel ';
        PullDowns[ConfirmMenu]^.str[3]   := '';
        PullDowns[ConfirmMenu]^.max      := 3;
        PullDowns[ConfirmMenu]^.SelPattern := '** *****';
        PullDowns[ConfirmMenu]^.sel      := 1;
        PullDowns[ConfirmMenu]^.x        := 57;
        PullDowns[ConfirmMenu]^.y        := 5;
        PullDowns[ConfirmMenu]^.TxtLen   := 14;
        PullDowns[ConfirmMenu]^.Width    := 14;
        PullDowns[ConfirmMenu]^.title    := '';
        PullDowns[ConfirmMenu]^.BorderFg := MenuBorderFg + blink;

        PullDowns[NumPtsMenu]^.str[1]   := '64';
        PullDowns[NumPtsMenu]^.str[2]   := '128';
        PullDowns[NumPtsMenu]^.str[3]   := '256';
        PullDowns[NumPtsMenu]^.str[4]   := '512';
        PullDowns[NumPtsMenu]^.str[5]   := '1024';
        PullDowns[NumPtsMenu]^.str[6]   := '2048';
        PullDowns[NumPtsMenu]^.str[7]   := '4096';
        PullDowns[NumPtsMenu]^.str[8]   := 'Set Special';
        PullDowns[NumPtsMenu]^.max      := 8;
        PullDowns[NumPtsMenu]^.title    := '';
        PullDowns[NumPtsMenu]^.sel      := 1;
        PullDowns[NumPtsMenu]^.x        := 1;
        PullDowns[NumPtsMenu]^.y        := 13;
        PullDowns[NumPtsMenu]^.width    := 20;
        PullDowns[NumPtsMenu]^.TxtLen   := 12;

        PullDowns[FileMenu]^.str[1]   := 'File Path';
        PullDowns[FileMenu]^.str[2]   := 'Search Mask';
        PullDowns[FileMenu]^.str[3]   := 'Get File';
        PullDowns[FileMenu]^.str[4]   := 'Fg Color';
        PullDowns[FileMenu]^.str[5]   := 'Bg Color';
        PullDowns[FileMenu]^.max      := 5;
        PullDowns[FileMenu]^.sel      := 1;
        PullDowns[FileMenu]^.x        := 1;
        PullDowns[FileMenu]^.y        := 2;
        PullDowns[FileMenu]^.width    := 28;
        PullDowns[FileMenu]^.TxtLen   := 14;
        PullDowns[FileMenu]^.title    := 'File Pick-List Example';

{If using save/restore menus, end here}
{
        RecallMenus;
}

{Pointer Values must be restored after recalling menus}

        PullDowns[ExeMenu]^.ScreenBufPtr:= EighthScreen1;
        PullDowns[VarMenu]^.VarPtr   := VarVars;
        PullDowns[VarMenu]^.ScreenBufPtr:= EighthScreen1;
        PullDowns[ConfirmMenu]^.ScreenBufPtr:= EighthScreen2;
        PullDowns[NumPtsMenu]^.VarPtr   := NumPtVars;
        PullDowns[NumPtsMenu]^.ScreenBufPtr:= EighthScreen2;
        PullDowns[FileMenu]^.VarPtr   := FileVars;
        PullDowns[FileMenu]^.ScreenBufPtr:= QuarterScreen1;

        ColorList^.str[1]  := 'Black';
        ColorList^.str[2]  := 'Blue';
        ColorList^.str[3]  := 'Green';
        ColorList^.str[4]  := 'Cyan';
        ColorList^.str[5]  := 'Red';
        ColorList^.str[6]  := 'Magenta';
        ColorList^.str[7]  := 'Brown';
        ColorList^.str[8]  := 'LightGray';
        ColorList^.str[9]  := 'DarkGray';
        ColorList^.str[10]  := 'LightBlue';
        ColorList^.str[11]  := 'LightGreen';
        ColorList^.str[12]  := 'LightCyan';
        ColorList^.str[13]  := 'LightRed';
        ColorList^.str[14]  := 'LightMagenta';
        ColorList^.str[15]  := 'Yellow';
        ColorList^.str[16]  := 'White';
        ColorList^.max     := 16;
        ColorList^.maxX    := 4;
        ColorList^.sel     := 1;
        ColorList^.y       := 13;
        ColorList^.x       := 1;
        ColorList^.BorderBg := MenuBorderBg;
        ColorList^.BorderFg := MenuBorderFg;
        ColorList^.Fg       := MenuSelFg;
        ColorList^.SelBg    := MenuSelBg;
        ColorList^.NoSelBg  := MenuNoSelBg;
        ColorList^.NoSelFg  := MenuNoSelFg;
        ColorList^.title   := 'Choose Color';
        ColorList^.ScreenBufPtr := QuarterScreen1;

        HelpList^.x       := 5;
        HelpList^.y       := 5;
        HelpList^.dx      := 70;
        HelpList^.dy      := MaxHelpLines + 2;
        HelpList^.BorderBg := magenta;
        HelpList^.BorderFg := yellow;
        HelpList^.Fg       := white;
        HelpList^.Bg       := red;
        HelpList^.title   := 'Help on Current Choices';
        HelpList^.ScreenBufPtr := HelpScreen;

        ErrorList^.x       := 5;
        ErrorList^.y       := 10;
        ErrorList^.dx      := 70;
        ErrorList^.dy      := 5;
        ErrorList^.BorderBg := black;
        ErrorList^.BorderFg := yellow;
        ErrorList^.Fg       := white;
        ErrorList^.Bg       := red;
        ErrorList^.title   := 'Error!  <esc> to resume';
        ErrorList^.ScreenBufPtr := HelpScreen;

        IOList^.x       := 5;
        IOList^.y       := 6;
        IOList^.dx      := 70;
        IOList^.dy      := 13;
        IOList^.BorderBg := MenuBorderBg;
        IOList^.BorderFg := MenuBorderFg;
        IOList^.Fg       := MenuHiFg;
        IOList^.Bg       := MenuSelBg;
        IOList^.VarFg   := MenuVarFg;
        IOList^.VarBg   := MenuVarBg;
        IOList^.title   := 'User Input';
        IOList^.ScreenBufPtr := HalfScreen1;

        SkinnyIO^.x        := 5;
        SkinnyIO^.y        := 13;
        SkinnyIO^.dx       := 70;
        SkinnyIO^.dy       := 1;
        SkinnyIO^.BorderBg := MenuBorderBg;
        SkinnyIO^.BorderFg := MenuBorderFg;
        SkinnyIO^.Fg       := MenuNoSelFg;
        SkinnyIO^.Bg       := MenuNoSelBg;
        SkinnyIO^.VarFg    := VarInpFg;
        SkinnyIO^.VarBg    := VarInpBg;
        SkinnyIO^.title    := 'User Input';
        SkinnyIO^.ScreenBufPtr := SkinnySave;

        New(DirList);
        DirList^.sel      := 1;
        DirList^.y        := 13;
        DirList^.x        := 1;
        DirList^.MaxX     := 5;
        DirList^.BorderBg := MenuBorderBg;
        DirList^.BorderFg := MenuBorderFg;
        DirList^.Fg       := MenuSelFg;
        DirList^.SelBg    := MenuSelBg;
        DirList^.NoSelBg  := MenuNoSelBg;
        DirList^.NoSelFg  := MenuNoSelFg;
        DirList^.title    := 'Directory';
        DirList^.ScreenBufPtr := HalfScreen1;

{
        SaveMenus;
}
end;


end.

