{
Copyright (c) 1988 BittWare Computing, ALL RIGHTS RESERVED
}
program tp4help;
uses
     dos,
     crt;

const
{These Help Variables are also defined in MenuVars.pas}
{They are checked with execution to make sure they are equal}
{all help records are equal}
{Size of the help file was sacrificed in favor of speed in file access}
     MaxHelpLines        = 4;
     HelpLineWidth       = 70;
     HelpFileName        = 'tp4menu.hlp';
     MaxHelpPages        = 5; {max number of "pages" for one help number}

{the number of help records can be change, but the above variables}
{cannot be changed, without changing the source code in MenuVars.pas}

{Help Codes, MUST be the same as set in pps_glob.pas}
     InfoRec        = 0;
     MainHeader     = 1;
     DataEntryHelp1 = 2;
     MenuNumHelp    = 3;
     FileMenuHelp   = 4;
     MaskListHelp   = 5;
     ChgVarHelp     = 6;
     InpVarsHelp    = 7;
     ExeMainHelp    = 8;
     ConfirmHelp    = 9;
     UserProc1Help  = 10;
     UserProc2Help  = 11;
     UserProc3Help  = 12;
     UserProc4Help  = 13;
     DataEntryHelp2 = 14;
     MainHeader2    = 15;

     MaxHelps       = 15;
type
     HelpMessType = record
          NextRec:integer;  {NextRec = 0 if last, else}
                            {NextRec = Seek Number of Next "Page" of Message}
          Str    :array[1..MaxHelpLines] of string[HelpLineWidth];
     end;
var
        HelpFile        :file of HelpMessType;
        HelpVar         :array[0..MaxHelps] of HelpMessType;
        HelpVarTmp      :HelpMessType;
        indx            :integer;
        DiskNeeded      :longint;
        DiskAvail       :longint;
begin

{check disk to make sure space available}
     DiskAvail := DiskFree(0);
     DiskNeeded := (MaxHelpLines * HelpLineWidth + 2) * (MaxHelps + 2);
     writeln('Disk Available = ',DiskAvail);
     writeln('Disk Needed = ',DiskNeeded);
     if DiskAvail < DiskNeeded then begin
          writeln('Not enough disk space available to create Help Files');
          writeln('Hit <enter> to continue...');
          readln;
     end

{Enough Disk Space!  Let's Create the HelpFile}
     else begin
          writeln('Help file being created = ',HelpFileName);
          Assign(HelpFile,HelpFileName);
          Rewrite(helpFile);

{info rec can be used to verify that the help file found is compatible}
          HelpVar[InfoRec].NextRec := 0;
          Str(HelpLineWidth,HelpVar[InfoRec].str[1]);
          Str(MaxHelpLines,HelpVar[InfoRec].str[2]);
          Str(MaxHelpPages,HelpVar[InfoRec].str[3]);
          HelpVar[InfoRec].str[4] := '';

          HelpVar[MainHeader].NextRec := MainHeader2;
          HelpVar[MainHeader].str[1] := 'Welcome to the BittWare Computing User-Interface Maker';
          HelpVar[MainHeader].str[2] := 'This Help utility <F1> provides information on the';
          HelpVar[MainHeader].str[3] := 'current choices available';
          HelpVar[MainHeader].str[4] := 'Select an item, and try <F1> again';

          HelpVar[MainHeader2].NextRec := 0;
          HelpVar[MainHeader2].str[1] := '"Execute"     - Sample User executable routines';
          HelpVar[MainHeader2].str[2] := '"File Select" - Sample Pick file/Pick Color';
          HelpVar[MainHeader2].str[3] := '"Data Entry"  - Sample Data Entry';
          HelpVar[MainHeader2].str[4] := '"Quit"        - Exit to Dos';

          HelpVar[DataEntryHelp1].NextRec := DataEntryHelp2;
          HelpVar[DataEntryHelp1].str[1] := 'Menu Data-Entry Demo';
          HelpVar[DataEntryHelp1].str[2] := 'Entries written in Black cannot be selected';
          HelpVar[DataEntryHelp1].str[3] := 'until the mask is changed';
          HelpVar[DataEntryHelp1].str[4] := 'hit <Enter> on the variable of your choice';

          HelpVar[DataEntryHelp2].NextRec := 0;
          HelpVar[DataEntryHelp2].str[1] := 'These Variables can be used by your programs';
          HelpVar[DataEntryHelp2].str[2] := 'when executed from the Execute Menu';
          HelpVar[DataEntryHelp2].str[3] := '';
          HelpVar[DataEntryHelp2].str[4] := '';

          HelpVar[MenuNumHelp].NextRec := 0;
          HelpVar[MenuNumHelp].str[1] := 'Numbers can be entered directly';
          HelpVar[MenuNumHelp].str[2] := 'or selected from a menu';
          HelpVar[MenuNumHelp].str[3] := '2';
          HelpVar[MenuNumHelp].str[4] := '3';

          HelpVar[FileMenuHelp].NextRec := 0;
          HelpVar[FileMenuHelp].str[1] := 'Set File Search Path';
          HelpVar[FileMenuHelp].str[2] := 'Set File Search Mask';
          HelpVar[FileMenuHelp].str[3] := 'Last File Selected';
          HelpVar[FileMenuHelp].str[4] := 'Fg/Bg - Demo for pick list';

          HelpVar[MaskListHelp].NextRec := 0;
          HelpVar[MaskListHelp].str[1] := 'Demonstrates use of';
          HelpVar[MaskListHelp].str[2] := 'Pull-Down-Menu masks';
          HelpVar[MaskListHelp].str[3] := '2';
          HelpVar[MaskListHelp].str[4] := '3';

          HelpVar[ExeMainHelp].NextRec := 0;
          HelpVar[ExeMainHelp].str[1] := 'User 1 - Shows Global Vars';
          HelpVar[ExeMainHelp].str[2] := 'User 2 - Window Data Entry';
          HelpVar[ExeMainHelp].str[3] := 'User 3 = Good Beep';
          HelpVar[ExeMainHelp].str[4] := 'User 4 = Bad Beep';

          HelpVar[ChgVarHelp].NextRec := 0;
          HelpVar[ChgVarHelp].str[1] := 'Hit <enter> to scroll through choices';
          HelpVar[ChgVarHelp].str[2] := '1';
          HelpVar[ChgVarHelp].str[3] := '2';
          HelpVar[ChgVarHelp].str[4] := '3';

          HelpVar[InpVarsHelp].NextRec := 0;
          HelpVar[InpVarsHelp].str[1] := 'Get User Input';
          HelpVar[InpVarsHelp].str[2] := 'Reals must have leading 0 ==> "0.02"';
          HelpVar[InpVarsHelp].str[3] := 'Reals also accept 2e-2 ==> "0.02"';
          HelpVar[InpVarsHelp].str[4] := '3';

          HelpVar[ConfirmHelp].NextRec := 0;
          HelpVar[ConfirmHelp].str[1] := 'Select "Confirm" to continue';
          HelpVar[ConfirmHelp].str[2] := 'or "Cancel" to return';
          HelpVar[ConfirmHelp].str[3] := '2';
          HelpVar[ConfirmHelp].str[4] := '3';

          HelpVar[UserProc1Help].NextRec := 0;
          HelpVar[UserProc1Help].str[1] := 'User Procedure 1 Help';
          HelpVar[UserProc1Help].str[2] := '1';
          HelpVar[UserProc1Help].str[3] := '2';
          HelpVar[UserProc1Help].str[4] := '3';

          HelpVar[UserProc2Help].NextRec := 0;
          HelpVar[UserProc2Help].str[1] := 'User Procedure 2 Help';
          HelpVar[UserProc2Help].str[2] := '1';
          HelpVar[UserProc2Help].str[3] := '2';
          HelpVar[UserProc2Help].str[4] := '3';

          HelpVar[UserProc3Help].NextRec := 0;
          HelpVar[UserProc3Help].str[1] := 'User Procedure 3 Help';
          HelpVar[UserProc3Help].str[2] := '1';
          HelpVar[UserProc3Help].str[3] := 'Emits a "good" beep';
          HelpVar[UserProc3Help].str[4] := '3';

          HelpVar[UserProc4Help].NextRec := 0;
          HelpVar[UserProc4Help].str[1] := 'User Procedure 4 Help';
          HelpVar[UserProc4Help].str[2] := '1';
          HelpVar[UserProc4Help].str[3] := 'Emits a "bad" beep';
          HelpVar[UserProc4Help].str[4] := '3';

          for indx := 0 to MaxHelps do
               write(HelpFile,HelpVar[indx]);

          close(helpfile);
     end;
end.

