                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to test EMSHEAP.

* ASSOCIATED FILES
EMSHEAP.PAS
EMSHEAP.ASM
EMSHEAP.OBJ
EMSHEAP.TPU
GETEMSHEAP.PAS
TESTHEAP.EXE
TESTHEAP.PAS


* KEYWORDS
PROGRAM PASCAL SOURCE V4.0

==========================================================================
}
program TestEmsHeap;
uses
  TpTimer,
  EmsHeap;

const
  FractionToDeallocate = 0.4;     {Approximate fraction of pointers deallocated}
  MaxPointers = 7000;             {Limited by SizeOf(DataRecord)*MaxPointers<64K}

type
  String2 = string[2];
  String80 = string[80];
  Darray = array[1..MaxInt] of Byte;
  DarrayPtr = ^Darray;
  DataRecord =
    record
      P : DarrayPtr;              {Points to array of data bytes on heap}
      Value : Byte;               {Value in each data byte}
      Size : Word;                {Size of the data array}
      InMemory : Boolean;         {True if currently allocated on heap}
    end;
  Parray = array[1..MaxPointers] of DataRecord;

var
  Ptrs : Parray;
  I, DeallCnt, Errors : Word;
  Str1, Str2 : String80;
  TotalSize : LongInt;
  NumBytes : Word;                {Maximum bytes in a heap item, limited to 16384}
  NumPointers : Word;             {Number of pointers tested}
  DaP : DarrayPtr;
  T1 : LongInt;
  T2 : LongInt;
  UseEms : Boolean;

  function GetWord(Prompt : String80; Min, Max : Word) : Word;
    {-Prompt for and return a validated Word}
  var
    I : Word;
    Good : Boolean;
  begin
    {$I-}
    repeat
      I := 0;
      Write(Prompt, ' [min:', Min, ', max:', Max, '] ');
      ReadLn(I);
      Good := (IoResult = 0);
      if not Good then
        WriteLn('illegal Word. try again...')
      else begin
        Good := (I >= Min) and (I <= Max);
        if not Good then
          WriteLn('Word out of range. try again...');
      end;
    until Good;
    GetWord := I;
    {$I+}
  end;

  function GetBool(Prompt : String80) : Boolean;
    {-Prompt for and return a boolean}
  var
    R : string[2];
    Result : Boolean;
    Good : Boolean;
  begin
    repeat
      Write(Prompt);
      ReadLn(R);
      Good := False;
      if Length(R) = 1 then
        case Upcase(R[1]) of
          'Y' : begin
                  Result := True;
                  Good := True;
                end;
          'N' : begin
                  Result := False;
                  Good := True;
                end;
        end;
      if not Good then
        WriteLn('Acceptable responses are Y and N. try again...');
    until Good;
    GetBool := Result;
  end;

  procedure ValCheck(S : String80; var Result : Word);
    {-Convert string to Word, halting if error}
  var
    Code : Word;
  begin
    Val(S, Result, Code);
    if Code <> 0 then
      Halt(1);
  end;

  procedure BoolCheck(S : String80; var Result : Boolean);
    {-Convert string to boolean, halting if error}
  begin
    if Length(S) <> 1 then
      Halt(1);
    case Upcase(S[1]) of
      'Y' : Result := True;
      'N' : Result := False;
    else
      Halt(1);
    end;
  end;

  procedure GetInputParameters;
    {-Prompt for input or take from command line}
  begin
    if ParamCount >= 3 then begin
      ValCheck(ParamStr(1), NumPointers);
      ValCheck(ParamStr(2), NumBytes);
      BoolCheck(ParamStr(3), UseEms);
    end else begin
      NumPointers := GetWord('Number of pointers generated for test', 1, MaxPointers);
      NumBytes := GetWord('Maximum number of bytes per test array', 1, 16384);
      UseEms := GetBool('Use EMS? ');
    end;
  end;

  function Hex(B : Byte) : String2;
    {-Return hex text for byte}
  const
    HexChars : array[0..$F] of Char = '0123456789ABCDEF';
  begin
    Hex := HexChars[B shr 4]+HexChars[B and $F];
  end;

  procedure Dump(A : DataRecord);
    {Display a heap item}
  var
    I : Word;
  begin
    with A do begin
      DaP := EmsP(P);
      for I := 1 to Size do
        Write(Hex(DaP^[I]), '  ');
      WriteLn;
    end;
  end;

  procedure Check(I : Word);
    {-Compare heap item to its expected value}
  var
    J, K : Word;
  begin
    with Ptrs[I] do begin
      DaP := EmsP(P);
      for J := 1 to Size do
        if DaP^[J] <> Value then begin
          Inc(Errors);
          WriteLn;
          WriteLn('Error in item ', I);
          for K := I-5 to I+5 do
            if K = I then
              Write('[', Ptrs[K].Size, '*$', Hex(Ptrs[K].Value), ']')
            else if (K >= 1) and (K <= NumPointers) then begin
              if Ptrs[K].InMemory then
                Write('(', Ptrs[K].Size, '*$', Hex(Ptrs[K].Value), ')')
              else
                Write('(o)');
            end;
          WriteLn;
          Dump(Ptrs[I]);
          Exit;
        end;
    end;
  end;

  procedure ShowMem(Start, Stop : LongInt; Msg : String80);
    {-Display the values of memavail and maxavail}
  begin
    WriteLn(^M,
            {$IFDEF Debug}
            ^J,
            {$ENDIF}
            EmsMemAvail:7, '  ', EmsMaxAvail:6, '  ', FreeCnt:6, '  ',
            ElapsedTime(Start, Stop):5:0, '  ', Msg);
  end;

begin

(*
  Randomize;
*)

  haltonerror:=true;

  {Get test input parameters}
  GetInputParameters;

  {Set up the heap manager}
  if UseEms then
    InitEmsHeap(10000000, 16384);

  WriteLn(' MemAvl  MaxAvl  FreCnt  Delay');
  ShowMem(0, 0, 'initially');

  {Get a bunch of heap items of varying sizes and contents}
  T1 := ReadTimer;
  TotalSize := 0;
  for I := 1 to NumPointers do
    with Ptrs[I] do begin
      Size := Random(NumBytes)+1;
      Value := Random(256);
      InMemory := True;
      GetEms(P, Size);
      DaP := EmsP(P);
      FillChar(DaP^, Size, Value);
      Inc(TotalSize, Size);
      {$IFNDEF Debug}
      if I and 63 = 0 then
        Write(^M, I);
      {$ENDIF}
    end;
  T2 := ReadTimer;
  Str(NumPointers, Str1);
  Str(TotalSize:0, Str2);
  ShowMem(T1, T2, 'after '+Str1+' items allocated ('+Str2+' bytes)');

  {Release random ones of those allocated}
  T1 := ReadTimer;
  DeallCnt := 0;
  TotalSize := 0;
  for I := 1 to NumPointers do
    with Ptrs[I] do begin
      {Deallocate some fraction of the items}
      if Random <= FractionToDeallocate then begin
        InMemory := False;
        FreeEms(P, Size);
        Inc(TotalSize, Size);
        Inc(DeallCnt);
      end;
      {$IFNDEF Debug}
      if I and 63 = 0 then
        Write(^M, I);
      {$ENDIF}
    end;
  T2 := ReadTimer;
  Str(DeallCnt, Str1);
  Str(TotalSize:0, Str2);
  ShowMem(T1, T2, 'after '+Str1+' items deallocated ('+Str2+' bytes)');

  {Allocate some more random ones}
  T1 := ReadTimer;
  DeallCnt := 0;
  TotalSize := 0;
  for I := 1 to NumPointers do
    with Ptrs[I] do
      if not InMemory then begin
        {Re-Allocate some fraction of the unallocated items}
        if Random <= FractionToDeallocate then begin
          Size := Random(NumBytes)+1;
          Value := Random(256);
          InMemory := True;
          GetEms(P, Size);
          DaP := EmsP(P);
          FillChar(DaP^, Size, Value);
          Inc(TotalSize, Size);
          Inc(DeallCnt);
          {$IFNDEF Debug}
          if I and 63 = 0 then
            Write(^M, I);
          {$ENDIF}
        end;
        {$IFNDEF Debug}
        if I and 63 = 0 then
          Write(^M, I);
        {$ENDIF}
      end;
  T2 := ReadTimer;
  Str(DeallCnt, Str1);
  Str(TotalSize:0, Str2);
  ShowMem(T1, T2, 'after '+Str1+' items reallocated ('+Str2+' bytes)');

  {Check to see that the data made it through OK}
  {$IFNDEF Debug}
  Write('Checking data contents... ');
  {$ENDIF}
  T1 := ReadTimer;
  Errors := 0;
  for I := 1 to NumPointers do
    if Ptrs[I].InMemory then
      Check(I);
  T2 := ReadTimer;
  Str(Errors, Str1);
  ShowMem(T1, T2, 'after data checking, finding '+Str1+' errors');

  {Release remainder of those allocated}
  T1 := ReadTimer;
  DeallCnt := 0;
  TotalSize := 0;
  for I := 1 to NumPointers do
    with Ptrs[I] do begin
      {Deallocate some fraction of the items}
      if InMemory then begin
        InMemory := False;
        FreeEms(P, Size);
        Inc(TotalSize, Size);
        Inc(DeallCnt);
      end;
      {$IFNDEF Debug}
      if I and 63 = 0 then
        Write(^M, I);
      {$ENDIF}
    end;
  T2 := ReadTimer;
  Str(DeallCnt, Str1);
  Str(TotalSize:0, Str2);
  ShowMem(T1, T2, 'after '+Str1+' items deallocated ('+Str2+' bytes)');

end.

