;EMSHEAP.ASM
; used in EMSHEAP.PAS

;****************************************************** Equates

EmsErrorCode    =       0FFFFh

;****************************************************** Macros

StackFrame      MACRO
                MOV     BX,SP           ;Set BX to point to stack
                ENDM

SetZero         MACRO Reg
                XOR     Reg,Reg         ;Reg = 0
                ENDM

EmsCall         MACRO EmsFunction
                MOV     AH,EmsFunction  ;function code into AH
                INT     67h             ;call the EMM
                ENDM

EmsWordResult   MACRO RegName
                LOCAL   EWRexit
                OR      AH,AH           ;AH = 0 means success
                MOV     AX,RegName      ;assume success
                JZ      EWRexit         ;Done if not 0
                MOV     AX,EmsErrorCode ;$FFFF for failure
        EWRExit:
                ENDM

EmsBoolean      MACRO
                LOCAL   EBexit
                CMP     AH,0            ;AH = 0 means success
                MOV     AX,1            ;Assume success
                JE      EBexit          ;Done if OK
                DEC     AX              ;Else AX = 0
        EBexit:
                ENDM

;****************************************************** Data

DATA    SEGMENT WORD PUBLIC
        EXTRN   FTop:DWORD              ;Pointer to top free list element
        EXTRN   FreeCnt:WORD            ;Number of free list elements
        EXTRN   CurPage:WORD            ;Current allocation page
        EXTRN   CurOfst:WORD            ;Current allocation offset
        EXTRN   FrameSeg:WORD           ;Segment of EMS page window
        EXTRN   PageMap:WORD            ;What's mapped into page window
        EXTRN   TimeCount:WORD          ;Quasi-time
        EXTRN   Handle:WORD             ;Handle of EMS memory block
DATA    ENDS

;****************************************************** Code

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE,DS:DATA

        PUBLIC  EmsPagesAvail, EmsPageFramePtr
        PUBLIC  AllocateEmsPages, MapEmsPage
        PUBLIC  DeallocateEmsHandle,
        PUBLIC  MergeFreeList, GetEmsP

        EXTRN   Error:NEAR

;****************************************************** EmsPagesAvail

;function EmsPagesAvail : Word;

;Returns the number of available pages from the expanded memory manager,
; or EmsErrorCode in case of error.

EmsPagesAvail   PROC FAR

        EmsCall 42h                     ;Get number of pages function
        EmsWordResult   BX              ;If successful, return value in BX
        RET

EmsPagesAvail   ENDP

;****************************************************** EmsPageFramePtr

;function EmsPageFramePtr : Pointer;

;Returns a pointer to the page frame used by the EMM. Returns nil pointer
;in case of error.

EmsPageFramePtr PROC FAR

        EmsCall 41h                     ;Get page frame segment
        OR      AH,AH                   ;Check for error
        MOV     AX,0                    ;Offset is zero in any case
        MOV     DX,BX                   ;Segment from DX to BX
        JZ      FramePtrExit            ;Done if AH = 0
        SetZero DX                      ;Else DX = 0
FramePtrExit:
        RET

EmsPageFramePtr ENDP

;****************************************************** AllocateEmsPages

;function AllocateEmsPages(NumPages : Word) : Word

;Allocates the indicated number of pages and returns a handle.
;Returns EmsErrorCode in case of error.

AllocNum        EQU     WORD PTR SS:[BX+4]

AllocateEmsPages        PROC FAR

        StackFrame
        MOV     BX,AllocNum             ;BX = NumPages
        EmsCall 43h                     ;Get handle and allocate memory
        EmsWordResult   DX              ;If successful, return value in DX
        RET     2

AllocateEmsPages        ENDP

;****************************************************** MapEmsPage

;function MapEmsPage(Handle, LogicalPage, PhysicalPage : Word) : Boolean;

;Maps the specified LogicalPage associated with Handle into PhysicalPage
; (0-3). Returns true if successful.}

MapHandle       EQU     WORD PTR SS:[BX+8]
MapLogPage      EQU     WORD PTR SS:[BX+6]
MapPhysPage     EQU     BYTE PTR SS:[BX+4]

MapEmsPage      PROC FAR

        StackFrame
        MOV     AL,MapPhysPage          ;AL = PhysicalPage
        MOV     DX,MapHandle            ;DX = Handle
        MOV     BX,MapLogPage           ;BX = LogicalPage
        EmsCall 44h                     ;Map memory function
        EmsBoolean                      ;Set AX
        RET     6

MapEmsPage      ENDP

;****************************************************** DeallocateEmsHandle

;function DeallocateEmsHandle(Handle : Word) : Boolean;

;Deallocates the indicated handle and the memory associated with it.

EmsHandle       EQU     WORD PTR SS:[BX+4]

DeallocateEmsHandle     PROC FAR

        StackFrame
        MOV     DX,EmsHandle            ;DX = Handle
        EmsCall 45h                     ;Release handle function
        EmsBoolean                      ;Set AX
        RET     2

DeallocateEmsHandle     ENDP

;****************************************************** MergeFreeList

;procedure MergeFreeList;
;Merge whatever's possible of the free list
;Guaranteed to enter with at least one free list element
;On entry, FTop must point to physical address of top free list element

FreeRecSize     EQU     6
InitOfst        EQU     2
PageNum         EQU     WORD PTR [SI]
PageOfs         EQU     WORD PTR [SI+2]
BlokSiz         EQU     WORD PTR [SI+4]

MergeFreeList   PROC    NEAR
        PUSH    BP
        MOV     BP,FreeCnt              ;Keep FreeCnt in BP
        PUSH    DS
        LDS     SI,FTop                 ;DS:SI -> top free list element
        MOV     DI,SI                   ;Save top offset for later

        MOV     BX,PageOfs              ;BX = POfs
        MOV     CX,BlokSiz              ;CX = Siz
        MOV     DX,PageNum              ;DX = PNum

MergeLoop:
        CMP     SI,InitOfst             ;Bottom of free list?
        JZ      MergeDone               ;Jump if so
        SUB     SI,FreeRecSize          ;Previous element

        CMP     PageNum,DX              ;Same page as base?
        JNZ     MergeLoop               ;Jump if not

MergeBefore:
        MOV     AX,PageOfs              ;AX=PageOfs
        SUB     AX,CX                   ;AX=PageOfs-Siz
        CMP     AX,BX                   ;Base merges prior to current block?
        JNZ     MergeAfter              ;Try other merge if not
        MOV     PageOfs,BX              ;Store new start of free block
        JMP     SHORT MergeMerge

MergeAfter:
        MOV     AX,PageOfs              ;AX=PageOfs
        ADD     AX,BlokSiz              ;AX=PageOfs+Size
        CMP     AX,BX                   ;Base merges after current block?
        JNZ     MergeLoop               ;Loop again if not
        MOV     BX,PageOfs              ;Store new starting offset

MergeMerge:
        ADD     BlokSiz,CX              ;Increase size of merged block
        MOV     CX,BlokSiz              ;Store for next compare
        DEC     BP                      ;Decrement free counter
        SUB     DI,FreeRecSize          ;Reduce top pointer
        PUSH    CX                      ;Save current block size
        PUSH    DI                      ;Save top pointer
        MOV     CX,FreeRecSize/2        ;Words to swap

MergeSwap:
        MOV     AX,[SI]
        XCHG    AX,[DI]
        MOV     [SI],AX
        ADD     SI,2
        ADD     DI,2
        LOOP    MergeSwap               ;Swap two records

        POP     DI                      ;Restore top pointer
        POP     CX                      ;Restore current size
        MOV     SI,DI                   ;Store new current pointer
        JMP     MergeLoop               ;Loop for next block

MergeDone:
        POP     DS                      ;Restore DS
        CMP     DX,CurPage              ;Free block on current allocation page?
        JNZ     MergeSave               ;Jump if not
        ADD     BX,CX                   ;BX = POfs+Siz
        CMP     BX,CurOfst              ;Free block hooks to current offset?
        JNZ     MergeSave
        SUB     CurOfst,CX              ;Reduce current offset
        DEC     BP                      ;Reduce FreeCnt

MergeSave:
        MOV     FreeCnt,BP              ;Store new value of FreeCnt
        POP     BP
        RET
MergeFreeList   ENDP

;****************************************************** GetEmsP

;function GetEmsP(P : Pointer) : Pointer;
;Return physical pointer for an EMS pointer
;EMS must have been allocated

MapRecSize      EQU     4                       ;Bytes in MapRec
MaxPP           EQU     3                       ;Highest physical page window
PageSize        EQU     16384                   ;Bytes in EMS page
EmsMapError     EQU     2                       ;Code for mapping error
LogicalPage     EQU     WORD PTR [SI]           ;Mask for MapRec
Touched         EQU     WORD PTR [SI+2]

GetEmsP         PROC    FAR
        MOV     BX,SP                   ;Stack frame
        LES     AX,SS:[BX+4]            ;Pointer P in ES:AX
        MOV     BX,ES                   ;BX=PageNum, AX=PageOfs
        MOV     DX,AX
        OR      DX,BX                   ;Check for nil
        JZ      GetEmsJustReturn        ;Don't map nil

        MOV     DX,0FFFFh               ;DX=Oldest timer count
        MOV     SI,OFFSET PageMap       ;DS:SI -> PageMap
        MOV     DI,FrameSeg             ;DI will be segment of physical pointer
        MOV     CX,MaxPP+1              ;Number of pages to check

GetEmsCheckPage:
        CMP     BX,LogicalPage          ;Correct logical page?
        JZ      GetEmsReturn            ;We're done if so
        CMP     Touched,DX              ;Is this page older than any before?
        JAE     GetEmsIncSeg            ;Jump if not
        MOV     DX,Touched              ;Save oldest
        MOV     ES,SI                   ;ES=offset of oldest page
GetEmsIncSeg:
        ADD     DI,PageSize/16          ;Increment segment of page
        ADD     SI,MapRecSize           ;Next MapRec
        LOOP    GetEmsCheckPage         ;Try again

;If we get here, the page is not mapped
        PUSH    AX                      ;Save PageOfs
        MOV     SI,ES                   ;SI = offset of oldest page
        MOV     AX,SI
        SUB     AX,OFFSET PageMap
        SHR     AX,1
        SHR     AX,1                    ;AX = Physical page number
        MOV     DI,AX                   ;Store page number temporarily
        MOV     DX,Handle               ;DX = EMS Handle
        EmsCall 44h                     ;Map memory function
        CMP     AH,0                    ;Successful mapping?
        POP     AX                      ;Restore PageOfs
        JNZ     GetEmsError             ;Jump if error

        MOV     LogicalPage,BX          ;Store new logical page
        MOV     CL,10
        SHL     DI,CL                   ;Convert page number to segment offset
        ADD     DI,FrameSeg             ;Compute segment of physical page

GetEmsReturn:
        MOV     CX,TimeCount
        INC     CX                      ;Increment timer count
        MOV     TimeCount,CX
        MOV     Touched,CX              ;Store time last touched
        OR      CX,CX                   ;Did timer wrap around?
        JZ      GetEmsReset             ;Jump if so
        MOV     DX,DI                   ;Return segment in DX, offset in AX
GetEmsJustReturn:
        RET     4

GetEmsReset:
        XOR     BX,BX
        MOV     SI,OFFSET PageMap       ;Reset Touched fields of PageMap
        MOV     CX,MaxPP+1
GetEmsResetLoop:
        MOV     Touched,BX
        ADD     SI,MapRecSize
        LOOP    GetEmsResetLoop
        MOV     DX,DI                   ;Return segment in DX, offset in AX
        RET     4

GetEmsError:
        MOV     AX,EmsMapError
        PUSH    AX
        CALL    Error                   ;Call error routine
        XOR     AX,AX
        MOV     DX,AX                   ;Return nil pointer
        RET     4

GetEmsP         ENDP

CODE    ENDS

        END

