                       F i l e    I n f o r m a t i o n

* DESCRIPTION
An "expert system" building tool that can be used to develop systems that
examine situations and outcomes, and from that deduce the rules that relate
them. Requires: Turbo Pascal 4.0. Author: John Carpenter. Version T1.0.
1985/86 TUG O'Wards entry. Converted to version 4.0.

* ASSOCIATED FILES


* KEYWORDS
PASCAL 4.0 EXPERT DEFINE TOOL PROGRAM

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

program LearningExpert;
{
This is an expert system building tool.  It is to be used as a template
for developing expert systems during which the author needs only to teach
the fledgling expert system the correct outcome to variables tagged as '1'
or '0'.  The fledgling expert automatically creates its own rules from this
learning process.

To gain familiarity with this concept, the user can run this tool as is.
For example, in response to queries:
              Variables = 6
              Outcomes = 3
              List variables as: wings, tail, beak, engine, feathers,
                                 and undercarriage.
              List outcomes as: bird, plane, and glider.
              Think of an outcome and tag variables as true=1 or false=0.
              The learning process continues until it provides correct
              outcome to all variable tagging combinations provided.

One of the changes that can be made to this template is to set the string
length of Variables and Outcomes under Type to some higher value so that
instead of single words, these values could be complete sentences.

Another change which will allow for a "run" mode instead of the current
"teach" mode would be to eliminate operator verification when an outcome is
presented by allowing only a "Press any key to continue".

Author: John D. Carpenter             Algorithm found in:
        1698 Villa Street               "Build Your Own Expert System"
        Mountain View, CA 94041         By Chris Naylor, page 237
        (415)960-1256                   c1983, Sigma Publishers,
                                               Wilmslow, England
Released to public domain but:
  1. Not to be sold for profit but can be used to make a product.
  2. Credit John D. Carpenter for software and Chris M. Naylor for algorithm.
}

Uses
  Crt;

type
   Variables    = string[25];
   Outcomes     = string[25];

const
   MaxArr       = 50;

var
   MaxVar, MaxOut               : integer;
   Variable                     : array[1..MaxArr] of Variables;
   Outcome                      : array[1..MaxArr] of Outcomes;
   Dee, Hie, Hjay, Score        : integer;
   Vstate                       : array[1..MaxArr] of integer;
   Sstate, Dstate               : array[1..MaxArr] of integer;
   Rule                         : array[1..MaxArr] of array[1..MaxArr]
                                  of integer;
   I, J                         : integer;
   Ans,Key                      : char;
   Done                         : boolean;

procedure SetLearn;
   begin
     ClrScr;
     Write(' How many variables have you? ');
     Readln(MaxVar);
     Write(' How many outcomes have you? ');
     Readln(MaxOut);
     Writeln;
     Writeln(' Please name the ', MaxVar, ' variables: ');
     for I := 1 to MaxVar do
     begin
       Write('    Variable ', I, ' is ');
       Readln(Variable[I]);
     end;
     Writeln(' Please name the ', MaxOut, ' outcomes: ');
     for I := 1 to MaxOut do
     begin
       Write('    Outcome ', I, ' is ');
       Readln(Outcome[I]);
     end;
     for I := 1 to MaxOut do
     begin
       Sstate[I] := 0;
       for J := 1 to MaxVar do Rule[I,J] := 0;
     end;
     Hie := 1;
   end;

procedure LearnVariables;
   begin
     ClrScr;
     Writeln('     This is a Training Session.  ');
     Writeln(' Provide values of Variables and I will guess the outcome. ');
     Writeln(' You must tell me if I am right or wrong. ');
     Dee := 0;
     for I := 1 to MaxOut do Dstate[I] := 0;
     for I := 1 to MaxVar do
     begin
       Write(' Variable ', I, '(', Variable[I],') is ');
       Readln(Vstate[I]);
     end;
     for I := 1 to MaxOut do
     begin
       for J := 1 to MaxVar do  Dstate[I] := Dstate[I] + Rule[I,J]*Vstate[J];
     end;
   end;

procedure ReconsiderOutcome;
   begin
     for I := 1 to MaxOut do  Writeln('   ', I, '.  ', Outcome[I]);
     Write('  Which Outcome is it? ');
     Readln(Hjay);
     for I := 1 to MaxOut do
     begin
       If (Dee < Dstate[I]) and (Hjay <> I) then
         for J := 1 to MaxVar do  Rule[I,J] := Rule[I,J] - Vstate[J];
     end;
     for J := 1 to MaxVar do  Rule[Hjay,J] := Rule[Hjay,J] + Vstate[J];
     Writeln(' I got ', Score, ' right, Before I made a mistake! ');
     Write('    Press any key to Continue. ');
     Key := ReadKey;
     for I := 1 to MaxOut do  Sstate[I] := 0;
   end;

procedure LearnOutcome;
   begin
     for I := 1 to MaxOut do
     begin
       If Dee < Dstate[I] then
         begin
           Dee := Dstate[I];
           Hie := I;
         end;
     end;
     Write(' Is it Outcome ', Hie, ' (', Outcome[Hie], ') ? ');
     Readln(Ans);
     If (Ans = 'Y') or (Ans = 'y') then
       begin
         Sstate[Hie] := 1;
         Score := 0;
         for I := 1 to MaxOut do Score := Score + Sstate[I];
         If Score = MaxOut then
           begin
             Writeln(' I''m Perfect! ');
             Done := True;
           end
         Else
           Done := False;
       end
     Else
       begin
         ReconsiderOutcome;
         Done := False;
       end;
   end;

begin
   SetLearn;
   repeat
     LearnVariables;
     LearnOutcome;
   until Done;
end.

