                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include file for HDMENU.PAS.
Requires: Turbo Pascal 4.0. Author: James Haas. Version T.1.0.
Converted to version 4.0.

* ASSOCIATED FILES
HDMENU.PAS
HDM.DOC
HDM.BAT
HDMENU.TXT
HDMX.BAT
BOX.INC
DATE.INC
DISPLAY.INC
HDMHELP.PAS
KEY.INC
KEYIN.INC
SCRHDR.INC
STANDARD.INC
TIME.INC


* KEYWORDS
PASCAL 4.0 DOS SHELL MENU PROGRAM

==========================================================================
}
{KEYIN.INC}
var keyin : str255;
    keyin_aborted : boolean;
procedure get_keyin(row,column:byte;line:str255;across,total,forecolor,backcolor:byte);
  var i, cursor, position : byte;
      ins : boolean;

  procedure bad_keyin;
    begin {procedure BAD_KEYIN}
      sound(2222); delay(22);
      sound(1111); delay(11);
      nosound;
    end;  {procedure BAD_KEYIN}

  procedure home_key;
    begin {procedure HOME_KEY}
      position := 1;
      cursor := 1;
    end;  {procedure HOME_KEY}

  procedure left_arrow;
    begin {procedure LEFT_ARROW}
      if cursor > 1 then cursor := cursor - 1
      else begin
        if position > 1 then position := position - 1 else bad_keyin;
      end;  {else}
    end;  {procedure LEFT_ARROW}

  procedure right_arrow;
    begin {procedure RIGHT_ARROW}
      if position + cursor - 2 < length(keyin) then begin
        if cursor < across then cursor := cursor + 1
        else position := position + 1;
      end else bad_keyin;
    end;  {procedure RIGHT_ARROW}

  procedure end_key;
    begin {procedure END_KEY}
      if length(keyin) < across then begin
        position := 1;
        cursor := length(keyin)+1;
      end else begin
        position := length(keyin) - across + 2;
        cursor := across;
      end;  {if}
    end;  {procedure END_KEY}

  procedure ctrl_end;
    begin {procedure CTRL_END}
      if length(keyin) < position + cursor - 1 then bad_keyin
      else keyin[0] := chr(position + cursor - 2);
    end;  {procedure CTRL_END}

  procedure insert_key;
    begin {procedure INSERT_KEY}
      if ins then begin
        ins := false;
        display(25,78,'Ovr',reverse);
      end else begin
        ins := true;
        display(25,78,'Ins',reverse);
      end;  {if ins}
    end;  {procedure INSERT_KEY}

  procedure delete_char(location:byte);
    begin {procedure DELETE_CHAR}
      if location=255 then keyin[0] := chr(254) else delete(keyin,location,1);
    end;  {procedure DELETE_CHAR}

  procedure delete_key;
    begin {procedure DELETE_KEY}
      if length(keyin) < position + cursor - 1 then bad_keyin
      else delete_char(position + cursor - 1);
    end;  {procedure DELETE_KEY}

  procedure back_space;
    begin {procedure BACK_SPACE}
      if position + cursor - 1 = 1 then bad_keyin
      else begin
        delete_char(position + cursor - 2);
        if position = 1 then cursor := cursor - 1
        else position := position - 1;
      end;  {if}
    end;  {procedure BACK_SPACE}

  procedure enter_key;
    begin {procedure ENTER_KEY}
      if length(keyin) < position + cursor - 1
      then display(row,column+cursor-1,'',backcolor)
      else display(row,column+cursor-1,keyin[position+cursor-1],forecolor);
    end;  {procedure ENTER_KEY}

  procedure escape_key;
    begin {procedure ESCAPE_KEY}
      if length(keyin) = 0 then keyin_aborted := true
      else begin
        keyin := '';
        position := 1;
        cursor := 1;
      end;  {if}
    end;  {procedure ESCAPE_KEY}

   procedure other_key;
     begin {procedure OTHER_KEY}
       if ins or (length(keyin) < position+cursor-1) then begin
         if length(keyin) = total then bad_keyin
         else begin
           insert(entry,keyin,position+cursor-1);
           right_arrow;
         end;  {else}
       end else begin
         keyin[position+cursor-1] := entry;
         right_arrow;
       end;
     end;  {procedure OTHER_KEY}

  procedure show_keyin;
    var i : integer;
    begin {procedure SHOW_KEYIN}
      for i := 1 to across do begin
        if length(keyin) < position + i - 1 then begin
          if position + i - 1 > total then clear(row,column+i-1,1)
          else display(row,column+i-1,'_',backcolor);
        end else display(row,column+i-1,keyin[position+i-1],forecolor);
      end;  {for}
      if length(keyin) < position + cursor - 1
      then display(row,column+cursor-1,chr(219),backcolor*$10+$80+forecolor)
      else begin
        if ins then display(row,column+cursor-1,keyin[position+cursor-1],reverse)
        else display(row,column+cursor-1,keyin[position+cursor-1],reverse+$80);
      end;  {else}
      mode('EDIT '+strint(position + cursor - 1));
    end;  {procedure SHOW_KEYIN}

  begin {procedure GET_KEYIN}
    keyin := line;
    keyin_aborted := false;
    ins := false;   {Insert off}
    insert_key; {set Insert on and display Ins}
    end_key;    {set cursor position}
    repeat  {until (entry = #13) or keyin_aborted}
      show_keyin;  {display line to edit}
      waitkey;  {wait for keyboard input while updating clock}
      if extkey then  {if extended key}
        case entry of
          #71: home_key;
          #75: left_arrow;
          #77: right_arrow;
          #79: end_key;
          #82: insert_key;
          #83: delete_key;
          #117: ctrl_end;  {delete to end of line}
          else bad_keyin;
        end  {case extkey}
      else case entry of
          #08: back_space;
          #13: enter_key;
          #27: escape_key;
          else other_key;
        end;  {case entry}
    until (entry = #13) or keyin_aborted;
    clear(25,78,3);  {erase Ins or Ovr}
  end;  {procedure GET_KEYIN}
{END OF KEYIN.INC}

