                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program is a DOS shell that hides the underlying system from the
uninitiated user, yet does not get in the way of the expert user.
Requires: Turbo Pascal 2.0, 3.0. Author: James Haas. Version T.1.0.


* ASSOCIATED FILES
HDMENU.PAS
HDM.DOC
HDM.BAT
HDMENU.TXT
HDMX.BAT
BOX.INC
DATE.INC
DISPLAY.INC
HDMHELP.PAS
KEY.INC
KEYIN.INC
SCRHDR.INC
STANDARD.INC
TIME.INC

* CHECKED BY
HEL 9/16/88

* KEYWORDS
PASCAL 4.0 DOS SHELL MENU PROGRAM

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

program HDMENU;   {Code Size: O = 800,  Dynamic Memory: A = 400}
{INCLUDE.PAS}

Uses
  Crt,
  Dos;

{$I standard.inc} {function - strint(integer)} {reg record}
{$I display.inc}  {procedure - display(row,column,'string',attribute) 0-255}
                  {procedure - clear(row,column,number) of bytes to erase}
                  {procedure - locate(row,column,cursor) 0=none 1=norm 2=block}
{$I date.inc}     {function - Wednesday, September 18, 1954}
{$I time.inc}     {function - 12:12am; minutes = time in minutes}
{$I key.inc}      {uses display.inc}
                  {function - entry:=key [pg.341(3.0)]; extkey = true/false}
                  {procedure - waitkey; waits for key entry, updates time}
{$I scrhdr.inc}   {uses display.inc, date.inc, time.inc}
                  {procedure - scrhdr('prog ver')}
{$I box.inc}      {procedure - box1(row,column,down,across,color)}
{$I keyin.inc}    {procedure - get_keyin(row,column,across,forecolor,backcolor)}
{END INCLUDE.PAS}

type page = string[18];
     menu = string[48];
     action = string[255];
var  page_desc : array[1..10] of page;
     menu_desc : array[1..100] of menu;
     action_desc : array[1..100] of action;
     menu_file : text;
     batch_file : text;
     batch, action_str : action;
     menu_str : menu;
     edit_type : string[12];
     hdm_path : string[64];  {DOS path containing HDM}
     i : integer;
     o : byte;
     x : byte;
     curr_page : integer;
     curr_menu : integer;
     selection : byte;
     help_letter : char;
     help_menu : boolean;
     from_help_menu : boolean;
     menu_changed : boolean;
     none_or_full : boolean;
     end_of_program : boolean;
     new_page : boolean;
     batch_not_written : boolean;
     error : boolean;
     autoexec : boolean;
const version : string[4] = '2.07';
     error001 : string[26] = 'HDM001  Procedure aborted!';
     error202 : string[35] = 'HDM202  Page must have description!';
     error661 : string[33] = 'HDM661  Error opening HDMENU.TXT!';
     error662 : string[34] = 'HDM662  Error opening HDMHELP.CHN!';
     error901 : string[46] = 'HDM901  Action + Keyin exceeds 255 characters!';
     error902 : string[48] = 'HDM902  Action + @@Batch exceeds 255 characters!';

procedure show_error(error_desc : str80);
  begin {procedure SHOW_ERROR}
    display(25,1,error_desc,reverse);
    error := true;
    sound(999); delay(99); nosound;
  end;  {procedure SHOW_ERROR}

function sub : byte;
  begin {function SUB}
    sub := (curr_page-1)*10 + curr_menu;
  end;  {function SUB}

procedure read_parms;
  begin {procedure READ_PARMS}
    i := -1;
    if paramcount > 0 then val(paramstr(1),curr_page,i);
    if (i <> 0) or ((curr_page < 1) or (curr_page > 10)) then curr_page := 1;
    if paramcount > 1 then val(paramstr(2),curr_menu,i);
    if (i <> 0) or ((curr_menu < 1) or (curr_menu > 10)) then curr_menu := 1;
    if (paramcount > 2) and ((paramstr(3) = 'A') or (paramstr(3) = 'a'))
      then autoexec := true else autoexec := false;
  end;  {procedure READ_PARMS}

procedure read_desc;
  begin {procedure READ_DESC}
    getdir(0,hdm_path);
    if length(hdm_path) = 3 then hdm_path[0] := chr(2);
    assign(menu_file,hdm_path+'\hdmenu.txt');
    assign(batch_file,hdm_path+'\hdmx.bat');
    edit_type := 'HDM II '+version;
    help_menu := false;
    from_help_menu := false;
    menu_changed := false;
    none_or_full := false;
    end_of_program := false;
    new_page := false;
    error := false;
    {$I-} reset(menu_file); {$I+}
    if ioresult > 0 then
      begin {HDMENU.TXT not found}
        show_error(error661);
        for i := 1 to 10 do page_desc[i] := '';
        for i := 1 to 100 do menu_desc[i] := '';
        for i := 1 to 100 do action_desc[i] := '';
      end else begin
        for i := 1 to 10 do readln(menu_file,page_desc[i]);
        for i := 1 to 100 do readln(menu_file,menu_desc[i]);
        for i := 1 to 100 do readln(menu_file,action_desc[i]);
        close(menu_file);
      end; {HDMENU.TXT}
  end;  {procedure READ_DESC}

procedure write_desc;
  begin {procedure WRITE_DESC}
    rewrite(menu_file);
    for i := 1 to 10 do writeln(menu_file,page_desc[i]);
    for i := 1 to 100 do writeln(menu_file,menu_desc[i]);
    for i := 1 to 100 do writeln(menu_file,action_desc[i]);
    close(menu_file);
    menu_changed := false;
  end;  {procedure WRITE_DESC}

procedure show_main;
  begin {procedure SHOW_MAIN}
    box1(7,1,14,54,lightred);
    box1(7,55,14,26,lightred);
    display(6,21,'HARD DISK MENU',lightblue);
    display(6,62,'CURRENT PAGE',lightblue);
    display(8,3,'1',lightmagenta);
    display(9,3,'2',lightmagenta);
    display(10,3,'3',lightmagenta);
    display(11,3,'4',lightmagenta);
    display(12,3,'5',lightmagenta);
    display(13,3,'6',lightmagenta);
    display(14,3,'7',lightmagenta);
    display(15,3,'8',lightmagenta);
    display(16,3,'9',lightmagenta);
    display(17,3,'0',lightmagenta);
    display(8,57,'F1',lightmagenta);
    display(9,57,'F2',lightmagenta);
    display(10,57,'F3',lightmagenta);
    display(11,57,'F4',lightmagenta);
    display(12,57,'F5',lightmagenta);
    display(13,57,'F6',lightmagenta);
    display(14,57,'F7',lightmagenta);
    display(15,57,'F8',lightmagenta);
    display(16,57,'F9',lightmagenta);
    display(17,57,'F10',lightmagenta);
    display(19,3,'Enter Selection Number '+chr(16),lightmagenta);
    display(19,59,'Enter /H for Help!',lightmagenta);
    display(19,65,'/H',lightcyan);
  end;  {procedure SHOW_MAIN}

procedure show_desc;
  begin {procedure SHOW_DESC}
    for i := 1 to 10 do begin
      display(7+i,61,page_desc[i],lightcyan);
      if new_page or (length(menu_desc[(curr_page-1)*10+i])=0)
        then clear(7+i,5,48);
      display(7+i,5,menu_desc[(curr_page-1)*10 + i],lightcyan);
    end;  {for i := 1 to 10}
    display(7+curr_page,61,page_desc[curr_page],reverse);
    display(7+curr_menu,5,menu_desc[sub],reverse);
    if length(menu_desc[sub])=0 then display(7+curr_menu,5,chr(17)+'',white);
    new_page := false;
  end;  {procedure SHOW_DESC}

procedure show_help_menu(letter:char);
  begin {procedure SHOW_HELP_MENU}
    help_letter := letter;
    display(3,3,'Help  Add  Change  Delete  Move  Page  Run  Exit  Quit',lightcyan);
    case letter of
      'H': begin
             display(3,3,'Help',reverse);
             display(4,3,
             'Display information for running the Hard Disk Menu program.     '
             ,lightmagenta);
           end;  {H}
      'A': begin
             display(3,9,'Add',reverse);
             display(4,3,
             'Add a new menu selection and action to the Hard Disk Menu.      '
             ,lightmagenta);
           end;  {A}
      'C': begin
             display(3,14,'Change',reverse);
             display(4,3,
             'Change a menu description and/or action on the Hard Disk Menu.  '
             ,lightmagenta);
           end;  {C}
      'D': begin
             display(3,22,'Delete',reverse);
             display(4,3,
             'Delete a menu selection and action from the Hard Disk Menu.     '
             ,lightmagenta);
           end;  {D}
      'M': begin
             display(3,30,'Move',reverse);
             display(4,3,
             'Move a menu selection from one page/menu number to another.     '
             ,lightmagenta);
           end;  {M}
      'P': begin
             display(3,36,'Page',reverse);
             display(4,3,
             'Change a page description on the Hard Disk Menu.                '
             ,lightmagenta);
           end;  {P}
      'R': begin
             display(3,42,'Run',reverse);
             display(4,3,
             'Run any program, batch file, or DOS command.                    '
             ,lightmagenta);
           end;  {R}
      'E': begin
             display(3,47,'Exit',reverse);
             display(4,3,
             'Return to the DOS prompt, enter EXIT to return here.            '
             ,lightmagenta);
           end;  {E}
      'Q': begin
             display(3,53,'Quit',reverse);
             display(4,3,
             'Return to the Hard Disk Menu to make a menu selection.          '
             ,lightmagenta);
           end;  {E}
    end;  {case letter}
  end;  {procedure SHOW_HELP_MENU}

procedure beep;
  begin {procedure BEEP}
    sound(0025); delay(18);
    sound(0050); delay(16);
    sound(0100); delay(14);
    sound(0200); delay(12);
    sound(0400); delay(10);
    sound(0800); delay(08);
    sound(1600); delay(06);
    sound(3200); delay(04);
    sound(6400); delay(02);
    nosound;
  end;  {procedure BEEP}

procedure abort;
  begin {procedure ABORT}
    if from_help_menu then begin
      show_error(error001);
      clear(21,1,320);
      help_menu := true;
      from_help_menu := false;
      edit_type := '';
    end else beep;
  end;  {procedure ABORT}

procedure edit_menu;
  begin {procedure EDIT_MENU}
    curr_menu := selection;
    show_desc;
    display(19,30,strint(curr_menu mod 10),reverse);
    if edit_type = 'Delete' then begin
      display(22,17,'Delete Menu Selection '+strint(curr_menu mod 10)+
              ' on Page '+strint(curr_page)+' (Y/N)?',lightblue);
      i := 0;
      repeat {until Y or N or keyin aborted}
        if i > 0 then beep;
        get_keyin(22,59,'',2,1,lightmagenta,cyan);
        i := i + 1;
        if i > 9 then keyin_aborted := true;
        if (keyin = 'N') or (keyin = 'n') then keyin_aborted := true;
      until (keyin = 'Y') or (keyin = 'y') or keyin_aborted;
      if keyin_aborted then show_error(error001)
      else begin {keyin = Y}
        menu_desc[sub] := '';
        action_desc[sub] := '';
        menu_changed := true;
        show_desc;
      end;  {if keyin_aborted or keyin = N}
    end else begin
      display(22,17,edit_type+' Menu Selection Description '+
              strint(curr_menu mod 10)+' on Page '+strint(curr_page),lightblue);
      get_keyin(23,17,menu_desc[sub],48,48,lightmagenta,cyan);
      if keyin_aborted or (length(keyin) = 0)
      then show_error(error001)  {procedure aborted}
      else begin
        menu_str := keyin;
        clear(22,1,160);
        box1(21,1,4,80,lightred);
        display(22,3,edit_type+' Menu Selection Action '+
                strint(curr_menu mod 10)+' on Page '+strint(curr_page),lightblue);
        get_keyin(23,3,action_desc[sub],76,255,lightmagenta,cyan);
        if keyin_aborted or (length(keyin) = 0)
        then show_error(error001)  {procedure aborted}
        else begin
          menu_desc[sub] := menu_str;
          action_desc[sub] := keyin;
          menu_changed := true;
          clear(7+curr_menu,5,48);
          show_desc;
        end;  {if action keyin aborted}
      end;  {if desc keyin aborted}
    end;  {if edit_type = 'Delete'}
    edit_type := '';
    clear(21,1,320);
    help_menu := true;
    from_help_menu := false;
  end;  {procedure EDIT_MENU}

procedure change_page_desc;
  begin {procedure CHANGE_PAGE_DESC}
    clear(19,30,1);
    display(22,32,'Change Page # '+strint(curr_page),lightblue);
    get_keyin(23,32,page_desc[curr_page],18,18,lightmagenta,cyan);
    if keyin_aborted then show_error(error001)
    else if length(keyin) = 0 then show_error(error202)
      else begin
        page_desc[curr_page] := keyin;
        menu_changed := true;
        clear(7+curr_page,61,18);
        show_desc;
      end;  {if length keyin = 0}
    edit_type := '';
    clear(21,1,320);
    help_menu := true;
    from_help_menu := false;
   end;  {procedure CHANGE_PAGE_DESC}

procedure do_help_selection;
  begin {procedure DO_HELP_SELECTION}
    case edit_type[1] of
    'A': if length(menu_desc[(curr_page-1)*10 + selection]) > 0 then beep
         else edit_menu;
    'P': change_page_desc;
    'T': if length(menu_desc[(curr_page-1)*10 + selection]) > 0 then beep
         else begin
           curr_menu := selection;
           menu_desc[sub] := menu_desc[x];
           action_desc[sub] := action_desc[x];
           menu_desc[x] := '';
           action_desc[x] := '';
           menu_changed := true;
           show_desc;
           edit_type := '';
           clear(21,1,320);
           help_menu := true;
           from_help_menu := false;
         end;  {T}
    else if length(menu_desc[(curr_page-1)*10 + selection]) = 0 then beep
         else begin
           if edit_type = 'Move' then begin
             curr_menu := selection;
             x := sub;
             show_desc;
             display(22,17,'Move Menu Selection '+strint(curr_menu mod 10)+
                     ' on Page '+strint(curr_page)+' to ? on Page ?',lightblue);
             edit_type := 'To';
             display(23,17,'Select page and menu number to move to:',
                     lightmagenta*$10+lightblue);
           end else edit_menu;  {if edit type = Move}
         end;  {if length = 0}
    end;  {case edit_type}
  end;  {proecdure DO_HELP_SELECTION}

procedure write_batch;
  begin {procedure WRITE_BATCH}
    batch[0] := chr(o-1);
    writeln(batch_file,batch);
    batch_not_written := false;
    o := 1;
  end;  {procedure WRITE_BATCH}

procedure write_char;
  begin {procedure WRITE_CHAR}
    batch[o] := action_str[i];
    o := o + 1;
  end;  {procedure WRITE_CHAR}

procedure get_input;
  begin {procedure GET_INPUT}
    if action_str[i+1] = '?' then begin
      i := i + 2;  {skip 'LEFT BRACE' and '?'}
      x := 1;       {start output at 1}
      if action_str[i] = '}' then keyin := 'Pause for input...'
      else begin {get prompt for keyin}
        repeat {until action_str[i] = 'RIGHT BRACE'}
          keyin[x] := action_str[i];
          i := i + 1;
          x := x + 1;
        until action_str[i] = '}';
        keyin[0] := chr(x-1);  {set length of keyin}
      end;  {get prompt for keyin}
      box1(21,7,4,68,lightred);
      display(22,9,keyin,lightblue);
      get_keyin(23,9,'',64,64,lightmagenta,cyan);
      if length(keyin) + length(action_str) < 256 then
        insert(keyin,action_str,i+1)
        else show_error(error901);  {Action + Keyin exceeds 255}
      if keyin_aborted then show_error(error001);  {Procedure aborted}
      clear(21,1,320);  {clear section of screen}
    end else write_char;
  end;  {procedure GET_INPUT}

procedure batch_command;
  begin {procedure BATCH_COMMAND}
    if action_str[i+1] = '@' then begin
      i := i + 1;  {skip @}
      if length(action_str) < 245  {256 - 11}
      then insert('Command /C ',action_str,i+1)
      else show_error(error902);  {Action + @@batch exceeds 255}
    end else write_char;
  end;  {procedure BATCH_COMMAND}

procedure create_batch;
  begin {procedure CREATE_BATCH}
    rewrite(batch_file);
    i := 1;
    o := 1;
    repeat  {until error or i > length(action_str)}
      batch_not_written := true;
      case action_str[i] of
        '~': write_batch;
        '{': get_input;
        '@': batch_command;
      else write_char;  {any other character}
      end;  {case action_str[i]}
      i := i + 1;
    until error or (i > length(action_str));
    if batch_not_written then write_batch;
    writeln(batch_file,copy(hdm_path,1,2));          {drive letter:}
    writeln(batch_file,'CD' + copy(hdm_path,3,62));  {cd subdirectory}
    writeln(batch_file,'HDM '+strint(curr_page)+' '+strint(curr_menu));
    close(batch_file);
    if not error then end_of_program := true;
  end;  {procedure CREATE_BATCH}

procedure do_action;
  begin {procedure DO_ACTION}
    if from_help_menu then do_help_selection else begin
      if length(menu_desc[(curr_page-1)*10 + selection]) = 0 then beep
      else begin {if length(menu_desc[]) <> 0}
        if length(action_desc[(curr_page-1)*10 + selection]) = 0 then beep
        else begin {if length(action_desc[]) <> 0}
          curr_menu := selection;
          show_desc;
          display(19,30,strint(curr_menu mod 10),reverse);
          action_str := action_desc[sub];
          create_batch;
        end;  {if length(action_desc[]) <> 0}
      end;  {if length(menu_desc[]) = 0}
    end;  {if from_help_menu}
  end;  {procedure DO_ACTION}

procedure show_help_selection;
  begin {procedure SHOW_HELP_SELECTION}
    help_menu := false;
    from_help_menu := true;
    box1(21,15,4,52,lightred);
    display(22,17,'Select page and menu number to '+edit_type+'.',lightmagenta*$10+lightblue);
  end;  {procedure SHOW_HELP_SELECTION}

procedure help_H;
  begin {procedure HELP_H}
    show_help_menu('H');
    if menu_changed then write_desc;
    action_str := 'rem HDMHELP~';
    create_batch;
    {$I-} exec('hdmhelp.chn',''); {$I+}
    if ioresult > 0 then show_error(error662);
    end_of_program := false;
  end;  {procedure HELP_H}

procedure help_A;
  begin {procedure HELP_A}
    show_help_menu('A');
    edit_type := 'Add';
    show_help_selection;
  end;  {procedure HELP_A}

procedure help_C;
  begin {procedure HELP_C}
    show_help_menu('C');
    edit_type := 'Change';
    show_help_selection;
  end;  {procedure HELP_C}

procedure help_D;
  begin {procedure HELP_D}
    show_help_menu('D');
    edit_type := 'Delete';
    show_help_selection;
  end;  {procedure HELP_D}

procedure help_M;
  begin {procedure HELP_M}
    show_help_menu('M');
    edit_type := 'Move';
    show_help_selection;
  end;  {procedure HELP_M}

procedure help_P;
  begin {procedure HELP_P}
    show_help_menu('P');
    edit_type := 'Page';
    box1(21,30,4,22,lightred);
    display(22,32,'Select page,',lightmagenta*$10+lightblue);
    display(23,32,'then press ENTER.',lightblue);
    help_menu := false;
    from_help_menu := true;
  end;  {procedure HELP_P}

procedure help_R;
  begin {procedure HELP_R}
    show_help_menu('R');
    if menu_changed then write_desc;
    action_str:='cd\~command /c {?Enter any program, batch file, or DOS command:}~pause~';
    create_batch;
  end;  {procedure HELP_R}

procedure help_E;
  begin {procedure HELP_E}
    show_help_menu('E');
    if menu_changed then write_desc;
    display(21,1,'Enter EXIT to return to the HARD DISK MENU',lightcyan);
    display(21,7,'EXIT',lightblue);
    action_str:='exit~cd\~command~';
    create_batch;
  end;  {procedure HELP_E}

procedure kill_help;
  begin {procedure KILL_HELP}
    help_menu := false;
    clear(2,1,320);
    if menu_changed then write_desc;
  end;  {procedure KILL_HELP}

procedure help_left;
  begin {procedure HELP_LEFT}
    case help_letter of
      'Q': show_help_menu('E');
      'E': show_help_menu('R');
      'R': show_help_menu('P');
      'P': show_help_menu('M');
      'M': show_help_menu('D');
      'D': show_help_menu('C');
      'C': show_help_menu('A');
      'A': show_help_menu('H');
      'H': show_help_menu('Q');
    end;  {case help_letter}
  end;  {procedure HELP_LEFT}

procedure help_right;
  begin {procedure HELP_RIGHT}
    case help_letter of
      'Q': show_help_menu('H');
      'E': show_help_menu('Q');
      'R': show_help_menu('E');
      'P': show_help_menu('R');
      'M': show_help_menu('P');
      'D': show_help_menu('M');
      'C': show_help_menu('D');
      'A': show_help_menu('C');
      'H': show_help_menu('A');
    end;  {case help_letter}
  end;  {procedure HELP_RIGHT}

procedure help_enter;
  begin {procedure HELP_ENTER}
    case help_letter of
      'Q': kill_help;
      'E': help_E;
      'R': help_R;
      'P': help_P;
      'D': help_D;
      'M': help_M;
      'C': help_C;
      'A': help_A;
      'H': help_H;
    end;  {case help_letter}
  end;  {procedure HELP_ENTER}

procedure go_up;
  begin {procedure GO_UP}
    i := i + 1;
    curr_menu := curr_menu - 1;
    if curr_menu < 1 then begin
      curr_menu := 10;
      curr_page := curr_page -1;
      new_page := true;
      if curr_page < 1 then curr_page := 10;
    end;  {if curr_menu < 1}
  end;  {procedure GO_UP}

procedure menu_up;
  begin {procedure MENU_UP}
    if edit_type = 'Page' then for i := 1 to 10 do go_up
    else begin
      i := 0;
      if (edit_type = 'Add') or (edit_type = 'To') then begin
        repeat go_up;
        until (i>99) or (length(menu_desc[sub]) = 0);
      end else begin
        repeat go_up;
        until (i>99) or (length(menu_desc[sub]) > 0);
      end;  {if Add or To}
    end;  {if Page}
    if i > 99 then none_or_full := true;
    show_desc;
  end;  {procedure MENU_UP}

procedure go_down;
  begin {procedure GO_DOWN}
    i := i + 1;
    curr_menu := curr_menu + 1;
    if curr_menu > 10 then begin
      curr_menu := 1;
      curr_page := curr_page +1;
      new_page := true;
      if curr_page > 10 then curr_page := 1;
    end;  {if curr_menu > 10}
  end;  {procedure GO_DOWN}

procedure menu_down;
  begin {procedure MENU_DOWN}
    if edit_type = 'Page' then for i := 1 to 10 do go_down
    else begin
      i := 0;
      if (edit_type = 'Add') or (edit_type = 'To') then begin
        repeat go_down;
        until (i>99) or (length(menu_desc[sub]) = 0);
      end else begin
        repeat go_down;
        until (i>99) or (length(menu_desc[sub]) > 0);
      end;  {if Add or To}
    end;  {if Page}
    if i > 99 then none_or_full := true;
    show_desc;
  end;  {procedure MENU_DOWN}

procedure menu_home;
  begin {procedure MENU_HOME}
    curr_menu := 10;
    curr_page := 10;
    menu_down;
  end;  {procedure MENU_HOME}

procedure menu_end;
  begin {procedure MENU_END}
    curr_menu := 1;
    curr_page := 1;
    menu_up;
  end;  {procedure MENU_END}

procedure check_page;
  begin {procedure CHECK_PAGE}
    if edit_type = 'Page' then beep else do_action;
  end;  {procedure CHECK_PAGE}

procedure menu_zero;
  begin {procedure MENU_ZERO}
    selection := 10;
    check_page;
  end;  {procedure MENU_ZERO}

procedure menu_one;
  begin {procedure MENU_ONE}
    selection := 1;
    check_page;
  end;  {procedure MENU_ONE}

procedure menu_two;
  begin {procedure MENU_TWO}
    selection := 2;
    check_page;
  end;  {procedure MENU_TWO}

procedure menu_three;
  begin {procedure MENU_THREE}
    selection := 3;
    check_page;
  end;  {procedure MENU_THREE}

procedure menu_four;
  begin {procedure MENU_FOUR}
    selection := 4;
    check_page;
  end;  {procedure MENU_FOUR}

procedure menu_five;
  begin {procedure MENU_FIVE}
    selection := 5;
    check_page;
  end;  {procedure MENU_FIVE}

procedure menu_six;
  begin {procedure MENU_SIX}
    selection := 6;
    check_page;
  end;  {procedure MENU_SIX}

procedure menu_seven;
  begin {procedure MENU_SEVEN}
    selection := 7;
    check_page;
  end;  {procedure MENU_SEVEN}

procedure menu_eight;
  begin {procedure MENU_EIGHT}
    selection := 8;
    check_page;
  end;  {procedure MENU_EIGHT}

procedure menu_nine;
  begin {procedure MENU_NINE}
    selection := 9;
    check_page;
  end;  {procedure MENU_NINE}

procedure menu_enter;
  begin {procedure MENU_ENTER}
    selection := curr_menu;
    do_action;
  end;  {procedure MENU_ENTER}

procedure show_help;
  begin {procedure SHOW_HELP}
    if from_help_menu then beep
    else begin
      help_menu := true;
      box1(2,1,4,80,lightred);
      show_help_menu('H');
    end;  {if add_menu}
  end;  {procedure SHOW_HELP}

procedure page_one;
  begin {procedure PAGE_ONE}
    curr_menu := 10;
    curr_page := 10;
    menu_down;
  end;  {procedure PAGE_ONE}

procedure page_two;
  begin {procedure PAGE_TWO}
    curr_menu := 10;
    curr_page := 1;
    menu_down;
  end;  {procedure PAGE_TWO}

procedure page_three;
  begin {procedure PAGE_THREE}
    curr_menu := 10;
    curr_page := 2;
    menu_down;
  end;  {procedure PAGE_THREE}

procedure page_four;
  begin {procedure PAGE_FOUR}
    curr_menu := 10;
    curr_page := 3;
    menu_down;
  end;  {procedure PAGE_FOUR}

procedure page_five;
  begin {procedure PAGE_FIVE}
    curr_menu := 10;
    curr_page := 4;
    menu_down;
  end;  {procedure PAGE_FIVE}

procedure page_six;
  begin {procedure PAGE_SIX}
    curr_menu := 10;
    curr_page := 5;
    menu_down;
  end;  {procedure PAGE_SIX}

procedure page_seven;
  begin {procedure PAGE_SEVEN}
    curr_menu := 10;
    curr_page := 6;
    menu_down;
  end;  {procedure PAGE_SEVEN}

procedure page_eight;
  begin {procedure PAGE_EIGHT}
    curr_menu := 10;
    curr_page := 7;
    menu_down;
  end;  {procedure PAGE_EIGHT}

procedure page_nine;
  begin {procedure PAGE_NINE}
    curr_menu := 10;
    curr_page := 8;
    menu_down;
  end;  {procedure PAGE_NINE}

procedure page_ten;
  begin {procedure PAGE_TEN}
    curr_menu := 10;
    curr_page := 9;
    menu_down;
  end;  {procedure PAGE_TEN}

procedure page_up;
  begin {procedure PAGE_UP}
    curr_menu := 1;
    menu_up;
  end;  {procedure PAGE_UP}

procedure page_down;
  begin {procedure PAGE_DOWN}
    curr_menu := 10;
    menu_down;
  end;  {procedure PAGE_DOWN}

procedure get_help_entry;
  begin {procedure GET_HELP_ENTRY}
    if extkey then begin
      case ord(entry) of  {extkey}
        75: help_left;  {left arrow key}
        77: help_right; {right arrow key}
        72: menu_up;    {up arrow key}
        80: menu_down;  {down arrow key}
        71: menu_home;  {home key}
        79: menu_end;   {end key}
        59: page_one;   {F1 key}
        60: page_two;   {F2 key}
        61: page_three; {F3 key}
        62: page_four;  {F4 key}
        63: page_five;  {F5 key}
        64: page_six;   {F6 key}
        65: page_seven; {F7 key}
        66: page_eight; {F8 key}
        67: page_nine;  {F9 key}
        68: page_ten;   {F10 key}
        73: page_up;    {PgUp key}
        81: page_down;  {PgDn key}
      else beep;
      end;  {case entry of extkey}
    end else begin
      case ord(upcase(entry)) of  {no extkey}
        72: help_H;     {H key}
        65: help_A;     {A key}
        67: help_C;     {C key}
        68: help_D;     {D key}
        77: help_M;     {M key}
        80: help_P;     {P key}
        82: help_R;     {R key}
        69: help_E;     {E key}
        81: kill_help;  {Q key}
        13: help_enter; {Enter key}
        27: kill_help;  {Esc key}
      else beep;
      end;  {case entry of no extkey}
    end;  {if extkey}
  end;  {procedure GET_HELP_ENTRY}

procedure get_menu_entry;
  begin {procedure GET_MENU_ENTRY}
    if extkey then begin
      case ord(entry) of  {extkey}
        72: menu_up;    {up arrow key}
        80: menu_down;  {down arrow key}
        71: menu_home;  {home key}
        79: menu_end;   {end key}
        59: page_one;   {F1 key}
        60: page_two;   {F2 key}
        61: page_three; {F3 key}
        62: page_four;  {F4 key}
        63: page_five;  {F5 key}
        64: page_six;   {F6 key}
        65: page_seven; {F7 key}
        66: page_eight; {F8 key}
        67: page_nine;  {F9 key}
        68: page_ten;   {F10 key}
        73: page_up;    {PgUp key}
        81: page_down;  {PgDn key}
      else beep;
      end;  {case entry of extkey}
    end else begin
      case ord(entry) of  {no extkey}
        48: menu_zero;  {0 key}
        49: menu_one;   {1 key}
        50: menu_two;   {2 key}
        51: menu_three; {3 key}
        52: menu_four;  {4 key}
        53: menu_five;  {5 key}
        54: menu_six;   {6 key}
        55: menu_seven; {7 key}
        56: menu_eight; {8 key}
        57: menu_nine;  {9 key}
        13: menu_enter; {Enter key}
        47: show_help;  {/ key}
        27: abort;      {Esc key}
      else beep;
      end;  {case entry of no extkey}
    end;  {if extkey}
  end;  {procedure GET_MENU_ENTRY}

begin  {program HDMENU}
  clrscr;
  read_parms;  {DOS parameters}
  scrhdr('HDMENU '+version);
  show_main;
  read_desc;
  show_desc;
  repeat  {until end_of_program}
    if help_menu then begin
      clear(19,30,1);
      mode('TOP MENU');
    end else begin
      display(19,30,chr(219),$DB);
      if length(edit_type) = 0 then mode('READY') else mode(edit_type);
    end;  {if help_menu}
    if edit_type <> 'Page' then begin
      if none_or_full then beep else begin
        if (edit_type = 'Add') or (edit_type = 'To') then begin
          if length(menu_desc[sub]) > 0 then menu_down
        end else
          if length(menu_desc[sub]) = 0 then menu_down;
      end;  {if none or full}
    end;  {if edit type <> Page}
    none_or_full := false;
    if autoexec then begin
      extkey := false;
      autoexec := false;
      entry := #13;
    end else waitkey;
    if error then clear(25,1,80);
    error := false;
    if help_menu then get_help_entry
    else get_menu_entry;
  until end_of_program;
  locate(21,1,1);  {return cursor to normal}
  clrscr;
end.  {program HDMENU}

