                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include file for HDMENU.PAS.
Requires: Turbo Pascal 4.0. Author: James Haas. Version T.1.0.
Converted to version 4.0.

* ASSOCIATED FILES
HDMENU.PAS
HDM.DOC
HDM.BAT
HDMENU.TXT
HDMX.BAT
BOX.INC
DATE.INC
DISPLAY.INC
HDMHELP.PAS
KEY.INC
KEYIN.INC
SCRHDR.INC
STANDARD.INC
TIME.INC

* KEYWORDS
PASCAL 4.0 DOS SHELL MENU PROGRAM

==========================================================================
}
{DISPLAY INCLUDE}
  const reverse : byte = $70;

procedure display (row, column: byte; line: str80; attribute: byte);
  var i: byte; offset: integer;
  begin {display procedure}
    offset:=(row-1)*160 + (column-1)*2;
    if mem[$0000:$0449] = 7 then begin {if mode = mono}
      for i:=1 to length(line) do begin {fill monochrome video buffer}
        mem[$B000:$0000 + offset]:=ord(line[i]); {monochrome buffer}
        mem[$B000:$0001 + offset]:=attribute;
        offset:=offset+2;
      end; {fill monochrome video buffer}
    end else begin
      for i:=1 to length(line) do begin {fill color video buffer}
        mem[$B000:$8000 + offset]:=ord(line[i]); {color buffer}
        mem[$B000:$8001 + offset]:=attribute;
        offset:=offset+2;
      end; {fill color video buffer}
    end; {if mode = mono}
  end; {display procedure}

procedure clear (row, column: byte; number: integer);
  var i: byte; offset: integer;
  begin {clear procedure}
    offset:=(row-1)*160 + (column-1)*2;
    if mem[$0000:$0449] = 7 then begin {if mode = mono}
      for i:=1 to number do begin {erase monochrome video buffer}
        memw[$B000:$0000 + offset]:=$0D00; {monochrome buffer}
        offset:=offset+2;
      end; {erase monochrome video buffer}
    end else begin
      for i:=1 to number do begin {erase color video buffer}
        memw[$B000:$8000 + offset]:=$0D00; {color buffer}
        offset:=offset+2;
      end; {erase color video buffer}
    end; {if mode = mono}
  end; {clear procedure}

procedure locate (row, column, cursor: byte);
  var regs : registers;
  begin {locate procedure}
    gotoxy(column,row);
    if mem[$0000:$0449] = 7 then begin  {if mode = mono}
        case cursor of         {monchrome display}
          0: Regs.cx := $4000;  {no cursor}
          1: Regs.cx := $0B0C;  {normal cursor}
          2: Regs.cx := $000D;  {block cursor}
        end;  {case of monochrome display}
      end else begin
        case cursor of         {color display}
          0: Regs.cx := $2000;  {no cursor}
          1: Regs.cx := $0707;  {normal cursor}
          2: Regs.cx := $0007;  {block cursor}
        end;  {case of color display}
    end;  {if mode = mono}
    Regs.ax := $0100;
    intr($10,Regs);
  end; {locate procedure}
{END OF DISPLAY INCLUDE}

