                       F i l e    I n f o r m a t i o n

* DESCRIPTION
A program to print out the directory structure of a disk in a useful format.
Requires: Turbo Pascal 4.0. Author: Fred Hulting. Version T1.0.
1985/86 TUG O'Wards entry. Converted to version 4.0.

* ASSOCIATED FILES
DISKTREE.PAS
DISKTREE.DOC

* KEYWORDS
PASCAL 4.0 DIRECTORY PROGRAM

==========================================================================
}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

{*****************************************************************************

      PROGRAM:    DiskTree


      PROGRAMMER: Fred L. Hulting
                  Department of Statistics
                  117 Snedecor Hall
                  Iowa State University
                  Ames, Ia   50011


      SYSTEM:     MS-DOS


      LAST UPDATE:  February 12, 1986

----------------------------------------------------------------------------


     A program to Print out the Directory Structure of a Disk in a useful
     format.  It is intended to replace the DOS supplied Tree command.
     Makes use of the Routines found in the QDL Program to Get the Files
     and Subdirectories.  This Program Builds a Tree which Corresponds
     to the Directory Structure.  Then it Prints it out.

     The tree structure used here is referred to as a "family" tree;
     Parents have a Child, and each Child has a Sibling.  Thus, each
     node in the tree has two pointers  A picture of the tree structure
     used is something like the following, where:

        ------>  = Pointer to the Next Sibling

           |
           |   = Pointer to the "Eldest" Child
          \|/


          +-----+        +-----+
          |     |        |     |
          |     |------->|     |
          |     |        |     |
          +-----+        +-----+
             |              |
             |              |
            \|/            \|/
          +-----+        +-----+             +-----+    +-----+
          |     |        |     |             |     |    |     |
 Parent   |     |        |     |------------>|     |--->|     |
          |     |        |     |             |     |    |     |
          +-----+        +-----+             +-----+    +-----+
             |                                  |
             |                                  |
             |                                  |
            \|/                                \|/
          +-----+    +-----+     +-----+      +-----+
  3 Sub   |     |    |     |     |     |      |     |
   Dirs   |     |----|     |-----|     |      |     |
 of that  |     |    |     |     |     |      |     |
  Parent  +-----+    +-----+     +-----+      +-----+



   Siblings are SubDirectories belonging the the same parent.  The
   "Eldest" Child is the first subdirectory of a parent subdirectory.


*****************************************************************************}

Program DiskTrees;

Uses
  Dos;

      {------------------------------------------------------
             TYPE DECLARATIONS
       ------------------------------------------------------}
type

  { Structures Used in Building the Tree }

  String80 = string[80];
  TreePtr = ^TreeNode;             { Pointers to Link Tree Together    }
  TreeNode = record                { The Nodes of the Tree             }
      Name: String80;              {     Name of the Directory         }
      Size: real;                  {     Size of the Directory         }
      Files: integer;              {     # of Files in the Directory   }
      Child: TreePtr;              {     The "Eldest Child"            }
      Sibling: TreePtr             {     Next Sibling                  }
    end;
  PtrTyp = (Kid, Sib);             { Variable Used to Assign Pointers  }


  Char80arr     = array [ 1..80 ] of Char;
  ParmType      = string [127];        { Command Line Parameters           }
  DateTimeType  = string[8];


      {------------------------------------------------------
              VARIABLE DECLARATIONS
       ------------------------------------------------------}
var
  DTA       : array [ 1..43 ] of Byte; { Data Transfer Area Buffer         }
  DTAseg,                              { DTA Segment before Execution      }
  DTAofs,                              { DTA Offset    "        "          }
  SetDTAseg,                           { DTA Segment and Offset set after  }
  SetDTAofs,                           { start of program                  }
  Option    : Integer;                 { Used to Specify File Types for    }
                                       { Directory Searches                }
  Regs      : Registers;               { Register Pack for MSDos function  }
  Path,                                { Path of Directory to Read         }
  NameofFile,                          { File Name                         }
  Volume    : String80;                { Volume Name                       }
  Mask      : Char80arr;               { File Mask                         }
  LowSize1,                            { Low Byte of Low Word of File Size }
  LowSize2,                            { High Byte of Low Word of File Size}
  HighSize1,                           { Low Byte of High Word of File Size}
  Attribute : byte;                    { Type of File Entry Found          }
  Place     : Integer;
  Buffer    : ParmType;                { Generic Buffer                    }
  Top,                                 { Top Node in Directory Tree        }
  Head      : TreePtr;                 { Pointer Used to Track Tree Moves  }
  DiskDrive : String[2];               { String Denoting Disk Drive        }
  ChildOrSib: PtrTyp;                  { Used to Decide Assignment of Ptrs }
  Generation: Integer;                 { Used to Keep Track of Tree Level  }
  CReturn   : boolean;                 { Used to keep track of Carriage    }
                                       { Returns during the Printing       }
  MaxGen    : Integer;                 { Maximum "Generation" of Tree      }
  Ch: char;
  InfoType,                            { Type of Information to Report     }
  TotalFiles: integer;                 { Number of Files in a Directory    }
  TotalSpace: real;                    { Total Space Used by Directory     }






{*****************************************

     These 5 Routines are taken from the QDL program in the Turbo Tutor
     Manual.  They are NOT mine.  I have chosen to use them rather
     than rewrite them and claim them as my owm.  I have, however,
     modified them somewhat in order to extract extra info from the
     DTA.

           ************************************************************}



{------------------------------------------------------------------------------
     SetDTA resets the current DTA to the new address specified in the
parameters 'SEGMENT' and 'OFFSET'.
------------------------------------------------------------------------------}

procedure SetDTA( Segment, Offset : Integer; var Error : Integer );
begin
  Regs.AX := $1A00;         { Function used to set the DTA }
  Regs.DS := Segment;       { store the parameter Segment in DS }
  Regs.DX := Offset;        {   "    "      "     Offset in DX }
  MSDos( Regs );            { Set DTA location }
  Error := Regs.AX and $FF; { get Error return }
end; { of proc SetDTA }

{------------------------------------------------------------------------------
     GetCurrentDTA is used to get the current Disk Transfer Area ( DTA )
address.  A function code of $2F is stored in the high Byte of the AX
register and a call to the predefined procedure MSDos is made.  This can
also be accomplished by using the "Intr" procedure with the same register
record and a $21 specification for the interrupt.
------------------------------------------------------------------------------}

procedure GetCurrentDTA( var Segment, Offset : Integer;
                         var Error : Integer );
begin
  Regs.AX := $2F00;    { Function used to get current DTA address }
  MSDos( Dos.Registers(Regs) );       { Exicute MSDos function request }
  Segment := Regs.ES;  { Segment of DTA returned by DOS }
  Offset := Regs.BX;   { Offset of DTA returned }
  Error := Regs.AX and $FF;
end; { of proc GetCurrentDTA }


{------------------------------------------------------------------------------
     GetFirst gets the first directory entry of a particular file Mask.  The
Mask is passed as a parameter 'Mask' and,  the Option was previosly specified
in the SpecifyOption procedure.
------------------------------------------------------------------------------}


procedure GetFirst(     Mask         : Char80arr;
                    var NameofFile   : String80;
                        Segment,
                        Offset       : Integer;
                        Option       : Integer;
                    var Error        : Integer );
var
  I : Integer;

begin
  Error := 0;
  Regs.AX := $4E00;                            { Get First Directory Entry }
  Regs.DS := Seg( Mask );                      { Point to the file Mask    }
  Regs.DX := Ofs( Mask );
  Regs.CX := Option;                           { Store the Option          }
  MSDos( Dos.Registers(Regs) );                               { Execute MSDos call        }
  Error := Regs.AX and $FF;                    { Get Error return          }
  Attribute := mem[ Segment : Offset + 21];    { Get Attribute of Entry    }
  LowSize1  := mem[ Segment : Offset + 26];    { Lowest Byte of File Size  }
  LowSize2  := mem[ Segment : Offset + 27];    { Middle Byte of File Size  }
  HighSize1 := mem[ Segment : Offset + 28];    { High   Byte of Files Size }
  I := 1;                            { Initialize 'I' to the first element }
  repeat                             { Enter the loop that reads in the    }
                                     { first file entry                    }
    NameofFile[ I ] := Chr( mem[ Segment : Offset + 29 + I ] );
    I := I + 1;
  until ( not ( NameofFile[ I - 1 ] in [ ' '..'~' ] ));

        { set string length because assigning by element does
          not set length      }

  NameofFile[ 0 ] := Chr( I - 1 );
end; { of proc GetFirst }



{------------------------------------------------------------------------------
     GetNext uses the first bytes of the DTA for the file Mask, and
returns the next file entry on disk corresponding to the file Mask.
------------------------------------------------------------------------------}


procedure GetNext     ( var NameofFile   : String80;
                            Segment,
                            Offset,
                            Option       : Integer;
                        var Error        : Integer );
var
  I : Integer;

begin
  Error := 0;
  Regs.AX := $4F00;           { Function used to get the next }
                              { directory entry }
  Regs.CX := Option;          { Set the file option }
  MSDos( Regs );              { Call MSDos }
  Error := Regs.AX and $FF;   { get the Error return }
  Attribute:= mem[ Segment : Offset + 21];
  LowSize1 := mem[ Segment : Offset + 26];
  LowSize2 := mem[ Segment : Offset + 27];
  HighSize1:= mem[ Segment : Offset + 28];
  I := 1;
  repeat
    NameofFile[ I ] := Chr( mem[ Segment : Offset + 29 + I ] );
    I := I + 1;
  until ( not ( NameofFile[ I - 1 ] in [ ' '..'~' ] ));
  NameofFile[ 0 ] := Chr( I - 1 );
end; { of proc GetNext }


Procedure DTAInitialize;

 var Error: integer;

 begin
  GetCurrentDTA( DTAseg, DTAofs, Error );    { Get the current DTA address }
  if ( Error <> 0 ) then begin               { Abort on Errors }
    WriteLn( 'Unable to get current DTA' );
    WriteLn( 'Program aborting.' );
    Halt;
  end;
  SetDTAseg := Seg( DTA );
  SetDTAofs := Ofs( DTA );
  SetDTA( SetDTAseg, SetDTAofs, Error );     { Reset DTA addresses }
  if ( Error <> 0 ) then begin               { Abort on Error      }
    WriteLn( 'Cannot reset DTA' );
    WriteLn( 'Program aborting.' );
    Halt;
  end;
end;



{*****************************************


    Miscellaneous routines written by me and used by the Tree building
    and Printing Routines


          ***********************************************************}

{------------------------------------------------------------------------------
    This routines simply returns the current Date in the form '11/10/86'
------------------------------------------------------------------------------}


  Function Date: DateTimeType;

    var Reg:     Registers;
        Year,
        Month,
        Day,
        W:       DateTimeType;
        I:       integer;

    begin
      Reg.AX:=$2A00;                 { Function Call Hex 2A }
      MSDos ( Reg );
      str (Reg.CX:4,Year);
      delete (Year,1,2);             { CH has year      }
      str (hi(Reg.DX):2,Month);      { DH has month         }
      str (lo(Reg.Dx):2,Day);        { Days in DL           }
      W:= Month + '/' + Day + '/' + Year;
      for i:=1 to length(W) do if W[i]=' ' then W[i]:='0';
      Date:=W
    end;

{------------------------------------------------------------------------------
   This routine returns the time as:  '09:17:58'
------------------------------------------------------------------------------}

  Function Time: DateTimeType;

    var Reg:    Registers;
        Hour,
        Min,
        Sec,
        W:      DateTimeType;
        i:      integer;


    begin
      Reg.AX:=$2C00;                    { Function call Hex 2C }
      MsDos ( Reg );
      str (hi(Reg.CX):2,Hour);             { Hours in CH   }
      str (lo(Reg.CX):2,Min);              { Minutes in CL }
      str (hi(Reg.DX):2,Sec);              { Seconds in DH }
      W:= Hour + ':' + Min + ':' + Sec;
      for i:=1 to length(W) do if W[i]=' ' then W[i]:='0';
      Time:=W
    end;



{------------------------------------------------------------------------------
  Byte_Add Takes Three One Byte Integers Which Represent the Bytes of
  a Word and a Half of Memory and Converts it to its Real Representation
------------------------------------------------------------------------------}


Function Byte_Add (Low1, Low2, High: byte): real;

   var Result: real;

   begin
     Result:=0.0;                { Initialize result }
     Result:=Result + Low1;      { Add the Value of the Low Byte }

     { Now Add the Contribution of the Middle Byte }

     if (Low2 and 128) = 128 then Result:=Result + 32768.0;
     if (Low2 and  64) =  64 then Result:=Result + 16384.0;
     if (Low2 and  32) =  32 then Result:=Result +  8192.0;
     if (Low2 and  16) =  16 then Result:=Result +  4096.0;
     if (Low2 and   8) =   8 then Result:=Result +  2048.0;
     if (Low2 and   4) =   4 then Result:=Result +  1024.0;
     if (Low2 and   2) =   2 then Result:=Result +   512.0;
     if (Low2 and   1) =   1 then Result:=Result +   256.0;

     { Now Add the Contribution of the High Byte }

     if (High and  64) =  64 then Result:=Result + 4194304.0;
     if (High and  32) =  32 then Result:=Result + 2097152.0;
     if (High and  16) =  16 then Result:=Result + 1048576.0;
     if (High and   8) =   8 then Result:=Result +  524288.0;
     if (High and   4) =   4 then Result:=Result +  262144.0;
     if (High and   2) =   2 then Result:=Result +  131072.0;
     if (High and   1) =   1 then Result:=Result +   65536.0;

     Byte_Add:=Result;
   end;


{------------------------------------------------------------------------------
    GetFirstEntry sets the Option and Mask for the Call to GetFirst, and
    Calculates the Approx Space occupied by the File that is Found
------------------------------------------------------------------------------}

Procedure GetFirstEntry (    Dname : String80;
                         var Att   : byte;
                         var Space : real;
                         var Ename : String80;
                         var Err   : integer);
 var temp: String80;
     I:    integer;

 begin
   Buffer:=DiskDrive + Dname + '\*.*';
   for I := 1 to length( Buffer ) do       { Assign Buffer to Mask }
        Mask[ I ] := Buffer[ I ];
   Option:=16;
   GetFirst( Mask, Temp, SetDTAseg, SetDTAofs, Option, Err );
   if Err = 0 then
     begin
       Ename    := Temp;
       Att      := Attribute;
       Space    := Byte_Add (LowSize1, LowSize2, HighSize1);
     end;
 end;


{------------------------------------------------------------------------------
    GetNextEntry simply calls GetNext, calculating Space before returning to
    the calling program.  I wrote this and GetFirstEntry so that I could
    leave GetFirst and GetNext essentially intact
------------------------------------------------------------------------------}

Procedure GetNextEntry  (var Att:   byte;
                         var Space: real;
                         var Ename: String80;
                         var Err:   integer);

 begin
   GetNext( NameofFile, SetDTAseg, SetDTAofs, Option, Err );
   if Err = 0 then
     begin
       Ename    := NameofFile;
       Att      := Attribute;
       Space    := Byte_Add (LowSize1, LowSize2, HighSize1);
     end;
 end;


{------------------------------------------------------------------------------
   This routine is called to clear the DTA, Mask and the NameofFile buffers
------------------------------------------------------------------------------}

Procedure BufferInitialize;
  var I: integer;
  begin
    for I := 1 to 21 do DTA[ I ] := 0;        { Initialize the DTA Buffer }
      for I := 1 to 80 do begin               { Initialize the Mask and }
        Mask[ I ] := Chr( 0 );                { file name buffers }
        NameofFile[ I ] := Chr( 0 );
      end
  end;






{**************************************************

       Tree Building Routines

           These routines perform the task of constructing a tree
           which describes the directory structure.  Each node
           represents a subdirectory and contains information about
           the number of files and the approx size of files in the
           directory

         ********************************************************}



{------------------------------------------------------------------------------
   Used to allocate a new pointer;  Space is taken from the Heap using the
   New function, and the values in the node are initialized
------------------------------------------------------------------------------}


Procedure AddNode (var NodePtr: TreePtr);
  begin
    new (NodePtr);              { Get Pointer New Node }
    NodePtr^.Name:='';          { Set Name to Null String }
    NodePtr^.Size:=0.0;
    NodePtr^.Files:=0;
    NodePtr^.Child:=nil;        { No Children }
    NodePtr^.Sibling:=nil;      { No Siblings }
  end;


{------------------------------------------------------------------------------
   This procedure is called once to get the command line parameters and to
   initialize variables for the Tree Structure
------------------------------------------------------------------------------}

Procedure TreeInitialize;

  var Param: string;
      Error: integer;

  begin
    AddNode (Top);                { Get Root of Tree }
    Generation:=-1;               { Start counter at -1, ie no directories }
    MaxGen:=0;                    { Root is Level 0 }
    Path:='';                     { Null Pathname to Start }
    DTAInitialize;                { Reset Address of DTA }


    { Get the First Parameter and Set Value of DiskDrive }

    if ParamCount > 0 then
      begin
        if Length(ParamStr(1)) = 1 then DiskDrive:= ParamStr(1)+':';
        if Length(ParamStr(1)) = 2 then DiskDrive:= ParamStr(1);
        if (Length(ParamStr(1)) <= 0) or (Length(ParamStr(1)) >= 3)
                                      then DiskDrive:= '';
      end;

     { Get Second Parameter; Decide which Info to Report }

    InfoType := 0;         { Default:  Approx File Sizes Reported }
    If ParamCount = 2 then
      begin
        Param := ParamStr(2);
        if UpCase(Param[1]) = 'N'
           then InfoType := 1;                { Number of Files Reported   }
      end;
  end;



{------------------------------------------------------------------------------
    This routine is called to add all children (subdirectories) to a given
    parent (directory).  It contains two nested procedures, Update and
    ParentInitialize.  The latter initializes varaibles, the former updates
    file count and size information for the current parent directory.
------------------------------------------------------------------------------}


Procedure AddChildren (var Parent: TreePtr;   { Node to Add Children (ie  }
                                              { subdirectories) to        }
                       var Exist: boolean);   { Returns true if Children  }
                                              { are added                 }

 var TotalSize,
     EntrySize:     real;
     DirName,
     EntryName:     String80;
     Error:         integer;
     Att:           byte;


   Procedure ParentInitialize;

     begin {ParentInitialize}

       Head:=Parent;        { Pointer used to Add Children and Siblings }
       ChildOrSib:=Kid;     { Next Addition is a Child                  }
       TotalSize:=0.0;      { Reset Size and Files Counter              }
       TotalFiles:=0;
       Exist:=false;        { Assume No Subdirectories Exist            }

     end; {ParentInitialize}


   Procedure Update;

     begin { Update }

       delete (EntryName,length(EntryName),1);
       TotalSize:= TotalSize + EntrySize;

       { Bit 4 Set means Entry is a Directory }

       if (Att <> 16) then TotalFiles:=TotalFiles + 1;
       if (Att = 16) and (EntryName <> '.') and (EntryName <> '..') then
         begin
           Exist:=true;
           if (ChildOrSib = Kid)
             then begin                       { Add First SubDirectory as  }
                    AddNode (Head^.Child);    { the Child                  }
                    Head:=Head^.Child;
                    ChildOrSib:=Sib;
                  end
             else begin                       { Subsequent SubDirectories  }
                    AddNode (Head^.Sibling);  { Added as Siblings of First }
                    Head:=Head^.Sibling;      { Subdirectory               }
                  end;
           Head^.Name:='\' + EntryName;       { Put SubDir Name in New Node }
         end;
     end;  { Update }


  begin    { AddChildren }

    { Clear the DTA Buffer and Initialize Variables }

    BufferInitialize;
    ParentInitialize;

    { Get Entries from Directory until No More Remain;  Call Update
      to increment file and size counters for this directory }

    GetFirstEntry (Path, Att, EntrySize, EntryName, Error);
    if Error = 0 then Update;
    while Error = 0 do
     begin
      GetNextEntry (Att, EntrySize, EntryName, Error);
      if Error = 0 then Update;
     end;

    { Store Count of Files and their Approx Size }

    Parent^.Size:=TotalSize;
    Parent^.Files:=TotalFiles;

  end;     { AddChildren }

{------------------------------------------------------------------------------
   This is the Recursive routine which builds a tree below the Root it is
   Given.   It calls AddChildren to add subdirectories to its root, and
   then calls itself to add the "grandchildren" if any children exist.
------------------------------------------------------------------------------}


Procedure BuildTree (Root: TreePtr);

  var ChildExists: boolean;
      I, LengthOfAddition: integer;

  begin
    Generation:=Generation + 1;                { Move to New Level }
    if Generation > MaxGen
      then MaxGen:=Generation;                 { Update Depth of Tree}
    repeat
      LengthOfAddition:= length (Root^.Name);  { Length of Directory Name }
      Path:=Path + Root^.Name;                 { Add to Full Path Name    }
      AddChildren (Root, ChildExists);         { Add Children to Root     }

      { If Children Added, Go and Add Their Children }

      if ChildExists then BuildTree (Root^.Child);

      { Delete Addition to Path Name }

      Path:= copy (Path,1,length(Path) - LengthOfAddition);

      { Now Add To the Siblings of the Current Node }

      Root:=Root^.Sibling;
    until (Root = nil);
    Generation:=Generation - 1;                { Move Up a Level }
  end;



{*******************************************

     Print Directory Structure Routines

        These routines traverse the tree and print out a listing of
        the disrectory structure

           *************************************************}


{------------------------------------------------------------------------------
    Called to print information for the current node;  if the node represents
    the root directory of the disk, then lots of header information is
    printed out.  Otherwise, size or count of files is printed.  The variable
    CReturn is used to control formatting of the output.
------------------------------------------------------------------------------}

Procedure PrintName (var Parent: TreePtr);

  var ListName : string[8];
      I,
      Error    : integer;

  begin

    { CReturn = false means align with current generation being printed }

    if not(CReturn) then
      for I:=1 to generation-1 do write ('                     ');
    CReturn:=true;

    { Extract Name of SubDirectory -- Make it 10 Characters Long }

    ListName:=copy(Parent^.Name,2,length(Parent^.Name) - 1) + '          ';

    { If Name is Blank We are at Root Directory; Print Header Info }

    if ListName = '        '
      then begin

             { First -- Get Volume Label }

             Buffer:=DiskDrive;
             for I := 1 to length( Buffer ) do       { Assign Buffer to Mask }
             Mask[ I ] := Buffer[ I ];
             Option:= 8;
             GetFirst( Mask, NameofFile, SetDTAseg, SetDTAofs, Option, Error );

             { Existence of Volume Label and Disk Drive Command Line }
             { Parameter Decides Main Heading                         }

             if (Error = 0) and (Length(NameofFile) > 0) then
               begin
                 writeln ('Directory Structure of Volume ',NameofFile);
               end
               else
                begin
                  if Length(DiskDrive) > 0
                    then writeln ('Directory Structure of Drive ',DiskDrive)
                    else writeln ('Directory Structure of Default Drive');
                end;

             { Add Date and Time Stamp }

             writeln;
             writeln ('Date: ',date,'    Time: ',time);
             writeln;

             { Report Desired Info for The Root Directory }

             if Infotype = 0
               then writeln ('Root Directory Occupies: ',
                              Parent^.Size:8:0,' Bytes.')
               else writeln ('Root Directory Contains ',
                              Parent^.Files:3,' Files.');
             writeln ;

             { If SubDirectories Exist, the Print Mode Headers }

             if MaxGen <= 0 then writeln ('No Sub Directories.');
             if MaxGen > 0 then
               begin
                 write ('Sub Directory Information:    ');
                 if InfoType = 0
                   then writeln ('Name and Size in Bytes')
                   else writeln ('Name and Number of Files');
                 writeln ;
                 for I:=1 to MaxGen do
                 write ('  Generation ',I:2,'      ');
                 writeln; writeln;
               end
           end

      { For all SubDirectories, report Size or Number of files }

      else begin
             if InfoType = 0
               then write (ListName,' ',Parent^.Size:8:0,'    ')
               else write (ListName,'    ',Parent^.Files:3,'      ')
           end;
  end;


{------------------------------------------------------------------------------
   Recursive routine to print the tree below the given root.  Structure is
   basically the same as BuildTree.
------------------------------------------------------------------------------}

Procedure PrintTree (Prtptr: TreePtr);

  begin
    Generation:=Generation + 1;           { Move Down A Level }
    repeat
      PrintName (Prtptr);                 { Print Info For Current Node }

      { If a Child Exisits, Go print info for it }

      if (Prtptr^.Child <> nil) then PrintTree (Prtptr^.Child);

      { No Children?  Go Print Info for Siblings }

      Prtptr:=Prtptr^.Sibling;

      { Go to A New Line; CReturn = true means go to a new line }
      { This Controls Extra Line Feeds for Moving up Multiple   }
      { Levels without printing info                            }

      if CReturn then
        begin
          CReturn:=false;
          writeln;
        end;
    until (Prtptr = nil);
    Generation:=Generation - 1;            { Move Up A Level }
   end;




{*********************************************

         Main Program

         *********************************************}


begin
  TreeInitialize;      { Initialize Tree Structures }
  BuildTree (Top);     { Build the Tree Describing the Directory Structure }
  PrintTree (Top)      { Print the Directory Structure }
end.

