{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Trinity version T2.0 by Axtell Kramer is a program that monitors
charitable donations to an organization. It accepts weekly entries on
contribution data in several categories, and maintains quarterly and
yearlong summary data, with printed reports for mailing. Written in Turbo
Pascal 4.0.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROGRAM  TRINITY;

(* Program developed and written by F. Axtell Kramer, Jr.

             Copyright (C) 1987, 1988 By F. Axtell Kramer, Jr.
                                      1432 Ruth Drive
                                      Kirkwood, MO  63122

             Written for Trinity Lutheran Church
                         820 Lockett Road
                         Kirkwood, Missouri  63122


   Permission is herein given to the Turbo User Group to freely distribute
   this program for non-commercial purposes as a public domain program.

   Requires MS/PC-DOS 2.1 or beyond and an IBM PC/XT/AT/Jr or compatible
   (is known to run on a Minolta PCW-1 WorkStation).   Compile with
   TURBO Pascal Version 4.0.    No TURBO "ToolBoxes" are needed.

   This program accepts weekly entries of contribution data in several
   categories by envelope number.  The program maintains quarterly and
   end of year summary data and prints reports for mailing.  A facility
   to edit previously entered data is provided.  The individual state-
   ments may also be viewed on screen in the same format as they will
   be printed.  All parts of the program are menu driven.

   Using the program is quite straightforward.  The user must first setup
   a record file to hold the information...one record for each envelope
   number.  This is done by choosing to Initialize a New File.  The user
   is prompted for an appropriate name.  The user then supplies the year
   and the file is set up.  This needs to be done only once a year, at the
   beginning.

   The user then enters the name/address/pledge data for families or
   individual members according to their assigned envelope number.  The
   envelopes are returned via the church offering plate.  Each week the
   offerings are entered in the proper categories for that week and
   quarter.  The names are entered at the beginning of the year with the
   Assign Envelope Numbers selection from the opening menu.  The weekly
   data updates are done via the Add Weekly Data menu selection.

   The maximum length of name and address data is 36 characters; to fit
   the statement form and the window envelope, it is recommended that the
   name and address data be kept to 30 characters, or less.   The addressee
   name and address are on the left to accommodate Trinity Church that uses
   window envelopes that have the window on the lower left.  If the more
   common sort of envelope with the window on the lower right is to be used
   then the positions of the quarterly subtotals and the name/address fields
   should be exchanged.  Other arrangements are also possible.

   The program automatically indexes to the next envelope number until all
   are accounted for during weekly data entry.

   Editing of names and money data is a function provided but the function
   is not sophisticated in its operation.  Selection of the Edit function
   is from the opening menu.  An Audit Trail module provides a most-recent-
   week's printout of the total contribution for each envelope number and
   a "total total" for all of the individual contributions that week, but
   any change made by the editor will not affect the Audit Trail.  When
   using the editor, any item selected for change is automatically erased.
   If it turns out that the wrong selection has been made, pressing the
   ENTER key alone will "unerase" the item.

   Display of the "quarterly statement" for an individual envelope number,
   and printing of a user choice of one or more, to all, of a selection of
   quarterly statements are activities called from the opening menu.  The
   program automatically skips the printing of any quarterly statement for
   which the total contribution for the year is zero.

   The statement forms automatically provide the Tax Year and the actual
   date of printing, and other data.  The name and address of the person
   to whom the statement is to be sent are printed in the lower left corner
   in the correct position for that style of "window envelope" so that no
   other mailing label is needed.  This is done automatically...the user
   need not be concerned with "report writing" at all.  The church name and
   address are printed on each statement as well.  Edit the include file
   "Prepare.inc" to put your church name, address, etc. in those fields.
   The program also provides a printed listing of the names, addresses,
   pledges, and envelope numbers to allow the user to cross check data
   entry for the beginning of the year.

   Trinity Lutheran Church had been subscribing to a commercial service that
   provided the same facilities that this program gives.  A week before
   Christmas (1987) the church learned that the commercial service was going
   out of business at the end of the year.  An immediate replacement for
   the service was needed...thus this entire program in its original version
   was developed and written in just nine days!  Because of the severe time
   restraint, this little program is not as elegant as it should be...what
   worked was what was used.  The editing function, especially, is
   unnecessarily crude but effective.

   This program is placed in the public domain for non-commercial and freely
   distributed use by churches and others, as is, or modified, but is NOT
   to be distributed or used commercially, or in connection with a fee.
   All commercial rights are reserved by the copyright holder.

   Last Revision:    June 28, 1988                                          *)



USES  Crt, Dos, Printer, Cursor, FlushKey, Sgllnbox, Dbllnbox, Date;


TYPE
  TextString      = STRING [36];    (* Global types for this program *)
  DOSString       = STRING [14];

VAR
  Choice          : CHAR;
  LoopIndex       : INTEGER;

(***************************************************************************)

PROCEDURE  ErrorMessageOne;

BEGIN
  ClrScr;
  DrawSingleLineBox (7,8,75,16);
  Write (#7);
  GoToXY (10,10);
    Write ('An ERROR has been reported ');
    Write ('by the Disk Operating System (DOS).');
  GoToXY (10,12);
    Write ('Your filename was unacceptable to DOS.  Perhaps a typing ');
    Write ('error');
  GoToXY (10,13);
    Write ('was made.  Please check and then enter an appropriate file ');
    Write ('name');
  GoToXY (10,14);
    Write ('when requested to do so.');
  Delay (13500)
END;

(***************************************************************************)

PROCEDURE  ErrorMessageTwo;

BEGIN
  ClrScr;
  DrawSingleLineBox (7,8,74,16);
  Write (#7);
  GoToXY (10,10);
    Write ('An ERROR has been reported ');
    Write ('by the Disk Operating System (DOS).');
  GoToXY (10,12);
    Write ('The file name you specified was not found.  Perhaps a typing');
  GoToXY (10,13);
    Write ('error was made.  Please check!  Then enter an appropriate file');
  GoToXY (10,14);
    Write ('name when requested to do so.');
  Delay (12000)
END;

(***************************************************************************)

PROCEDURE  ErrorMessageThree;

BEGIN
  ClrScr;
  DrawSingleLineBox (9,9,69,15);
  Write (#7);
  GoToXY (12,11);
    Write ('A number that you entered is out of bounds for possible');
  GoToXY (12,12);
    Write ('Envelope Numbers.  Perhaps you made a typing error.');
  GoToXY (12,13);
    Write ('Please check!  Then enter appropriate Envelope Numbers.');
  Delay (10000);
  ClrScr
END;

(***************************************************************************)

PROCEDURE  EntryErrorMessage;

BEGIN
  CursorOff;
  Write(#7);
  GoToXY(11,20);
    Write ('There is an INVALID character in your numerical data entry!');
  GOTOXY(27,21);
    WRITE ('Please REPEAT your entry.');
  DELAY (6000);
  GoToXY(1,20);
    ClrEOL;
  GoToXY(1,21);         (* Erase error message after viewing *)
    ClrEOL;
  CursorOn
END;

(***************************************************************************)

PROCEDURE  GetEntry (VAR EnteredItem : REAL; VAR ErrorPlace : INTEGER);

TYPE
  String14  = STRING[14];

VAR
  Entry     : String14;

BEGIN
  Readln (Entry);

(* If user presses the ENTER key alone, then automatically enter a value
   of zero (0.0) for that item.                                            *)

  IF (Entry <> '')
    THEN  Val (Entry, EnteredItem, ErrorPlace)
    ELSE
      BEGIN
        ErrorPlace := 0;
        EnteredItem := 0.0
      END;

(* The Val procedure reads the data item as a character string and converts
   it to numerical form if there is no error in the entry.  An error code of
   zero is returned if the entry converts to numerical form without error.
   This procedure acts as an error trap for typing errors of the form
   form  1l.O0  where a "pure" number was required. (l, the lower case
   letter L, and O, the upper case version of the letter o, are not numeric
   characters).                                                            *)

  IF (ErrorPlace <> 0)
    THEN EntryErrorMessage
END;

(***************************************************************************)

PROCEDURE  GetRealEntry (VAR EnteredItem : REAL;
                               VAR ErrorPlace : INTEGER;
                                     VAR NoChange : BOOLEAN);

TYPE
  String14  = STRING[14];
                                  (* Used by Editor for changing entries *)
VAR
  Entry     : String14;

BEGIN
  NoChange := FALSE;
  Readln (Entry);

(* If user presses the ENTER key alone, then this procedure sets a flag
   indicating that no change in the previous value for the item should
   be made and skips further processing of the entry.                  *)

  IF (Entry <> '')
    THEN  Val (Entry, EnteredItem, ErrorPlace)
    ELSE
      BEGIN
        NoChange := TRUE;
        ErrorPlace := 0
      END;

  IF (ErrorPlace <> 0)
    THEN EntryErrorMessage
END;

(***************************************************************************)

PROCEDURE  GetIntegerEntry (VAR EnteredItem, ErrorPlace : INTEGER);

TYPE
  String10  = STRING[10];

VAR
  Entry     : String10;

BEGIN
  Readln (Entry);
  Val (Entry, EnteredItem, ErrorPlace);

  IF (ErrorPlace <> 0)
    THEN EntryErrorMessage
END;

(***************************************************************************)

PROCEDURE  GetLongIntegerEntry (VAR EnteredItem : LONGINT;
                                       VAR ErrorPlace : INTEGER);

TYPE
  String14  = STRING[14];

VAR
  Entry     : String14;

BEGIN
  Readln (Entry);
  Val (Entry, EnteredItem, ErrorPlace);

  IF (ErrorPlace <> 0)
    THEN EntryErrorMessage
END;

(***************************************************************************)

{$I Initial.inc}
{$I Assign.inc}
{$I Addweek.inc}
{$I Edit.inc}
{$I Prepare.inc}
{$I Display.inc}
{$I Printit.inc}
{$I Audit.inc}
{$I Listing.inc}

(* These Include Files contain the individual modules that support the
   selections made on the main menu.  They must be included in this file
   in this order for proper compilation.                                   *)


BEGIN                                                      (* Main Program *)
  DirectVideo := TRUE;
  CheckSnow := TRUE;                             (* For CGA color displays *)
  CursorOff;
  ClrScr;
  GoToXY (24,22);
    Write ('Church Contributions Monitor Program');
  GoToXY (19,23);
    Write ('(C) Copyright 1988   By F. Axtell Kramer, Jr.');

  REPEAT
    CursorOn;
    DrawDoubleLineBox (9,1,74,20);                    (* Box the Main Menu *)
    GoToXY (9,1);
      For LoopIndex := 1 TO 66 DO Write (#219);        (* Heavy top border *)
    GoToXY (21,3);
      Write ('Please indicate your choice of activity:');
    GoToXY (13,6);
      Write ('Press 1 to Initialize a New File.');
    GoToXY (13,7);
      Write ('Press 2 to Assign Envelope Numbers.');
    GoToXY (13,8);
      Write ('Press 3 to Add Weekly Data.');
    GoToXY (13,9);
      Write ('Press 4 to Retrieve a Specific Envelope Number for Editing.');
    GoToXY (13,10);
      Write ('Press 5 to Display a Statement on Screen.');
    GoToXY (13,11);
      Write ('Press 6 to Print Quarterly Mailings.');
    GoToXY (13,12);
      Write ('Press 7 to Print an Audit File for the most recent week.');
    GoToXY (13,13);
      Write ('Press 8 to Print a Name/Address listing.');
    GoToXY (13,15);
      Write ('Press X to Exit the Program entirely.');
    GoToXY (30,18);
      Write ('Your Choice: ');

    REPEAT
      FlushKeyBuffer;
      Choice := ReadKey
    UNTIL Choice IN ['1', '2', '3', '4', '5', '6', '7', '8', 'X', 'x'];

      CASE Choice OF
        '1' : InitializeNewFile;
        '2' : AssignEnvelopeNumbers;
        '3' : AddWeeklyData;
        '4' : EditEnvelopeData;
        '5' : DisplayQuarterlyStatement;
        '6' : PrintQuarterlyStatements;
        '7' : PrintAuditFile;
        '8' : PrintNameAddressListing
     END

  UNTIL Choice IN  ['X', 'x'];

  CursorOn;
  ClrScr
END.                                             (* End of TRINITY program *)

(***************************************************************************)

