{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
PROCEDURE to draw a single line box around text on the screen.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
UNIT SglLnBox;                            (* File: SGLLNBOX.PAS *)

(* Adapted from Tom Swan, TURBO TECHNIX, Vol. 1, No. 1., 1987, Page 29.
   Last revision, with error correction:  January 20, 1988 *)

INTERFACE

  USES  Crt;

  PROCEDURE DrawSingleLineBox (Left, Top, Right, Bottom : INTEGER);

(* Call this procedure to draw a single line box around text on screen,
   using four global numeric variables, or four numeric constants,
   given in the procedure invocation, that locate the corners of the box. *)


IMPLEMENTATION

  PROCEDURE DrawSingleLineBox;   (* Inputs are the corner coordinates:
                                           Left, Top, Right and Bottom *)
    CONST
      TopLine            = #196;      (* IBM single line characters *)
      LeftLine           = #179;
      BottomLine         = #196;
      RightLine          = #179;
      TopLeftCorner      = #218;
      TopRightCorner     = #191;
      BottomLeftCorner   = #192;
      BottomRightCorner  = #217;

    VAR
      x, y : INTEGER;              (* x is horizontal index and y is vertical
                                     index for positioning line elements *)
    BEGIN
      GoToXY (Left, Top);            (* draw four corners, top and *)
        Write (TopLeftCorner);       (* bottom, then the sides *)
      GoToXY (Right, Top);
        Write (TopRightCorner);
      GoToXY (Left, Bottom);
        Write (BottomLeftCorner);
      GoToXY (Right, Bottom);
        Write (BottomRightCorner);

      GoToXY (Left + 1, Top);
        FOR x := (Left + 1) TO (Right - 1) DO Write (TopLine);
      GoToXY (Left + 1, Bottom);
        FOR x := (Left + 1) TO (Right - 1) DO Write (BottomLine);

      For y := (Top + 1) TO (Bottom - 1) DO
        BEGIN
          GoToXY (Left, y);
            Write (LeftLine);
          GoToXY (Right, y);
            Write (RightLine)
        END

    END;                        (* END of the box drawing PROCEDURE *)

END.          (* END of SglLnBox UNIT *)

