{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  PrintQuarterlyStatements;

(* This File: PRINTIT.INC      Allows the user to print a selection of
   quarterly statements for at the end of each quarter.  The name and
   address of the contributor are automatically printed on the statement
   along with the church name, address, year and date prepared.  The
   user need only specify the appropriate envelope numbers.

   For TURBO Pascal Version 4.0.       Last revision:  April 12, 1988      *)


TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions       : FILE of ContributionsRecord;
  Offerings           : ContributionsRecord;
  ErrorCheck          : BYTE;
  FileName            : DOSString;
  Number,
  Maximum,
  First,
  Last,
  Index               : LONGINT;
  Error               : INTEGER;
  Service             : CHAR;
  TotalYearToDate     : REAL;

BEGIN
  ClrScr;
  CursorOff;
  GoToXY (9,3);
    Write ('Print Quarterly Statement for a Specified Envelope Number:');
  GoToXY (15,5);
    Write ('Please give the name of the Contributions File');
  GoToXY (15,6);
    Write ('that you wish to open for Printing: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, Filename);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

  If ErrorCheck <> 0
    THEN
      BEGIN
        ErrorMessageTwo;
        PrintQuarterlyStatements
      END
    ELSE
      BEGIN
        ClrScr;
        Maximum := FileSize (Contributions);
        Close (Contributions);
        Service := 'P';                       (* Select Printer as Device: *)

        REPEAT
          GoToXY (13,5);
            Write ('Envelopes are numbered in sequence from 1 to ');
            Write ((Maximum - 1), '.....');
          GoToXY (13,7);
            Write ('Which Envelope Numbers are to be Printed? ');
          GoToXY (20,8);
            Write ('The First (lower) Number is: ');
          CursorOn;
          GetLongIntegerEntry (First, Error);

            WHILE (Error <> 0) DO
              BEGIN
                GoToXY (49,8);
                  ClrEOL;
                GoToXY (49,8);
                  GetLongIntegerEntry (First, Error)
              END;

          GoToXY (20,9);
            Write ('The Last (higher) Number is: ');
          GetLongIntegerEntry (Last, Error);

            WHILE (Error <> 0) DO
              BEGIN
                GoToXY (49,9);
                  ClrEOL;
                GoToXY (49,9);
                  GetLongIntegerEntry (Last, Error)
              END;

          CursorOff;

          IF ((First < 1) OR (Last > (Maximum - 1)) OR (Last < First))
            THEN ErrorMessageThree

        UNTIL ((First > 0) AND (Last < Maximum) AND (Last >= First));

        ClrScr;

        FOR Index := First To Last DO
          BEGIN
            GoToXY (27,10);
              Write ('Printing.  Please Wait .....');
            GoToXY (19,12);
               Write ('Printing Statement for Envelope Number: ');
               Write (Index);
               PrepareSelectedItem (TotalYearToDate, Index,
                                             Service, FileName)
          END;              (* END of FOR loop *)

        GoToXY (29,15);
          Write ('Printing Completed!');
        Delay (2500);
        ClrScr
      END;

  CursorOn
END;                              (* End of procedure to Print a Statement *)

(***************************************************************************)


