{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  PrepareSelectedItem (VAR TotalYearToDate : REAL;
                                             Number : LONGINT;
                                            Service : CHAR;
                                           FileName : DOSString);

(* Turbo User Group (TUG) version.  Prepares a quarterly statement for
   display on the screen or for printing, as selected by user.
   File name: PREPARE.INC

   The user should edit this file as indicated below to have it print
   the proper church name and address.     Last revision: June 28, 1988 *)


TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions          : FILE of ContributionsRecord;
  Offerings              : ContributionsRecord;
  Choice                 : CHAR;
  Total1stQtr,
  Total2ndQtr,
  Total3rdQtr,
  Total4thQtr,
  TotalLocalOperations,
  TotalBenevolence,
  TotalBuildingMaint,
  TotalFlowers,
  TotalSeasonal,
  TotalSpecial,
  TotalImprovement       : REAL;
  Year                   : LONGINT;
  Device                 : TEXT;

        (* Device is the Display Screen or Printer as selected by the user *)
BEGIN
  Assign (Contributions, Filename);

(* The validity of the filename will have already been checked by the
   calling procedure.  Thus IOCheck not needed here.                 *)

  Reset (Contributions);

  Seek (Contributions, 0);
  Read (Contributions, Offerings);
  Year := Offerings.EnvelopeNumber;

  Seek (Contributions, Number);
  Read (Contributions, Offerings);

  WITH Offerings DO
    BEGIN
      Total1stQtr := FstQtrLocalOperations + FstQtrBenevolence +
                     FstQtrBuildingMaint + FstQtrFlowers + FstQtrSeasonal +
                     FstQtrSpecial + FstQtrImprovement;

      Total2ndQtr := SndQtrLocalOperations + SndQtrBenevolence +
                     SndQtrBuildingMaint + SndQtrFlowers + SndQtrSeasonal +
                     SndQtrSpecial + SndQtrImprovement;

      Total3rdQtr := TrdQtrLocalOperations + TrdQtrBenevolence +
                     TrdQtrBuildingMaint + TrdQtrFlowers + TrdQtrSeasonal +
                     TrdQtrSpecial + TrdQtrImprovement;

      Total4thQtr := FthQtrLocalOperations + FthQtrBenevolence +
                     FthQtrBuildingMaint + FthQtrFlowers + FthQtrSeasonal +
                     FthQtrSpecial + FthQtrImprovement;

      TotalLocalOperations := FstQtrLocalOperations + SndQtrLocalOperations
                      + TrdQtrLocalOperations + FthQtrLocalOperations;

      TotalBenevolence := FstQtrBenevolence + SndQtrBenevolence +
                               TrdQtrBenevolence + FthQtrBenevolence;

      TotalBuildingMaint := FstQtrBuildingMaint + SndQtrBuildingMaint +
                              TrdQtrBuildingMaint + FthQtrBuildingMaint;

      TotalImprovement := FstQtrImprovement + SndQtrImprovement
                            + TrdQtrImprovement + FthQtrImprovement;

      TotalFlowers := FstQtrFlowers + SndQtrFlowers + TrdQtrFlowers
                                          + FthQtrFlowers;

      TotalSeasonal := FstQtrSeasonal + SndQtrSeasonal + TrdQtrSeasonal
                                          + FthQtrSeasonal;

      TotalSpecial := FstQtrSpecial + SndQtrSpecial + TrdQtrSpecial
                                          + FthQtrSpecial

    END;

  TotalYearToDate := Total1stQtr + Total2ndQtr + Total3rdQtr + Total4thQtr;

  CASE Service OF            (* Send quarterly statement to display screen *)
    'S' : BEGIN
            Assign (Device, 'CON');
            Rewrite (Device)
          END;

    'P' : IF (TotalYearToDate = 0.0)
            THEN                    (* Send quarterly statement to printer *)
              BEGIN
                Close (Contributions);
                GoToXY (10,12);
                  Write ('Total Contributions for the year for this');
                  Write (' Envelope Number are 0.');
                GoToXY (25,14);
                  Write ('Therefore, skipping Envelope Number ', Number);
                Delay (4000);
                GoToXY (1,12);
                  ClrEOL;
                GoToXY (1,14);
                  ClrEOL;
                Delay (600);
                Exit
              END                     (* Skip printing of this statement *)
            ELSE
              BEGIN
                Assign (Device, 'LPT1');
                Rewrite (Device)
              END
  END;

(* Fill out a form showing contributions for the separate quarters and for
   the year, the name, address, city/state/zip, and pledge for a specified
   envelope number, use the same format for display as used to print a
   quarterly statement for mailing.                                        *)

  WITH Offerings DO
    BEGIN
      Write (Device, '  OFFERING SUMMARY');
      Write (Device, '        Total Pledge:', TotalPledge : 10 : 2);
      Writeln (Device, '        Envelope Number:', EnvelopeNumber : 4);
      Writeln (Device);
      Write (Device, '                              Amount Given');
      Writeln (Device, '                 Amount Given');
      Write (Device, '  Local Operational Expenses:');
      Write (Device, TotalLocalOperations : 10 : 2);
      Write (Device, '           Flowers:');
      Writeln (Device, TotalFlowers : 10 : 2);
      Write (Device, '     Church-Wide Benevolence:');
      Write (Device, TotalBenevolence : 10 : 2);
      Write (Device, '          Seasonal:');
      Writeln (Device, TotalSeasonal : 10 : 2);
      Write (Device, '   Building Maintenance Fund:');
      Write (Device, TotalBuildingMaint : 10 : 2);
      Write (Device, '           Special:');
      Writeln (Device, TotalSpecial : 10 : 2);
      Write (Device, '            Improvement Fund:');
      Writeln (Device, TotalImprovement : 10 : 2);
      Writeln (Device);
      Write (Device, '  Your Church Name Here  ');
      Writeln (Device, '                    For Tax Year: ', Year);
      Write (Device, '  Address Here    ');
      Writeln (Device, '                          Date Prepared: ', TheDate);
      Writeln (Device, '  City/State/Zip     ');
      Write (Device, '                                  ');
      Write (Device, '          First Quarter: ');
      Writeln( Device, Total1stQtr : 10 : 2);
      Write (Device, '                                  ');
      Write (Device, '         Second Quarter: ');
      Writeln( Device, Total2ndQtr : 10 : 2);
      Write (Device, '                                  ');
      Write (Device, '          Third Quarter: ');
      Writeln( Device, Total3rdQtr : 10 : 2);
      Write (Device, '                                  ');
      Write (Device, '         Fourth Quarter: ');
      Writeln( Device, Total4thQtr : 10 : 2);
      Writeln (Device, '      ', Name);
      Writeln (Device, '      ', Address);
      Writeln (Device, '      ', CityStateZip);
      Write (Device, '                                ');
      Write (Device, '       Total For The Year: ');
      Writeln (Device, TotalYearToDate : 10 : 2);
      Write (Device, '                               ');
      Writeln (Device, '            Thank You!');
      Writeln (Device);
      Write (Device, '  -------------------------------------------------');
      Writeln (Device, '--------------------------')
    END;

  Close (Device);
  Close (Contributions)
END;                                  (* Prepared a form for selected item *)

(***************************************************************************)

