{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
PROCEDURE  InitializeNewFile;                        (* File:  INITIAL.INC *)

(* Establish a new file for year as specified by user.  To keep the envelope
   numbers and record numbers in correspondance, the zero record number is
   filled in before the user enters any data.  Doing this also provides the
   program with a place to store the year...as the envelope number for
   record number zero.   This procedure is to be run only once a year, at
   the beginning of the year to establish a new file for that year.
   Consecutive envelope numbers must be used with no numbers omitted or used
   twice.  For TURBO Pascal Version 4.0.    Last revision: April 12, 1988  *)

TYPE
  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  Contributions       : FILE of ContributionsRecord;
  Offerings           : ContributionsRecord;
  FileName            : DOSString;
  Year,
  ErrorCheck,
  Error               : INTEGER;

BEGIN
  ClrScr;
  CursorOff;
  GoToXY (22,5);
    Write ('Initialize a New File for the year:');
  GoToXY (8,8);
    Write ('Please give your new Contributions File ');
    Write ('a name.  The suggested');
  GoToXY (8,9);
    Write ('name is  contrb__  where the underscore would be the last two');
  GoToXY (8,10);
    Write ('digits of the year; for example  contrb85  for the year 1985.');
  GoToXY (3,12);
    Write ('Enter the name you wish to use (maximum of 8 characters): ');
  CursorOn;
  Readln (FileName);
  GoToXY (12,14);
    Write ('Next enter the year as a number, for example 1985: ');
  GetIntegerEntry (Year, Error);

    WHILE  Error <> 0  DO
      BEGIN
        GoToXY (63,14);
          ClrEOL;
        GoToXY (63,14);
        GetIntegerEntry (Year, Error)
      END;

  GoToXY (27,18);
  CursorOff;
    Write ('Please Wait....');

  Assign (Contributions, FileName);
  {$I-}
  Rewrite (Contributions);
  {$I+}
  ErrorCheck := IOResult;

  IF ErrorCheck <> 0
    THEN
      BEGIN
        ErrorMessageOne;
        InitializeNewFile           (* Redo from beginning if typing error *)
      END
    ELSE
      BEGIN
        WITH Offerings DO
          BEGIN
            EnvelopeNumber := Year;

               (* Year value will be stored in Record 0 as Envelope Number *)

            Name           := 'Church Contributions Monitor';
            Address        := 'Program (C) Copyright 1987, 1988';
            CityStateZip   := 'By F. Axtell Kramer, Jr.'
          END;

        Write (Contributions, Offerings);
        Close (Contributions);

        ClrScr;
        GoToXY (8,10);
          Write ('The new Contributions File, ');
          Write (FileName);
          Write (', for ', Year);
          Write (' has been established.');
        Delay (4000);
        ClrScr;
        CursorOn
      END
END;                                   (* End of initial file setup module *)

(***************************************************************************)

