{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
PROCEDURE to empty the typeahead keyboard buffer in memory before asking
for a specific keystroke resopnse.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

}
UNIT FlushKey;                             (* File: FLUSHKEY.PAS *)

(* A procedure to empty the typeahead keyboard buffer in memory before
   asking for a specific keystroke response.  Also useful in connection
   with ReadKey function when asking for a "continue" signal and do not
   want to have user hold down a key long enough to put multiple
   keystrokes into the buffer accidently.

   Based on a procedure developed by Jeff Duntemann in the book Turbo
   Pascal Solutions, page 43.         Last revision:  February 24, 1988 *)


INTERFACE

  USES Dos;

  PROCEDURE  FlushKeyBuffer;


IMPLEMENTATION

  PROCEDURE  FlushKeyBuffer;

    VAR
      RegisterGroup : Registers;     (* Registers is defined in DOS UNIT *)

    BEGIN
      RegisterGroup.AH := $01;          (* Check for keystroke in buffer *)
      INTR ($16, RegisterGroup);

      IF (RegisterGroup.Flags AND $0040) = 0   (* If buffer is not empty *)
        THEN
          REPEAT
            RegisterGroup.AH := $00; (* Read keystroke and throw it away *)
            INTR ($16, RegisterGroup);
            RegisterGroup.AH := $01;        (* Check for more keystrokes *)
            INTR ($16, RegisterGroup);
          UNTIL (RegisterGroup.Flags AND $0040) <> 0      (* Until empty *)

    END;

END.               (* END of FlushKey UNIT *)

