{                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Include source code for Trinity.

* ASSOCIATED FILES
TRINITY.PAS
ADDWEEK.INC
ASSIGN.INC
AUDIT.INC
CURSOR.PAS
DATE.PAS
DBLLNBOX.PAS
DISPLAY.INC
EDIT.INC
FLUSHKEY.PAS
INITIAL.INC
LISTING.INC
PREPARE.INC
PRINTIT.INC
SGLLNBOX.PAS
TRINITY.DOC
TRINITY.EXE

TURBO PASCAL V4.0 UPDATE
==========================================================================
}
PROCEDURE  AddWeeklyData;                       (* This File:  ADDWEEK.INC *)

(* This procedure allows the user to enter contribution data for a given
   week, for a specified quarter, for each assigned envelope number.  A
   second record file is used to keep track of the total amount con-
   tributed for each envelope number to prepare an audit trail for
   printing at the end of the data entry session.  The audit trail is
   kept in disk file AUDITFIL.  The data entry procedure called by this
   procedure automatically sets equal to zero any entry "skipped" by the
   user.   Thus, to have any category equal zero, then, the user need
   only to press the ENTER (RETURN) key alone.

   Use TURBO Pascal Version 4.0.      Last revision:   April 12, 1988      *)


TYPE
  AuditRecord         = RECORD
                          EnvelopeNumber            : LONGINT;
                          WeekTotalForEnvelope      : REAL
                        END;

  ContributionsRecord = RECORD
                          EnvelopeNumber            : LONGINT;
                          Name,
                          Address,
                          CityStateZip              : TextString;
                          TotalPledge,
                          FstQtrLocalOperations,
                          FstQtrBenevolence,
                          FstQtrBuildingMaint,
                          FstQtrFlowers,
                          FstQtrSeasonal,
                          FstQtrSpecial,
                          FstQtrImprovement,
                          SndQtrLocalOperations,
                          SndQtrBenevolence,
                          SndQtrBuildingMaint,
                          SndQtrFlowers,
                          SndQtrSeasonal,
                          SndQtrSpecial,
                          SndQtrImprovement,
                          TrdQtrLocalOperations,
                          TrdQtrBenevolence,
                          TrdQtrBuildingMaint,
                          TrdQtrFlowers,
                          TrdQtrSeasonal,
                          TrdQtrSpecial,
                          TrdQtrImprovement,
                          FthQtrLocalOperations,
                          FthQtrBenevolence,
                          FthQtrBuildingMaint,
                          FthQtrFlowers,
                          FthQtrSeasonal,
                          FthQtrSpecial,
                          FthQtrImprovement         : REAL
                        END;

VAR
  AuditFile               : FILE of AuditRecord;
  Contributions           : FILE of ContributionsRecord;
  AuditInfo               : AuditRecord;
  Offerings               : ContributionsRecord;
  FileName                : DOSString;
  ErrorCheck,
  QtrChoice               : BYTE;
  Quarter                 : CHAR;
  TotalEnvelopes          : LONGINT;

(*-------------------------------------------------------------------------*)

PROCEDURE  DisplayEntryMessage (Index : LONGINT);

BEGIN
  GoToXY (15,2);
    Write ('Enter a Number and press Return for each item.');
  GoToXY (10,3);
    Write ('If there is no entry for an item, press Return alone.');
  GoToXY (15,5);
    Write ('For Envelope Number ', Index, ':')
END;

(*-------------------------------------------------------------------------*)

PROCEDURE  InputWeeklyData (VAR  LocalOperations,
                                 Benevolence,
                                 BuildingMaint,
                                 Flowers,
                                 Seasonal,
                                 Special,
                                 Improvements       : REAL);

VAR
  Response : CHAR;
  Error    : INTEGER;

BEGIN
  REPEAT
    GoToXY (1,8);
      Writeln ('           Local Operations: ');
      Writeln ('    Church-Wide Benevolence: ');
      Writeln ('  Building Maintenance Fund: ');
      Writeln ('                    Flowers: ');
      Writeln ('                   Seasonal: ');
      Writeln ('                    Special: ');
      Writeln ('           Improvement Fund: ');

      CursorOn;
      GoToXY (30,8);
        GetEntry (LocalOperations, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,8);
              ClrEOL;
            GoToXY (30,8);
              GetEntry (LocalOperations, Error)
          END;

      GoToXY (30,9);
        GetEntry (Benevolence, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,9);
              ClrEOL;
            GoToXY (30,9);
              GetEntry (Benevolence, Error)
          END;

      GoToXY (30,10);
        GetEntry (BuildingMaint, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,10);
              ClrEOL;
            GoToXY (30,10);
              GetEntry (BuildingMaint, Error)
          END;

      GoToXY (30,11);
        GetEntry (Flowers, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,11);
              ClrEOL;
            GoToXY (30,11);
              GetEntry (Flowers, Error)
          END;

      GoToXY (30,12);
        GetEntry (Seasonal, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,12);
              ClrEOL;
            GoToXY (30,12);
              GetEntry (Seasonal, Error)
          END;

      GoToXY (30,13);
        GetEntry (Special, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,13);
              ClrEOL;
            GoToXY (30,13);
              GetEntry (Special, Error)
          END;

      GoToXY (30,14);
        GetEntry (Improvements, Error);

        WHILE (Error <> 0) DO
          BEGIN
            GoToXY (30,14);
              ClrEOL;
            GoToXY (30,14);
              GetEntry (Improvements, Error)
          END;

      CursorOff;
      GoToXY (20,18);
        Write ('Check!  Are the data above all OK?');
      GoToXY (20,19);
        Write ('Answer YES or NO.  (Press Y or N): ');
      CursorOn;

        REPEAT
          FlushKeyBuffer;
          Response := ReadKey
        UNTIL Response IN ['N', 'n', 'Y', 'y'];

        IF ((Response = 'n') OR (Response = 'N'))
          THEN
            BEGIN

   (* Clear fields for data re-entry if data entered initially have errors *)

              Window (30,8,60,14);
              GoToXY (1,1);
                ClrScr;
              Window (1,1,80,25);
              GoToXY (1,18);
                ClrEOL;
              GoToXY (1,19);
                ClrEOL
            END

  UNTIL Response IN ['Y', 'y']

END;

(*-------------------------------------------------------------------------*)

PROCEDURE  UpDateQuarter (TotalEnvelopes : INTEGER; QtrChoice : BYTE);

VAR
  Index                   : LONGINT;
  Response                : CHAR;
  CurrentLocalOperations,
  CurrentBenevolence,
  CurrentBuildingMaint,
  CurrentFlowers,
  CurrentSeasonal,
  CurrentSpecial,
  CurrentImprovements,
  WeekSummary,
  WeekTotalForEnvelope    : REAL;

BEGIN
  FOR Index := 1 TO TotalEnvelopes DO
    BEGIN
      ClrScr;
      CursorOff;
      Delay (300);
      GoToXY (15,3);
        Write ('Are there entries for Envelope Number ', Index, ': (Y/N)?');
      CursorOn;

      REPEAT
        FlushKeyBuffer;
        Response := ReadKey
      UNTIL Response IN ['N', 'n', 'Y', 'y'];

      CursorOff;

      IF ((Response = 'Y') OR (Response = 'y'))      (* Yes, data to enter *)
        THEN
          BEGIN
            DisplayEntryMessage (Index);
            InputWeeklyData (CurrentLocalOperations,
                             CurrentBenevolence,
                             CurrentBuildingMaint,
                             CurrentFlowers,
                             CurrentSeasonal,
                             CurrentSpecial,
                             CurrentImprovements);

            CursorOff;
            Seek (Contributions, Index);
            Read (Contributions, Offerings);

            WITH Offerings DO   (* Update quarter totals for each category *)
              BEGIN

                CASE QtrChoice OF
                  1 : BEGIN
                        FstQtrLocalOperations := FstQtrLocalOperations
                                         + CurrentLocalOperations;
                        FstQtrBenevolence := FstQtrBenevolence
                                         + CurrentBenevolence;
                        FstQtrBuildingMaint := FstQtrBuildingMaint
                                         + CurrentBuildingMaint;
                        FstQtrFlowers := FstQtrFlowers + CurrentFlowers;
                        FstQtrSeasonal := FstQtrSeasonal + CurrentSeasonal;
                        FstQtrSpecial := FstQtrSpecial + CurrentSpecial;
                        FstQtrImprovement := FstQtrImprovement
                                       + CurrentImprovements
                      END;

                  2 : BEGIN
                        SndQtrLocalOperations := SndQtrLocalOperations
                                         + CurrentLocalOperations;
                        SndQtrBenevolence := SndQtrBenevolence
                                         + CurrentBenevolence;
                        SndQtrBuildingMaint := SndQtrBuildingMaint
                                         + CurrentBuildingMaint;
                        SndQtrFlowers := SndQtrFlowers + CurrentFlowers;
                        SndQtrSeasonal := SndQtrSeasonal + CurrentSeasonal;
                        SndQtrSpecial := SndQtrSpecial + CurrentSpecial;
                        SndQtrImprovement := SndQtrImprovement
                                       + CurrentImprovements
                      END;

                  3 : BEGIN
                        TrdQtrLocalOperations := TrdQtrLocalOperations
                                         + CurrentLocalOperations;
                        TrdQtrBenevolence := TrdQtrBenevolence
                                         + CurrentBenevolence;
                        TrdQtrBuildingMaint := TrdQtrBuildingMaint
                                         + CurrentBuildingMaint;
                        TrdQtrFlowers := TrdQtrFlowers + CurrentFlowers;
                        TrdQtrSeasonal := TrdQtrSeasonal + CurrentSeasonal;
                        TrdQtrSpecial := TrdQtrSpecial + CurrentSpecial;
                        TrdQtrImprovement := TrdQtrImprovement
                                       + CurrentImprovements
                      END;

                  4 : BEGIN
                        FthQtrLocalOperations := FthQtrLocalOperations
                                         + CurrentLocalOperations;
                        FthQtrBenevolence := FthQtrBenevolence
                                         + CurrentBenevolence;
                        FthQtrBuildingMaint := FthQtrBuildingMaint
                                         + CurrentBuildingMaint;
                        FthQtrFlowers := FthQtrFlowers + CurrentFlowers;
                        FthQtrSeasonal := FthQtrSeasonal + CurrentSeasonal;
                        FthQtrSpecial := FthQtrSpecial + CurrentSpecial;
                        FthQtrImprovement := FthQtrImprovement
                                       + CurrentImprovements
                      END
                END                    (* END of CASE *)
              END;                 (* End of WITH Offerings *)

            Seek (Contributions, Index);
            Write (Contributions, Offerings);

            WeekSummary := CurrentLocalOperations + CurrentBenevolence +
                           CurrentBuildingMaint + CurrentFlowers +
                           CurrentSeasonal + CurrentSpecial +
                           CurrentImprovements;

            WITH AuditInfo DO
              BEGIN
                EnvelopeNumber := Index;
                WeekTotalForEnvelope := WeekSummary
              END;

(* Keep week's total for each envelope in a separate disk file for later
   printing of an audit trail.                                             *)

            Seek (AuditFile, (Index - 1));
            Write (AuditFile, AuditInfo)

          END                     (* End IF data to be entered *)

        ELSE
          BEGIN
            WITH AuditInfo DO
              BEGIN
                EnvelopeNumber := Index;
                WeekTotalForEnvelope := 0.0
              END;

            Seek (AuditFile, (Index - 1));
            Write (AuditFile, AuditInfo)
          END                             (* End ELSE no data to enter *)

    END                              (* End of FOR Loop *)
END;                              (* End of Update Quarter *)

(*-------------------------------------------------------------------------*)

BEGIN                                        (* Main Body of AddWeeklyData *)
  ClrScr;
  CursorOff;

  Assign (AuditFile, 'AUDITFIL');
  Rewrite (AuditFile);

  GoToXY (24,2);
    Write ('Enter Weekly Contribution Data');
  GoToXY (27,3);
    Write ('for each Envelope Number:');
  GoToXY (15,5);
    Write ('Please give the name of the Contributions File');
  GoToXY (10,6);
    Write ('that you wish to open for Adding of Weekly Data: ');
  CursorOn;
  Readln (FileName);
  CursorOff;

  Assign (Contributions, FileName);
  {$I-}
  Reset (Contributions);
  {$I+}
  ErrorCheck := IOResult;

    IF ErrorCheck <> 0
      THEN
        BEGIN
          ErrorMessageTwo;

(* Repeat from the beginning if file name is not found due to typing error *)

          AddWeeklyData
        END
      ELSE
        BEGIN
          ClrScr;
          TotalEnvelopes := (FileSize (Contributions) - 1);
          DrawSingleLineBox (12,7,63,13);
          GoToXY (15,9);
            Write ('You wish to add weekly data for which quarter?');
          GoToXY (15,11);
            Write ('Please answer  1, 2, 3, or 4: ');
          CursorOn;

          REPEAT
            FlushKeyBuffer;
            Quarter := ReadKey
          UNTIL Quarter IN ['1', '2', '3', '4'];

          CursorOff;

          CASE Quarter OF
            '1' : BEGIN
                    QtrChoice := 1;
                    UpDateQuarter (TotalEnvelopes, QtrChoice)
                  END;

            '2' : BEGIN
                    QtrChoice := 2;
                    UpDateQuarter (TotalEnvelopes, QtrChoice)
                  END;

            '3' : BEGIN
                    QtrChoice := 3;
                    UpDateQuarter (TotalEnvelopes, QtrChoice)
                  END;

            '4' : BEGIN
                    QtrChoice := 4;
                    UpDateQuarter (TotalEnvelopes, QtrChoice)
                  END
          END;

          Close (AuditFile);
          Close (Contributions)
        END;                                        (* End of IF/THEN/ELSE *)

  ClrScr;
  CursorOn
END;                                               (* End of AddWeeklyData *)

(***************************************************************************)

