uses crt, supergen;

Procedure How_to_input_real_number;  (* same applies to Byte,Integer,Longint...etc *)
var term_key:word;
    value:real;
    result:integer;
    dummy:string[13];
  begin
   value := 0.29;                 (* initialize numeric variable value *)
   str(value:13:2,dummy);         (* convert it into a dummy string*)
   inspect(dummy);                (* Take out leading Blanks. Require *)
   repeat
     term_key := getfield(5,5,Underline,13,reals,Noformat,dummy);
                                   (* Use dummy string variable in Getfield *)
   until (Term_key = CR) or (Term_key = ESC);  (*Loop until user hit CR or ESC*)
   val(dummy,value,result);        (* Convert dummy string back to value*)
  end;
Procedure How_to_input_date;
  var key_hit:word;
      TXDate:string[8];
  Begin
   TXdate := space(8);         (*Initalize string date same as DBase II*)
   repeat
    key_hit := getfield(5,5,Reverse,8,DATE,Noformat,TXdate);  (*put in getfield*)
   until (key_hit = CR);
  end;

Procedure How_to_input_string;
  Var
    key:word;some_string:string[30];
  Begin
    some_string := space(30);   (*Initialize string to a blank space*);
    repeat
      key := getfield(5,5,Underline + Intensity,30,STRINGS,Noformat,some_string);
    until (key = CR);
  end;
Procedure How_to_input_time;
  Var
     Hit_key:word;txtime:string[5];
  Begin
    txtime := space(5);
    repeat
      Hit_key := getfield(5,5,FG_BLACK + BG_MAGENTA,5,Time,Noformat,txtime);
    until (Hit_key = CR);
  end;
Procedure write_screen_normally;
  Begin
   gotoxy(1,5);write('Social_scc_No:');
   gotoxy(1,7);write('Student Name:');      {normal gotoxy screen write}
   gotoxy(48,7);write('Date_apply:');
   gotoxy(1,9);write('Payment:');
   gotoxy(24,10);write ('Press F10 to Confirm or ESC to Cancel');
  End;

Procedure How_to_input_many_fields;      {This procedure is written by hand}
  Var                                    {not by code generator}
     student :record
              Social_id:string[12];
              Name:string[30];
              Date_apply:string[8];
              Payment:real;
              end;
     fieldno:integer;               {use for checking which field are in use}
     result:integer;
     key:word;      dummy:string[7];
  Begin
    write_screen_normally;
    fillchar(student,sizeof(student),0); {Initialize record to blank}
    dummy := space(7);    {Initialize dummy variable (use for numeric) }
    fieldno := 1;                        {start input at field No. 1}
  Repeat
    case fieldno of                      {check to see which field No start}
    1:key := getfield(15,5,reverse,9,strings,'999-999-9999', Student.social_id);
    2:key := getfield(14,7,reverse,30,strings,Noformat, Student.name);
    3:key := getfield(59,7,reverse,8,Date,Noformat,Student.Date_apply);
    4:Begin
      inspect(dummy);                    {trim leading space from dummy}
      key := getfield(9,9,reverse,7,reals,Noformat,dummy); {pass dummy to getfield}
      val(dummy,Student.payment,result); {convert dummy after read to payment}
      end;
    end;{ First Case}                  {end of field numbering case}
       Case key of              { select your own field to field movement }
       DOWNKEY,CR:Begin inc(fieldno);if fieldno > 4 then fieldno := 1;end;
            UPKEY:Begin dec(fieldno);if fieldno < 1 then fieldno := 4;end;
       end;{Second Case}
   Until (key = F10) or (key = ESC);     {repeat read until user hit F10 or ESC}
  end;

Procedure How_to_input_many_fields_with_prompt;
                         {This procedure is written by hand}
  Var                                    {not by code generator}
     student :record
              Social_id:string[12];
              Name:string[30];
              Date_apply:string[8];
              Payment:real;
              end;
     fieldno:integer;               {use for checking which field are in use}
     result:integer;
     key:word;      dummy:string[7];
  Begin
    write_screen_normally;
    fillchar(student,sizeof(student),0); {Initialize record to blank}
    dummy := space(7);    {Initialize dummy variable (use for numeric) }
    fieldno := 1;                        {start input at field No. 1}
  Repeat
    case fieldno of                      {check to see which field No start}
    1:Begin
      gotoxy(1,24);clreol;
      gotoxy(1,24);write('Enter student social security number');
      Key := getfield(15,5,reverse,9,strings,'999-999-9999', Student.social_id);
      end;
    2:Begin
      gotoxy(1,24);clreol;
      gotoxy(1,24);write('Enter Applicant Name');
      key := getfield(14,7,reverse,30,strings,Noformat, Student.name);
      end;
    3:Begin
      gotoxy(1,24);clreol;
      gotoxy(1,24);write('Enter Student Applicantion date');
      key := getfield(59,7,reverse,8,Date,Noformat,Student.Date_apply);
      end;
    4:Begin
      repeat
      inspect(dummy);                    {trim leading space from dummy}
      key := getfield(9,9,reverse,7,reals,Noformat,dummy); {pass dummy to getfield}
      val(dummy,Student.payment,result); {convert dummy after read to payment}
         if student.payment = 0 then
                        begin
                        gotoxy(1,24);sound(2000);delay(10);nosound;
                        write('Every student must pay something at enroll time');
                        end;
      until student.payment <> 0;      {every student must pay money or continue loop}
      end;
    end;{ First Case}                  {end of field numbering case}

       Case key of              { select your own field to field movement }
       DOWNKEY,CR:Begin inc(fieldno);if fieldno > 4 then fieldno := 1;end;
            UPKEY:Begin dec(fieldno);if fieldno < 1 then fieldno := 4;end;
       end;{Second Case}
   Until (key = F10) or (key = ESC);     {repeat read until user hit F10 or ESC}
  end;

Procedure How_to_edit_many_fields;
                         {This procedure is written by hand}
  Var                                    {not by code generator}
     student :record
              Social_id:string[12];
              Name:string[30];
              Date_apply:string[8];
              Payment:real;
              end;
     fieldno:integer;               {use for checking which field are in use}
     result:integer;
     key:word;      dummy:string[7];
  Begin
  student.social_id := '121-312-3212';   {suppose a value already exist for edit}
  student.name := 'Jeff Dunteman';
  student.date_apply := '03/12/88';
  student.payment := 3000.00;
  write_screen_normally;
    fieldno := 1;                        {start input at field No. 1}
  Repeat
    case fieldno of                      {check to see which field No start}
    1:Key := getfield(15,5,reverse,9,strings,'999-999-9999', Student.social_id);
    2:key := getfield(14,7,reverse,30,strings,Noformat, Student.name);
    3:key := getfield(59,7,reverse,8,Date,Noformat,Student.Date_apply);
    4:Begin
      str(student.payment:7:2,dummy);     {this is require when edit }
                              {convert payment value to dummy for editing}
      inspect(dummy);                    {trim leading space from dummy}
      key := getfield(9,9,reverse,7,reals,Noformat,dummy); {pass dummy to getfield}
      val(dummy,Student.payment,result); {convert dummy after read to payment}
      end;
    end;{ First Case}                  {end of field numbering case}

       Case key of              { select your own field to field movement }
       DOWNKEY,CR:Begin inc(fieldno);if fieldno > 4 then fieldno := 1;end;
            UPKEY:Begin dec(fieldno);if fieldno < 1 then fieldno := 4;end;
       end;{Second Case}
   Until (key = F10) or (key = ESC);     {repeat read until user hit F10 or ESC}
  end;

Procedure Fasthlp_scn;external;      {external procedure for fast help}
{$L fasthlp.obj}

Procedure How_to_input_many_fields_with_variety_of_editing_control;
                             {This procedure is written by hand}
                             {not by code generator}
 const
   TAB = 9;
   Lmenu2:array[1..8] of Linemenulist =
    ( (x:9; Y:11; Command:' No Money Now...will pay later ';        Ch: 'N'),
      (x:9; Y:12;  Command:' Top Football player (Excempt) ';        Ch: 'T'),
      (x:9; Y:13; Command:' Father in Congress........... ';        Ch: 'F'),
      (x:9; Y:14; Command:' MAFIA Relative kids (No pay)  ';        Ch: 'M'),
      (x:9; Y:15; Command:' Charge credit Card. MC/VC/KGB ';        Ch: 'C'),
      (x:9; Y:16; Command:' Pay by personnel check        ';        Ch: 'P'),
      (x:9; Y:17; Command:' Imposter CIA student (a spy)  ';        Ch: 'I'),
      (x:9; Y:18; Command:' Quit to Dos (IRS high boss)   ';        Ch: 'Q')  );
      Select:word = 1;
  Var
     student :record
              Social_id:string[12];
              Name:string[30];
              Date_apply:string[8];
              Payment:real;
              end;
     fieldno:integer;               {use for checking which field are in use}
     result:integer;
     dum,key,ans:word;      dummy:string[7];
  Begin
  student.social_id := '121-312-3212';   {suppose a value already exist for edit}
  student.name := 'Jeff Dunteman';
  student.date_apply := '03/12/88';
  student.payment := 3000.00;
  write_screen_normally;
  gotoxy(1,20);write('Try using TAB or F1 on each data entry field');
    fieldno := 1;                        {start input at field No. 1}
  Repeat
    case fieldno of                      {check to see which field No start}
    1:Key := getfield(15,5,reverse,9,strings,'999-999-9999', Student.social_id);
    2:key := getfield(14,7,reverse,30,strings,Noformat, Student.name);
    3:key := getfield(59,7,reverse,8,Date,Noformat,Student.Date_apply);
    4:Begin
      str(student.payment:7:2,dummy);     {this is require when edit }
                                  {convert payment value to dummy for editing}
      inspect(dummy);
      key := getfield(9,9,reverse,7,reals,noformat,dummy); {pass dummy to getfield}
      val(dummy,Student.payment,result); {convert dummy after read to payment}
      end;
    end;{ First Case}                  {end of field numbering case}

       Case key of              { select your own field to field movement }
       TAB,CR,
       DOWNKEY:Begin inc(fieldno);if fieldno > 4 then fieldno := 1;end;
       UPKEY:Begin dec(fieldno);if fieldno < 1 then fieldno := 4;end;
       F1:Begin       {if F4 is hit then do field checking}
          case fieldno of
          1:Begin
            savepic(1,1,80,25,3); {keep screen in memory page 3}
            showtxtln('help1.txt',FG_BLACK + BG_Magenta,13);  {call up only 12 lines of text}
            dum := getkey;
            loadpic(1,1,80,25,3);  {bring back screen from memory}
            end; {1}
          2:Begin
            savepic(1,1,80,25,3); {keep screen in memory page 3}
            writeln;
            writeln('-------------------------');
            writeln('| With SuperGen every   |');
            writeln('| data entry field is   |'); {display help screen}
            writeln('| fully controllable by |');
            writeln('| your own creativity   |');
            writeln('-------------------------');
            dum := getkey;
            loadpic(1,1,80,25,3);  {bring back screen from memory}
            end; {2}
          3:Begin
            savepic(1,1,80,25,3); {keep screen in memory page 3}
            showscreen(@fasthlp_scn);      {pop-up fast help screen}
            dum := getkey;
            loadpic(1,1,80,25,3);  {bring back screen from memory}
            end; {3}
          4:Begin
            savepic(1,1,80,25,3); {keep screen in memory page 3}
             select := 1;
             repeat
             ans := linemenu(8,select,lmenu2);
             select := ans;
             until (ans = ESC) or (ans = 8) or (ans = 13);
            loadpic(1,1,80,25,3);
            end; {4}
           end;{end case inside F1}
          end;        {case key of F1}
       end;{Second Case}
   Until (key = F10) or (key = ESC);     {repeat read until user hit F10 or ESC}
  end;
Begin
clrscr;
write('Input real number');
How_to_input_real_number;
clrscr;
write('Input date');
How_to_input_date;
clrscr;
write('Input time');
How_to_input_time;
clrscr;
write('Input string');
How_to_input_string;
clrscr;
write('Input multiple fields');
How_to_input_many_fields;
clrscr;
write('Edit multiple fields');
How_to_edit_many_fields;
clrscr;
write('Input multiple fields with prompt line');
How_to_input_many_fields_with_prompt;
clrscr;
write('Input multiple fields with variety of field by field controls');
How_to_input_many_fields_with_variety_of_editing_control;
end.