                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Generalized windowing support routines, including drawing of boxes around
designated window areas.  Author unknown.  Version T1.0.  Turbo Pascal 4.0.

* ASSOCIATED FILES
WINDMO.PAS
WINDOWS.PAS

* KEYWORDS
TURBO PASCAL 4.0 PROGRAM WINDOW ROUTINE DEMO

==========================================================================
}

unit windows;

interface

uses crt;

procedure initwin;
{  records initial window dimension  }

procedure boxwin(x1,y1,x2,y2:integer);
{  Draws a box, fills it with blanks, and makes it the current window.   }
{  Dimensions given are for the box;  actual window is one unit smaller  }
{  in each direction.  This routine can be used separately from the      }
{  rest of the unit. {!removable window package.                         }

procedure mkwin(x1,y1,x2,y2:integer);
{  create a removable window  }

procedure rmwin;
{  Remove the most recently created removable window.  Restore the screen    }
{  contents, window dimensions, and position of the cursor.                  }

implementation

const
     maxwin = 5;

type
    imagetype = array[1..4096] of char;
    windimtype = record
                 x1,y1,x2,y2: integer
                 end;

var
   win          :            {global variable package}
        record
              dim: windimtype; {current window dimensions}
              depth: integer;
              stack: array[1..maxwin] of
                     record
                           image : imagetype;   {saved screen image}
                           dim   : windimtype;  {saved window dimensions}
                           x,y   : integer      {saved cursor position}
                     end
        end;
    crtmode     :     byte       absolute $0040:$0049;
    crtwidth    :     byte       absolute $0040:$004A;
    monobuffer  :     imagetype  absolute $B000:$0000;
    colorbuffer :     imagetype  absolute $B800:$0000;

procedure initwin;

begin
     with win.dim do
          begin x1:=1; y1:=1; x2:=crtwidth; y2:=25 end;
          win.depth:=0
end;

procedure boxwin(x1,y1,x2,y2:integer);

var
   x,y : integer;

begin
     window(1,1,80,25);

     {top}
     gotoxy(x1,y1);
     write(chr(213));
     for x:=x1+1 to x2-1 do write(chr(205));
     write(chr(184));

    {sides}
    for y:=y1+1 to y2-1 do
        begin
             gotoxy(x1,y);
             write(chr(179),' ':x2-x1-1, chr(179))
        end;

    {bottom}
    gotoxy(x1,y2);
    write(chr(212));
    for x:=x1+1 to x2-1 do write(chr(205));
    write(chr(190));

    {make it the current window}
    window(x1+1,y1+1,x2-1,y2-1);       { y2-2 corrected to y2-1 - DSMB }
    gotoxy(1,1)

end;

procedure mkwin(x1,y1,x2,y2:integer);

begin
{increment stack pointer}
    with win do depth:=depth+1;
    if win.depth > maxwin then
    begin
         writeln(^G'windows nested too deep');
         halt
    end;

  {save contents of the screen}
  if crtmode = 7 then
    win.stack[win.depth].image := monobuffer
  else
    win.stack[win.depth].image := colorbuffer;

  win.stack[win.depth].dim  :=  win.dim;
  win.stack[win.depth].x    :=  wherex;
  win.stack[win.depth].y    :=  wherey;

  {create the window}
  boxwin(x1,y1,x2,y2);
  win.dim.x1          := x1+1;
  win.dim.y1          := y1+1;    {allow for margins}
  win.dim.x2          := x2-1;
  win.dim.y2          := y2-1;

end;

procedure rmwin;

begin
     if crtmode = 7 then
        monobuffer  := win.stack[win.depth].image
     else
        colorbuffer := win.stack[win.depth].image;

   with win do
        begin
             dim := stack[depth].dim;
             window(dim.x1,dim.y1,dim.x2,dim.y2);
             gotoxy(stack[depth].x,stack[depth].y);
             depth := depth - 1
        end
end;

end.
