                       F i l e    I n f o r m a t i o n

* DESCRIPTION
I/O support routines for TPARCV.PAS.  Author: Michael Quinlan.  Version
1.01.  Turbo Pascal 4.0.

* ASSOCIATED FILES
TPARCV.PAS
TPARC.DOC
TPARCCIO.INC
TPARCDAT.INC
TPARCGFN.INC
TPARCINI.INC
TPARCIO.INC
TPARCLST.INC
TPARCSVC.INC


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM ARC COMPRESS FILE LIBRARY UTILITY

==========================================================================
}

{======================================================================}
{                                                                      }
{  Turbo Pascal ARC Utility                                            }
{                                                                      }
{  A group project by the Borland SIG.                                 }
{                                                                      }
{======================================================================}

{======================================================================}
{                                                                      }
{  TPARCIO  - Archive file I/O routines.                               }
{  From ARCIO.C; writehdr and filecopy routines not yet implemented.   }
{                                                                      }
{  Initial version 9/28/85 by Michael Quinlan                          }
{                                                                      }
{======================================================================}

function readhdr(var hdr : heads; var f : cfile) : boolean;
{ FALSE = eof found; TRUE = header found }
  var name : fntype;
      try  : integer;
  begin
    try := 10;

    if feof(f) then begin
      readhdr := FALSE;
      exit
    end;

    while fgetb(f) <> arcmarc do begin
      if try = 0 then abort(arcname + ' is not an archive');
      try := try - 1;
      if warn then writeln(arcname, ' is not an archive, or is out of sync');
      if feof(f) then abort('Archive length error')
    end;

    hdrver := fgetb(f);
    if hdrver < 0 then abort('Invalid header in archive ' + arcname);
    if hdrver = 0 then begin   { special end of file marker }
      readhdr := FALSE;
      exit
    end;
    if hdrver > arcver then begin
      fread(name, sizeof(char), fnlen, f);
      writeln('I dont know how to handle file ', fn_to_str(name),
        ' in archive ', arcname);
      writeln('I think you need a newer version of TPARC.');
      halt(1)
    end;

    if hdrver = 1 then begin
      fread(hdr, sizeof(heads) - sizeof(long), 1, f);
      hdrver := 2;
      hdr.length := hdr.size
    end else
      fread(hdr, sizeof(heads), 1, f);

    readhdr := TRUE
  end;

