                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Starmaps is a program that will plot a star map of any area of the sky as
viewed from any place on Earth at any time of the day or year.

* ASSOCIATED FILES
STARMAPS.PAS
SETUP
STARMAPS.DOC
STARS.DAT


* KEYWORDS
TURBO PASCAL V4.0 GRAPHICS CGA MAP
==========================================================================
}
program StarMaps;

{$M 32768,0,655360}

uses
   CRT,DOS,Graph3;

type
   star_record = record
                    name:STRING[6];
                    right_ascension_in_radians:REAL;
                    declination_in_radians:REAL;
                    magnitude:REAL;
                    color_index:REAL
                    end;

   picture_record = record
                       star_number:INTEGER;
                       X:INTEGER;
                       Y:INTEGER
                       end;

   constellation_record = record
                             A:STRING[3];
                             G:STRING[19]
                             end;

   greek_letter_record = record
                            A:STRING[3];
                            L:STRING[7]
                            end;

   name_record = record
                    D:STRING[6];
                    N:STRING[10]
                    end;

const
   max_number_of_stars = 1573;
   max_number_of_stars_in_picture = 400;
   number_of_constellations = 89;
   number_of_greek_letters = 24;
   number_of_star_names = 21;
   Radians_per_hour = 0.2617993878;
   Radians_per_degree = 0.01745329252;
   Radians_in_a_circle = 6.283185307;

   blanks_20:STRING[20] = '                    ';

   Menu:array[1..12] of STRING[12]
      = ('latitude',
         'longitude',
         'date',
         'time',
         'time zone',
         'azimuth',
         'altitude',
         'zoom',
         'save setup',
         'reload setup',
         'plot stars',
         'quit');

   format:array[1..8] of STRING[8]
      = ('NN.N',
         'NNN.N',
         'MM/DD/YY',
         'HH:MM XM',
         'AAA',
         'NNN.N',
         'NN.N',
         'NN.N');

   constellations:array[1..number_of_constellations] of constellation_record
      = ((A:'AND';G:'Andromedae'),
         (A:'ANT';G:'Antliae'),
         (A:'APS';G:'Apodis'),
         (A:'AQL';G:'Aquilae'),
         (A:'AQR';G:'Aquarii'),
         (A:'ARA';G:'Arae'),
         (A:'ARG';G:'Argu'),
         (A:'ARI';G:'Arietis'),
         (A:'AUR';G:'Aurigae'),
         (A:'BOO';G:'Bootis'),
         (A:'CAE';G:'Caeli'),
         (A:'CAM';G:'Camelopardi'),
         (A:'CAP';G:'Capricorni'),
         (A:'CAR';G:'Carinae'),
         (A:'CAS';G:'Cassiopeiae'),
         (A:'CEN';G:'Centauri'),
         (A:'CEP';G:'Cephei'),
         (A:'CET';G:'Ceti'),
         (A:'CHA';G:'Chamaeleontis'),
         (A:'CIR';G:'Circini'),
         (A:'CMA';G:'Canis Majoris'),
         (A:'CMI';G:'Canis Minoris'),
         (A:'CNC';G:'Cancri'),
         (A:'COL';G:'Columbae'),
         (A:'COM';G:'Comae Berenices'),
         (A:'CRA';G:'Coronae Australis'),
         (A:'CRB';G:'Coronae Borealis'),
         (A:'CRT';G:'Crateris'),
         (A:'CRU';G:'Crucis'),
         (A:'CRV';G:'Corvi'),
         (A:'CVN';G:'Canum Venaticorum'),
         (A:'CYG';G:'Cygni'),
         (A:'DEL';G:'Delphini'),
         (A:'DOR';G:'Doradus'),
         (A:'DRA';G:'Draconis'),
         (A:'EQU';G:'Equulei'),
         (A:'ERI';G:'Eridani'),
         (A:'FOR';G:'Fornacis'),
         (A:'GEM';G:'Geminorum'),
         (A:'GRU';G:'Gruis'),
         (A:'HER';G:'Herculis'),
         (A:'HOR';G:'Horologii'),
         (A:'HYA';G:'Hydrae'),
         (A:'HYI';G:'Hydri'),
         (A:'IND';G:'Indi'),
         (A:'LAC';G:'Lacertae'),
         (A:'LEO';G:'Leonis'),
         (A:'LEP';G:'Leporia'),
         (A:'LIB';G:'Librae'),
         (A:'LMI';G:'Leonis Minoris'),
         (A:'LUP';G:'Lupi'),
         (A:'LYN';G:'Lyncis'),
         (A:'LYR';G:'Lyrae'),
         (A:'MEN';G:'Mensae'),
         (A:'MIC';G:'Microscopii'),
         (A:'MON';G:'Monocerotis'),
         (A:'MUS';G:'Muscae'),
         (A:'NOR';G:'Normae'),
         (A:'OCT';G:'Octantis'),
         (A:'OPH';G:'Ophiuchi'),
         (A:'ORI';G:'Orionis'),
         (A:'PAV';G:'Pavonis'),
         (A:'PEG';G:'Pegasi'),
         (A:'PER';G:'Persei'),
         (A:'PHE';G:'Phoenicis'),
         (A:'PIC';G:'Pictoris'),
         (A:'PSA';G:'Piscis Austrini'),
         (A:'PSC';G:'Piscium'),
         (A:'PUP';G:'Puppis'),
         (A:'PYX';G:'Pyxidis'),
         (A:'RET';G:'Reticuli'),
         (A:'SCL';G:'Sculptoris'),
         (A:'SCO';G:'Scorpii'),
         (A:'SCT';G:'Scuti'),
         (A:'SER';G:'Serpentis'),
         (A:'SEX';G:'Sextantis'),
         (A:'SGE';G:'Sagittae'),
         (A:'SGR';G:'Sagittarii'),
         (A:'TAU';G:'Tauri'),
         (A:'TEL';G:'Telescopii'),
         (A:'TRA';G:'Trianguli Australis'),
         (A:'TRI';G:'Trianguli'),
         (A:'TUC';G:'Tucanae'),
         (A:'UMA';G:'Ursae Majoris'),
         (A:'UMI';G:'Ursae Minoris'),
         (A:'VEL';G:'Velorum'),
         (A:'VIR';G:'Virginis'),
         (A:'VOL';G:'Volantis'),
         (A:'VUL';G:'Vulpeculae'));

   greek_letters:array[1..number_of_greek_letters] of greek_letter_record
      = ((A:'ALP';L:'Alpha'),
         (A:'BET';L:'Beta'),
         (A:'GAM';L:'Gamma'),
         (A:'DEL';L:'Delta'),
         (A:'EPS';L:'Epsilon'),
         (A:'ZET';L:'Zeta'),
         (A:'ETA';L:'Eta'),
         (A:'THE';L:'Theta'),
         (A:'IOT';L:'Iota'),
         (A:'KAP';L:'Kappa'),
         (A:'LAM';L:'Lambda'),
         (A:'MU ';L:'Mu'),
         (A:'NU ';L:'Nu'),
         (A:'XI ';L:'Xi'),
         (A:'OMI';L:'Omicron'),
         (A:'PI ';L:'Pi'),
         (A:'RHO';L:'Rho'),
         (A:'SIG';L:'Sigma'),
         (A:'TAU';L:'Tau'),
         (A:'UPS';L:'Upsilon'),
         (A:'PHI';L:'Phi'),
         (A:'CHI';L:'Chi'),
         (A:'PSI';L:'Psi'),
         (A:'OME';L:'Omega'));

   names:array[1..number_of_star_names] of name_record
      = ((D:'ALPCMA';N:'Sirius'),
         (D:'ALPARG';N:'Canopus'),
         (D:'ALPBOO';N:'Arcturus'),
         (D:'ALPLYR';N:'Vega'),
         (D:'ALPAUR';N:'Capella'),
         (D:'BETORI';N:'Rigel'),
         (D:'ALPCMI';N:'Procyon'),
         (D:'ALPERI';N:'Achernar'),
         (D:'ALPAQL';N:'Altair'),
         (D:'ALPORI';N:'Betelgeuse'),
         (D:'ALPTAU';N:'Aldebaran'),
         (D:'ALPVIR';N:'Spica'),
         (D:'ALPSCO';N:'Antares'),
         (D:'BETGEM';N:'Pollux'),
         (D:'ALPPSA';N:'Fomalhaut'),
         (D:'ALPCYG';N:'Deneb'),
         (D:'ALPLEO';N:'Regulus'),
         (D:'ALPGEM';N:'Castor'),
         (D:'ALPPER';N:'Algo'),
         (D:'ALPUMI';N:'Polaris'),
         (D:'OMICET';N:'Mira'));

var
   R:REGISTERS;

   StarData,InFile,OutFile:TEXT;

   stars:array [1..max_number_of_stars] of star_record;
   star:star_record;

   picture_stars:array[1..max_number_of_stars_in_picture] of picture_record;
   picture_star:picture_record;

   X_dot_color,Y_dot_color:array[1..9] of BYTE;

   blanks:STRING[80];

   star_designation:STRING[27];
   constellation:STRING[19];
   star_name:STRING[10];
   date_string,time_string:STRING[8];
   greek_letter:STRING[7];
   star_designation_abbreviation:STRING[6];
   longitude_string,azimuth_string:STRING[5];
   latitude_string,altitude_string,zoom_string:STRING[4];
   greek_letter_abbreviation,constellation_abbreviation,
   zone_string:STRING[3];
   month_string,day_string,year_string,hour_string,minute_string,
   XM:STRING[2];

   latitude,longitude,time,azimuth,altitude,zoom,
   latitude_in_radians,longitude_in_radians,
   zone_correction_in_radians,year_in_radians,time_in_radians,
   azimuth_in_radians,altitude_in_radians,Xplot,Yplot,color,
   hour_angle_offset_in_radians,cos_latitude,sin_latitude,
   cos_azimuth,sin_azimuth,cos_altitude,sin_altitude,
   declination_in_radians,magnitude,color_index:REAL;

   X_difference,Y_difference,smallest_distance_squared,
   distance_squared:LONGINT;

   L,P1,P2,V,code,X,Y,C,Number_of_stars,Star_number,
   horizon_line,star_brightness_case,year,month,day,hour,minute,
   zone_correction,temp_hour,number_of_stars_in_picture,X_mouse,
   X_crosshair,Y_crosshair,X_dot,Y_dot,past_X_crosshair,
   past_Y_crosshair,picture_star_number,index:INTEGER;

   selection,past_selection,mouse_buttons:BYTE;

   character:STRING[1];

   flag,function_key,mouse_flag,stars_in_picture_overflow_flag,
   constellation_found_flag,greek_letter_found_flag,
   star_name_found_flag:BOOLEAN;

procedure read_in_star_data;

var
   Star_info:STRING[28];
   V1,V2:INTEGER;

begin
   ClrScr;
   Write('Reading in star data.');
   Assign(StarData,'STARS.DAT');
   Reset(StarData);
   star_number := 0;
   while not EOF(StarData) do begin
      star_number := star_number + 1;
      Readln(StarData,Star_info);
      star.name := copy(Star_info,1,6);
      val(copy(Star_info,8,2),V1,code);
      val(copy(Star_info,10,3),V2,code);
      star.right_ascension_in_radians
         := (V1 + V2 / 600) * radians_per_hour;
      val(copy(Star_info,14,2),V1,code);
      val(copy(Star_info,16,2),V2,code);
      declination_in_radians
         := (V1 + V2 / 60) * radians_per_degree;
      if copy(Star_info,13,1) = '-' then
         declination_in_radians
            := - declination_in_radians;
      star.declination_in_radians := declination_in_radians;
      val(copy(Star_info,20,3),magnitude,code);
      if copy(Star_info,19,1) = '-' then
         magnitude := - magnitude;
      star.magnitude := magnitude;
      val(copy(Star_info,25,5),color_index,code);
      if copy(Star_info,24,1) = '-' then
         color_index := - color_index;
      star.color_index := color_index;
      stars[star_number] := star
      end;
   Number_of_stars := Star_number;
   close(StarData)
end;


procedure change_latitude;

begin
   while copy(latitude_string,1,1) = ' ' do
      latitude_string := copy(latitude_string,2,4);
   val(latitude_string,latitude,code);
   if latitude < -90 then
      latitude := -90;
   if 90 < latitude then
      latitude := 90;
   str(latitude:4:1,latitude_string)
end;

procedure change_longitude;

begin
   while copy(longitude_string,1,1) = ' ' do
      longitude_string := copy(longitude_string,2,5);
   val(longitude_string,longitude,code);
   if (longitude < 0) or (360 <= longitude) then
      longitude := 0;
   str(longitude:5:1,longitude_string)
end;

procedure change_date;

begin
   P1 := pos('/',date_string);
   L := length(date_string);
   P2 := P1 + pos('/',copy(date_string,P1 + 1,8));
   val(copy(date_string,1,P1 - 1),month,code);
   if month < 1 then
      month := 1;
   if 12 < month then
      month := 12;
   str(month,month_string);
   val(copy(date_string,P2 + 1,2),year,code);
   str(year,year_string);
   val(copy(date_string,P1 + 1,P2 - P1 - 1),day,code);
   if day < 1 then
      day := 1;
   if month = 2 then begin
      if year mod 4 = 0 then begin
         if 29 < day then
            day := 29
         end
      else begin
         if 28 < day then
            day := 28
         end
      end
   else begin
      if (month = 4) or (month = 6) or (month = 9) or (month = 11) then begin
         if (30 < day) then
            day := 30
         end
      else begin
         if 31 < day then
            day := 31
         end
      end;
   str(day,day_string);
   date_string := month_string + '/' + day_string + '/' + year_string
end;

procedure change_time;

begin
   P1 := pos(':',time_string);
   P2 := pos(' ',time_string);
   val(copy(time_string,1,P1 - 1),hour,code);
   if 11 < hour then
      hour := 0;
   val(copy(time_string,P1 + 1,P2 - P1 - 1),minute,code);
   if minute < 0 then
      minute := 0;
   if 59 < minute then
      minute := 59;
   XM := copy(time_string,P2 + 1,2);
   if (XM <> 'AM') and (XM <> 'PM') then begin
      if 6 < hour then
         XM := 'PM'
      else
         XM := 'AM'
      end;
   if XM = 'PM' then
      hour := hour + 12;
   if XM = 'PM' then
      temp_hour := hour - 12
   else
      temp_hour := hour;
   if temp_hour < 1 then
      temp_hour := 12;
   str(temp_hour,hour_string);
   while length(hour_string) < 2 do
      hour_string := '0' + hour_string;
   str(minute,minute_string);
   while length(minute_string) < 2 do
      minute_string := '0' + minute_string;
   time_string := hour_string + ':' + minute_string + ' ' + XM
end;

procedure change_zone;

begin
   character := Copy(zone_string,1,1);
   if character = 'G' then
      zone_correction := 0;
   if character = 'A' then
      zone_correction := 4;
   if character = 'E' then
      zone_correction := 5;
   if character = 'C' then
      zone_correction := 6;
   if character = 'M' then
      zone_correction := 7;
   if character = 'P' then
      zone_correction := 8;
   character := Copy(zone_string,2,1);
   if character = 'D' then begin
      zone_correction := zone_correction - 1;
      case zone_correction of
         3:zone_string := 'ADT';
         4:zone_string := 'EDT';
         5:zone_string := 'CDT';
         6:zone_string := 'MDT';
         7:zone_string := 'PDT'
      else
         zone_string := 'GMT'
      end
      end
   else
      case zone_correction of
         4:zone_string := 'AST';
         5:zone_string := 'EST';
         6:zone_string := 'CST';
         7:zone_string := 'MST';
         8:zone_string := 'PST'
      else
         zone_string := 'GMT'
      end
end;

procedure change_azimuth;

begin
   while copy(azimuth_string,1,1) = ' ' do
      azimuth_string := copy(azimuth_string,2,5);
   val(azimuth_string,azimuth,code);
   if (azimuth < 0) or (360 <= azimuth) then
      azimuth := 0;
   str(azimuth:4:1,azimuth_string)
end;

procedure change_altitude;

begin
   while copy(altitude_string,1,1) = ' ' do
      altitude_string := copy(altitude_string,2,4);
   val(altitude_string,altitude,code);
   if altitude < 0 then
      altitude := 0;
   if 90 < altitude then
      altitude := 90;
   str(altitude:4:1,altitude_string)
end;

procedure change_zoom;

begin
   while copy(zoom_string,1,1) = ' ' do
      zoom_string := copy(zoom_string,2,4);
   if copy(zoom_string,1,1) = '.' then
      zoom_string := '0' + zoom_string;
   val(zoom_string,zoom,code);
   if zoom < 0.1 then
      zoom := 0.1;
   if 10 < zoom then
      zoom := 10;
   str(zoom:4:1,zoom_string)
end;

procedure save_setup;

begin
   Assign(OutFile,'SETUP');
   Rewrite(OutFile);
   writeln(OutFile,latitude_string);
   writeln(OutFile,longitude_string);
   writeln(OutFile,date_string);
   writeln(OutFile,time_string);
   writeln(OutFile,zone_string);
   writeln(OutFile,azimuth_string);
   writeln(OutFile,altitude_string);
   writeln(OutFile,zoom_string);
   Close(OutFile)
end;

procedure load_setup;

begin
   Assign(InFile,'SETUP');
   Reset(InFile);
   readln(InFile,latitude_string);
   readln(InFile,longitude_string);
   readln(InFile,date_string);
   readln(InFile,time_string);
   readln(InFile,zone_string);
   readln(InFile,azimuth_string);
   readln(InFile,altitude_string);
   readln(InFile,zoom_string);
   Close(InFile);
   change_latitude;
   change_longitude;
   change_date;
   change_time;
   change_zone;
   change_azimuth;
   change_altitude;
   change_zoom
end;

procedure menu_select;

begin
   Repeat
      ClrScr;
      TextMode(3);
      TextBackground(0);
      TextColor(6);
      GotoXY(39,2);
      writeln('MENU');
      GotoXY(1,4);
      writeln(Menu[1],' = ',latitude_string);
      writeln(Menu[2],' = ',longitude_string);
      writeln(Menu[3],' = ',date_string);
      writeln(Menu[4],' = ',time_string);
      writeln(Menu[5],' = ',zone_string);
      writeln(Menu[6],' = ',azimuth_string);
      writeln(Menu[7],' = ',altitude_string);
      writeln(Menu[8],' = ',zoom_string);
      writeln(Menu[9]);
      writeln(Menu[10]);
      writeln(Menu[11]);
      writeln(Menu[12]);
      writeln;
      writeln('Note - After the stars are plotted a frame is drawn around the map.');
      if mouse_flag then begin
         writeln('       Clicking the left mouse button will cause the mouse pointer');
         writeln('       to appear.  Select a star with the pointer and click the left');
         writeln('       mouse button to display the star''s name.  Return to the plot');
         writeln('       by clicking the left mouse button.  Return to the menu by');
         writeln('       typing "M" or click the left mouse button to get the pointer.')
         end
      else begin
         writeln('       Typing "C" will cause crosshairs to appear.  The crosshairs');
         writeln('       can be moved around the map with the cursor control keys.');
         writeln('       Select a star with the crosshairs and type "S" to display');
         writeln('       the star''s name.  Return to the plot by typing "P".');
         writeln('       From the plot return to the menu by typing "M".')
         end;
      Repeat
         TextBackground(6);
         TextColor(0);
         gotoxy(1,selection + 3);
         write(menu[selection]);
         character := readkey;
         past_selection := selection;
         function_key := (character = #0);
         if function_key then begin
            character := readkey;
            if character = #72 then begin
               if 1 < selection then
                  selection := selection - 1
               else
                  selection := 12
               end;
            if character = #80 then begin
               if selection < 12 then
                  selection := selection + 1
               else
                  selection := 1
               end
            end;
         TextBackground(0);
         TextColor(6);
         gotoxy(1,past_selection + 3);
         write(menu[past_selection])
      Until not function_key and (character = #13);
      if selection < 9 then begin
         gotoxy(1,selection + 3);
         writeln(blanks);
         TextBackground(6);
         TextColor(0);
         gotoxy(1,selection + 3);
         write(menu[selection],' (',format[selection],') = ')
         end;
      Case selection of
          1:begin
               readln(latitude_string);
               change_latitude
               end;
          2:begin
               readln(longitude_string);
               change_longitude
               end;
          3:begin
               readln(date_string);
               change_date
               end;
          4:begin
               readln(time_string);
               change_time
               end;
          5:begin
               readln(zone_string);
               change_zone
               end;
          6:begin
               readln(azimuth_string);
               change_azimuth
               end;
          7:begin
               readln(altitude_string);
               change_altitude
               end;
          8:begin
               readln(zoom_string);
               change_zoom
               end;
          9:save_setup;
         10:load_setup;
         end
   Until 10 < selection
end;

procedure convert_to_radians;

var
   fraction_of_a_day:REAL;
   month_days,full_years_since_leap_year,
   full_days_since_leap_year:INTEGER;

begin
   latitude_in_radians := radians_per_degree * latitude;
   longitude_in_radians := radians_per_degree * longitude;
   fraction_of_a_day := hour / 24 + minute / 1440;
   case month of
       1:month_days := 0;
       2:month_days := 31;
       3:month_days := 59;
       4:month_days := 90;
       5:month_days := 120;
       6:month_days := 151;
       7:month_days := 181;
       8:month_days := 212;
       9:month_days := 243;
      10:month_days := 273;
      11:month_days := 304;
      12:month_days := 334
      end;
   full_years_since_leap_year := (year - 1) mod 4;
   if (full_years_since_leap_year = 3) and (2 < month) then
      month_days := month_days + 1;
   full_days_since_leap_year
      := day - 1 + month_days
       + 365 * full_years_since_leap_year;
   year_in_radians
      := radians_in_a_circle * Frac((fraction_of_a_day
       + full_days_since_leap_year) / 365.25);
   time_in_radians := radians_in_a_circle * fraction_of_a_day;
   zone_correction_in_radians
      := radians_per_hour * zone_correction;
   azimuth_in_radians := radians_per_degree * azimuth;
   altitude_in_radians := radians_per_degree * altitude
end;

procedure plot_dot(X,Y:INTEGER);

begin
   if (0 <= X) and (X <= 319)
   and (0 <= Y) and (Y <= 199) then
      plot(X,Y,C)
end;

procedure plot_1_dot;

begin
   plot_dot(trunc(Xplot),trunc(Yplot))
end;

procedure plot_2_dots;

begin
   X := trunc(Xplot - 0.5);
   Y := trunc(Yplot);
   plot_dot(X,Y);
   plot_dot(X + 1,Y)
end;

procedure plot_4_dots;

begin
   X := trunc(Xplot - 0.5);
   Y := trunc(Yplot - 0.5);
   plot_dot(X,Y);
   plot_dot(X + 1,Y);
   plot_dot(X,Y + 1);
   plot_dot(X + 1,Y + 1)
end;

procedure plot_8_dots;

begin
   plot_4_dots;
   plot_dot(X,Y - 1);
   plot_dot(X + 2,Y);
   plot_dot(X + 1,Y + 2);
   plot_dot(X - 1,Y + 1)
end;

procedure plot_lots_of_dots;

var
   R,Rsqr,BX,BY,DX,DY:INTEGER;

begin
   R := trunc(5.37669 * exp(-0.4605170186 * magnitude));
   Rsqr := sqr(R);
   X := trunc(Xplot - 0.5);
   Y := trunc(Yplot - 0.5);
   for DX := -R to R do
      for DY := -R to R do
         if (sqr(DX) + sqr(DY) <= Rsqr) then
            plot_dot(X + DX,Y + DY)
end;

procedure plot_star;

begin
   color_index := star.color_index;
   if color_index < 0 then
      C := 1
   else begin
      if color_index > 1.8 then
         C := 2
      else
         C := 3
      end;
   magnitude := star.magnitude;
   if magnitude < 2.0 then
      plot_lots_of_dots
   else begin
      star_brightness_case
         := trunc((magnitude - 1) / 0.75);
      if 4 < star_brightness_case then
         star_brightness_case := 4;
      case star_brightness_case of
         4:plot_1_dot;
         3:plot_2_dots;
         2:plot_4_dots;
         1:plot_8_dots
         end
      end
end;

procedure calculate_coordinates;

var
   cos_declination,local_hour_angle,
   X0,Y0,Z0,X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3,XOZ,YOZ:REAL;

begin
   number_of_stars_in_picture := 0;
   stars_in_picture_overflow_flag := FALSE;
   for star_number := 1 to number_of_stars do begin
      star := stars[star_number];
      declination_in_radians := star.declination_in_radians;
      cos_declination := cos(declination_in_radians);
      local_hour_angle := star.right_ascension_in_radians
                        + hour_angle_offset_in_radians;
      if local_hour_angle >= radians_in_a_circle then
         local_hour_angle := local_hour_angle
                           - radians_in_a_circle;
      X0 := cos_declination * sin(local_hour_angle);
      Y0 := sin(declination_in_radians);
      Z0 := cos_declination * cos(local_hour_angle);

      X1 := X0;
      Y1 := Y0 * cos_latitude - Z0 * sin_latitude;
      Z1 := Z0 * cos_latitude + Y0 * sin_latitude;

      X2 := -X1 * cos_azimuth + Y1 * sin_azimuth;
      Y2 := -Y1 * cos_azimuth - X1 * sin_azimuth;
      Z2 := Z1;

      X3 := X2;
      Y3 := Z2 * cos_altitude + Y2 * sin_altitude;
      Z3 := -Y2 * cos_altitude + Z2 * sin_altitude;

      if 0.4411287733 < Z3 then begin
         XOZ := zoom * X3 / Z3;
         if (abs(XOZ) < 0.16666666666) then begin
            YOZ := zoom * Y3 / Z3;
            if (abs(YOZ) < 0.11666666666) then begin
               Xplot := 159.5 - 957 * XOZ;
               Yplot := 99.5 - 852.8571429 * YOZ;
               plot_star;
               number_of_stars_in_picture
                  := number_of_stars_in_picture + 1;
               if max_number_of_stars_in_picture
                  < number_of_stars_in_picture then
                  stars_in_picture_overflow_flag := TRUE
               else begin
                  picture_star.star_number := star_number;
                  picture_star.X := trunc(Xplot);
                  picture_star.Y := trunc(Yplot);
                  picture_stars[number_of_stars_in_picture]
                     := picture_star
                  end
               end
            end
         end
      end
end;

procedure calculate_factors;

begin
   hour_angle_offset_in_radians := longitude_in_radians
                                 - zone_correction_in_radians
                                 + 4.532838682
                                 - year_in_radians
                                 - time_in_radians;
   while hour_angle_offset_in_radians < 0 do
      hour_angle_offset_in_radians
         := hour_angle_offset_in_radians
          + radians_in_a_circle;
   while radians_in_a_circle <= hour_angle_offset_in_radians do
      hour_angle_offset_in_radians
         := hour_angle_offset_in_radians
          - radians_in_a_circle;
   cos_latitude := cos(latitude_in_radians);
   sin_latitude := sin(latitude_in_radians);
   cos_azimuth := cos(azimuth_in_radians);
   sin_azimuth := sin(azimuth_in_radians);
   cos_altitude := cos(altitude_in_radians);
   sin_altitude := sin(altitude_in_radians);
   if sin_altitude < 0.7592566024 then
      horizon_line := 100 + Round(zoom * 848.57
                    * sin_altitude / cos_altitude)
   else
      horizon_line := 200
end;

procedure crosshairs;

var
   picture:ARRAY [1..16006] of BYTE;

begin
   GetPic(picture,0,199,319,0);
   if mouse_flag then begin
      repeat
         r.ax := 3;
         intr(51,r);
         mouse_buttons := r.bx
      until (mouse_buttons = 0);
      r.ax := 1;
      intr(51,r);
      repeat
         r.ax := 3;
         intr(51,r);
         mouse_buttons := r.bx;
         X_mouse := r.cx;
         Y_crosshair := r.dx
      until mouse_buttons = 1;
      r.ax := 2;
      intr(51,r);
      X_crosshair := X_mouse div 2
      end
   else begin
      Repeat
         if ((0 <= Y_crosshair) and (Y_crosshair < 200)) then
            for X_dot := X_crosshair - 4 to X_crosshair + 4 do
               if ((0 <= X_dot) and (X_dot < 320)) then
                  X_dot_color[X_dot - (X_crosshair - 5)]
                     := GetDotColor(X_dot,Y_crosshair);
         if ((0 <= X_crosshair) and (X_crosshair < 320)) then
            for Y_dot := Y_crosshair - 4 to Y_crosshair + 4 do
               if ((0 <= Y_dot) and (Y_dot < 320)) then
                  Y_dot_color[Y_dot - (Y_crosshair - 5)]
                     := GetDotColor(X_crosshair,Y_dot);
         if ((0 <= Y_crosshair) and (Y_crosshair < 200)) then
            for X_dot := X_crosshair - 4 to X_crosshair + 4 do
               if ((0 <= X_dot) and (X_dot < 320)) then
                  plot(X_dot,Y_crosshair,3);
         if ((0 <= X_crosshair) and (X_crosshair < 320)) then
            for Y_dot := Y_crosshair - 4 to Y_crosshair + 4 do
               if ((0 <= Y_dot) and (Y_dot < 320)) then
                  plot(X_crosshair,Y_dot,3);
         past_X_crosshair := X_crosshair;
         past_Y_crosshair := Y_crosshair;
         character := readkey;
         function_key := (character = #0);
         if function_key then begin
            character := readkey;
            if character = #72 then begin
               Y_crosshair := Y_crosshair - 1;
               if Y_crosshair < 1 then
                  Y_crosshair := 1
               end;
            if character = #80 then begin
               Y_crosshair := Y_crosshair + 1;
               if 198 < Y_crosshair then
                  Y_crosshair := 198
               end;
            if character = #75 then begin
               X_crosshair := X_crosshair - 1;
               if X_crosshair < 1 then
                  X_crosshair := 1
               end;
            if character = #77 then begin
               X_crosshair := X_crosshair + 1;
               if 318 < X_crosshair then
                  X_crosshair := 318
               end
            end;
         if ((0 <= past_Y_crosshair) and (past_Y_crosshair < 200)) then
            for X_dot := past_X_crosshair - 4 to past_X_crosshair + 4 do
               if ((0 <= X_dot) and (X_dot < 320)) then
                  plot(X_dot,past_Y_crosshair,
                       X_dot_color[X_dot - (past_X_crosshair - 5)]);
         if ((0 <= past_X_crosshair) and (past_X_crosshair < 320)) then
            for Y_dot := past_Y_crosshair - 4 to past_Y_crosshair + 4 do
               if ((0 <= Y_dot) and (Y_dot < 320)) then
                  plot(past_X_crosshair,Y_dot,
                       Y_dot_color[Y_dot - (past_Y_crosshair - 5)])
      Until (not function_key and ((character = 'S') or (character = 's')))
      end;
   TextMode(3);
   TextBackground(0);
   TextColor(6);
   if 1 < number_of_stars_in_picture then begin
      X_difference := X_crosshair - picture_stars[1].X;
      Y_difference := Y_crosshair - picture_stars[1].Y;
      smallest_distance_squared := X_difference * X_difference
                                 + Y_difference * Y_difference;
      picture_star_number := 1;
      for index := 2 to number_of_stars_in_picture do begin
         picture_star := picture_stars[index];
         X_difference := X_crosshair - picture_star.X;
         Y_difference := Y_crosshair - picture_star.Y;
         distance_squared := X_difference * X_difference
                           + Y_difference * Y_difference;
         if distance_squared < smallest_distance_squared then begin
            smallest_distance_squared := distance_squared;
            picture_star_number := index
            end;
         end
      end;
   star_number := picture_stars[picture_star_number].star_number;
   star_designation_abbreviation := stars[star_number].name;
   greek_letter_abbreviation := copy(star_designation_abbreviation,1,3);
   constellation_abbreviation := copy(star_designation_abbreviation,4,3);
   constellation_found_flag := FALSE;
   index := 0;
   while not constellation_found_flag
   and (index < number_of_constellations) do begin
      index := index + 1;
      if constellation_abbreviation = constellations[index].A then begin
         constellation_found_flag := TRUE;
         constellation := constellations[index].G
         end
      end;
   greek_letter_found_flag := FALSE;
   index := 0;
   while not greek_letter_found_flag
   and (index < number_of_greek_letters) do begin
      index := index + 1;
      if greek_letter_abbreviation = greek_letters[index].A then begin
         greek_letter_found_flag := TRUE;
         greek_letter := greek_letters[index].L
         end
      end;
   if constellation_found_flag then
      star_designation := constellation
   else begin
      star_designation := constellation_abbreviation;
      writeln('Constellation not found.');
      writeln
      end;
   star_designation := ' ' + star_designation;
   if greek_letter_found_flag then
      star_designation := greek_letter + star_designation
   else begin
      if greek_letter_abbreviation[3] = ' ' then begin
         greek_letter_abbreviation := copy(greek_letter_abbreviation,1,2);
         if greek_letter_abbreviation[2] = ' ' then
            greek_letter_abbreviation := copy(greek_letter_abbreviation,1,1)
         end;
      star_designation := greek_letter_abbreviation + star_designation
      end;
   star_name_found_flag := FALSE;
   index := 0;
   while not star_name_found_flag
   and (index < number_of_star_names) do begin
      index := index + 1;
      if star_designation_abbreviation = names[index].D then begin
         star_name_found_flag := TRUE;
         star_name := names[index].N
         end
      end;
   write('The selected star is ');
   if star_name_found_flag then
      writeln(star_name,' (',star_designation,')')
   else
      writeln(star_designation);
   if mouse_flag then begin
      repeat
         r.ax := 3;
         intr(51,r);
         mouse_buttons := r.bx
      until mouse_buttons = 0;
      repeat
         r.ax := 3;
         intr(51,r);
         mouse_buttons := r.bx
      until (mouse_buttons = 1)
      end
   else begin
      Repeat
         character := readkey
      Until (character = 'P') or (character = 'p')
      end;
   GraphMode;
   Palette(1);
   GraphBackground(0);
   PutPic(picture,0,199)
end;

begin
   blanks := blanks_20 + blanks_20 + blanks_20 + blanks_20;
   TextMode(3);
   TextBackground(0);
   TextColor(6);
   mouse_flag := FALSE;
   r.ah := $30;
   msdos(r);
   if (lo(r.ax) > $03)
   or ((lo(r.ax) = $03) and (hi(r.ax) > $13)) then begin
      r.ax := 0;
      intr(51,r);
      mouse_flag := boolean(r.ax)
      end;
   read_in_star_data;
   load_setup;
   selection := 1;
   Repeat
      TextMode(3);
      TextBackground(0);
      TextColor(6);
      menu_select;
      if selection = 11 then begin
         convert_to_radians;
         calculate_factors;
         GraphMode;
         Palette(1);
         GraphBackground(0);
         calculate_coordinates;
         if horizon_line < 199 then
            Draw(0,horizon_line,319,horizon_line,3);
         if horizon_line < 198 then
            for Y := horizon_line + 1 to 198
               do Draw(1,Y,318,Y,0);
         draw(0,0,319,0,3);
         draw(319,0,319,199,3);
         draw(319,199,0,199,3);
         draw(0,199,0,0,3);
         X_crosshair := 160;
         Y_crosshair := 100;
         if mouse_flag then begin
            r.ax := 0;
            intr(51,r)
            end;
         Repeat
            repeat
               if mouse_flag then begin
                  repeat
                     r.ax := 3;
                     intr(51,r);
                     mouse_buttons := r.bx;
                  until (mouse_buttons = 0);
                  repeat
                     r.ax := 3;
                     intr(51,r);
                     mouse_buttons := r.bx;
                     function_key := keypressed
                  until (mouse_buttons = 1)
                        or function_key;
                  if function_key then
                     character := readkey
                  else
                     character := 'C'
                  end
               else
                  character := readkey
            Until ((character = 'M') or (character = 'm')
                      or (character = 'C') or (character = 'c'));
            if ((character = 'C') or (character = 'c')) then
               crosshairs
         Until (character = 'M') or (character = 'm');
         end
   Until selection = 12;
   Clrscr
end.
