                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to print source code files.  Works with lines longer than 80
characters while maintaining proper pagination.  Author: Glenn Brooke.
Version T1.0.  Turbo Pascal 2.0, 3.0, 4.0.


* KEYWORDS
TURBO PASCAL 2.0 3.0 4.0 PROGRAM UTILITY SOURCE LISTER

==========================================================================
}

program Show_File;

{ written by Glenn Brooke 7/20/85 in Turbo Pascal.  Intended for the
  public domain.  This program may not be sold or used for profit without
  the express written permission of Glenn Brooke.

  Ok, another file lister.  Yes, it's better.  Sigh.  Actually, this is
  a significant improvement over any other lister I've seen -- it handles
  lines longer than 80 characters without screwing up the pagination!  It's
  especially great for program source listings.

  To use, compile with Turbo Pascal (any version should work), and run!
  The program will prompt you for filenames and whether you want pagination
  or not.  Pagination provides the filename and page # on each page.

  You can modify the source to your heart's content.  I use 79 columns per
  line and 55 lines per page most frequently.

  Important note : program works only with text (ASCII) files.

                                          Glenn Brooke
                                          1025 Garnett Place
                                          Evanston, IL 60201
                                                                       }

{}
Uses
  Crt,
  Printer;
{}
type
    filename = string[14];

var
   filetolist : filename;
   ch : char;
   pagination,ok : boolean;


{this is the key procedure which does all the work!}
procedure List_File(name : filename;
                    pagination : boolean);
{lists files with wraparound, pagination if desired, on lst: device}
const
     MaxLinesPerPage = 55;
     MaxCharPerLine = 79;
var
   line : string[255];
   i,l, linecount, pagecount : integer;
   filetoshow : text;

begin
     Assign(filetoshow, Name);
     Reset(filetoshow);
     linecount := 0; pagecount := 1;
     if pagination then
        begin writeln(lst); writeln(lst,'   ',Name,'   Page ',pagecount);
              writeln(lst);
        end
     else
         begin writeln(lst); writeln(lst); writeln(lst);
         end; {else}

     while not eof(filetoshow) do
           begin
           line := '';
           readln(filetoshow,line);
           l := length(line);
           if L <= MaxCharPerLine then
              begin
              linecount := succ(linecount);
              writeln(lst,line);
              end {if}
           else  {handle lines longer than MaxCharPerLine}
              begin
              for i := 1 to l do
                  begin
                  write(lst,line[i]);   {write char by char}
                  if i mod MaxCharPerLine = 0 then  {begin new line}
                     begin
                     writeln(lst);
                     linecount := succ(linecount);
                     end; {if}
                  end; {for}
              writeln(lst);
              linecount := succ(linecount)
              end; {else}
        if linecount >= MaxLinesPerPage then  {begin new page}
           begin
           writeln(lst);
           writeln(lst); writeln(lst); writeln(lst); writeln(lst);
           linecount := 0; pagecount := succ(pagecount);
           if pagination then
              begin
              writeln(lst);
              writeln(lst,'   ',Name,'   Page ',pagecount)
              end
           else
               begin
               writeln(lst); writeln(lst);
               end; {else}
           writeln(lst);writeln(lst);writeln(lst);writeln(lst);
           end;
     end; {while}
     close(filetoshow);
end; {ListFile}

function Exists(name : filename) : boolean;
{returns true if name is a valid filename}
var fil : file;
begin
     Assign(fil, Name);
     {$I-}
     Reset(fil);
     Close(fil);   { added for 3.0 and 4.0 compatibility - DSMB }
     {$I+}
     Exists := (IOresult = 0);
end;


begin {main program body}
      repeat
      ClrScr;
      Gotoxy(15,12);write('        Text File Printer -- with wraparound !');

      ok := true;        {assume file exists}
      repeat
      gotoxy(15,15);clreol;write('Enter a valid filename (or return to quit) : ');
      readln(filetolist);   {'read' replaced for 4.0 compatibility - DSMB }
      if filetolist = '' then
         begin {quit program}
         gotoxy(1,23);
         halt
         end
      else      {does this file really exist?}
         begin
         if not Exists(filetolist) then
            begin
            write(chr(7));      {beep}
            ok := false
            end {if}
         else ok := true;
         end; {else}
      until ok;

      gotoxy(15,16);write('Do you want pagination (Y/N) ? ');
      readln(ch);       { 'read' replaced for 4.0 compatibility - DSMB }
      if upcase(ch) = 'Y' then pagination := true else pagination := false;
      List_File(filetolist, pagination);
      until 0 = 1;    {always repeat; must go through halt to quit program}
end.

