                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to send setup codes to HP LaserJet printer.  Author unknown.
Version T1.0.  Turbo Pascal 4.0.


* KEYWORDS
TURBO PASCAL 4.0 PROGRAM UPLOAD SETUP CODE LASERJET PRINTER

==========================================================================
}

{ This program sends escape codes to the printer.  The codes are for the
  HP LaserJet printer. }
{ CommandLine (absolute cseg:$80) approach replaced by ParamStr approach
  for 4.0 compatibility - DSMB }

program Laser;

Uses
  Printer;

const
  Port = ^['&l0o66p2e7.6c66F'^['&k11H';
  Land = ^['&l1o66p2e5.7c66F';
  Norm = ^['(s10H';
  Cond = ^['(s16.66H';
  Memo = ^['&l0o66p17c1e6d60F'^['(s12H';
  Enve = ^['&l1o3H';
  Copies = ^['&lN';
  ResetMargin = ^['9';
  RMargin = ^['&aL';
  LMargin = ^['&aM';
  Init = ^['E';
  TOF = ^L;

var
  Option : string;
  I, J           : Integer;
  PtrReset       : Boolean;

begin
  PtrReset := false;
  if paramcount = 0 then begin { modified for 4.0 compatibility - DSMB }
    writeln(
      'HP LaserJet Printer Initialization',
      '              Revised: FEB 22, 1985' );
    writeln;
    writeln(
      'To use this program, type "LASER option-1 option-2 ... option-n"' );
    writeln(
      '  where the options allowed:' );
    writeln;
    writeln(
      '     NORMAL    == Standard print',
      ' with 80 chr per line and 66 lines per page' );
    writeln(
      '     CONDENSED == Computer print',
      ' with 176 chr per line and 66 lines per page');
    writeln(
      '     MEMO      == IOC Memo page formatting' );
    writeln(
      '     ENVELOPE  == Manual envelope formatting' );
    writeln(
      '     TOF       == Set printer to Top Of Page',
      ' (prints data in printer''s buffer)' );
    writeln(
      '     RESET     == Set printer to the power on status' );
  end;
  for I := 1 to paramcount do begin
    Option := paramstr(I);
    for J := 1 to length( Option ) do Option [J] := upcase( Option[J]  );

    if copy( Option, 1, 4 ) = 'NORM' then begin
      write( Lst, Init, Port, Norm );  PtrReset := false;  end;

    if copy( Option, 1, 4 ) = 'COND' then begin
      write( Lst, Init, Land, Cond );  PtrReset := false;  end;

    if copy( Option, 1, 4 ) = 'MEMO' then begin
      write( Lst, Init, Memo );  PtrReset := false;  end;

    if copy( Option, 1, 4 ) = 'ENVE' then begin
      write( Lst, Init, Enve );  PtrReset := false;  end;

    if copy( Option, 1, 3 ) = 'TOF' then begin
      write( Lst, TOF );  end;

    if copy( Option, 1, 5 ) = 'RESET' then begin
     PtrReset := true;  end;

  end; { length( Buffer ) > 0 == processing the command line }
  if PtrReset then write( Lst, Init );
{
(* This is a test pattern to check alignment. *)

  writeln( Lst, 'TEST LINE - TOP                              page 1' );
  for I := 1 to 25  do write( Lst, '123456789 ' ); writeln( Lst );
  for I := 1 to 250 do write( Lst, '-' ); writeln( Lst );
  for I := 4 to 65 do writeln( Lst, I );
  writeln( Lst, 'TEST LINE - BOTTOM                           page 1' );
}
end. { of program Laser }

