                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Function DollarString converts a real number representing a dollar amount
into a string in standard accounting format (with commas, decimals, and
negative amounts in parentheses).  Author: Charles L. Jackson.  Version T1.0.
Turbo Pascal 2.0, 3.0, 4.0.

* ASSOCIATED FILES
DOLLARST.PAS
DOLLARST.INC

* KEYWORDS
TURBO PASCAL 2.0 3.0 4.0 PROGRAM STRING FORMAT PROCEDURE

==========================================================================
}

type dlrstr = string[20]; {dollar string for output representation}

function DollarString(x:real;decimalpts:integer):dlrstr;

var
   xlen,
   cp:integer;
   xd:dlrstr;

begin
 if not( (0<=decimalpts) and (decimalpts<=3) ) then decimalpts:=2;
 str(x:20:decimalpts,xd);
 while xd[1] in [' ','-'] do delete(xd,1,1);
 {Debug writeln(' xd at a   ',xd:20);}
 xlen:=length(xd);
 cp:=xlen-(3+decimalpts);
 if decimalpts=0 then cp:=cp+1;  {the decimal point is suppressed so adjust}
while cp>1 do
      begin
      insert(',',xd,cp);
      {DEBUG writeln(' xd at b   ',xd:20,'  xlen',xlen:5,' cp',cp:5);}
      xlen:=xlen-6;
      cp:=cp-3;
      end;

if x<0 then xd:= '('+xd+')';
{Debug writeln(  ' xd at c   ',xd:20);}
DollarString:=xd;
end;

