                       F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to display/print a file directory, with automatic display of lines
3,4 and 5 of ASCII files with .PAS or .INC file extension.  Author unknown.
Version T1.0.  Turbo Pascal 4.0.

* ASSOCIATED FILES
DIRTE.PAS
DIRTE.DOC

* KEYWORDS
TURBO PASCAL 4.0 DIRECTORY TEXT LIST UTILITY

==========================================================================
}

program DIRTExt;

{DIR + automatic comments of .PAS files.                                      }
{SHORT dir prints 2nd to 43rd characters of 3rd line of .PAS .INC files.      }
{LONG prints entire 3rd, 4th and 5th lines of .PAS .INC files                 }
{                                                                             }
{   DIRTE DIRECTORY                                                           }
{   Idea for Self-Documentating PASCAL directories was conceived and          }
{   implemented by:                                                           }
{                    Phil Somers                                              }
{                    258 Wilkes Court                                         }
{                    Beavercreek, Ohio                                        }
{                    45385                                                    }
{                                                                             }
{   This program is an adaptation of an excellent directory program called    }
{   DIRLIST.PAS written by David W. Terry  4/29/85 . Much of his program is   }
{   intact in this program. However, I don't know David because he left only  }
{   his name with his program.                                                }
{                                                                             }
{   The name DIRTE comes from DIRectory plus TExt. It could also be           }
{   DIrectory TErry.                                                          }
{                                                                             }
{   This program is released to PUBLIC DOMAIN in hopes of the following:      }
{     1.  That it will encourage a standard PASCAL documentation style.       }
{     2.  That PASCAL programs may become easier to catalog.                  }
{     3.  That DIRTE DIRECTORY will be modified and enhanced.                 }
{                                                                             }
{   How best to document for DIRTE DIRECTORY:                                 }
{     1. Line 3 should start with a left brace followed by 42 letters         }
{        concisely describing the PASCAL program.                             }
{     2. The rest of line 3, and all of line 4 and line 5 should further      }
{        describe the program, in detail.                                     }
{     3. All three lines start and end with left and right braces.            }
{     4. The right braces should be in column 79 or less (NOT in 80).         }
{     5. All three lines should be filled, or at least have braces.           }
{                                                                             }
{   Suggested Modifications:                                                  }
{     1. Make it possible to select the drive to list. Currently DIRTE.COM    }
{        must be on the drive to list, or it is invoked from the drive to     }
{        list. For example, to get directory of drive B: with DIRTE.COM on    }
{        drive B: and drive B: being the default drive, simply type           }
{        DIRTE .  If you want a listing of drive A: when DIRTE.COM is on      }
{        drive B:, go to drive A: and type B:DIRTE .                          }
{     2. DIRTE DIRECTORY could be used with any text files, not just PASCAL   }
{        The only requirement is that lines 3,4,and 5 contain the info        }
{        in ASCII printable characters.                                       }
{     3. Perhaps the folks who write the ARC utilities could find a way       }
{        to leave lines 3,4 and 5 oftheir README.DOC file in ASCII.           }
{     4. An easy enhancement would be to provide a condensed printout for     }
{        diskette labels. Currently, hardcopy is full size.                   }
{                                                                             }
{     REQUEST:                                                                }
{        If you modify DIRTE DIRECTORY, please stick to the standard of having}
{        the comments on lines 3, 4, and 5, as described. This way, any       }
{        version of DIRTE DIRECTORY will be able to read all PASCAL files     }
{        that follow that convention. It is also a sensible way to document   }
{        your PASCAL files anyway.                                            }
{                                                                             }
{        If you produce a nice enhancement, please send me a listing or a copy}
{        at the address above, or at WAREHOUSE RBBS, Dayton, Ohio , phone     }
{        513-258-0020. At least, release it to public domain.                 }
{                                                                             }



Uses
  Crt,
  Dos,
  Printer;

type
  str2  = string[2];
  str6  = string[6];
  str9  = string[9];
  str15 = string[15];
  FileList = array[1..128] of record
               Name: string[13];
               Attrib: byte;
               Size: real;
               Date,Time: str9;
               end;
var
  List: filelist;
  FileMask: str15;
  X,total: byte;
  recpack: Registers;
  lineone: string[80];
  Oldname : array[1..128] of string[12];
  FileName: text;
  Lines : integer;
  Extend : char;

procedure Directory(FileMask: str15; var List: FileList; var Total: byte);
var Dta: string[44];

function FileSize: real;           { decypher the File's Size in Bytes }
var Size: real;
    Byte1,Byte2,Byte3,Byte4: byte;
begin
  Byte1:=ord(dta[28]);    { the assignments 'Bytei:=ord(copy(dta,xx,1))' }
  Byte2:=ord(dta[27]);    { are modified for 4.0 compatibility  -  DSMB  }
  Byte3:=ord(dta[29]);
  Byte4:=ord(dta[30]);
  Size:=Byte1 shl 8+Byte2;
  if Size<0 then Size:=Size+65536.0;   { adjust for negative values }
  Size:=(Byte3 shl 8+Byte4)*256.0+Size;
  FileSize:=Size;
  end;  { filesize }

function FileDate: str9;         { decypher the File's Date Stamp }
var Day,Month,Year: str2;
    Temp: integer;
    Byte1,Byte2: byte;
begin
  Byte1:=ord(dta[25]);
  Byte2:=ord(dta[26]);
  str(Byte1 and 31:2,Day);
  Temp:=(Byte1 shr 5) and 7+(Byte2 and 1) shl 3;
  str(Temp:2,Month);
  str((Byte2 shr 1)+80:2,Year);
  if Day[1]=' ' then Day[1]:='0';
  if Year[1]=' ' then Year[1]:='0';
  FileDate:=Month+'-'+Day+'-'+Year;
  end;  { filedate }

function FileTime: str6;            { decypher the File's Time Stamp }
var Hour,Min: str2;
    Temp: integer;
    AmPm: char;
    Byte1,Byte2: byte;
begin
  Byte1:=ord(dta[23]);
  Byte2:=ord(dta[24]);
  Temp:=(Byte1 shr 5) and 7+(Byte2 and 7) shl 3;
  str(Temp:2,Min);
  Temp:=Byte2 shr 3;
  if Temp<13 then AmPm:='a' else begin
    Temp:=Temp-12;
    AmPm:='p';
    end;
  str(Temp:2,Hour);
  if Min[1]=' ' then Min[1]:='0';
  FileTime:=Hour+':'+Min+AmPm;
  end;  { filetime }

procedure FillRecord(RecNo: byte);        { fill List.[RecNo] with file info }
begin
  with List[RecNo] do begin
    Name:=copy(Dta,31,13);
    oldname[RecNo] := Name;
    Attrib:=ord(Dta[22]);
    Size:=FileSize;
    Date:=FileDate;
    Time:=FileTime;
    if (Name[1]<>'.') and (pos('.',Name)<>0) then begin        { line up the }
      while pos('.',Name)<9 do insert(' ',Name,pos('.',Name)); { file ext.   }
      Name[pos('.',Name)]:=' ';
      end;
    end;
  end;  { fillrecord }

procedure FillDirList;
begin
  Total:=1;
  FillRecord(Total);
  repeat
    recpack.Ax:=$4f shl 8;
    MsDos(recpack);    { compare Dos.FindNext - DSMB }
    if (recpack.Ax<>18) and (recpack.Ax<>2) then begin
      Total:=Total+1;
      FillRecord(Total);
      end;                              { repeat filling until no more }
    until (recpack.flags and 1)<>0;     { files are found              }
  end;  { filldirlist }

begin  { Directory }
  Total:=0;
  Dta:='                                           ';
  FileMask:=FileMask+#0;
  with recpack do begin                        { First, Set aside the DTA    }
    Ax:=$1a shl 8;                             { or Data Transfer Area,      }
    Ds:=Seg(Dta); Dx:=Ofs(Dta)+1;              { call $1A then call $4E to   }
    MsDos(recpack);                            { find the First Match. Set   }
    Ax:=$4e shl 8;                             { set Cx to 23 to include all }
    Ds:=Seg(FileMask); Dx:=Ofs(FileMask)+1;    { hidden files. Then up above }
    Cx:=23;                                    { call $4F to find subsequent }
    MsDos(recpack);                            { matches, filling List.      }
                { compare Dos.FindFirst - DSMB }
    if (flags and 1)=0 then FillDirList;
    end;
  end;  { directory }


procedure ShortDirectory;
begin
  lines := 1;
  for X:=1 to total do
    with List[X] do begin
      if (copy(Name,10,3) = 'PAS') or (copy(Name,10,3) = 'INC')
         then
            begin
               write(Name,Size:6:0,' ',Date:8,' ',Time:6,'  ');
               assign(Filename,OldName[x] );
               Reset(Filename);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               writeln( Copy(LineOne,2,42) );
               close(Filename);  { Added for version 3.0 compatibility - DT }
               lines := lines + 1;
               if lines > 24 then
                  begin
                    write('Press  <SPACE BAR> to continue');
                    Extend := readkey; writeln;
                    lines := 1;
                  end;
            end;
      end;
end; {ShortDirectory}


procedure LongDirectory;
begin
  lines := 1;
  for X:=1 to total do
    with List[X] do begin
      if (copy(Name,10,3) = 'PAS') or (copy(Name,10,3) = 'INC')
         then
            begin
               writeln(Name,Size:6:0,' ',Date:8,' ',Time:6,'  ');
               assign(Filename,OldName[x] );
               Reset(Filename);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               writeln(LineOne);
               readln(Filename,LineOne);
               writeln(LineOne);
               readln(Filename,LineOne);
               writeln(LineOne);
               close(Filename); { Added for version 3.0 compatibilty - DT }
               lines := lines + 5;
               if lines > 24 then
                  begin
                    Extend := readkey;
                    lines := 1;
                    clrscr;
                  end
               else writeln;
            end;
      end;
end; {LongDirectory}


procedure PrintShortDirectory;
begin
  lines := 1;
  for X:=1 to total do
    with List[X] do begin
      if (copy(Name,10,3) = 'PAS') or (copy(Name,10,3) = 'INC')
         then
            begin
               write(LST,Name,Size:6:0,' ',Date:8,' ',Time:6,'  ');
               assign(Filename,OldName[x] );
               Reset(Filename);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               writeln(LST,Copy(LineOne,2,42) );
               close(Filename);  { Added for version 3.0 compatibility - DT }
               lines := lines + 1;
               if lines > 60 then
                  begin
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    lines := 1;
                  end;
            end;
      end;
end; {PrintShortDirectory}


procedure PrintLongDirectory;
begin
  lines := 1;
  for X:=1 to total do
    with List[X] do begin
      if (copy(Name,10,3) = 'PAS') or (copy(Name,10,3) = 'INC')
         then
            begin
               writeln(LST,Name,Size:6:0,' ',Date:8,' ',Time:6,'  ');
               assign(Filename,OldName[x] );
               Reset(Filename);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               readln(Filename,LineOne);
               writeln(LST,LineOne);
               readln(Filename,LineOne);
               writeln(LST,LineOne);
               readln(Filename,LineOne);
               writeln(LST,LineOne);
               writeln(LST);
               close(Filename);  { Added for version 3.0 compatibility - DT }
               lines := lines + 5;
               if lines > 56 then
                  begin
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    writeln(LST);
                    lines := 1;
                  end
               else writeln;
            end;
      end;
end; {LongDirectory}


procedure SelectPrint;
begin
  Extend := ' ';
  while upcase(Extend) <> 'E' do
    begin
      clrscr;
      gotoxy(20,6);
      writeln('            DIRTE DIRECTORY');
      gotoxy(20,8);
      writeln('         Ensure printer is ready');
      gotoxy(10,10);
      writeln('Type <S> for SHORT,  <L>  for LONG directory,  <E> to end');
      Extend := readkey;
      if upcase(Extend) = 'S' then PrintShortDirectory;
      if upcase(Extend) = 'L' then PrintLongDirectory;
    end;
end; {SelectPrint}

begin
  clrscr;
  Gotoxy(30,10);
  Writeln('DIRTE DIRECTORY');
  TextColor(White);
  FileMask:='*.*';                               { default to all files *.* }
  Directory(FileMask,List,Total);
  clrscr;
  ShortDirectory;
  writeln;
  write(
    '<SPACE BAR> for Long Directory, <P> for Printer Options,  <C/R> to end');
  Extend := readkey;
  writeln;
  if Extend = ' ' then
     begin
       clrscr;
       LongDirectory;
     end;
  if upcase(Extend) = 'P' then
     begin
       clrscr;
       SelectPrint;
     end;
  end.

