{
                       F i l e    I n f o r m a t i o n 

* DESCRIPTION
Space displays the total and available space on the number of logical HARD
disk drives and RAM disk drives in your system specified in the command
line parameter. Version 1.2. Author: John Land, ESQ.

* ASSOCIATED FILES


* KEYWORDS
TURBO PASCAL V4.0 HARDDISK DISPLAY SPACE
==========================================================================
}
PROGRAM SPACE;

{$B-,D+,R-,S-,T+,V-}

USES DOS, CRT;

{
Ŀ
 GLOBAL VARIABLES                                   

}

CONST
  DiskAlpha : ARRAY [1..26] OF CHAR = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  Bell      = #7;                     { List of 26 drive letters }

TYPE
 Str10     = STRING[10];

VAR
  TotSize   : longint;
  TotFree   : longint;
  TotLeft   : longint;
  IndexMax  : word;
  Disk      : Longint;
  OutCRT    : TEXT;

  Time      : Array[1..4] of word;
  Date      : Array[1..4] of word;

{
Ŀ
 FUNCTION Format                                    

}

FUNCTION Format (Num : LONGINT) : Str10;

VAR
  NumStr : Str10;

BEGIN
  STR (Num,NumStr);
  IF (LENGTH (NumStr) > 6) THEN                  { Insert millions comma    }
    INSERT (',',NumStr,(LENGTH(NumStr) - 5));

  IF (LENGTH (NumStr) > 3) THEN                  { Insert thousands comma   }
    INSERT (',',NumStr,(LENGTH(NumStr) - 2));

  Format := NumStr;
END;

{
Ŀ
 PROCEDURE Usage                                    

}

PROCEDURE Usage;

CONST
  NL = #13#10;

BEGIN
  WRITELN (Bell,
'Displays the total and available space on the number of logical HARD disk',NL,
'drives and RAM disk drives in your system specified in the command line',NL,
'parameter.  If no parameter is entered, the information for the current',NL,
'drive is shown. ',NL,
'',NL,
'USAGE:     SPACE {n}',NL,
'',NL,
'where "n" is the number of drives you want shown.',NL,
'',NL);

  Halt;
END;

{
Ŀ
 PROCEDURE Get_Disk_Info                            

}

PROCEDURE Get_Disk_Info (IndexMaxV : word; VAR DiskV : longint;
                         VAR TotSize, TotFree, TotLeft : longint);

VAR
  Index  : byte;
  CurDir : string[65];
  Done   : Boolean;

BEGIN
  Done     := False;

  TotSize := 0;                                   { Init. grand totals }
  TotFree := 0;
  TotLeft := 0;

  FOR Index := 1 TO IndexMaxV DO
    BEGIN
      IF NOT Done AND (DiskSize(DiskV) > 0) THEN
        BEGIN
          IF DiskV = 0 THEN
            Done := True;

          TotSize := TotSize + DiskSize(DiskV);
          TotFree := TotFree + DiskFree(DiskV);
          TotLeft := TotSize - TotFree;

          IF DiskV <> 0 THEN                       { Convert num. to alpha    }
            WRITE (OutCRT, DiskAlpha[DiskV])       { for drive designator     }
          ELSE
            BEGIN                                  { Get cur. drive letter if }
              GETDIR (0,CurDir);                   { default is active        }
              WRITE (OutCRT, CurDir[1]);
           END;
                                                   { Write out drive info     }
          WRITELN (OutCRT, ': >  ',Format (DiskSize(DiskV)):11, '    ',
                  Format (DiskSize (DiskV) - DiskFree(DiskV)):11, '     ',
                  Format (DiskFree(DiskV)):11);


          INC (DiskV);                             { Get next drive           }
       END;
     END;
END;

{
Ŀ
 FUNCTION Year                                      

}

FUNCTION Year : Str10;

VAR
  YearVal : str10;

BEGIN
  GETDATE (Date[1],Date[2],Date[3],Date[4]);

  STR (Date[1],YearVal);
  Year := YearVal
END;

{
Ŀ
 FUNCTION Month                                     

}

FUNCTION Month : Str10;

CONST
  MonthList : Array [1..12] of Str10 =
              ('January','February','March','April','May','June','July',
              'August','September','October','November','December');

BEGIN
  GETDATE (Date[1],Date[2],Date[3],Date[4]);

  Month := MonthList[Date[2]];
END;

{
Ŀ
 FUNCTION Day                                       

}

FUNCTION Day : Str10;

VAR
  DayVal : str10;

BEGIN
  GETDATE (Date[1],Date[2],Date[3],Date[4]);

  STR (Date[3],DayVal);

  IF (LENGTH(DayVal) = 1) THEN      { Pad if necessary }
    Day := ' ' + DayVal
  ELSE
    Day := DayVal;
END;

{
Ŀ
 FUNCTION DayOfWeek                                 

}

FUNCTION DayOfWeek : Str10;

CONST
  DayList : Array [0..6] of Str10 =
            ('Sunday','Monday','Tuesday','Wednesday',
             'Thursday','Friday','Saturday');

BEGIN
  GETDATE (Date[1],Date[2],Date[3],Date[4]);

  DayOfWeek := DayList[Date[4]];
END;

{
Ŀ
 FUNCTION Hours                                     

}

FUNCTION Hours : Str10;

VAR
  HourVal  : str10;

BEGIN
  GETTIME (Time[1],Time[2],Time[3],Time[4]);

  IF Time[1] > 12 THEN
    Time[1]  := Time[1] - 12;
  STR (Time[1],HourVal);

  IF LENGTH(HourVal) = 1 THEN
    Hours := ' ' + HourVal   { Pad hours if necessary }
  ELSE
    Hours := HourVal;
END;

{
Ŀ
 FUNCTION Minutes                                   

}

FUNCTION Minutes : Str10;

VAR
  MinVal   : str10;

BEGIN
  GETTIME (Time[1],Time[2],Time[3],Time[4]);

  STR (Time[2],MinVal);
  IF LENGTH(MinVal) = 1 THEN
    Minutes := '0' + MinVal   { Pad minutes if necessary }
  ELSE
    Minutes := MinVal;
END;

{
Ŀ
 FUNCTION Meridian                                  

}

FUNCTION Meridian : Str10;

BEGIN
  GETTIME (Time[1],Time[2],Time[3],Time[4]);

  IF Time[1] > 12 THEN
    Meridian := ' pm'
  ELSE
    Meridian := ' am';
END;

{
Ŀ
 PROCEDURE Header                                   

}

PROCEDURE Header;

VAR
  MonthYear : string[20];

BEGIN
  WRITELN (OutCRT);
  WRITE   (OutCRT, DayOfWeek);
  MonthYear := Month + ' ' + Day + ', ' + Year;
  GOTOXY  (ROUND((50 - LENGTH(MonthYear))/2),WhereY); { Center date              }
  WRITE   (OutCRT, MonthYear);
  GOTOXY  (43,WhereY);
  WRITELN (OutCRT, Hours + ':' + Minutes + Meridian:8);
  WRITELN (OutCRT, '');
  WRITELN (OutCRT, 'DRIVE   TOTAL SPACE      ALLOCATED      FREE SPACE');
  WRITELN (OutCRT, '');
  WRITELN (OutCRT);
END;

{
Ŀ
 PROCEDURE Write_Totals                             

}

PROCEDURE Write_Totals (DiskV : Byte; TotSize, TotFree, Totleft : longint);

BEGIN
  IF DiskV = 1 THEN                              { Don't show totals if     }
    BEGIN                                        { only getting cur. drive  }
      WRITELN (OutCRT);                          { info.                    }
      WRITELN (OutCRT, '');
    END
  ELSE
    BEGIN
      WRITELN (OutCRT);
      WRITELN (OutCRT, '');
      WRITELN (OutCRT, 'TOTALS: ',Format (TotSize):11, '    ',
               Format (TotLeft):11, '     ', Format (TotFree):11);
    END;
END;

{
Ŀ
 PROCEDURE Read_Params                              

}

PROCEDURE Read_Params (VAR IndexMaxV : word; VAR DiskV : longint);

VAR
  Result   : integer;
  CurDir   : String[65];

BEGIN
  IF ParamCount > 0 THEN
    BEGIN
      IF (ParamStr(1) = '?') OR (ParamStr(1) = '/?') THEN
        Usage
      ELSE
        BEGIN
          VAL (ParamStr(1),IndexMaxV,Result);
          IF Result <> 0 THEN
            BEGIN
             SOUND (760);
              DELAY (60);
              NOSOUND;
              WRITELN (OutCRT, 'Please enter in the NUMBER of drives you want to see.');
              HALT;
            END;
          GETDIR (0,CurDir);
          DiskV := ORD (CurDir[1]) - 64;            {convert drv. letter to no.}
          IF DiskV >= 3 THEN
            DiskV := 3;
          IF IndexMaxV <= 0 THEN
            BEGIN
              IndexMaxV := 1;
              DiskV     := 0;
            END;
        END;
    END
  ELSE
    BEGIN
      IndexMaxV := 1;
      DiskV     := 0;
    END;
END;

{
Ŀ
 MAIN PROGRAM                                       

}

VAR
  Version : string;

BEGIN

  Version  := 'Version 1.2, 8-8-88 -- Public Domain by John Land';
                                                 { Sticks in EXE file       }

  AssignCRT (OutCRT);
  ReWrite   (OutCRT);

  ClrScr;

  Read_Params (IndexMax, Disk);

  Header;

  Get_Disk_Info (IndexMax, Disk, TotSize, TotFree, Totleft);
                                                 { Get disk size info       }

  Write_Totals (Disk, TotSize, TotFree, Totleft);

  Close (OutCRT);

END.
