{
                       F i l e    I n f o r m a t i o n 

* DESCRIPTION
Mouse version 2.2 is a general purpose mouse unit that can be used in text
or graphics mode. It is not limited to a particular type of display. It
does require that you have a mouse driver loaded in your computer.
Author: Michael Day.

* ASSOCIATED FILES

* KEYWORDS TURBO PASCAL V4.0 MOUSE TEXT MENU EGA CGA GRAPHICS 
========================================================================== } 

Unit Mouse;

{***************************************************************************}
{*              Mouse - Turbo Pascal Mouse Unit Version 2.2                *}
{*                      by Michael Day  09/15/88                           *}
{*                                                                         *}
{*    Based on the Mouse4 unit developed by Richard Sadowsky 11/20/87      *}
{*           Graphics cursor procedure borrowed from EgaMouse              *}
{*                    by Eduardo Martins 02/02/88                          *}
{*                                                                         *}
{*           This program is released to the public domain                 *}
{*                                                                         *}
{*        This program assumes that you have a MS (or compatible)          *}
{*                 mouse driver installed on the computer.                 *}
{*                                                                         *}
{***************************************************************************}

Interface

Uses DOS;


{---------------------------------------------------------------------------}
{Externally accessable constants}

const

  LeftButton   = 1;                                    {what the buttons are}
  RightButton  = 2;
  CenterButton = 4;

  Standard     = 1;                              {graphic cursor definitions}
  UpArrow      = 2;
  DownArrow    = 3;
  LeftArrow    = 4;
  RightArrow   = 5;
  CheckMark    = 6;
  UpHand       = 7;
  DownHand     = 8;
  LeftHand     = 9;
  RightHand    = 10;
  StopHand     = 11;
  HourGlass    = 12;
  DiagCross    = 13;
  RectCross    = 14;
  RectBox      = 15;
  TargetCross  = 16;
  TargetCircle = 17;
  TargetBox    = 18;
  QuestionMark = 19;

  MaxMouseCursorShape = 19;

{---------------------------------------------------------------------------}
{Externally accessable variables}

var

  Mouse_Installed    : Boolean;   {InitMouse - True if mouse is operable}
  Mouse_Error        : Integer;   {InitMouse - Error code}
  Mouse_Type         : Integer;   {InitMouse - Mouse Type}

  Mouse_Clicked      : Boolean;   {ReadMouse - True if button was clicked}
  Mouse_Buttons      : Word;      {ReadMouse - Current mouse button status}
  Mouse_Click_Button : Word;      {ReadMouse - Click button status}
  MouseX             : Word;      {ReadMouse - Mouse Text X Position}
  MouseY             : Word;      {ReadMouse - Mouse Text Y Position}
  Click_MouseX       : Word;      {ReadMouse - Text X Click Position}
  Click_MouseY       : Word;      {ReadMouse - Text Y Click Position}
  Real_MouseX        : Word;      {ReadMouse - Real mouse X Position}
  Real_MouseY        : Word;      {ReadMouse - Real mouse Y Position}

  MouseTextWidth     : Word;      {size of text on screen for mouse}
  MouseTextHeight    : Word;

{---------------------------------------------------------------------------}
type
     MaskType = record                      {mouse graphic cursor definition}
                  Def: array [0..1, 0..15] of word;     {graphics cursor def}
                  HotX, HotY: integer;                       { hot spot X,Y }
                end;

{---------------------------------------------------------------------------}
{Note: You must set the MouseTextWidth and MouseTextHeight values}
{to the current character pixel width and height to properly use the}
{mouse text X,Y coordinate system. Startup Default is 8x8.}
{To start up the mouse you should do the following: }
{InitMouse; ReadMouse; ShowMouse; - This insures that the mouse is}
{properly setup and ready to run. }

{For more information on the mouse interface and programming with }
{with a mouse refer to the MicroSoft Mouse Programmer's Reference Guide}
{Available from MicroSoft Corporation.}

{Warning: All mouse drivers are not created equal. I've experienced some}
{problems with non-MS mouse drivers (such as Logitec which had trouble}
{with the MouseAreaHide function) so be careful with the mice you use.}

{---------------------------------------------------------------------------}
{ Function 0 - Initialize mouse software and hardware }
procedure InitMouse;

{---------------------------------------------------------------------------}
{ Function 1 - show mouse cursor }
procedure ShowMouse;

{---------------------------------------------------------------------------}
{ Function 2 - hide mouse cursor }
procedure HideMouse;

{---------------------------------------------------------------------------}
{ Function 3 - read mouse position and button status }
procedure ReadMouse;

{---------------------------------------------------------------------------}
{ function 4 - sets mouse position }
{ X and Y values are scaled for text }
procedure SetMousePosition(X, Y : Word);

{---------------------------------------------------------------------------}
{ function 4 - sets mouse position }
{ X and Y values are scaled for graphics }
procedure SetMousePoint(X, Y : Word);

{---------------------------------------------------------------------------}
{ function 5 - gets button press information  }
{ X and Y values are scaled for text }
function MousePress(button: Word;
                     var count, lastx, lasty: Word): Word;

{---------------------------------------------------------------------------}
{ function 6 - gets button release information  }
{ X and Y values are scaled for text }
function MouseRelease(button: Word;
                       var count, lastx, lasty: Word): Word;

{---------------------------------------------------------------------------}
{ functions 7 and 8 - sets area where the mouse is allowed to run }
{ X and Y values are scaled for text }
procedure SetMouseArea(x1,y1,x2,y2: Word);

{---------------------------------------------------------------------------}
{ functions 7 and 8 - sets area where the mouse is allowed to run }
{ X and Y values are scaled for graphics }
procedure SetMouseBoxArea(var R);

{---------------------------------------------------------------------------}
{ function 9 - sets the graphics cursor shape }
procedure MouseGraphicCursor(Shape: integer);

{---------------------------------------------------------------------------}
{ function 9 - sets a custom graphics cursor shape }
procedure SetMouseGraphicCursor(var Mask:MaskType);

{---------------------------------------------------------------------------}
{ function 10 - sets the text cursor shape }
procedure MouseTextCursor(Select, Start, Stop: Word);

{---------------------------------------------------------------------------}
{ function 11 - Read Mouse Motion counters }
procedure ReadMickey(var X, Y: Word);

{---------------------------------------------------------------------------}
{ function 12 - Set Mouse Interrupt service routine and mask }
procedure SetMouseISR(Mask:word; var Address);

{---------------------------------------------------------------------------}
{ function 13 and 14 - Light pen emulation on/off }
procedure LightPen(Flag: boolean);

{---------------------------------------------------------------------------}
{ function 15 - sets the mickey to pixel ratio }
procedure SetPixeltoMickey(X, Y: Word);

{---------------------------------------------------------------------------}
{ function 16 - Conditional Mouse Hide - hides mouse if in text area }
procedure HideMouseArea(x1,y1,x2,y2: Word);

{---------------------------------------------------------------------------}
{ function 16 - Conditional Mouse Hide - hides mouse if in graphics area }
procedure HideMouseBoxArea(var R);

{---------------------------------------------------------------------------}
{ function 19 - Set Double Speed Threshold }
procedure MouseThreshold(Threshold:Word);

{---------------------------------------------------------------------------}
{ function 20 - Swap current Mouse ISR with a new one}
{ Returns old ISR and mask in the calling variables }
procedure SwapMouseISR(var Mask:word; var Address);

{---------------------------------------------------------------------------}
{ function 29 - Set Mouse Page }
procedure SetMousePage(Page: Word);

{---------------------------------------------------------------------------}
{ function 30 - Get Mouse Page }
function GetMousePage: Word;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{ The following procedures use the mouse functions to provide }
{ a higher level of control over the mouse }

{---------------------------------------------------------------------------}
{ checks if mouse is currently inside specified text area }
function MouseIn(x1,y1,x2,y2: Word):boolean;

{---------------------------------------------------------------------------}
{ checks if mouse is currently inside specified graphic area }
function MouseInBox(var R): boolean;

{---------------------------------------------------------------------------}
{has the mouse been clicked recently?}
function MouseClick: boolean;

{---------------------------------------------------------------------------}
{ checks if mouse was inside specified text area when clicked }
function MouseClickIn(x1,y1,x2,y2: Word): boolean;

{---------------------------------------------------------------------------}
{ checks if mouse was inside specified graphic area when clicked }
function MouseClickInBox(var R): boolean;

{---------------------------------------------------------------------------}
{Pushes current mouse status on the mouse stack}
{Returns false if not enough heap space to push}
function PushMouse: boolean;

{---------------------------------------------------------------------------}
{Pops mouse status from the mouse stack.}
function PopMouse: boolean;

{---------------------------------------------------------------------------}
{Get rid of mouse stack}
procedure ZapMouseStack;

{***************************************************************************}

implementation

{---------------------------------------------------------------------------}
{ local mouse stuff }

type
     Mrect = record
               x1,y1,x2,y2 : Word;                {defines a mouse rectangle}
             end;

     MousePtrP   = ^MousePtrRec;               {defines a mouse stack record}
     MousePtrRec = record      {Prev points to previous stack record on heap}
        Prev : MousePtrP;                {if nil then is top record on stack}
        Buf  : Pointer;                  {Buf points to the mouse data saved}
        Size : Integer;                    {Size = bytes in the mouse buffer}
     end;
                                                {array of predefined cursors}
     MGCarray = array [1..MaxMouseCursorShape] of MaskType;

{---------------------------------------------------------------------------}
var
     Mouse_Reg  : Registers;         {registers used to call mouse interrupt}
     MouseStack : MousePtrP;   {MouseStack points to last rec on mouse stack}
                                  {if nil then there is nothing on the stack}

{---------------------------------------------------------------------------}
const

  MouseCursor: MGCarray =        {a predefined list of mouse graphic cursors}

{ Standard }
 ((Def: (($3FFF,$1FFF,$0FFF,$07FF,$03FF,$01FF,$00FF,$007F,    { Screen Mask }
          $003F,$001F,$01FF,$10FF,$30FF,$F87F,$F87F,$FC7F),

         ($0000,$4000,$6000,$7000,$7800,$7C00,$7E00,$7F00,    { Cursor Mask }
          $7F80,$7C00,$6C00,$4600,$0600,$0300,$0300,$0000));

         HotX: -1; HotY: -1),                                    { Hot Spot }

{ UpArrow }
  (Def: (($F9FF,$F0FF,$E07F,$E07F,$C03F,$C03F,$801F,$801F,
          $000F,$000F,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF),

         ($0000,$0600,$0F00,$0F00,$1F80,$1F80,$3FC0,$3FC0,
          $7FE0,$0600,$0600,$0600,$0600,$0600,$0600,$0000));

         HotX: 5; HotY: 0),

{ DownArrow }
  (Def: (($F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$000F,$000F,
          $801F,$801F,$C03F,$C03F,$E07F,$E07F,$F0FF,$F9FF),

         ($0000,$0600,$0600,$0600,$0600,$0600,$0600,$7FE0,
          $3FC0,$3FC0,$1F80,$1F80,$0F00,$0F00,$0600,$0000));

         HotX: 5; HotY: 15),

{ LeftArrow }
  (Def: (($FE1F,$F01F,$0000,$0000,$0000,$F01F,$FE1F,$FFFF,
          $FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

         ($0000,$00C0,$07C0,$7FFE,$07C0,$00C0,$0000,$0000,
          $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

         HotX: 0; HotY: 3),

{ RightArrow }
  (Def: (($F87F,$F80F,$0000,$0000,$0000,$F80F,$F87F,$FFFF,
          $FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

         ($0000,$0300,$03E0,$7FFE,$03E0,$0300,$0000,$0000,
          $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

         HotX: 15; HotY: 3),

{ CheckMark }
  (Def: (($FFF0,$FFE0,$FFC0,$FF03,$0607,$000F,$001F,$C03F,
          $F07F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

         ($0000,$0006,$000C,$0018,$0030,$0060,$70C0,$1D80,
          $0700,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

         HotX: 6; HotY: 7),

{ UpHand }
  (Def: (($E1FF,$E1FF,$E1FF,$E1FF,$E000,$E000,$E000,$0000,    { Screen Mask }
          $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000),

         ($1E00,$1200,$1200,$1200,$13FF,$1249,$1249,$F249,    { Cursor Mask }
          $9001,$9001,$9001,$8001,$8001,$8001,$8001,$FFFF));

         HotX: 5; HotY: 0),                                      { Hot Spot }

{ DownHand }
  (Def: (($0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,
          $0000,$E000,$E000,$E000,$E1FF,$E1FF,$E1FF,$E1FF),

         ($FFFF,$8001,$8001,$8001,$8001,$9001,$9001,$9001,
          $F249,$1249,$1249,$13FF,$1200,$1200,$1200,$1E00));

         HotX: 5; HotY: 15),

{ LeftHand }
  (Def: (($FFFF,$FF8F,$FF07,$FF03,$FF81,$8000,$0000,$0000,
          $0000,$8000,$F000,$F800,$F800,$FC00,$FC01,$FC03),

         ($0000,$0000,$0070,$0048,$0024,$0032,$7FF2,$800A,
          $7FF6,$0412,$07F2,$0212,$03F2,$0116,$01FC,$0000));

         HotX: 0; HotY: 7),

{ RightHand }
  (Def: (($FFFF,$F1FF,$E0FF,$C0FF,$81FF,$0001,$0000,$0000,
          $0000,$0001,$000F,$001F,$001F,$003F,$803F,$C03F),

         ($0000,$0000,$0E00,$1200,$2400,$4C00,$4FFE,$5001,
          $6FFE,$4820,$4FE0,$4840,$4FC0,$6880,$3F80,$0000));

         HotX: 15; HotY: 7),

{ StopHand }
  (Def: (($FE3F,$F80F,$F007,$F003,$F001,$F001,$0001,$0001,
          $0001,$0001,$8001,$C001,$C001,$E003,$F007,$F80F),

         ($0000,$01C0,$0770,$0550,$055C,$0554,$0554,$7554,
          $5554,$4FFC,$2804,$1004,$180C,$0C18,$07F0,$0000));

         HotX: 7; HotY: 7),

{ HourGlass }
  (Def: (($0000,$0000,$0000,$0000,$8001,$C003,$E007,$F00F,
          $E007,$C003,$8001,$0000,$0000,$0000,$0000,$FFFF),

         ($0000,$7FFE,$6006,$300C,$1818,$0C30,$0660,$03C0,
          $0660,$0C30,$1998,$33CC,$67E6,$7FFE,$0000,$0000));

         HotX: 7; HotY: 7),

{ DiagCross }
  (Def: (($07E0,$0180,$0000,$C003,$F00F,$C003,$0000,$0180,
          $07E0,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

         ($0000,$700E,$1C38,$0660,$03C0,$0660,$1C38,$700E,
          $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

         HotX: 7; HotY: 4),

{ RectCross }
  (Def: (($FC3F,$FC3F,$FC3F,$0000,$0000,$0000,$FC3F,$FC3F,
          $FC3F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF),

         ($0000,$0180,$0180,$0180,$7FFE,$0180,$0180,$0180,
          $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000));

         HotX: 7; HotY: 4),


  { these cursors need to be updated yet }
{ RectBox }
  (Def: (($FFFF,$FFFF,$0000,$0000,$0000,$1FF8,$1FF8,$1FF8,
          $1FF8,$1FF8,$1FF8,$1FF8,$0000,$0000,$0000,$FFFF),

         ($0000,$0000,$0000,$7FFE,$4002,$4002,$4002,$4002,
          $4002,$4002,$4002,$4002,$4002,$7FFE,$0000,$0000));

         HotX: 7; HotY: 8),

{ TargetCross }
  (Def: (($FFFF,$FFFF,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$06C1,
          $0101,$06C1,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$FFFF),

         ($0000,$0000,$0000,$0100,$0100,$0100,$0100,$0000,
          $783C,$0000,$0100,$0100,$0100,$0100,$0000,$0000));

         HotX: 7; HotY: 4),

{ TargetCircle }
  (Def: (($FFFF,$FFFF,$F01F,$C007,$8003,$0001,$0C61,$06C1,
          $0101,$06C1,$0C61,$0001,$8003,$C007,$F01F,$FFFF),

         ($0000,$0000,$0000,$07C0,$1D30,$3118,$610C,$600C,
          $783C,$600C,$610C,$3118,$1D30,$07C0,$0000,$0000));

         HotX: 7; HotY: 8),

{ TargetBox }
  (Def: (($FFFF,$FFFF,$0001,$0001,$0001,$1C71,$1C71,$06C1,
          $0101,$06C1,$1C71,$1C71,$0001,$0001,$0001,$FFFF),

         ($0000,$0000,$0000,$7FFC,$4104,$4104,$4104,$4004,
          $783C,$4004,$4104,$4104,$4104,$7FFC,$0000,$0000));

         HotX: 7; HotY: 8),

{ QuestionMark }
  (Def: (($FFFF,$E00F,$C007,$8003,$0001,$0001,$0001,$0001,
          $0001,$0001,$0001,$0001,$0001,$8003,$C007,$E00F),

         ($0000,$0000,$1FF0,$3FF8,$783C,$739C,$739C,$7F3C,
          $7E7C,$7E7C,$7FFC,$7E7C,$7E7C,$3FF8,$1FF0,$0000));

         HotX: 7; HotY: 7));


{---------------------------------------------------------------------------}
{ an inline function to limit an integer between min and max values}
function IntLimit(Val,Min,Max: integer): integer;
Inline(
   $58        {  pop AX}
  /$5B        {  pop BX}
  /$59        {  pop CX}
  /$39/$C8    {  cmp AX,CX}
  /$7C/$08    {  jl done}
  /$89/$D8    {  mov AX,BX}
  /$39/$C8    {  cmp AX,CX}
  /$7F/$02    {  jg done}
  /$89/$C8);  {  mov AX,CX}
              {done:}

{***************************************************************************}
{ Function 0 - Initialize mouse software and hardware }

procedure InitMouse;
begin
  Mouse_Reg.AX := 0;              {tell the mouse to start over from scratch}
  Intr($33,Mouse_Reg);
  Mouse_Error := Mouse_Reg.AX;
  Mouse_Type := Mouse_Reg.BX;
  Mouse_Installed := Mouse_Error = -1;      {<-- check if mouse is out there}
end;

{---------------------------------------------------------------------------}
{ function 1 - show mouse cursor }

procedure ShowMouse;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 1;
  Intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 2 - hide mouse cursor }

procedure HideMouse;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 2;
  Intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 3 - read current mouse position and button status }
{ X and Y values are scaled for text }

procedure ReadMouse;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 3;
  Intr($33,Mouse_Reg);                         {Get the current mouse status}
  with Mouse_Reg do
  begin
    Real_MouseX := CX;                       {save real mouse X and Y values}
    Real_MouseY := DX;
    MouseX := (CX div MouseTextWidth);         {save the X and Y coordinates}
    MouseY := (DX div MouseTextHeight);
    if (BX <> Mouse_Buttons) and (BX <> 0) then        {<-- new button down?}
    begin
      Mouse_Click_Button := BX;               {if button down save which one}
      Click_MouseX := MouseX;                           {and the current X,Y}
      Click_MouseY := MouseY;
      Mouse_Clicked := true;                       {tell them it was clicked}
    end;
    Mouse_Buttons := BX;                 {<-- save the current button status}
  end;
end;

{---------------------------------------------------------------------------}
{ function 4 - sets mouse position }
{ X and Y values are scaled for text }

procedure SetMousePosition(X,Y: Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 4;
  Mouse_Reg.CX := (X*MouseTextWidth);                {tell mouse where to go}
  Mouse_Reg.DX := (Y*MouseTextHeight);
  intr($33,Mouse_Reg);
  MouseX := X;                                            {update local vars}
  MouseY := Y;
end;

{---------------------------------------------------------------------------}
{ function 4 - sets mouse position }
{ X and Y values are scaled for graphics}

procedure SetMousePoint(X,Y: Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 4;
  Mouse_Reg.CX := X;                                 {tell mouse where to go}
  Mouse_Reg.DX := Y;
  intr($33,Mouse_Reg);
  MouseX := X div MouseTextWidth;                         {update local vars}
  MouseY := Y div MouseTextHeight;
end;

{---------------------------------------------------------------------------}
{ function 5 - gets button press information  }
{ X and Y values are scaled for text }

function MousePress(button: Word;
                    var count, lastx, lasty: Word): Word;
begin
  if Mouse_Installed then                          {check if mouse installed}
  begin
    Mouse_Reg.AX := 5;
    Mouse_Reg.BX := button;                      {request info on the button}
    intr($33,Mouse_Reg);
    MousePress := Mouse_Reg.AX;
    count := Mouse_Reg.BX;                   {return the info for the button}
    lastx := (Mouse_Reg.CX div MouseTextWidth);
    lasty := (Mouse_Reg.DX div MouseTextHeight);
  end
  else
  begin
    MousePress := 0;              {if no mouse everything comes back as zero}
    lastx := 0;
    lasty := 0;
    count := 0;
  end;
end;

{---------------------------------------------------------------------------}
{ function 6 - gets button release information  }
{ X and Y values are scaled for text }

function MouseRelease(button: Word;
                       var count, lastx, lasty: Word): Word;
begin
  if Mouse_Installed then                          {check if mouse installed}
  begin
    Mouse_Reg.AX := 6;
    Mouse_Reg.BX := button;                      {request info on the button}
    intr($33,Mouse_Reg);
    MouseRelease := Mouse_Reg.AX;
    count := Mouse_Reg.BX;                   {return the info for the button}
    lastx := (Mouse_Reg.CX div MouseTextWidth);
    lasty := (Mouse_Reg.DX div MouseTextHeight);
  end
  else
  begin
    MouseRelease := 0;            {if no mouse everything comes back as zero}
    lastx := 0;
    lasty := 0;
    count := 0;
  end;
end;

{---------------------------------------------------------------------------}
{ functions 7 and 8 - sets area where the mouse is allowed to run }
{ X and Y values are scaled for text }

procedure SetMouseArea(x1,y1,x2,y2: Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 7;
  Mouse_Reg.CX := (x1*MouseTextWidth);                       {set the X values}
  Mouse_Reg.DX := (x2*MouseTextWidth);
  intr($33,Mouse_Reg);
  Mouse_Reg.AX := 8;
  Mouse_Reg.CX := (y1*MouseTextHeight);                      {set the Y values}
  Mouse_Reg.DX := (y2*MouseTextHeight);
  intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ functions 7 and 8 - sets area where the mouse is allowed to run }
{ X and Y values are scaled for graphics }

procedure SetMouseBoxArea(var R);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 7;
  Mouse_Reg.CX := Mrect(R).x1;                             {set the X values}
  Mouse_Reg.DX := Mrect(R).x2;
  intr($33,Mouse_Reg);
  Mouse_Reg.AX := 8;
  Mouse_Reg.CX := Mrect(R).y1;                             {set the Y values}
  Mouse_Reg.DX := Mrect(R).y2;
  intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 9 - sets a custom graphics cursor shape }

procedure SetMouseGraphicCursor(var Mask:MaskType);
begin
   if not(Mouse_Installed) then Exit;           {<-- can't do this, no mouse}
   Mouse_Reg.AX := 9;
   Mouse_Reg.BX := Mask.HotX;                            { set the Hot Spot }
   Mouse_Reg.CX := Mask.HotY;
   Mouse_Reg.ES := seg(Mask.Def);
   Mouse_Reg.DX := ofs(Mask.Def);                { set the new cursor shape }
   Intr($33, Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 9 - sets the graphics cursor shape }
{ Graphic cursor routine borrowed from EGAMouse }

procedure MouseGraphicCursor(Shape:integer);
begin
   if not(Mouse_Installed) then Exit;           {<-- can't do this, no mouse}
   with MouseCursor[IntLimit(Shape,1,MaxMouseCursorShape)] do
   begin
     Mouse_Reg.AX := 9;
     Mouse_Reg.BX := HotX;                               { set the Hot Spot }
     Mouse_Reg.CX := HotY;
     Mouse_Reg.ES := seg(Def);
     Mouse_Reg.DX := ofs(Def);                   { set the new cursor shape }
     Intr($33, Mouse_Reg);
   end;
end;

{---------------------------------------------------------------------------}
{ function 10 - sets the text cursor shape }

procedure MouseTextCursor(Select, Start, Stop: Word);
begin
   if not(Mouse_Installed) then Exit;           {<-- can't do this, no mouse}
   Mouse_Reg.AX := 10;
   Mouse_Reg.BX := Select;                           {select the cursor type}
   Mouse_Reg.CX := Start;                         {and the start/stop values}
   Mouse_Reg.DX := Stop;                           {(or screen/cursor masks)}
   Intr($33, Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 11 - Read Mouse Motion counters }

procedure ReadMickey(var X, Y: Word);
begin
  if Mouse_Installed then                          {check if mouse installed}
  begin
    Mouse_Reg.AX := 11;
    Intr($33, Mouse_Reg);
    X := Mouse_Reg.CX;                                 {return mickey values}
    Y := Mouse_Reg.DX;
  end
  else
  begin
    X := 0;                                  {if no mouse return zero values}
    Y := 0;
  end;
end;

{---------------------------------------------------------------------------}
{ function 12 - Set Mouse Interrupt service routine and mask }

procedure SetMouseISR(Mask:word; var Address);
type Arec = record Lo, Hi: Word; end;
var A : Arec absolute Address;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.CX := Mask;                        {<-- set the ISR service mask}
  Mouse_Reg.ES := A.Hi;
  Mouse_Reg.DX := A.Lo;                         {set the ISR service address}
  Mouse_Reg.AX := 12;
  Intr($33, Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 13 and 14 - Light pen emulation on/off }

procedure LightPen(Flag:boolean);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  if Flag then
    Mouse_Reg.AX := 13                           {set light pen emulation on}
  else
    Mouse_Reg.AX := 14;                         {set light pen emulation off}
  Intr($33,Mouse_Reg)
end;


{---------------------------------------------------------------------------}
{ function 15 - sets the mickey to pixel ratio }

procedure SetPixeltoMickey(X, Y: Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 15;
  Mouse_Reg.CX := X;                              {set the new mickey values}
  Mouse_Reg.DX := Y;
  Intr($33,Mouse_Reg)
end;


{---------------------------------------------------------------------------}
{ function 16 - Conditional Mouse Hide - hides mouse if in text area }
{ use ShowMouse after using this function - just like regular HideMouse }

procedure HideMouseArea(x1,y1,x2,y2: Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 16;
  Mouse_Reg.CX := (x1*MouseTextWidth);                 {set the X and Y values}
  Mouse_Reg.DX := (x2*MouseTextWidth);
  Mouse_Reg.SI := (y1*MouseTextHeight);
  Mouse_Reg.DI := (y2*MouseTextHeight);
  intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 16 - Conditional Mouse Hide - hides mouse if in graphics area }
{ use ShowMouse after using this function - just like regular HideMouse }

procedure HideMouseBoxArea(var R);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 16;
  Mouse_Reg.CX := Mrect(R).x1;                       {set the X and Y values}
  Mouse_Reg.DX := Mrect(R).x2;
  Mouse_Reg.SI := Mrect(R).y1;
  Mouse_Reg.DI := Mrect(R).y2;
  intr($33,Mouse_Reg);
end;

{---------------------------------------------------------------------------}
{ function 19 - Set Double Speed Threshold }

procedure MouseThreshold(Threshold:Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 19;
  Mouse_Reg.DX := Threshold;                    {set the new threshold value}
  Intr($33,Mouse_Reg)
end;


{---------------------------------------------------------------------------}
{ function 20 - Swap current Mouse ISR with a new one}
{ Returns old ISR and mask in the calling variables }

procedure SwapMouseISR(var Mask:word; var Address);
type Arec = record Lo, Hi: Word; end;
var A : Arec absolute Address;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.CX := Mask;                        {<-- set new ISR service mask}
  Mouse_Reg.ES := A.Hi;
  Mouse_Reg.DX := A.Lo;                         {set new ISR service address}
  Mouse_Reg.AX := 20;
  Intr($33,Mouse_Reg);
  Mask := Mouse_Reg.CX;                        {<-- Get old ISR service mask}
  A.Hi := Mouse_Reg.ES;
  A.Lo := Mouse_Reg.DX;                         {Get old ISR service address}
end;

{---------------------------------------------------------------------------}
{ function 29 - Set Mouse Page }

procedure SetMousePage(Page:Word);
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 29;
  Mouse_Reg.BX := Page;                         {set the new threshold value}
  Intr($33,Mouse_Reg)
end;

{---------------------------------------------------------------------------}
{ function 30 - Get Mouse Page }

function GetMousePage:Word;
begin
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 29;
  Intr($33,Mouse_Reg);
  GetMousePage := Mouse_Reg.BX;                 {get the new threshold value}
end;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}
{ The following procedures use the mouse functions to provide }
{ a higher level of control over the mouse }

{---------------------------------------------------------------------------}
{Check if mouse is currently in the specified area}
{returns true if it is, false if not}
{ X and Y values scaled for text mode }

function MouseIn(x1,y1,x2,y2:word):boolean;
begin
   MouseIn := false;               {<-- assume it won't be in the area first}
   if not(Mouse_Installed) then Exit;           {<-- can't do this, no mouse}
   ReadMouse;                              {<-- find out where thhe mouse is}
   if (MouseX >= x1) and
      (MouseX <= x2) and                         {check if it is in the area}
      (MouseY >= y1) and
      (MouseY <= y2)
     then MouseIn := true;                         {<-- return true if it is}
end;


{---------------------------------------------------------------------------}
{ Check if mouse is currently in the specified box area }
{ Returns true if it is, false if not }
{ X and Y values are scaled for graphics }

function MouseInBox(var R):boolean;
begin
   MouseInBox := false;            {<-- assume it won't be in the area first}
   if not(Mouse_Installed) then Exit;           {<-- can't do this, no mouse}
   ReadMouse;                              {<-- find out where thhe mouse is}
   if (MouseX * MouseTextWidth >= Mrect(R).x1) and
      (MouseX * MouseTextWidth <= Mrect(R).x2) and   {check if in the box area}
      (MouseY * MouseTextHeight >= Mrect(R).y1) and
      (MouseY * MouseTextHeight <= Mrect(R).y2)
     then MouseInBox := true;                      {<-- return true if it is}
end;


{---------------------------------------------------------------------------}
function MouseClick:boolean;           {has the mouse been clicked recently?}
begin
    MouseClick := Mouse_Clicked;             {get a copy of the click status}
    Mouse_Clicked := false;                           {then clear the status}
end;

{---------------------------------------------------------------------------}
{Check if mouse was in the specified area when clicked.}
{Returns true if it was, false if not.}
{ X and Y values scaled for text mode }

function MouseClickIn(x1,y1,x2,y2:word):boolean;
begin
  MouseClickIn := false;
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  if (Click_MouseX >= x1) and
     (Click_MouseX >= x2) and                    {check if it is in the area}
     (Click_MouseY >= y1) and
     (Click_MouseY <= y2)
    then MouseClickIn := true;                     {<-- return true if it is}
end;

{---------------------------------------------------------------------------}
{Check if mouse was in the specified area when clicked.}
{Returns true if it was, false if not.}
{ X and Y values are scaled for graphics }

function MouseClickInBox(var R):boolean;
begin
  MouseClickInBox := false;
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  if (Click_MouseX * MouseTextWidth >= Mrect(R).x1) and
     (Click_MouseX * MouseTextWidth <= Mrect(R).x2) and
     (Click_MouseY * MouseTextHeight >= Mrect(R).y1) and {check if in box area}
     (Click_MouseY * MouseTextHeight <= Mrect(R).y2)
    then MouseClickInBox := true;                  {<-- return true if it is}
end;

{---------------------------------------------------------------------------}
function PushMouse:boolean;  {Pushes current mouse status on the mouse stack}
var Ptemp : MousePtrP;       {Returns false if not enough heap space to push}

begin
  PushMouse := false;                      {<-- assume no good to begin with}
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  Mouse_Reg.AX := 21;                        {find out how much data to save}
  intr($33,Mouse_Reg);                 {then check to see if it can be saved}
  If MaxAvail < ( Mouse_Reg.bx + sizeof(MousePtrRec) ) then Exit;
  Ptemp := MouseStack;                           {<-- save old stack pointer}
  GetMem(MouseStack,sizeof(MousePtrRec));      {<-- get a new pointer record}
  with MouseStack^ do
  begin
    Prev := Ptemp;                            {<-- link in old stack pointer}
    Size := Mouse_Reg.bx;                      {<-- save how big the data is}
    GetMem(Buf,Size);               {<-- grab some buffer space for the data}
    Mouse_Reg.AX := 22;
    Mouse_Reg.ES := seg(Buf^);            {save the Mouse data in the buffer}
    Mouse_Reg.DX := ofs(Buf^);
    intr($33,Mouse_Reg);
  end;
  PushMouse := true;                               {<-- tell them we made it}
end;

{---------------------------------------------------------------------------}
function PopMouse:boolean;          {Pops mouse status from the mouse stack.}
var Ptemp : MousePtrP;                     {Returns false if nothing to pop.}

begin
  PopMouse := false;                       {<-- assume no good to begin with}
  if not(Mouse_Installed) then Exit;            {<-- can't do this, no mouse}
  If MouseStack = nil then Exit;            {<-- Nothing in the stack to pop}
  with MouseStack^ do
  begin
    Mouse_Reg.AX := 23;
    Mouse_Reg.ES := seg(Buf^);            {restore mouse data from the stack}
    Mouse_Reg.DX := ofs(Buf^);
    intr($33,Mouse_Reg);
    Ptemp := Prev;                              {<-- unlink the prev pointer}
    FreeMem(Buf,Size);                           {and free up the heap space}
    FreeMem(MouseStack,sizeof(MousePtrRec));
    MouseStack := Ptemp;                            {<-- update stack pointer}
  end;
  PopMouse := true;                                {<-- tell them we made it}
end;

{---------------------------------------------------------------------------}
procedure ZapMouseStack;                             {Get rid of mouse stack}
var Ptemp : MousePtrP;

begin
   While MouseStack <> nil do               {pop the stack until it is empty}
     with MouseStack^ do
     begin
       Ptemp := Prev;                           {<-- unlink the prev pointer}
       FreeMem(Buf,Size);                        {and free up the heap space}
       FreeMem(MouseStack,sizeof(MousePtrRec));
       MouseStack := Ptemp;                         {<-- update stack pointer}
     end;
end;

{***************************************************************************}
{Initialization section}

begin
  MouseTextWidth  := 8;                    {size of text on screen for mouse}
  MouseTextHeight := 8;
  MouseStack := nil;
  Mouse_Installed := false;
  Mouse_Buttons := 0;
  Mouse_Click_Button := 0;
  MouseX := 1;
  MouseY := 1;
  Click_MouseX := 1;
  Click_MouseY := 1;
  Mouse_Clicked := false;
  InitMouse;
end.

{***************************************************************************}
{ EOF }

