{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
A simple chemical engineering program that illustrates how to use
FIELD2.TPU to create a screen with a large number of fields that have the
same format.

* ASSOCIATED FILES
FIELD2.PAS
FLD2DEMO.PAS
FLD2TEST.PAS
OLD2TEST.PAS
README.1ST

* KEYWORDS
TURBO PASCAL V4.0 DATA ENTRY SCREEN INPUT EDIT MENU
==========================================================================
}
Program field_2_demonstration;  { FLD2DEMO.PAS }

{ This program was written by Frank Wood to demonstrate the use of the unit
  FIELD2.PAS for controlled data entry followed by unrestricted data editing. }

{N+}

Uses Crt,Dos,field2;

Type linestring = String[80];            { Utility string }
     namestring = String[16];            { For component names }
     direction  = (up,down,left,right);  { Edit direction commands }
     component  = 1..28;                 { Field numbers }


Const

      { The following array dicates which field is to be edited next based on
        the last field number (component) and the edit direction command (up,
        down, left, or right). }

      nextfldnum: Array[component,direction] Of Byte
                  = ((10,2,21,11),
                     (1,3,22,12),
                     (2,4,23,13),
                     (3,5,24,14),
                     (4,6,25,15),
                     (5,7,26,16),
                     (6,8,27,17),
                     (7,9,28,18),
                     (8,10,19,19),
                     (9,1,20,20),
                     (20,12,1,21),
                     (11,13,2,22),
                     (12,14,3,23),
                     (13,15,4,24),
                     (14,16,5,25),
                     (15,17,6,26),
                     (16,18,7,27),
                     (17,19,8,28),
                     (18,20,9,9),
                     (19,11,10,10),
                     (28,22,11,1),
                     (21,23,12,2),
                     (22,24,13,3),
                     (23,25,14,4),
                     (24,26,15,5),
                     (25,27,16,6),
                     (26,28,17,7),
                     (27,21,18,8));

      { The following array lists the component names by field number. }

      compname: Array[component] Of namestring
                = ( 'Hydrogen',
                    'Nitrogen',
                    'Oxygen',
                    'Water',
                    'Carbon Monoxide',
                    'Carbon Dioxide',
                    'Hydrogen Sulfide',
                    'Sulfur Dioxide',
                    'Benzene',
                    'Toluene',
                    'Methane',
                    'Ethane',
                    'Propane',
                    'i-Butane',
                    'n-Butane',
                    'Neopentane',
                    'i-Pentane',
                    'n-Pentane',
                    'n-Hexane',
                    'n-Heptane',
                    'Ethylene',
                    'Propylene',
                    'i-Butene',
                    '1-Butene',
                    't-2-Butene',
                    'c-2-Butene',
                    '1-Pentene',
                    '1,3-Butadiene' );

      { The following array lists the molecular weights by field number. }

      compmolewt: Array[component] Of Real
                 = (  2.016,
                     28.013,
                     31.999,
                     18.015,
                     18.010,
                     44.010,
                     34.076,
                     64.059,
                     78.114,
                     92.141,
                     16.043,
                     30.070,
                     44.097,
                     58.124,
                     58.124,
                     72.151,
                     72.151,
                     72.151,
                     86.178,
                    100.205,
                     28.054,
                     42.081,
                     56.108,
                     56.108,
                     56.108,
                     56.108,
                     70.135,
                     54.092 );

      maxcompnum = 28;         { Maximum component number }

Var fldnum: Byte;              { Field number }
    maxfldnum: Byte;           { Maximum field number }
    fldlength: Byte;           { Field length }
    decpla: Byte;              { Decimal places }
    returnkey: Byte;           { Code for key that terminates field entry }
    startrow: Byte;            { Starting row for fields }
    rowcount: Byte;            { Row count }
    compcount: Byte;           { Component count }
    count: Byte;               { Count }
    compnumber: Byte;          { Component number }
    maxrow: Byte;              { Maximum number of rows }

    col: Array[1..3] Of Byte;  { Location of columns 1, 2, and 3 }
    colindex: Byte;            { Column index }

    totalmassflow: Real;       { Total mass flow in pounds per hour }
    totalmoleflow: Real;       { Total molar flow in pound moles per hour }
    moleweight: Real;          { Molecular weight }

    text: linestring;
    value: linestring;

    success: Boolean;          { Result of field search }

    compmassflow: Array[component] Of Real;  { Component mass flow }
    compmoleflow: Array[component] Of Real;  { Component molar flow }


Procedure beep;              { Routine to make error sound }

Begin
  Write(chr(7))
End;

Begin
  reversevideo:=False;       { Use block markers rather than reverse video }
  zerovoid:=False;           { A zero entry is accepted in manditory field }
  hitxtcolor:=Yellow;        { Select yellow as high intensity text color }
  lotxtcolor:=LightGray;     { Select light gray as low intensity text color }
  txtbkgnd:=Black;           { Select black as background color }
  cursor(hidden);            { Hide cursor }
  TextMode(CO80);            { Set text mode to medium resolution color }
  TextColor(lotxtcolor);     { Set text color }
  TextBackground(txtbkgnd);  { Set text background color }

  Repeat

    { Clear screen and initialize component mass flow array }
    ClrScr;
    For count:=1 To maxcompnum Do compmassflow[count]:=0;

    { Write title for screen }
    text:='Refinery Gas Molecular Weight';
    GotoXY(39-(length(text) Div 2),2);
    Write(text);

    { Set location parameters for field labels (component names) }
    startrow:=6;
    col[1]:=1;
    col[2]:=31;
    col[3]:=55;
    colindex:=1;
    rowcount:=0;
    compcount:=0;
    maxrow:=10;

    { Write field labels (component names) to screen }
    Repeat
      Repeat
        GotoXY(col[colindex],startrow+rowcount);
        inc(compcount);
        If compcount <= maxcompnum Then Write(compname[compcount]);
        Inc(rowcount);
      Until rowcount = maxrow;
      Inc(colindex);
      rowcount:=0
    Until compcount >= maxcompnum;

    { Set location parameters for fields }
    maxfldnum:=maxcompnum;
    fldlength:=7;
    decpla:=0;
    col[1]:=19;
    col[2]:=43;
    col[3]:=70;
    fldnum:=1;
    firstpass:=True;

    Repeat  { Field operations until user accepts data screen or exits }

      Repeat  { Search for field until returnkey sets field number to zero }
        rowcount:=0;
        compnumber:=1;
        colindex:=1;
        success:=False;

        Repeat  { Search for field until it is found and processed }
          Repeat  { Search until successful or end of column is reached }
            If compnumber = fldnum Then
              Begin
                { Field2 function to enter/edit/accept data }
                returnkey:=editfield(col[colindex],          { Column }
                                     startrow+rowcount,      { Row }
                                     fldlength,              { Field length }
                                     decpla,                 { Decimal places }
                                     usndec,                 { Field type }
                                     optional,               { Entry required }
                                     compmassflow[fldnum]);  { Variable name }
                { Calculate molar flow of component }
                compmoleflow[fldnum]:=compmassflow[fldnum]/compmolewt[fldnum];
                { Indicate that field was found }
                success:=True
              End;
            Inc(compnumber);  { Try next field number }
            Inc(rowcount);  { Move to next row }
          Until rowcount = maxrow;  { End of column }
          Inc(colindex);  { Move to next column }
          rowcount:=0;  { Start new row count }
        Until success;  { Field found and processed }

        { Select next field number to process on basis of return key used }
        Case returnkey Of
          enterkey:                              { Move through fields in   }
              If fldnum < maxfldnum              { numerical order and quit }
              Then Inc(fldnum)                   { after the last field is  }
              Else fldnum:=0;                    { entered.                 }
          uparrowkey:
              fldnum:=nextfldnum[fldnum,up];     { Move up to next field    }
          dnarrowkey:
              fldnum:=nextfldnum[fldnum,down];   { Move down to next field  }
          tabkey:
              fldnum:=nextfldnum[fldnum,right];  { Move right to next field }
          shiftabkey:
              fldnum:=nextfldnum[fldnum,left];   { Move left to next field  }
          esckey:
              If firstpass                       { Beep on first pass       }
              Then beep
              Else fldnum:=0                     { Quit editing thereafter  }
          Else
        End;

      Until fldnum = 0;  { Data entry/editing is complete }

      { Calculate molecular weight of mixture }
      totalmassflow:=0;
      totalmoleflow:=0;
      For compnumber:= 1 To maxcompnum Do
        Begin
          totalmassflow:=totalmassflow+compmassflow[compnumber];
          totalmoleflow:=totalmoleflow+compmoleflow[compnumber]
        End;
      If totalmoleflow <> 0 Then
        moleweight:=totalmassflow/totalmoleflow
      Else moleweight:=0;

      { Field 2 procedure to display choices for user }
      note('END to Accept, ENTER to Edit, ESC to exit');

      Repeat  { Key input until choice is made }
        { Field2 function to get code for special key }
        returnkey:=getspecialkey;
        If (returnkey <> endkey) And
           (returnkey <> enterkey) And
           (returnkey <> esckey)
        Then
          { Field2 procedure to display error message }
          errmsg('Must be END (Accept), ENTER (Edit), Or ESC (Exit)')
      Until  { User choses next action }
           (returnkey = endkey) Or
           (returnkey = enterkey) Or
           (returnkey = esckey);

      If returnkey = enterkey Then
        { Return to data entry/editing }
        Begin
          firstpass:=False;
          fldnum:=1
        End;
    Until  { User accepts screen data or exits }
         (returnkey = endkey) Or
         (returnkey = esckey);

    If returnkey = endkey Then
      Begin
        { Write results to screen }
        GotoXY(1,startrow+13);
        Write('Total Stream Flow Rate lb/hr =      ',totalmassflow:10:0);
        GotoXY(1,startrow+14);
        Write('Total Stream Flow Rate, lb-moles/hr = ',totalmoleflow:8:1);
        GotoXY(1,startrow+15);
        Write('Total Stream Molecular Weight =        ',moleweight:7:3);

        { Field 2 procedure to display choices for user }
        note('ENTER to Run Another Case, or ESC to Exit');

        While ((returnkey <> enterkey) And (returnkey <> esckey)) Do
          Begin
            { Field2 function to get code for special key }
            returnkey:=getspecialkey;
            If ((returnkey <> enterkey) And (returnkey <> esckey)) Then
              { Field2 procedure to display error message }
              errmsg('Must be ENTER (New Case), or ESC (Exit)')
          End
      End;
  Until returnkey = esckey;  { User exits }
  cursor(underline);
  NormVideo;
End.

