{
                       F i l e    I n f o r m a t i o n

* DESCRIPTION
This program allows setting Diablo and compatible printer parameters with
software, from the command. Can reset, and set paper length, top of form,
characters per inch, left margin, and skip perforation. Allows use of the
Diablo at the DOS level, even with a cut sheet feeder. Author:Rick Housh.

* ASSOCIATED FILES
DIABLO.PAS
DIABLO.DOC

}
Program SetDiabloPrinter;

    USES Printer;

    CONST
        ResetPrinter: BOOLEAN = False;
        SkipPerf: BOOLEAN = False;
        SetTop: BOOLEAN = False;
        SetPageLength: BOOLEAN = False;
        SetCPI: BOOLEAN = False;
        SetLeftMargin: BOOLEAN = False;
        CancelSkip: BOOLEAN = False;
        Commodore6400Special: BOOLEAN = False;

    VAR
        st, st2: ARRAY [1..7] OF STRING [3];
        CPIString: STRING [3];
        k, lpp, spc, bm, skiplines: BYTE;

    PROCEDURE WriteHelp;
        BEGIN
            WriteLn('Sets parameters for Diablo and compatible printers.');
            WriteLn;
            WriteLn('  Syntax:  DIABLO [ R T C## L## P## S##]');
            Write('  R   Resets printer to switch defaults');
            WriteLn(' - cancels all current settings.');
            Write('  T   Top of form set at the current paper position.');
            WriteLn('  Cancels SkipPerf.');
            WriteLn('  C## Characters per inch, in ## range 10-17 cpi.');
            WriteLn('  L## Left margin setting, in ## range 01-99 spaces.');
            Write('  P## Paper length setting in ## range 01-99 lines, ');
            WriteLn('at 6 lines/inch.');
            Write('  S## Skip perforation, range ## lines.');
            WriteLn(' (Cancelled by S00, T, or R).');
            WriteLn;
            WriteLn('Notes:');
            Write('To set a left margin smaller than currently set,');
            WriteLn('it is necessary to');
            Write('reset the printer entirely, by ');
            WriteLn('turning it off and on again, or with');
            Write('the R parameter ');
            WriteLn('as the first command on the line, in which case all');
            Write('parameters must be reset.  Any of the above parameters');
            WriteLn(' may be used');
            Write('in any combination, in any order, although ');
            WriteLn('obviously R will cancel');
            Write('anything before it, and T will ');
            WriteLn('cancel any skip perforation command');
            WriteLn('before it. There must be a space between each parameter.'
                    );
            Halt(2);
        END;


    PROCEDURE ErrorMessage(st: STRING );
        BEGIN
            Write(#7'Unknown parameter "', st, '".');
            WriteLn('  Enter DIABLO ? for help.');
            Halt(1);
        END;


    PROCEDURE Initialize;
        BEGIN
            WriteLn;
            Write('Diablo printer parameter setting program by ');
            WriteLn('Rick Housh - CIS PIN 72466,212');
            WriteLn('"Diablo" is a trademark of the Xerox Corporation.');
            WriteLn;

        END; { Procedure Initialize }


    PROCEDURE Get_Parms_And_Set_Options;

        VAR
            NumParm, i, j: BYTE;
            err : INTEGER;
            ch  : CHAR;

        BEGIN { Get_Parms_And_Set_Options }
            NumParm := ParamCount;
            IF NumParm < 1 THEN
                WriteHelp;
            FOR i := 1 TO NumParm DO
                BEGIN { OuterLoop }
                st[i] := ParamStr(i);
                IF Pos('?', st[i]) <> 0 THEN
                    WriteHelp;

                st2[i] := '';
                FOR j := 1 TO Length(st[i]) DO
                    BEGIN { InnerLoop }
                    ch := Upcase(st[i][j]);
                    IF (st2[i] = '') AND
                       (ch IN ['C', 'T', 'P', 'L', 'S', 'R', 'Q']) THEN
                        st2[i] := st2[i] + ch;
                    IF (st2[i] <> '') AND (ch IN ['0'..'9']) THEN
                        st2[i] := st2[i] + ch;
                    END; { InnerLoop }

                IF Pos('P', st2[i]) = 1 THEN
                    BEGIN
                    IF Length(st2[i]) < 3 THEN
                        Insert('0', st2[i], 2);
                    Val(Copy(st2[i], 2, 2), lpp, err);
                    IF lpp > 99 THEN
                        ErrorMessage(
                          st2[i] + '" "Illegal value');
                    SetPageLength := True;
                    END;

                IF Pos('S', st2[i]) = 1 THEN
                    BEGIN
                    IF Length(st2[i]) < 3 THEN
                        Insert('0', st2[i], 2);
                    Val(Copy(st2[i], 2, 2), skiplines, err);
                    IF skiplines = 0 THEN
                        CancelSkip := True
                    ELSE
                        SkipPerf := True;
                    END;

                IF Pos('L', st2[i]) = 1 THEN
                    BEGIN
                    IF Length(st2[i]) < 3 THEN
                        Insert('0', st2[i], 2);
                    Val(Copy(st2[i], 2, 2), spc, err);
                    SetLeftMargin := True;
                    END;

                IF st2[i] = 'C16' THEN
                    st2[i] := 'C17';
                IF st2[i] = 'C14' THEN
                    st2[i] := 'C15';
                IF (st2[i] <> 'C10') AND (st2[i] <> 'C11') AND
                   (st2[i] <> 'C12') AND (st2[i] <> 'C13') AND
                   (st2[i] <> 'C15') AND (st2[i] <> 'C17') AND
                   (st2[i][1] <> 'S') AND (st2[i][1] <> 'P') AND
                   (st2[i][1] <> 'L') AND (st2[i] <> 'T') AND
                   (st2[i] <> 'R') AND (st2[i] <> 'Q') THEN
                    ErrorMessage(st[i]);

                IF (Length(st2[i]) <> 3) AND
                 ( (st2[i][1] = 'S') OR (st2[i][1] = 'P') OR
                   (st2[i][1] = 'L') ) THEN
                     ErrorMessage(st2[i][1] +'" - "## required');

                IF st2[i][1] = 'T' THEN
                    SetTop := True;
                IF st2[i][1] = 'R' THEN
                    ResetPrinter := True;
                IF st2[i][1] = 'Q' THEN
                    Commodore6400Special := True;
                IF st2[i][1] = 'C' THEN
                    BEGIN
                    CPIString := st2[i];
                    SetCPI := True;
                    END;
                END; { OuterLoop }
        END; { Get_Parms_And_Set_Options }


    PROCEDURE Check_Printer_Status;
        BEGIN
            Write('Printer is not responding.  Fix and try again.'#13);
            {$I-}
            Write(lst, #13);
            {$I+}
            IF IOResult <> 0 THEN
                Halt(1)
            ELSE
                Write('                                              '#13);
        END; { Procedure Check_Printer_Status }

    BEGIN { Main Program }
        Initialize;
        Get_Parms_And_Set_Options;
        Check_Printer_Status;

        {Don't disturb the order of the ResetPrinter and
         SetPageLength blocks.  They must come first.}

        IF ResetPrinter THEN
            BEGIN
            Write(lst, #27#13'P');
            WriteLn('Printer reset to default switch settings');
            END;

        IF SetPageLength THEN
            BEGIN
            Write(lst, #27#12, chr(lpp));
            Write(lst, #13);
            WriteLn('Page length set to ',lpp, ' lines.');
            END;

        IF SetTop OR SkipPerf THEN
            BEGIN
            Write(lst, #27'S');
            Write(lst, #13);
            WriteLn('Top of form set');
            IF NOT SkipPerf THEN
                WriteLn('Skip perforations cancelled.');
            END;

        IF SkipPerf THEN
            BEGIN
            IF SetPageLength THEN bm := lpp ELSE bm := 66;
            Write(lst, #27#11, chr(bm - skiplines));
            Write(lst, #27'L');
            Write(lst, #12);
            Write(lst, #13);
            WriteLn('Skip Perforations Set at ', skiplines, ' lines.');
            WriteLn('Number of printed lines on page: ',bm-skiplines);
            END;

        IF CancelSkip THEN
            BEGIN
            Write(lst, #27'C');
            WriteLn('Skip perforations cancelled.');
            END;

        IF SetCPI THEN
            BEGIN
            IF CPIString = 'C10' THEN
                Write(lst, #27#31#13);
            IF CPIString = 'C11' THEN
                Write(lst, #27#31#12);
            IF CPIString = 'C12' THEN
                Write(lst, #27#31#11);
            IF CPIString = 'C13' THEN
                Write(lst, #27#31#10);
            IF CPIString = 'C15' THEN
                Write(lst, #27#31#9);
            IF CPIString = 'C17' THEN
                Write(lst, #27#31#8);
            WriteLn(lst, #13);
            WriteLn('Printer set at ', Copy(CPIString, 2, 2),
                    ' characters per inch.');
            END;

        IF SetLeftMargin THEN
            BEGIN
            Write(lst, #27#9#2);
            IF spc < 1 THEN
                spc := 1;
            IF spc = 1 THEN
                Write(lst, #13)
            ELSE
                FOR k := 1 TO spc DO
                    Write(lst, ' ');
            Write(lst, #27'9');
            Write(lst, #13);
            WriteLn('Left margin set to', spc: 4, ' spaces.');
            END;

        IF Commodore6400Special THEN
            BEGIN
            Write(lst, #27'%');
            WriteLn(
               'Undocumented Commodore carriage settle time increased 20ms.'
                    );
            END;

    END. { Main Program }

