{                      F i l e    I n f o r m a t i o n

* DESCRIPTION
Program to illustrate four different sorting algorithms:  Bubble, Heap,
Selection, and QuickSort.  It displays a table to show the differences
between the sorts.  Author: Jonathan Allan.  Version: T1.0.

* ASSOCIATED FILES
SORTS4.PAS
SORTS4.NOT
SORTS4P.PAS

}
{.PL66}
{.HEProgram 4 Sorts                                        page: #}
{********************************************************************}
{                                                                    }
{  Program: 4 Sorts           Machine: IBM PC w/256k                 }
{  Author: Jonathan Allan     Date: 4/30/85                          }
{                                                                    }
{  The following program illustrates the differences among 4 sorts:  }
{  Bubble, Heap, Selection, and Quick sorts are shown.  These        }
{  are the classical algorithms, which I learned in a class on       }
{  data structures. ( This was an assignment )  Note that the Heap   }
{  and Quick sorts REQUIRE recursion.  These sorts use pseudo-random }
{  integers as the data.  The table this program produces should     }
{  show the differences among the sorts.  For more reference, see:   }
{  Trembley and Sorenson's "An Introduction to Data Structures with  }
{  Applications".  2nd Edition McGraw-Hill, Inc. 1984.               }
{  With inspiration from Donald E. Knuths "The Art of Computer       }
{  Programming.                                                      }
{                                                                    }
{  This program should list fairly well with TLIST.                  }
{  This program as written can take over 1 hour to run on the IBM PC.}
{                                                                    }
{  I give my permission to use in whole or in part any portion of    }
{  this program for the betterment of programs everywhere.  I        }
{  further declare this whole program to be PUBLIC DOMAIN as of      }
{  10/22/1985.                                                       }
{                                                                    }
{  Jon Allan   3 Fox Run   O'Fallon, Il. 62269                       }
{  Resume available on written request.                              }
{                                                                    }
{********************************************************************}
{.PA}
type  Int1000  =  array[1..1001] of integer;

type Registers = record
        AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags :  integer;
      end;  { record Registers }

type String255 = string[255];

{********************************************************************}
{*                                                                  *}
{* Common variables used by the sort routines.                      *}
{*                                                                  *}
{********************************************************************}

var   MainArray   :  Int1000;      { preloaded array with all values }
      SortArray   :  Int1000;      { sort array to use for sorting   }
      Cmp_Cnt     :  real;         { comparison counter / sort       }
      Swap_Cnt    :  real;         { data swaps counter / sort       }
      Cmp_Tot     :  real;         { total number of comparisons     }
      Swap_Tot    :  real;         { total number of swaps           }
      Time_In     :  real;         { time in 100ths into the sort    }
      Time_Tot    :  real;         { total sort times                }

const FormFeedSeq =  ^L;           { send formfeed command           }
      CrLf        =  ^M^J;         { send cairrage return/linefeed   }

{.PA}
{********************************************************************}
{*                                                                  *}
{*  Return the time in hundredths of seconds.                       *}
{*  1 second ~ 100 from this routine.  60 secs. ~ 6000.             *}
{*                                             Author JAA 4/4/85    *}
{*                                                                  *}
{********************************************************************}

function JULIAN_TIME: real;

var   Intrcall  : Registers;
      Time      : real;

  begin
    Intrcall.AX := $2A00;                               { get date   }
    intr($21,Intrcall);
    Time := (Intrcall.CX-1980) * 3153600000.0;          { year       }
    Time := Time + hi(Intrcall.DX) * 259200000.0;       { month      }
    Time := Time + lo(Intrcall.DX) * 8640000.0;         { day        }
    Intrcall.AX := $2C00;                               { get time   }
    intr($21,Intrcall);
    Time := Time + hi(Intrcall.CX) * 360000.0;          { hours      }
    Time := Time + lo(Intrcall.CX) * 6000.0;            { minutes    }
    Time := Time + hi(Intrcall.DX) * 100.0;             { seconds    }
    Time := Time + lo(Intrcall.DX);                     { hundredths }
    JULIAN_TIME := Time;
  end;  { procedure JULIAN_TIME }
{.PA}
{********************************************************************}
{*                                                                  *}
{*    Change time in minutes to military time                       *}
{*                                                                  *}
{********************************************************************}

function CHANGE_TIME(Time: real): String255;
 
var   I        :  integer;
      Temp     :  String255;
      Temp_N   :  String255;
 
   begin
      Temp := '';
      Temp_N := '';
      I := trunc(Time) mod 3600;                           { minutes }
      str((I div 60),Temp);
      I := I mod 60;
      Temp := concat('00',Temp);
      Temp := copy(Temp,length(Temp)-1,2);
      Temp_N := concat(Temp_N,Temp,':');                   { seconds }
      str(I,Temp);
      Temp := concat('00',Temp);
      Temp := copy(Temp,length(Temp)-1,2);
      CHANGE_TIME := concat(Temp_N,Temp);
   end;  { function CHANGE_TIME }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Randomize MainArray with values for sorting routines to use      *}
{*                                                                  *}
{********************************************************************}

procedure   RANDOMIZ;
 
var   Temp  :  integer;
 
   begin
      MainArray[1] := 313;
      for Temp := 2 to 1000 do begin
         MainArray[Temp] := ((29*MainArray[Temp-1]+217) mod 1024);
      end;  { for }
      Swap_Tot := 0.0;                  { zero out total fields once }
      Cmp_Tot := 0.0;
      Time_Tot := 0.0;
   end;  { procedure RANDOMIZ }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Dump out all values in the main array                            *}
{*                                                                  *}
{********************************************************************}

procedure   DUMPM;
 
var   Temp  :  integer;

   begin
      writeln(FormFeedSeq,'Main Array the sorts come from:',CrLf);
      write(MainArray[1]:4);
      for Temp := 2 to 1000 do write(' ',MainArray[Temp]:4);
      writeln('');
   end;  { procedure DUMPM }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Dump out selected portions of the SortArray                      *}
{*                                                                  *}
{********************************************************************}

procedure   DUMPS(Lb,Ub: integer);

var   Temp  :  integer;

   begin
      write(SortArray[Lb]:4);
      for Temp := (Lb + 1) to Ub do write(' ',SortArray[Temp]:4);
      writeln('.');
   end;  { procedure DUMP }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Return the log base 2 of the value sent in                       *}
{*                                                                  *}
{********************************************************************}
 
function    LOG2(Temp: integer): real;
 
   begin
      LOG2 := ln(Temp) / ln(2);
   end;  { function LOG2 }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Swap the SortArray values passed as indices, and keep count      *}
{*                                                                  *}
{********************************************************************}

procedure SWAP(I,J: integer);
 
var   Temp     :  integer;
 
   begin
      Temp := SortArray[I];
      SortArray[I] := SortArray[J];
      SortArray[J] := Temp;
      Swap_Cnt := Swap_Cnt + 1.0;
   end;  { procedure SWAP }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Move the values from the MainArray to the SortArray for sorting  *}
{*                                                                  *}
{********************************************************************}
 
procedure   MOVEARRAY(Lb,Ub: integer);

var   Temp  :  integer;
 
   begin
      for Temp := Lb to Ub do SortArray[Temp-Lb+1] := MainArray[Temp];
      Temp := Temp + 1;
      while Temp <= 1000 do begin
         SortArray[Temp] := 0;
         Temp := Temp + 1;
      end;  { for Temp }
      Cmp_Cnt := 0.0;                      { zero comparison counter }
      Swap_Cnt := 0.0;                           { zero Swap counter }
      Time_In := JULIAN_TIME;                  { start timer running }
   end;  { procedure MOVEARRAY }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Bubble sort the SortArray in memory                              *}
{*                                                                  *}
{********************************************************************}
 
procedure   BUBBLE(Lb,Ub: integer);
 
var   Posit    :  integer;
      End_P    :  integer;
      Temp     :  integer;
      Exchange :  boolean;

   begin
      Exchange := true;
      End_P := Ub - 1;
      while Exchange do begin
         Exchange := false;
         for Posit := Lb to End_P do begin
            Cmp_Cnt := Cmp_Cnt + 1.0;          { count data compares }
            if SortArray[Posit] > SortArray[Posit + 1]
               then begin
                  Exchange := true;
                  SWAP(Posit,Posit+1);
               end;  { then }
         end;  { for }
         End_P := End_P - 1;
      end;  { while }
   end;  { procedure BUBBLE }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Select sort the SortArray in memory                              *}
{*                                                                  *}
{********************************************************************}

procedure   SELECT(Lb,Ub: integer);
 
var   Posit    :  integer;                  { loop value             }
      End_P    :  integer;                  { last value to check    }
      Temp     :  integer;                  { current greatest index }
 
   begin
      End_P := Ub;
      while End_P > Lb do begin
         Temp := End_P;
         for Posit := Lb to (End_P - 1) do begin
            Cmp_Cnt := Cmp_Cnt + 1.0;          { count data compares }
            if SortArray[Posit] > SortArray[Temp]
               then Temp := Posit;
         end;  { for }
         if Temp = End_P
            then
            else begin
               SWAP(Temp,End_P);
            end;   { else }
         End_P := End_P - 1;
      end;  { while }
   end;  { procedure SELECT }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Quick sort the SortArray in memory                               *}
{*                                                                  *}
{********************************************************************}
 
procedure QUICK(Lb,Ub: integer);
 
var   Key,I,J  :  integer;
      Temp     :  integer;
      Flag     :  boolean;
 
   begin
      Flag := true;
      if Lb < Ub
         then begin
            I := Lb;
            J := Ub + 1;
            Key := SortArray[Lb];
            while Flag do begin
               I := I + 1;
               while SortArray[I] < Key do begin
                  I := I + 1;
                  Cmp_Cnt := Cmp_Cnt + 1.0;
               end;  { while I }
               J := J - 1;
               while SortArray[J] > Key do begin
                  J := J - 1;
                  Cmp_Cnt := Cmp_Cnt + 1.0;
               end;  { while J }
               if I < J
                  then SWAP(I,J)
                  else Flag := false;
            end;  { while Flag }
            SWAP(Lb,J);
            QUICK(Lb,(J-1));
            QUICK((J+1),Ub);
         end;  { then }
   end;  { procedure QUICK }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Force the SortArray into a heap "tree" structure                 *}
{*                                                                  *}
{********************************************************************}

procedure HEAPIFY(I,J: integer);
 
var   Temp     :  integer;
      Max_Index:  integer;
      I2       :  integer;
 
   begin
      I2 := I*2;
      if (I2+1) <= J
         then begin
            Cmp_Cnt := Cmp_Cnt + 2.0;
            if SortArray[I2+1] > SortArray[I2]
               then Max_Index := I2+1
               else Max_Index := I2;
            if SortArray[I] < SortArray[Max_Index]
               then begin
                  SWAP(I,Max_Index);
                  HEAPIFY(Max_Index,J);
               end;  { then I,Max_Index }
         end   { then J }
         else begin
            if I2 <= J
               then begin
                  Cmp_Cnt := Cmp_Cnt + 1;
                  if SortArray[I] < SortArray[I2]
                     then begin
                        SWAP(I,I2);
                        HEAPIFY(I2,J);
                     end;  { then I,I2 }
               end;  { then I2,J }
         end;  { else J }
   end;  { procedure HEAPIFY }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Build a heap from the SortArray                                  *}
{*                                                                  *}
{********************************************************************}
 
procedure BUILD_HEAP(Lb,Num: integer);

var   I     :  integer;
 
   begin
      for I := Num downto Lb do HEAPIFY(I,Num);
   end;  { procedure BUILD_HEAP }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Heap sort the data in an array but think of a tree structure     *}
{*                                                                  *}
{********************************************************************}
 
procedure   HEAP_SORT(Lb,Num: integer);

var   I     :  integer;
 
   begin
      BUILD_HEAP(Lb,Num);
      for I := Num downto (Lb+1) do begin
         SWAP(Lb,I);
         HEAPIFY(Lb,(I-1));
      end;  { for }
   end;  { procedure HEAP_SORT }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Calculate ratios for this sort                                   *}
{*                                                                  *}
{********************************************************************}
 
procedure   CALC(Num: integer);
 
   begin
      write(Cmp_Cnt/Num:11:3);
      write(' ',Cmp_Cnt/LOG2(Num):11:3);
      write(' ',Cmp_Cnt/Num/LOG2(Num):11:5);
      write(' ',Cmp_Cnt/Num/Num:11:7);
      write(' ',Swap_Cnt:7:0);
      write(' ',Cmp_Cnt:7:0);
      if Time_In <= 0.99
         then Time_In := 1.0;                  { force 1 second mark }
      writeln('  ',CHANGE_TIME(Time_In));
      writeln('');
      Swap_Tot := Swap_Tot + Swap_Cnt;
      Cmp_Tot := Cmp_Tot + Cmp_Cnt;
      Time_Tot := Time_Tot + Time_In;
   end;  { procedure CALC }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Run to statistics for each sort and print results                *}
{*                                                                  *}
{********************************************************************}
 
procedure   RUN(Number: integer);
 
   begin
      writeln(FormFeedSeq,CrLf,CrLf,CrLf,CrLf);    { set top of form }
      write('Number of data values to be sorted (N): ');
      writeln(Number:4,'.',CrLf);
      write('Values shown are the number of comparisons');
      writeln(' divided by the heading:',CrLf);
      write('The value closest to 1 is probably the ');
      writeln('best estimate of Big-O(N) running time.',CrLf);
      write('Sort            N         Lg2(N)    ');
      writeln('N*Lg2(N)    N^2        Swaps Compares  Time');
      write('---------------------------------------');
      writeln('----------------------------------------');
      writeln('');
      MOVEARRAY(1,Number);
      BUBBLE(1,Number);
      Time_In := (JULIAN_TIME - Time_In)/100.0;
      write('Bubble   ');
      CALC(Number);
      MOVEARRAY(1,Number);
      SELECT(1,Number);
      Time_In := (JULIAN_TIME - Time_In)/100.0;
      write('Selection');
      CALC(Number);
      MOVEARRAY(1,Number);
      HEAP_SORT(1,Number);
      Time_In := (JULIAN_TIME - Time_In)/100.0;
      write('Heap     ');
      CALC(Number);
      MOVEARRAY(1,Number);
      SortArray[Number + 1] := 32767;   { take care of problem here }
      QUICK(1,Number);
      Time_In := (JULIAN_TIME - Time_In)/100.0;
      write('Quick    ');
      CALC(Number);
      write('---------------------------------------');
      writeln('----------------------------------------');
      writeln(CrLf,'Total Swaps:    ',Swap_Tot:12:0);
      writeln(CrLf,'Total Compares: ',Cmp_Tot:12:0);
      writeln(CrLf,'Total Time:          ',(trunc(Time_Tot)div 3600),
              ':',CHANGE_TIME(Time_Tot));       { take care of hours }
   end;  { procedure RUN }
{.PA}
{********************************************************************}
{*                                                                  *}
{* Drive the running procedure to get the tables generated          *}
{*                                                                  *}
{********************************************************************}

   begin
      RANDOMIZ;
      DUMPM;
      writeln(FormFeedSeq,
                  'Verification of algorithm sorting ability:',CrLf);
      MOVEARRAY(1,20);
      BUBBLE(1,20);
      writeln('Bubble:');
      DUMPS(1,10);
      DUMPS(11,20);
      MOVEARRAY(1,20);
      SELECT(1,20);
      writeln(CrLf,'Selection:');
      DUMPS(1,10);
      DUMPS(11,20);
      MOVEARRAY(1,20);
      HEAP_SORT(1,20);
      writeln(CrLf,'Heap:');
      DUMPS(1,10);
      DUMPS(11,20);
      MOVEARRAY(1,20);
      SortArray[21] := 32767;           { take care of problem here }
      QUICK(1,20);
      writeln(CrLf,'Quick:');
      DUMPS(1,10);
      DUMPS(11,20);
      RUN(20);
      RUN(50);
      RUN(100);
      RUN(200);
      RUN(300);
      RUN(400);
      RUN(500);
      RUN(700);
      RUN(800);
      RUN(1000);
      write(FormFeedSeq,FormFeedSeq);
   end.
