{ FASTTEST.PAS }

{
Description:  Test routine for FastStuf's FillToScreen procedure

Author:       Don Taylor
Date:         2/15/89
Last revised: 02/27/1989  07:44:58
Application:  IBM PC and compatibles

}

PROGRAM FastTest;

USES
 Crt,          { Built-in video routines                                     }
 Dos,          { Built-in DOS interface routines                             }
 FastStuf;     { TUG's direct screen-writing routines                        }

VAR
 ScreenWord : WORD;
 InColor    : BOOLEAN;

{--------------------}

FUNCTION ScreenSeg : WORD;

CONST
 IntrCall    = 16;
 ServiceCall = 15;

VAR
 Result : INTEGER;
 SegRec : Registers;

BEGIN
 WITH SegRec DO
  BEGIN
   AH := ServiceCall;
   INTR(IntrCall, SegRec);
   Result := AL;
   CASE Result OF
    0..6   : ScreenSeg := $B800;
    7      : ScreenSeg := $B000
   END { CASE }
  END { WITH }
END;  { ScreenSeg }


{====================}

BEGIN { FastTest }
 InColor    := ScreenSeg = $B800;
 IF InColor
  THEN ScreenWord := Lightgray + Blue  * 16
  ELSE ScreenWord := Lightgray + Black * 16;
 ScreenWord := ScreenWord SHL 8 + ORD('*');

 FillToScreen(MEM[ScreenSeg:0], ScreenWord, 25 * 80);
 Delay (1500);

 IF InColor
  THEN ScreenWord := White + Blue  * 16
  ELSE ScreenWord := White + Black * 16;
 ScreenWord := ScreenWord SHL 8 + ORD('*');

 FillToScreen(MEM[ScreenSeg:0], ScreenWord, 25 * 80);
 Delay (1500)

END.  { FastTest }

