{ FASTSTUF.PAS }

UNIT FastStuf;

{
Description:  PC-specific routines for direct screen-to-memory and memory-
              to-screen transfers.

Author:       Don Taylor
Date:         2/3/89
Last revised: 02/04/1989  19:00:48
Application:  IBM PC and compatibles; Turbo Pascal 4.0 and 5.0


Note: This unit contains code that has been adapted from the work of Brian
      Foley and Borland International.
}

{--------------------}
     INTERFACE
{--------------------}

USES
 Crt;         { Built-in video routines                                      }

{$L FASTSTUF.OBJ}

PROCEDURE CopyToScreen(  VAR Source;        { Address of source memory       }
                         VAR Destination;   { Address of screen memory       }
                             Len : WORD);   { Number of bytes to copy        }

PROCEDURE CopyFromScreen(VAR Source;        { Address of screen memory       }
                         VAR Destination;   { Address of target memory       }
                             Len : WORD);   { Number of bytes to copy        }

PROCEDURE FillToScreen(  VAR Destination;   { Address of screen memory       }
                             SData : WORD;  { Character + Attribute          }
                             Len   : WORD); { Number of words to fill        }


{--------------------}
   IMPLEMENTATION
{--------------------}

PROCEDURE CopyToScreen(  VAR Source;        { Address of source memory       }
                         VAR Destination;   { Address of screen memory       }
                             Len : WORD);   { Number of bytes to copy        }
                         EXTERNAL;          { FASTSTUF.OBJ }

PROCEDURE CopyFromScreen(VAR Source;        { Address of screen memory       }
                         VAR Destination;   { Address of target memory       }
                             Len : WORD);   { Number of bytes to copy        }
                         EXTERNAL;          { FASTSTUF.OBJ }

PROCEDURE FillToScreen(  VAR Destination;   { Address of screen memory       }
                             SData : WORD;  { Character + Attribute          }
                             Len   : WORD); { Number of words to fill        }
                         EXTERNAL;


{====================}
{   INITIALIZATION   }
{====================}

BEGIN { UNIT FastStuf }
END.  { UNIT FastStuf }

