; FASTSTUF.ASM
;
;Description:  Assembly support routines for direct transfers between
;              memory and screen memory on an IBM PC or compatible. Includes
;              snow supression.
;
;Author:       Don Taylor
;Date:         2/3/89
;Last revised: 02/20/89 13:45
;Application:  IBM PC and compatibles; Turbo Assembler 1.0
;
;Note:         The code in this file is based upon the work of Brian Foley
;              and that of Borland International.

		.MODEL	TPascal

		.CODE

		EXTRN	CheckSnow : BYTE

CGAStatusPort	EQU	03DAh

;{-------------------}
;
;PROCEDURE CopyToScreen( VAR Source;        { Address of source memory       }
;                        VAR Destination;   { Address of screen memory       }
;                            Len : WORD);   { Number of bytes to move        }

CopyToScreen	PROC	FAR Source : DWORD, Destination : DWORD, Len : WORD
	        PUBLIC	CopyToScreen


CTS_Start:
	PUSH	DS			; Save DS
	MOV	AL, CheckSnow		; Grab before changing DS
	LES	DI,Destination		; ES:DI points to Destination
	LDS	SI,Source		; DS:SI points to Source
	MOV	CX,Len			; CX = Length
	OR	CX,CX			; Done if CX=0
	JE	CTS_Exit

	CMP	SI,DI			; Check direction
	JLE	CTS_ReverseDirection

	CLD				; Set direction to forward
	JMP	SHORT CTS_SnowCheck	;

CTS_ReverseDirection:
	ADD	SI,CX			; Set direction to backward
	SUB	SI,2
	ADD	DI,CX
	SUB	DI,2
	STD

CTS_SnowCheck:
	SHR	CX,1			; Convert count to words
	OR	AL,AL			; Test CheckSnow
	JE	CTS_NoWait		; If false, no waiting
	MOV	DX, CGAStatusPort	; Point DX to CGA status port

CTS_GetNext:
	LODSW				; Load next memory word into AX
	MOV	BX,AX			; Store memory word in BX
	CLI				; Critical timing: No interrupts now

CTS_WaitNoH:
	IN	AL,DX			; Get 6845 status
	TEST	AL,8			; Check for vertical retrace
	JNZ	CTS_Go			; In progress? Go for it!
	RCR	AL,1			; Wait for end of horizontal retrace
	JC	CTS_WaitNoH

CTS_WaitH:
	IN	AL,DX			; Get 6845 status again
	RCR	AL,1			; Wait for horizontal
	JNC	CTS_WaitH		;  retrace

CTS_Go:
	MOV	AX,BX			; Move word back to AX...
	STOSW				;  and then to screen
	STI				; Allow interrupts again
	LOOP	CTS_GetNext		; Get next video word
	JMP	CTS_Exit		; All done

CTS_NoWait:
	REP	MOVSW			; That's all, folks!

CTS_Exit:
	POP	DS			; Restore DS and return
	RET

CopyToScreen	ENDP



;{-------------------}
;
;PROCEDURE CopyFromScreen( VAR Source;      { Address of screen memory       }
;                          VAR Destination; { Address of target memory       }
;                              Len : WORD); { Number of bytes to move        }

CopyFromScreen	PROC	FAR Source : DWORD, Destination : DWORD, Len : WORD
	        PUBLIC  CopyFromScreen

CFS_Start:
	MOV	BX,DS			; Save DS in BX
	MOV	AL, CheckSnow		; Grab before changing DS
	LES	DI,Destination		; ES:DI points to Destination
	LDS	SI,Source		; DS:SI points to Source
	MOV	CX,Len			; CX = Length
	OR	CX,CX			; Done if CX=0
	JE	CFS_Exit

	CMP	SI,DI			; Check direction
	JLE	CFS_Backwards

	CLD				; Set direction to forward
	JMP	SHORT CFS_SnowCheck	;

CFS_Backwards:
	ADD	SI,CX			; Set direction to backward
	SUB	SI,2
	ADD	DI,CX
	SUB	DI,2
	STD

CFS_SnowCheck:
	SHR	CX,1			; Convert count to words
	OR	AL,AL			; Test CheckSnow
	JE	CFS_NoWait		; If false, no waiting
	MOV	DX, CGAStatusPort	; Point DX to CGA status port

CFS_GetNext:
	CLI				; Critical timing: No interrupts now

CFS_WaitNoH:
	IN	AL,DX			; Get 6845 status
	TEST	AL,8			; Check for vertical retrace
	JNZ	CFS_Go			; In progress? go for it!
	RCR	AL,1			; Wait for end of horizontal
	JC	CFS_WaitNoH		;  retrace

CFS_WaitH:
	IN	AL,DX			; Get 6845 status again
	RCR	AL,1			; Wait for horizontal
	JNC	CFS_WaitH		;  retrace

CFS_Go:
	LODSW				; Load next video word into AX
	STI				; Allow interrupts again
	STOSW				; Store video word at Destination
	LOOP	CFS_GetNext		; Get next video word
	JMP	CFS_Exit		; All Done!

CFS_NoWait:
	REP	MOVSW			; That's all, folks!

CFS_Exit:
	MOV	DS,BX			; Restore DS and leave
	RET

CopyFromScreen	ENDP



;{-------------------}
;
;PROCEDURE FillToScreen( VAR Destination;   { Address of screen memory       }
;                            SData : WORD;  { Character + Attribute          }
;                            Len   : WORD); { Number of words to fill        }

FillToScreen	PROC	FAR Destination : DWORD, SData : WORD, Len : WORD
 	        PUBLIC	FillToScreen


FTS_Start:
	LES	DI,Destination		; ES:DI points to Destination
        MOV     CX, Len                 ; Get length in CX
	OR	CX,CX			; All done if CX = 0
	JE	FTS_Exit
	CLD				; Assume forward direction
                	
FTS_SnowCheck:
	MOV	AL, CheckSnow		; Get the CheckSnow value in AL
	OR	AL,AL			; Test CheckSnow
	JE	FTS_NoWait		; If false, no waiting
	MOV	DX, CGAStatusPort	; Point DX to CGA status port

FTS_DoNext:
	CLI				; Critical timing: No interrupts now

FTS_WaitNoH:
	IN	AL,DX			; Get 6845 status
	TEST	AL,8			; Check for vertical retrace
	JNZ	FTS_Go			; In progress? Go for it!
	RCR	AL,1			; Wait for end of horizontal retrace
	JC	FTS_WaitNoH

FTS_WaitH:
	IN	AL,DX			; Get 6845 status again
	RCR	AL,1			; Wait for beginning
	JNC	FTS_WaitH		;  of horizontal retrace

FTS_Go:
	MOV	AX,SData		; Get character/attribute
	STOSW				; Place it and go to next location
	STI				; Interrupts are OK now
	LOOP	FTS_DoNext
	JMP 	FTS_Exit		; Last one: all done

FTS_NoWait:
	MOV	AX,SData		; Get character/attribute

FTS_Repeat:
	STOSW				; Move word to screen memory
	LOOP FTS_Repeat			;  CX times

FTS_Exit:
	RET				; That's all, folks!

FillToScreen	ENDP

		END
