{ PRTRSTUF.PAS }

UNIT PrtrStuf;

{
Description:  Substitute printer interface unit for Turbo Pascal

Author:       Jim Zwick and Don Taylor
Date:         9/17/88
Last revised: 09/29/1988  14:52:48
Application:  IBM PC and compatibles; Turbo Pascal 4.0
}


{--------------------}
     INTERFACE
{--------------------}

USES
 Dos;                   { Built-in DOS interface routines                    }

CONST
 PrtrNoError     = 0;   { No error detected                                  }
 PrtrInUse       = 1;   { Printer is busy                                    }
 PrtrNotSelected = 2;   { Printer is not on line                             }
 PrtrNoPaper     = 3;   { Printer is out of paper                            }
 PrtrNoPower     = 4;   { Printer power is off                               }
 PrtrMiscError   = 5;   { Unknown error                                      }

VAR
 Lst : TEXT;

FUNCTION PrinterStatus : INTEGER;
PROCEDURE Eject;


{--------------------}
   IMPLEMENTATION
{--------------------}


FUNCTION PrinterStatus : INTEGER;

CONST
 PrtrIntr = $17;        { Printer service interrupt                          }
 StatFunc = $02;        { Printer status function code                       }

VAR
 r : Registers;

BEGIN
 WITH r DO
  BEGIN
   AH := StatFunc;
   INTR(PrtrIntr, r);
   CASE AH OF
    $90 : PrinterStatus := PrtrNoError;
    $A1 : PrinterStatus := PrtrInUse;
    $08 : PrinterStatus := PrtrNotSelected;
    $28 : PrinterStatus := PrtrNoPaper;
    $48 : PrinterStatus := PrtrNoPower; { for IBM XT }
   ELSE   PrinterStatus := PrtrMiscError;
   END { CASE }
  END { WITH }
END; { PrinterStatus }


{--------------------}

PROCEDURE Eject;

CONST
 PFormFeed = #12;

BEGIN
 WRITE(Lst, PFormFeed)
END; { Eject }


{--------------------}
{  INITIALIZATION    }
{--------------------}

BEGIN { UNIT PrtrStuf }
 ASSIGN(Lst, 'PRN');
 REWRITE(Lst)
END.  { UNIT PrtrStuf }
