{ HEAPALOT.PAS }
{
Description:  Program that demonstrates the use of over-range subscripts to
              access variable-length arrays stored on the Pascal Heap.

Author:       Douglas R. Robello
Date:         September, 1988
Application:  IBM PC and compatibles; Turbo Pascal 4.0
}

PROGRAM HeapALot;

{Tested using Turbo Pascal 4.0, but should work with 3.0 with slight}
{ modification.}

{The following line is ABSOLUTELY necessary!!!}
{$R-}

TYPE
  RealArray= ARRAY[1..1] OF REAL;

VAR
 OurData  : ^RealArray; {This is the starting address of the array.}
 NValues  : WORD;       {Number of reals in the list.}
 DataFile : TEXT;       {For the example, this is called REALS.DAT.}
 I        : WORD;       {Just a counter.}
 TempReal : REAL;       {Dummy variable used to find the length of the list.}

BEGIN {.....Main Program.....}

{^^^   Get data stored in text file.               ^^^}
{^^^   In this example, each line of the data file ^^^}
{^^^    contains one real number.                  ^^^}
{^^^   Normally, you'd make sure the file exists   ^^^}
{^^^    and check that the inputted values are     ^^^}
{^^^    valid, but we'll leave that to you.        ^^^}

  ASSIGN(DataFile,'REALS.DAT');
  RESET(DataFile);

{^^^   Here we do a preliminary read of the file   ^^^}
{^^^    to see how many values are in it.          ^^^}

  NValues:=0;
  WHILE NOT EOF(DataFile) DO
    BEGIN
      READLN(DataFile,TempReal);
      INC(NValues);
    END; {WHILE}

{^^^   Allocate memory on the heap to fit NValues  ^^^}
{^^^   of variables of type real.                  ^^^}

  GETMEM(OurData,NValues*SIZEOF(OurData^[1]));

{^^^   Get back to the beginning of the file.      ^^^}

  RESET(DataFile);

{^^^   We're about to violate the subscript range! ^^^}

  FOR I:=1 TO NValues DO READLN(DataFile,OurData^[I]);

  CLOSE(DataFile);


{^^^   We're going to violate it again.            ^^^}

  FOR I:=1 TO NValues DO WRITELN(' ',I,': ',OurData^[I]:6:2);


{^^^   Deallocate the memory occupied by OurData   ^^^}
{^^^    so it can be reused later.                 ^^^}

  FREEMEM(OurData,NValues*SIZEOF(OurData^[1]));

END. {HeapALot}

