  UNIT Engine;

  {$V-}

  (*********************************************************)
  (*  SEARCH ENGINE                                        *)
  (*     Input Parameters:                                 *)
  (*       Mask : The file specification to search for     *)
  (*              May contain wildcards                    *)
  (*       Attr : File attribute to search for             *)
  (*       Proc : Procedure to process each found file     *)
  (*                                                       *)
  (*     Ouput Parameters:                                 *)
  (*       ErrorCode : Contains the final error code.      *)
  (*                                                       *)
  (*********************************************************)

  (**********************)
  (**)   INTERFACE    (**)
  (**********************)

USES DOS;

TYPE ProcType = PROCEDURE (VAR S : SearchRec; P : PathStr);

  PROCEDURE SearchEngine(Mask : PathStr;
                          Attr : Byte;
                          Proc : ProcType;
                 VAR ErrorCode : Byte);

  FUNCTION GoodDirectory(S : SearchRec) : Boolean;
  PROCEDURE ShrinkPath(VAR path  : PathStr);
  PROCEDURE ErrorMessage(ErrCode : Byte);
  PROCEDURE SearchEngineAll(path : PathStr;
                            Mask : NameStr;
                            Attr : Byte;
                            Proc : ProcType;
                            VAR ErrorCode : Byte);

  (**********************)
  (**) IMPLEMENTATION (**)
  (**********************)

VAR
  EngineMask : NameStr;
  EngineAttr : Byte;
  EngineProc : ProcType;
  EngineCode : Byte;

  PROCEDURE SearchEngine(Mask : PathStr;
                         Attr : Byte;
                         Proc : ProcType;
                         VAR ErrorCode : Byte);
  VAR
    S : SearchRec;
    P : PathStr;
    Ext : ExtStr;

{procedure FSplit(Path: PathStr; var Dir: DirStr;
  var Name: NameStr; var Ext: ExtStr);}


  BEGIN
    FSplit(Mask, P, Mask, Ext);
    Mask := Mask + Ext;
    FindFirst(P + Mask, Attr, S);
    IF DosError <> 0 THEN
      BEGIN
        ErrorCode := DosError;
        Exit;
      END;
    WHILE DosError = 0 DO
      BEGIN
        Proc(S, P);
        FindNext(S);
      END;
    IF DosError = 18 THEN ErrorCode := 0
    ELSE ErrorCode := DosError;
  END;

  FUNCTION GoodDirectory(S : SearchRec) : Boolean;
  BEGIN
    GoodDirectory := (S.name <> '.') AND
    (S.name <> '..') AND
    (S.Attr AND Directory = Directory);
  END;

  PROCEDURE ShrinkPath(VAR path : PathStr);
  VAR P : Byte;
    Dummy : NameStr;
  BEGIN
    FSplit(path, path, Dummy, Dummy);
    Dec(path[0]);
  END;

  {$F+} PROCEDURE SearchOneDir(VAR S : SearchRec; P : PathStr); {$F-}
    {Recursive procedure to search one directory}
  BEGIN
    IF GoodDirectory(S) THEN
      BEGIN
        P := P + S.name;
        SearchEngine(P + '\' + EngineMask, EngineAttr,
                     EngineProc, EngineCode);
        SearchEngine(P + '\*.*', Directory OR Archive,
                     SearchOneDir, EngineCode);
      END;
  END;

  PROCEDURE SearchEngineAll(path : PathStr;
                            Mask : NameStr;
                            Attr : Byte;
                            Proc : ProcType;
                            VAR ErrorCode : Byte);
  BEGIN
    (*Set up Unit global variables for use in
      recursive directory search procedure*)
    EngineMask := Mask;
    EngineProc := Proc;
    EngineAttr := Attr;
    SearchEngine(path + Mask, Attr, Proc, ErrorCode);
    SearchEngine
    (path + '*.*', Directory OR Attr, SearchOneDir, ErrorCode);
    ErrorCode := EngineCode;
  END;

  PROCEDURE ErrorMessage(ErrCode : Byte);
  BEGIN
    CASE ErrCode OF
      0 : ;                  {OK -- no error}
      2 : WriteLn('File not found');
      3 : WriteLn('Path not found');
      5 : WriteLn('Access denied');
      6 : WriteLn('Invalid handle');
      8 : WriteLn('Not enough memory');
      10 : WriteLn('Invalid environment');
      11 : WriteLn('Invalid format');
      18 : ;                 {OK -- merely "no more files"}
    ELSE WriteLn('ERROR #', ErrCode);
    END;
  END;


END.

