Program PTOOLDAT;  {Copyright  R D Ostrander
                               Ostrander Data Services
                               5437 Honey Manor Dr
                               Indianapolis  IN  46241

     This is a demonstration program for the Turbo Pascal subroutine PTOOLDAT
     for date manipulations. Address any questions to the author at the above
     address.                                                                }

{$V-}     { This parameter is necessary in order to pass String parameters
            of other than 21 characters.                                     }

Var
   Input       : String [21];
   InGreg      : Array [1..20] of String [21];
   InJul       : Array [1..20] of Real;
   I,J,K       : Byte;
   Done        : Boolean;
   Ch          : Char;
   Code, Short : Integer;


{$I PTOOLDAT.INC}  {Include statement for PTOOLDAT functions and procedures  }


BEGIN

     ClrScr;
     Gotoxy (15,5); Write ('Demonstration of PTOOLDAT procedure.');
     Gotoxy (15,7); Write ('PTOOLDAT and this program are copyrights');
     Gotoxy (15,8); Write ('of R D Ostrander');
     Gotoxy (15,9); Write ('   Ostrander Data Services');
     Gotoxy (15,10); Write ('   5437 Honey Manor Dr');
     Gotoxy (15,11); Write ('   Indianapolis  IN  46241');
     Gotoxy (15,13); Write ('and have been placed in the public domain.');
     Delay (4000);
     ClrScr;

     Done := False;
     Gotoxy (30,1); Write ('Gregorian Date Validation');
     Gotoxy (1, 3); Write ('Enter up to 20 dates to be validated');
     Writeln (' - give  Month, Day, and Year  - ie ', PTDGCurr);
     Gotoxy (1, 5); Write ('Enter  X  to end');
     I := 1;
     While (I <= 20)
       and (Done = False) do
           Begin
                Gotoxy (1, I + 5);
                Write ('Enter date                ');
                Gotoxy (12, I + 5);
                Read (Input);
                Ch := Input [1];
                Gotoxy (32, I + 5);
                If UpCase (Ch) = 'X' then Done := True
                else
                   If PTDGValid (Input) then
                      Begin
                           Write (Input, ' is a Valid Date              ');
                           InGreg [I] := Input;
                           I := I + 1;
                      End
                   else
                      Write (Input, ' is not Valid  - Try Again     ');
           End;

     ClrScr;
     Done := False;
     Gotoxy (30,1); Write ('Julian Date Validation');
     Gotoxy (1, 3); Write ('Enter up to 20 dates to be validated');
     Writeln (' - give  number as YYDDD - ie ', PTDJCurr:5:0);
     Gotoxy (1, 5); Write ('Enter  X  to end');
     J := 1;
     While (J <= 20)
       and (Done = False) do
           Begin
                Gotoxy (1, J + 5);
                Write ('Enter date                ');
                Gotoxy (12, J + 5);
                Read (Input);
                Ch := Input [1];
                If (UpCase (Ch) = 'X') or (Ch = '') then Done := True
                else
                   Begin
                        Gotoxy (32, J + 5);
                        Val (Input, InJul [J], Code);
                        If Code <> 0 then InJul [J] := 0;
                        If PTDJValid (InJul [J]) then
                           Begin
                                Write (Input,
                                       ' is a Valid Date                 ');
                                J := J + 1;
                           End
                        else
                           Write (Input, ' is not Valid  -  Try Again    ');
                   End;
           End;

     ClrScr;
     I := I - 1;
     Gotoxy (30,1); Write ('Gregorian Date Manipulations');
     Gotoxy (1, 3); Write ('Input                 Julian (Type B) (Type E)');
     Gotoxy (48,3); Write ('Alternate (Day of Week) Short');
     For K := 1 to I do
         Begin
              Gotoxy (1, K + 4); Write (InGreg [K]);
              Gotoxy (23,K + 4); Write (PTDGtoJ (InGreg [K]):5:0);
              PTOOLDAT_J_Type := 'B';
              Gotoxy (30,K + 4); Write (PTDGtoJ (InGreg [K]):7:0);
              PTOOLDAT_J_Type := 'E';
              Gotoxy (39,K + 4); Write (PTDGtoJ (InGreg [K]):8:0);
              PTOOLDAT_J_Type := 'A';
              PTOOLDAT_G_Order := 'YMD';
              PTOOLDAT_G_Sep1 := '-';
              PTOOLDAT_G_Sep2 := '-';
              PTOOLDAT_G_ZeroSup := False;
              PTOOLDAT_G2_Order := 'MDY';
              Gotoxy (48,K + 4); Write (PTDGtoG (InGreg [K]));
              PTOOLDAT_G_Order := 'MDY';
              PTOOLDAT_G_Sep1 := '/';
              PTOOLDAT_G_Sep2 := '/';
              PTOOLDAT_G_ZeroSup := False;
              PTOOLDAT_G2_Order := 'YMD';
              PTOOLDAT_Day_Type := 9;
              Gotoxy (58,K + 4); Write (PTDGDay (InGreg [K]));
              PTOOLDAT_Day_Type := 3;
              Short := PTDGtoS (InGreg [K]);
              Gotoxy (72,K + 4); Write (Short:6);
              Gotoxy (80,K + 4);
              If Short = -32766 then Write ('*');
         End;
     Gotoxy (1, 25); Write ('Press any key to continue');
     Read (KBD, Ch);

     ClrScr;
     J := J - 1;
     Gotoxy (30,1); Write ('Julian Date Manipulations');
     Gotoxy (1, 3); Write ('Input Gregorian  or');
     Gotoxy (40,3); Write ('Day LeapYr +100 Days Minus Prev Date');
     For K := 1 to J do
         Begin
              Gotoxy (1, K + 4); Write (InJul [K]:5:0);
              Gotoxy (7, K + 4); Write (PTDJtoG (InJul [K]));
              PTOOLDAT_G_YrDisp := 4;
              PTOOLDAT_G_MoDisp := 9;
              PTOOLDAT_G_Sep1   := ' ';
              PTOOLDAT_G_Sep2   := ', ';
              PTOOLDAT_G_ZeroSup := True;
              Gotoxy (18,K + 4); Write (PTDJtoG (InJul [K]));
              PTOOLDAT_G_YrDisp := 2;
              PTOOLDAT_G_MoDisp := 2;
              PTOOLDAT_G_Sep1   := '/';
              PTOOLDAT_G_Sep2   := '/';
              PTOOLDAT_G_ZeroSup := False;
              Gotoxy (40,K + 4); Write (PTDJDay (InJul [K]));
              Gotoxy (44,K + 4);
              If PTDJLeap (InJul [K]) then Write ('Yes')
                                      else Write ('No');
              Gotoxy (51,K + 4); Write (PTDJtoG (PTDJAdd (InJul [K], 100)));
              If K > 1 then
                 Begin
                      Gotoxy (61,K + 4);
                      Write (PTDJComp (InJul [K], InJul [K-1]):8:0, ' Days');
                 End;
         End;

Gotoxy (1, 24);

END.