PROCEDURE Flood_Fill (X, Y:  Real);

{  Example of a flood-fill algorithm  }

{ By Fred Robinson
     Monotreme Software     Copyright (c) 1987 Monotreme Software
     29766 Everett
     Southfield, MI  48076
     USA  }

VAR
   Start_X, Start_Y, X1Loc, X2Loc:  Integer;

   (*****************************************************************)

   PROCEDURE Do_The_Flood_Fill (X, Y:  Integer);

   {  The actual filling routine.  Taken from Fundamentals of Inter-
   active Computer Graphics, Foley & Van Dam 1982, p. 448.  }

   BEGIN
   IF (X>=X1Loc) AND (X<=X2Loc) AND (Y>=Y1RefGlb) AND
      (Y<=Y2RefGlb) THEN
      IF NOT PD (X, Y) THEN
         BEGIN
         DP (X, Y);
         Do_The_Flood_Fill (X+1, Y);
         Do_The_Flood_Fill (X-1, Y);
         Do_The_Flood_Fill (X, Y+1);
         Do_The_Flood_Fill (X, Y-1)
         END (* THEN *)
   END (* Do_The_Flood_Fill *);

   (*****************************************************************)

BEGIN (* Flood_Fill *)
{  Get pixel coordinates of (X, Y)  }

IF DirectModeGlb THEN
   BEGIN
   Start_X := Round (X);
   Start_Y := Round (Y)
   END (* THEN *)

ELSE
   BEGIN
   Start_X := WindowX (X);
   Start_Y := WindowY (Y)
   END (* ELSE *);

{  Set the proper X-bounds  }

IF HatchGlb THEN
   BEGIN
   X1Loc := X1RefGlb;
   X2Loc := X2Refglb;
   END (* THEN *)

ELSE
   BEGIN
   X1Loc := X1RefGlb SHL 3;
   X2Loc := X2RefGlb SHL 3 + 7
   END (* ELSE *);

Do_The_Flood_Fill (Start_X, Start_Y)
END (* Flood_Fill *);
