{ TP40TIPS.PAS }
{
Description:  Routines for "bulletproof" entry of integer and real values
              without using the modified READ/READLN of Turbo Pascal 4.0.

Author:       Stephen Lowens
Date:         1/3/88
Application:  IBM PC or compatible, Turbo Pascal 4.0

}


USES CRT;

PROCEDURE BEEP;
BEGIN
SOUND(440);
DELAY(200);
NOSOUND;
END;

PROCEDURE GETINTEGER(VAR VALUE:INTEGER; LOW,HIGH:INTEGER);
VAR  OK                      : BOOLEAN;
     TEMPX,TEMPY,CO,CO1,CO2  : BYTE;
     INV,RET,BAK,PLUS,MINUS  : CHAR;
     TEMPVAL                 : LONGINT;
     NEGATIVE,SYMBOL         : BOOLEAN;
LABEL AGAIN;

BEGIN
RET   := CHR(13);
BAK   := CHR(8);
PLUS  := CHR(43);
MINUS := CHR(45);
OK    := FALSE;
TEMPX := WHEREX;
TEMPY := WHEREY;
REPEAT
   CO       := 0;
   TEMPVAL  := 0;
   NEGATIVE := FALSE;
   SYMBOL   := FALSE;
   REPEAT
      BEGIN
AGAIN:
      INV := READKEY;
      IF CO = 0 THEN
         IF INV IN [PLUS,MINUS] THEN
            BEGIN
            IF INV = MINUS THEN NEGATIVE := TRUE;
            WRITE(INV);
            SYMBOL := TRUE;
            GOTO AGAIN;
            END;
      IF INV IN [BAK,RET,'0'..'9'] THEN
         BEGIN
         IF INV IN ['0'..'9'] THEN
            BEGIN
            CO := CO + 1;
            WRITE(INV);
            TEMPVAL := TEMPVAL*10  + ORD(INV) - 48;
            END
         ELSE
         IF INV = BAK THEN
            BEGIN
            GOTOXY(WHEREX-1,WHEREY);
            WRITE(' ');
            GOTOXY(WHEREX-1,WHEREY);
            TEMPVAL := TEMPVAL DIV 10;
            CO := CO - 1;
            END;
         END
      ELSE
         BEEP
      END;
   UNTIL (INV = RET) OR (CO > 6);
IF (LOW<= TEMPVAL) AND (TEMPVAL<= HIGH) THEN
  OK := TRUE
ELSE
      BEGIN
      BEEP;
      GOTOXY(TEMPX,TEMPY);
      CO1 := 0;
      REPEAT
        CO1 := CO1 + 1;
        TEMPVAL := TEMPVAL DIV 10;
      UNTIL TEMPVAL = 0;
      FOR CO2 := 1 TO CO1 DO WRITE(' ');
      IF SYMBOL = TRUE THEN WRITE(' ');
      GOTOXY(TEMPX,TEMPY);
      END;
UNTIL OK;
VALUE := TEMPVAL;
IF NEGATIVE = TRUE THEN VALUE := VALUE * (-1);
IF CO = 0 THEN VALUE := 0;
IF VALUE = 0 THEN
   BEGIN
   GOTOXY(TEMPX,TEMPY);
   WRITE(VALUE);
   END;
END;

PROCEDURE GETREAL(VAR VALUE:REAL);

VAR  OK                          : BOOLEAN;
     TEMPX,TEMPY,CO,CO2,I        : BYTE;
     CO1                         : SHORTINT;
     INV,RET,BAK,PER,PLUS,MINUS  : CHAR;
     NEGATIVE,SYMBOL,PER1        : BOOLEAN;
     ST1,ST2                     : STRING;
     TENS                        : REAL;
LABEL AGAIN,ONWEGO;

BEGIN
RET   := CHR(13);
BAK   := CHR(8);
PLUS  := CHR(43);
MINUS := CHR(45);
PER   := CHR(46);
TEMPX := WHEREX;
TEMPY := WHEREY;
CO    := 0;
VALUE := 0;
ST1   := '';
OK       := FALSE;
NEGATIVE := FALSE;
SYMBOL   := FALSE;
PER1     := FALSE;
REPEAT
   BEGIN
AGAIN:
   INV := READKEY;
   IF CO = 0 THEN
      IF INV IN [PLUS,MINUS] THEN
         BEGIN
         IF INV = MINUS THEN NEGATIVE := TRUE;
         WRITE(INV);
         SYMBOL := TRUE;
         GOTO AGAIN;
         END;
   IF INV IN [BAK,RET,PER,'0'..'9'] THEN
      BEGIN
      IF INV = PER THEN
        IF PER1 THEN
           BEEP
        ELSE
           BEGIN
           PER1 := TRUE;
           CO := CO + 1;
           WRITE(INV);
           ST1 := ST1 + INV;
           END
        ELSE
        IF INV IN ['0'..'9'] THEN
           BEGIN
           CO := CO + 1;
           WRITE(INV);
           ST1 := ST1 + INV;
           END
        ELSE
        IF INV = BAK THEN
           BEGIN
           GOTOXY(WHEREX-1,WHEREY);
           WRITE(' ');
           GOTOXY(WHEREX-1,WHEREY);
           ST2 := '';
           FOR I := 1 TO (CO-1) DO
              ST2 := ST2 + ST1[I];
           ST1 := ST2;
           CO := CO - 1;
           END;
      END
   ELSE
      BEEP
   END;
UNTIL INV = RET;
IF CO > 0 THEN
   BEGIN
   CO1 := 0;
   OK := FALSE;
   REPEAT
   CO1 := CO1 + 1;
   IF ST1[CO1] = PER THEN
      BEGIN
      OK := TRUE;
      GOTO ONWEGO;
      END;
   UNTIL CO1 = CO;
ONWEGO:
   TENS := 1;
   IF OK THEN CO1 := CO1 - 1;
   IF CO1 > 0 THEN
      FOR I := 1 TO CO1 DO
         VALUE := VALUE*10.0  + ORD(ST1[I]) - 48;
      IF OK THEN
         BEGIN
         CO2 := CO1 + 2;
         IF CO2 <= CO THEN
            FOR I := CO2 TO CO DO
               BEGIN
               TENS := TENS * 10.0;
               VALUE := VALUE + ((ORD(ST1[I]) -48)/TENS);
               END;
         END;
   END;
IF NEGATIVE THEN VALUE := VALUE * (-1.0);
IF VALUE = 0.0 THEN
   BEGIN
   GOTOXY(TEMPX,TEMPY);
   WRITE(VALUE:3:1);
   END;
END;

