program PlayGame;
{
       purpose          implement tic-tac-toe on the computer
       author           bruce f. webster
       last update      12 Dec 87 -- 1100 mst
}
uses CRT,TicTac,Moves,GameIO;
 
procedure StartGame(var theGame : Game);
{
  purpose      set up a new game
  pre          none
  post         g,cflag,cmove have been initialized
               no moves have been made
               the tictactoe grid has been drawn on the screen
}
var
  Ans          : Char;
begin
  ClrScr;
  ReadChar(Ans,'Who moves first:  H)uman or C)omputer? ',['H','C']);
  if Ans = 'C'
    then CFlag := 0
    else CFlag := 1;
  ReadChar(Ans,'Do you wish to be X or O? ',['X','O']);
  if Ans = 'X'
    then CMove := O
    else CMove := X;
  if CFlag <> 0
  then NewGame(theGame,Opposite(CMove))
  else NewGame(theGAme,CMove);
  DrawGrid;
  DisplayGame(theGame)
end; { of proc Initialize }
 
procedure GetMove(theGame : Game; var L : Location);
{
   purpose     select the next move for the game
   pre         g has been initialized
               0 or more moves have been made
               the game is not yet over
   post        l contains a value from 1..9
               getloc(g,l) is BLANK
}
var
  I            : Integer;
begin
  if (MovesMade(theGame) mod 2) = CFlag
  then GenerateMove(theGame,L)
 else begin
  repeat
    ReadInt(I,'Enter move',1,9);
    if GetLoc(theGame,I) <> BLANK
     then Write(^G)
   until GetLoc(theGame,I) = BLANK;
   L := I
 end
end; { of proc GetMove }
 
procedure ShowResults(var theGame : Game);
{
   purpose     show results of tictactoe game
   pre         g has been initialized, 5 or more moves have been made
               the game is over
   post        the results of the game are displayed on the screen
}
var
  M           : Move;
begin
  M := Winner(theGame);
  GoToXY(1,1); ClrEol;
  case M of
    BLANK  : Write('The game was a draw');
    X      : Write('The winner is X');
    O      : Write('The winner is O')
  end;
  Write(' -- press any key to continue (Q to quit)  ')
end; { of proc CleanUp }
 
var
  theGame     : Game;
  Next        : Location;
  Ch          : Char;
 
begin  { main body of program TicTacToe }
  repeat
    StartGame(theGame);
    repeat
      GetMove(theGame,Next);
      DoMove(theGame,Next);
      DisplayGame(theGame);
    until GameOver(theGame);
    ShowResults(theGame);
    Ch := ReadKey;
  until (Ch in ['Q','q']);
        ClrScr
end. { of program TicTacToe }
