unit Moves;
{
   MOVES.PAS   unit for making computer's moves for tictactoe
         author      bruce f. webster
         last update 12 dec 87
}
interface
 
uses TicTac;
 
var
  CFlag        : Integer; { 0 if computer moves first, 1 otherwise }
  CMove        : Move;    { contains computer's market (X,O)       }
 
procedure GenerateMove(G : Game; var L : Location);
 
implementation
 
function WinFound(G : Game; var L : Location) : Boolean;
{
   purpose     checks for winning move in game
   pre         g has been initialized, 0 or more moves have been made,
               the game is not yet over
   post        if the next move can win the game
               then l is set to that move and winfound() returns TRUE
               else l is unchanged and winfound() returns FALSE
}
var
  Temp         : Game;
  I            : Integer;
begin
  I := 1;
  WinFound := FALSE;
  repeat
    if GetLoc(G,I) = BLANK then begin
      Temp := G;
      DoMove(Temp,I);
      if GameOver(Temp) and (Winner(Temp) <> BLANK) then begin
        L := I;
        WinFound := TRUE;
        Exit;
      end;
    end;
    I := I + 1;
  until I > GLim;
end; { of func WinFound }

function BlockFound(G: Game; var L : Location) : Boolean;
{
   purpose    checks for blocking move in game
   pre        g has been initialized, 0 or more moves have been made,
              the game is not yet over
   post       if the next move can prevent the following move from
              winning the game
              then l is set to that move and blockfound() returns TRUE
              else l is unchanged and blockfound() returns FALSE
}
var
  Temp         : Game;
  I            : Integer;
  J            : Location;
begin
  I := 1;
  BlockFound := FALSE;
  repeat
    if GetLoc(G,I) = BLANK then begin
      Temp := G;
      DoMove(Temp,I);
      if not WinFound(Temp,J) then begin
        L := I;
        BlockFound := TRUE;
        Exit
      end
    end;
    I := I + 1
  until I > GLIM;
end; { of func BlockFound }
 
procedure GenerateMove(G : Game; var L : Location);
{
   purpose     generates next move for computer
   pre         g has been initialized, 0 or more moves have been made,
               the game is not yet over
   post        *l contains a value in the range 1..9,
               getloc(g,*l) returns BLANK
   strategy    goes first for move to the center (*l == 5)
               then focuses on corners, then moves randomly
               always looks for winning move
               after 3 or more moves, also looks for blocking moves
   analysis    not perfect, but simple and effective; won't always
               win when it could, but always plays to at least a draw
}
var
  NMoves       : Integer;
begin
  L := 5;
  NMoves := MovesMade(G);
  if NMoves <= 2 then begin
    if GetLoc(G,L) = BLANK
      then Exit
  end;
  if WinFound(G,L) then Exit;
  if (NMoves > 2) and BlockFound(G,L) then Exit;
  repeat
    if NMoves <= 4
      then L := 1 + 2 * Random(5)
      else L := 1 + Random(GLim);
  until GetLoc(G,L) = BLANK
end; { of proc GenerateMoves }
 
end. { of unit Moves }
