unit GameIO;
interface

uses CRT,TicTac;

type                           { define types for parameters }
  CharSet      = set of Char;
  MsgStr       = string[80];

procedure DisplayGame(theGame : Game);
procedure DrawGrid;
procedure ReadChar(var Ch : Char; Prompt : MsgStr; OKSet : CharSet);
procedure ReadInt(var Val  : Integer;
                  Prompt   : MsgStr;
                  Low,High : Integer);

implementation

const
  BoardX               = 10;      { positioning for tictactoe grid }
  BoardY               = 10;
  Bar                  = #186;    { special characters used for grid }
  Line                 = #205;
  Cross                = #206;
 
procedure DrawGrid;
{
   purpose     draws full-sized tictactoe grid,
               with smaller numbered one beside it
   pre         screen has been cleared
   post        two grids drawn on screen
}

  procedure DrawHorz(X,Y : Integer);
  {
     purpose     draws horizontal bar for tictactoe grid
     pre         x <= 63, y <= 23
     post        bar is written to screen
  }
  begin
    GoToXY(X,Y);
    Write(Line,Line,Line,Line,Line,Cross);
    Write(Line,Line,Line,Line,Line,Cross);
    Write(Line,Line,Line,Line,Line)
  end; { of locproc DrawHorz }
 
  procedure DrawVert(X,Y : Integer);
  {
     purpose    draws vertical bars for tictactoe grid
     pre        x <= 78, y <= 16
     post       vertical bar appears on screen (with gaps for crosses)
  }
  var
    J,I       : Integer;
  begin
    for J := 1 to 3 do begin
      for I := 0 to 2 do begin
        GoToXY(X,Y+I); Write(Bar)
      end;
      Y := Y + 4
    end
  end; { of locproc DrawVert }
 
  procedure DrawMoves(X,Y : Integer);
  {
     purpose     draws 3x3 grid with numbered positions
     pre         x <= 77, y <= 21
     post        3x3 grid drawn on screen
  }
 begin
   GoToXY(X,Y);   Write('1',Bar,'2',Bar,'3');
   GoToXY(X,Y+1); Write(Line,Cross,Line,Cross,Line);
   GoToXY(X,Y+2); Write('4',Bar,'5',Bar,'6');
   GoToXY(X,Y+3); Write(Line,Cross,Line,Cross,Line);
   GoToXY(X,Y+4); Write('7',Bar,'8',Bar,'9')
 end; { of locproc DrawMoves }

begin
  DrawHorz(BoardX,BoardY);
  DrawHorz(BoardX,BoardY+4);
  DrawVert(BoardX+5,BoardY-3);
  DrawVert(BoardX+11,BoardY-3);
  DrawMoves(BoardX+20,BoardY)
end; { of proc DrawGrid }
 
procedure DisplayGame(theGame : Game);
{
   purpose     draws status of tictactoe game on screen
   pre         grid has already been drawn on screen
   post        contents of each grid location are displayed
}
var
  I,Col,Row   : Integer;
  M           : Move;
begin
  for I := 1 to GLim do begin
    M := GetLoc(theGame,I);
    Col := BoardX + 2 + 6 * ((I-1) mod 3);
    Row := BoardY - 2 + 4 * ((I-1) div 3);
    GoToXY(Col,Row);
    case M of
      BLANK  : Write(' ');
      X      : Write('X');
      O      : Write('O')
    end
  end
end; { of proc DisplayGame }

procedure ReadChar(var Ch : Char; Prompt : MsgStr; OKSet : CharSet);
{
   purpose     prompt for and get one character of a given set
   pre         okset is non-empty and contains valid uppercase
               characters (including digits, punctuation, etc.)
   post        readchar() returns some character contained in okset
}
begin
  GoToXY(1,1); ClrEol;
  Write(Prompt);
  repeat
    Ch := UpCase(ReadKey)
  until Ch in OKSet;
  Write(Ch)
end; { of proc ReadChar }

procedure ReadInt(var Val  : Integer;
                  Prompt   : MsgStr;
                  Low,High : Integer);
{
   purpose     prompt for and get an integer value in a given range
   pre         low <= high
   post        readint() returns some value in the range low..high
}
begin
{$I-}
  repeat
    GoToXY(1,1); ClrEol;
    Write(Prompt,' (',Low,',',High,'): ');
    Readln(Val)
  until (IOResult = 0) and (Val >= Low) and (Val <= High)
{$I+}
end; { of proc ReadInt }

end. { of unit GameIO }
