{DIRECTRE.PAS}
{
Description:  Directory "Tree" program that displays the contents of a
              specified directory and all its subdirectories. The user
              enters both the starting search directory and a file name
              mask; standard DOS wildcards are supported. This program
              was written as a demonstration of the combined power of
              pointer variables and recursive programming techniques.

Author:       Don Taylor
Date:         3/10/88
Last revised: 04/01/1988  09:42
Application:  PC-DOS/MS-DOS version 2 or greater; Turbo Pascal 4.0

}


PROGRAM DirecTREE;

USES
 Crt, Dos;

VAR
 FileMask  : STRING;
 PathName  : STRING;
 FileAttr  : BYTE;
 DirLevel  : WORD;

{--------------------}

PROCEDURE GetParameters;

VAR
 FMask : STRING;
 PName : STRING;

BEGIN
 ClrScr;
 WRITELN('DirecTREE Directory Scanning Demo -------------------');
 GOTOXY(1,5); WRITE('  File specification: ', FileMask);
 GOTOXY(23,5); READLN(FMask);
 IF FMask <> '' THEN FileMask := FMask;
 GOTOXY(1,7); WRITE('  Starting directory: ', PathName);
 GOTOXY(23,7); READLN(PName);
 IF PName <> '' THEN PathName := PName
END;  { GetParameters }

{--------------------}

PROCEDURE ProcessFile(ThePath      : STRING;      { The path to search     }
                      TheFileInfo  : SearchRec;   { The info on the file   }
                      ThisAttrib   : BYTE);       { Attribute of the file  }

VAR
 ch : CHAR;
 s  : STRING;
 ss : STRING;

BEGIN
 { Specific file processing routines start here...}

 s := '  ' + TheFileInfo.Name + '             ';
 s := COPY(s,1,18);
 STR(TheFileInfo.Size : 7,ss);
 WRITELN(s + ss);

 IF KeyPressed
  THEN BEGIN { pause }
        ch := ReadKey;
        ch := ReadKey
       END;

 { ..and end here. }
END;  { ProcessFile }

{--------------------}

PROCEDURE ProcessDirectory(ThePath      : STRING;  { The path to search     }
                           TheFileMask  : STRING;  { The mask to match      }
                           TheAttribute : BYTE);   { The attribute to match }

TYPE
 DirRecPtr = ^DirRec;

 DirRec = RECORD
           ThisFile : SearchRec;
           NextFile : DirRecPtr
          END;

CONST
 AnyFileSpec = '*.*';

VAR
 EntriesFound : INTEGER;
 TheFileInfo  : SearchRec;
 TheFileSpec  : STRING;
 DPtr         : DirRecPtr;
 ThisDPtr     : DirRecPtr;
 DirBase      : DirRecPtr;
 DirPath      : STRING;
 MemMark      : ^INTEGER;

BEGIN
{ First, process all files... }

 Mark(MemMark);
 EntriesFound := 0;
 DirLevel     := SUCC(DirLevel);
 IF ThePath[LENGTH(ThePath)] <> '\'
  THEN ThePath := ThePath + '\';

 TheFileSpec := ThePath + TheFileMask;

 FindFirst(TheFileSpec, TheAttribute - Directory, TheFileInfo);
 WHILE DosError = 0 DO
  BEGIN
   EntriesFound := SUCC(EntriesFound);
   ProcessFile(ThePath, TheFileInfo, TheFileInfo.Attr);
   FindNext(TheFileInfo)
  END; { WHILE }


{ Now make a list of all subdirectories... }

 EntriesFound := 0;
 DirBase := NIL;
 ThisDPtr := NIL;
 DPtr := NIL;

 FindFirst(ThePath + AnyFileSpec, Directory, TheFileInfo);
 WHILE DosError = 0 DO
  BEGIN
   IF   (TheFileInfo.Attr = Directory)
    AND (TheFileInfo.Name <> '.') AND (TheFileInfo.Name <> '..')
    THEN BEGIN { add directory to list }
          EntriesFound := SUCC(EntriesFound);
          NEW(DPtr);
          DPtr^.ThisFile := TheFileInfo;
          DPtr^.NextFile := NIL;
          IF EntriesFound = 1
           THEN DirBase := DPtr
           ELSE ThisDPtr^.NextFile := DPtr;
          ThisDPtr := DPtr
         END;
   FindNext(TheFileInfo)
  END; { WHILE }


{ ..and then process all subdirectories }

  DPtr := DirBase;
  WHILE DPtr <> NIL DO
   BEGIN
    TheFileInfo := DPtr^.ThisFile;
    DirPath := ThePath + TheFileInfo.Name + '\';

  { Specific directory processing routines start here...}
    WRITELN; WRITELN;
    WRITE('DIRECTORY -- PATH: ');
    WRITE(DirPath,' ------------ Level ', DirLevel);
    WRITELN;
  { ..and end here. }

    ProcessDirectory(DirPath, TheFileMask, TheAttribute);
    DPtr := DPtr^.NextFile
   END; { WHILE }
  DirLevel := PRED(DirLevel);
  Release(MemMark)
END;  { ProcessDirectory }

{====================}

BEGIN { DirecTREE }
 ClrScr;
 DirLevel := 0;
 FileAttr := AnyFile;
 FileMask := '*.*';
 PathName := '\';
 GetParameters;
 ClrScr; WRITELN('Directory Listing -------------------------');
 WRITELN;
 WRITELN('Directory mask: ', FileMask);
 WRITELN('Starting at:    ', PathName);
 ProcessDirectory(PathName, FileMask, FileAttr);
END.  { DirecTREE }


