Program twoCurvs;

   { Draw joined Bezier curves on the CGA }

USES graph, Bezier, crt;

CONST  lastPoint = 4;     { highest subscript used }

VAR  a, b                                 : vectorArray;
     graphDriver, graphMode, errorCode, n : INTEGER;
     wait                                 : CHAR;
{ --------------------------- }

PROCEDURE initPoints;     { Define control points }

VAR    n, j : INTEGER;

BEGIN
  FOR n := 0 TO maxPoints DO     { Zero the array }
    FOR j := 0 TO 2 DO BEGIN
      a [n, j] := 0;
      b [n, j] := 0;
    END;
  a [0, 0] :=  10;   a [0, 1] := 110;  { first hull }
  a [1, 0] :=  10;   a [1, 1] :=   0;
  a [2, 0] := 120;   a [2, 1] :=   0;
  a [3, 0] := 180;   a [3, 1] := 110;
  a [4, 0] := 240;   a [4, 1] := 110;

  b [0, 0] := 240;   b [0, 1] := 110;  { second hull }
  b [1, 0] := 310;   b [1, 1] := 110;
  b [2, 0] := 310;   b [2, 1] :=   0;
  b [3, 0] := 180;   b [3, 1] :=   0;
  b [4, 0] := 120;   b [4, 1] := 199;
END;
{ --------------------------- }

BEGIN
{ Set up the screen in CGA 320 x 200 mode, palette 1 }
  GraphDriver := CGA;
  GraphMode   := CGAC1;
  InitGraph (graphDriver, graphMode, 'C:\DRIVERS');

{ Check to make sure it happened }
  ErrorCode := graphResult;
  IF errorCode <> grOK THEN BEGIN
    WRITELN ('Graphics error ', errorCode);
    WRITELN ('Program cannot run');
    HALT (1);
  END;

{ Draw the first hull outline }
  InitPoints;      { First initialize control points }
  SetLineStyle (dottedLn, 0, normWidth);
  SetColor (1);
  MoveTo (a [0, 0], a [0, 1]);
  FOR n := 1 TO lastPoint DO
    LineTo (a [n, 0], a [n, 1]);

{ Draw the second hull }
  MoveTo (b [0, 0], b [0, 1]);
  FOR n := 1 TO lastPoint DO
    LineTo (b [n, 0], b [n, 1]);

{ Mark the joint with a vertical line }
  MoveTo (240, 100);
  LineTo (240, 120);

{ Now draw the first curve }
  SetLineStyle (solidLn, 0, normWidth);
  SetColor (2);
  DrawBezier2D (a, lastPoint);

{ And second curve }
  SetColor (3);
  DrawBezier2D (b, lastPoint);

{ Clean up after a keypress }
  Wait := readkey;
  CloseGraph;
END.


