Program curve;

   { Draw a Bezier curve on the CGA }

USES graph, Bezier, crt;

CONST  lastPoint = 6;     { highest subscript used }

VAR  pt                                   : vectorArray;
     graphDriver, graphMode, errorCode, n : INTEGER;
     wait                                 : CHAR;
{ --------------------------- }

PROCEDURE initPoints;     { Define control points }

VAR    n, j : INTEGER;

BEGIN
  FOR n := 0 TO maxPoints DO     { Zero the array }
    FOR j := 0 TO 2 DO
      pt [n, j] := 0;
  pt [0, 0] := 160;   pt [0, 1] := 110;
  pt [1, 0] := 160;   pt [1, 1] := 160;
  pt [2, 0] :=  55;   pt [2, 1] := 160;
  pt [3, 0] :=  55;   pt [3, 1] :=  20;
  pt [4, 0] := 205;   pt [4, 1] :=  40;
  pt [5, 0] := 190;   pt [5, 1] := 110;
  pt [6, 0] := 280;   pt [6, 1] := 110;
END;
{ --------------------------- }

BEGIN
{ Set up the screen in CGA 320 x 200 mode, palette 1 }
  GraphDriver := CGA;
  GraphMode   := CGAC1;
  InitGraph (graphDriver, graphMode, 'C:\DRIVERS');

{ Check to make sure it happened }
  ErrorCode := graphResult;
  IF errorCode <> grOK THEN BEGIN
    WRITELN ('Graphics error ', errorCode);
    WRITELN ('Program cannot run');
    HALT (1);
  END;

{ Draw the hull outline }
  InitPoints;      { First initialize control points }
  SetLineStyle (dottedLn, 0, normWidth);
  SetColor (1);
  MoveTo (pt [0, 0], pt [0, 1]);
  FOR n := 1 TO lastPoint DO
    LineTo (pt [n, 0], pt [n, 1]);

{ Now draw the curve itself }
  SetLineStyle (solidLn, 0, normWidth);
  SetColor (2);
  DrawBezier2D (pt, lastPoint);

{ Clean up after a keypress }
  Wait := readkey;
  CloseGraph;
END.


